/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.util.ArrayList;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransferDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.OpenDialogAction;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransferDialog;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.BookmarkMenu;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.AccountContextMenu;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.actions.ConvertBuySellToDeliveryAction;
import name.abuchen.portfolio.ui.views.actions.ConvertDeliveryToBuySellAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;

public class TransactionContextMenu {
    private final AbstractFinanceView owner;

    public TransactionContextMenu(AbstractFinanceView owner) {
        this.owner = owner;
    }

    public void menuAboutToShow(IMenuManager manager, boolean fullContextMenu, IStructuredSelection selection) {
        if (selection.isEmpty() && fullContextMenu) {
            new SecurityContextMenu(this.owner).menuAboutToShow(manager, null, null);
        }
        if (selection.size() == 1) {
            TransactionPair tx = (TransactionPair)selection.getFirstElement();
            tx.withAccountTransaction().ifPresent(t -> this.fillContextMenuAccountTx(manager, fullContextMenu, (TransactionPair<AccountTransaction>)t));
            tx.withPortfolioTransaction().ifPresent(t -> this.fillContextMenuPortfolioTx(manager, fullContextMenu, (TransactionPair<PortfolioTransaction>)t));
            manager.add((IContributionItem)new Separator());
        }
        if (!selection.isEmpty()) {
            if (fullContextMenu) {
                this.fillContextMenuPortfolioTxList(manager, selection);
            }
            manager.add((IAction)new SimpleAction(Messages.MenuTransactionDelete, a -> {
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object tx = objectArray[n2];
                    ((TransactionPair)tx).deleteTransaction(this.owner.getClient());
                    ++n2;
                }
                this.owner.markDirty();
            }));
        }
    }

    public void handleEditKey(KeyEvent e, IStructuredSelection selection) {
        if (e.keyCode == 101 && e.stateMask == SWT.MOD1) {
            if (selection.isEmpty()) {
                return;
            }
            TransactionPair tx = (TransactionPair)selection.getFirstElement();
            tx.withAccountTransaction().ifPresent(t -> this.createEditAccountTransactionAction((TransactionPair<AccountTransaction>)t).run());
            tx.withPortfolioTransaction().ifPresent(t -> this.createEditPortfolioTransactionAction((TransactionPair<PortfolioTransaction>)t).run());
        }
    }

    private void fillContextMenuPortfolioTxList(IMenuManager manager, IStructuredSelection selection) {
        ArrayList<TransactionPair<PortfolioTransaction>> txCollection = new ArrayList<TransactionPair<PortfolioTransaction>>(selection.size());
        for (TransactionPair foo : selection) {
            foo.withPortfolioTransaction().ifPresent(txCollection::add);
        }
        if (txCollection.isEmpty()) {
            return;
        }
        boolean allBuyOrSellType = true;
        boolean allDelivery = true;
        for (TransactionPair transactionPair : txCollection) {
            PortfolioTransaction ptx = (PortfolioTransaction)transactionPair.getTransaction();
            allBuyOrSellType &= ptx.getType() == PortfolioTransaction.Type.BUY || ptx.getType() == PortfolioTransaction.Type.SELL;
            allDelivery &= ptx.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND || ptx.getType() == PortfolioTransaction.Type.DELIVERY_OUTBOUND;
        }
        if (allBuyOrSellType) {
            manager.add((IAction)new ConvertBuySellToDeliveryAction(this.owner.getClient(), txCollection));
            manager.add((IContributionItem)new Separator());
        }
        if (allDelivery) {
            manager.add((IAction)new ConvertDeliveryToBuySellAction(this.owner.getClient(), txCollection));
            manager.add((IContributionItem)new Separator());
        }
    }

    private void fillContextMenuAccountTx(IMenuManager manager, boolean fullContextMenu, TransactionPair<AccountTransaction> tx) {
        Action action = this.createEditAccountTransactionAction(tx);
        action.setAccelerator(SWT.MOD1 | 0x45);
        manager.add((IAction)action);
        if (fullContextMenu) {
            manager.add((IContributionItem)new Separator());
            new AccountContextMenu(this.owner).menuAboutToShow(manager, (Account)tx.getOwner(), ((AccountTransaction)tx.getTransaction()).getSecurity());
        }
    }

    private void fillContextMenuPortfolioTx(IMenuManager manager, boolean fullContextMenu, TransactionPair<PortfolioTransaction> tx) {
        PortfolioTransaction ptx = (PortfolioTransaction)tx.getTransaction();
        Action editAction = this.createEditPortfolioTransactionAction(tx);
        editAction.setAccelerator(SWT.MOD1 | 0x45);
        manager.add((IAction)editAction);
        manager.add((IContributionItem)new Separator());
        if (fullContextMenu) {
            new SecurityContextMenu(this.owner).menuAboutToShow(manager, ptx.getSecurity(), (Portfolio)tx.getOwner());
        } else {
            manager.add((IContributionItem)new BookmarkMenu(this.owner.getPart(), ptx.getSecurity()));
        }
    }

    private Action createEditAccountTransactionAction(TransactionPair<AccountTransaction> tx) {
        if (((AccountTransaction)tx.getTransaction()).getCrossEntry() instanceof BuySellEntry) {
            BuySellEntry entry = (BuySellEntry)((AccountTransaction)tx.getTransaction()).getCrossEntry();
            return new OpenDialogAction(this.owner, Messages.MenuEditTransaction).type(SecurityTransactionDialog.class, d -> d.setBuySellEntry(entry)).parameters(entry.getPortfolioTransaction().getType());
        }
        if (((AccountTransaction)tx.getTransaction()).getCrossEntry() instanceof AccountTransferEntry) {
            AccountTransferEntry entry = (AccountTransferEntry)((AccountTransaction)tx.getTransaction()).getCrossEntry();
            return new OpenDialogAction(this.owner, Messages.MenuEditTransaction).type(AccountTransferDialog.class, d -> d.setEntry(entry));
        }
        return new OpenDialogAction(this.owner, Messages.MenuEditTransaction).type(AccountTransactionDialog.class, d -> d.setTransaction((Account)tx.getOwner(), (AccountTransaction)tx.getTransaction())).parameters(((AccountTransaction)tx.getTransaction()).getType());
    }

    private Action createEditPortfolioTransactionAction(TransactionPair<PortfolioTransaction> tx) {
        if (((PortfolioTransaction)tx.getTransaction()).getCrossEntry() instanceof BuySellEntry) {
            BuySellEntry entry = (BuySellEntry)((PortfolioTransaction)tx.getTransaction()).getCrossEntry();
            return new OpenDialogAction(this.owner, Messages.MenuEditTransaction).type(SecurityTransactionDialog.class, d -> d.setBuySellEntry(entry)).parameters(entry.getPortfolioTransaction().getType());
        }
        if (((PortfolioTransaction)tx.getTransaction()).getCrossEntry() instanceof PortfolioTransferEntry) {
            PortfolioTransferEntry entry = (PortfolioTransferEntry)((PortfolioTransaction)tx.getTransaction()).getCrossEntry();
            return new OpenDialogAction(this.owner, Messages.MenuEditTransaction).type(SecurityTransferDialog.class, d -> d.setEntry(entry));
        }
        return new OpenDialogAction(this.owner, Messages.MenuEditTransaction).type(SecurityTransactionDialog.class, d -> d.setDeliveryTransaction(tx)).parameters(((PortfolioTransaction)tx.getTransaction()).getType());
    }
}

