/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityEvent;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.model.Watchlist;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Quote;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.impl.EurostatHICPQuoteFeed;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.SecurityPriceDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.OpenDialogAction;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransferDialog;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.ConfirmAction;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.TableViewerCSVExporter;
import name.abuchen.portfolio.ui.util.swt.SashLayout;
import name.abuchen.portfolio.ui.util.swt.SashLayoutData;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.DateEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.TransactionOwnerListEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ValueEditingSupport;
import name.abuchen.portfolio.ui.views.AbstractListView;
import name.abuchen.portfolio.ui.views.QuotesContextMenu;
import name.abuchen.portfolio.ui.views.SecuritiesChart;
import name.abuchen.portfolio.ui.views.SecuritiesTable;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.SecurityDetailsViewer;
import name.abuchen.portfolio.ui.views.SecurityQuoteQualityMetricsViewer;
import name.abuchen.portfolio.ui.views.actions.ConvertBuySellToDeliveryAction;
import name.abuchen.portfolio.ui.views.actions.ConvertDeliveryToBuySellAction;
import name.abuchen.portfolio.ui.views.columns.CalculatedQuoteColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import name.abuchen.portfolio.ui.wizards.events.CustomEventWizard;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityDialog;
import name.abuchen.portfolio.ui.wizards.security.SearchSecurityWizardDialog;
import name.abuchen.portfolio.util.TradeCalendar;
import name.abuchen.portfolio.util.TradeCalendarManager;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SecurityListView
extends AbstractListView
implements ColumnEditingSupport.ModificationListener {
    @Inject
    private SelectionService selectionService;
    @Inject
    private ExchangeRateProviderFactory factory;
    private SecuritiesTable securities;
    private TableViewer prices;
    private TableViewer transactions;
    private TableViewer events;
    private SecuritiesChart chart;
    private SecurityDetailsViewer latest;
    private SecurityQuoteQualityMetricsViewer metrics;
    private List<Predicate<Security>> filter = new ArrayList<Predicate<Security>>();
    private Watchlist watchlist;
    private Pattern filterPattern;

    @Override
    protected String getDefaultTitle() {
        StringBuilder title = new StringBuilder();
        if (this.watchlist == null) {
            title.append(Messages.LabelSecurities);
        } else {
            title.append(Messages.LabelSecurities).append(' ').append(this.watchlist.getName());
        }
        if (this.securities != null) {
            title.append(" (").append(this.securities.getColumnHelper().getConfigurationName()).append(")");
        }
        return title.toString();
    }

    @Override
    public void notifyModelUpdated() {
        if (this.securities != null && !this.securities.getTableViewer().getTable().isDisposed()) {
            this.updateTitle(this.getDefaultTitle());
            this.securities.refresh(true);
        }
    }

    @Override
    public void markDirty() {
        super.markDirty();
        Security security = (Security)((IStructuredSelection)this.securities.getTableViewer().getSelection()).getFirstElement();
        this.latest.setInput(security);
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        Security security = (Security)this.prices.getData(Security.class.toString());
        if (newValue instanceof LocalDate) {
            SecurityPrice price = (SecurityPrice)element;
            security.removePrice(price);
            security.addPrice(price);
        }
        this.securities.refresh(security);
        this.prices.refresh(element);
        this.latest.setInput(security);
        this.metrics.setInput(security);
        this.transactions.setInput((Object)security.getTransactions(this.getClient()));
        this.events.setInput((Object)security.getEvents());
        this.chart.updateChart(security);
        this.markDirty();
    }

    @Inject
    @Optional
    public void setup(@Named(value="name.abuchen.portfolio.ui.param.viewparameter") Watchlist parameter) {
        this.watchlist = parameter;
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        this.addSearchButton(toolBar);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IContributionItem)new CreateSecurityDropDown());
        toolBar.add((IContributionItem)new FilterDropDown(this.getPreferenceStore()));
        this.addExportButton(toolBar);
        toolBar.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> this.securities.getColumnHelper().menuAboutToShow(manager)));
    }

    private void addSearchButton(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)new ControlContribution("searchbox"){

            protected Control createControl(Composite parent) {
                Text search = new Text(parent, 384);
                search.setMessage(Messages.LabelSearch);
                search.setSize(300, -1);
                search.addModifyListener(e -> {
                    String filterText = Pattern.quote(search.getText().trim());
                    if (filterText.length() == 0) {
                        SecurityListView.this.filterPattern = null;
                        SecurityListView.this.securities.refresh(false);
                    } else {
                        SecurityListView.this.filterPattern = Pattern.compile(".*" + filterText + ".*", 2);
                        SecurityListView.this.securities.refresh(false);
                    }
                });
                return search;
            }

            protected int computeWidth(Control control) {
                return control.computeSize((int)100, (int)-1, (boolean)true).x;
            }
        });
    }

    private void addExportButton(ToolBarManager toolBar) {
        Action export = new Action(){

            public void run() {
                new TableViewerCSVExporter(SecurityListView.this.securities.getTableViewer()).export(String.valueOf(SecurityListView.this.getTitle()) + ".csv");
            }
        };
        export.setImageDescriptor(Images.EXPORT.descriptor());
        export.setToolTipText(Messages.MenuExportData);
        toolBar.add((IAction)export);
    }

    @Override
    protected void createTopTable(Composite parent) {
        this.securities = new SecuritiesTable(parent, this);
        this.updateTitle(this.getDefaultTitle());
        this.securities.getColumnHelper().addListener(() -> this.updateTitle(this.getDefaultTitle()));
        this.securities.getColumnHelper().setToolBarManager(this.getViewToolBarManager());
        this.securities.addSelectionChangedListener(event -> this.onSecurityChanged((Security)((IStructuredSelection)event.getSelection()).getFirstElement()));
        this.securities.addSelectionChangedListener(event -> {
            Security security = (Security)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (security != null) {
                this.selectionService.setSelection(new SecuritySelection(this.getClient(), security));
            }
        });
        this.securities.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String[] properties;
                if (SecurityListView.this.filterPattern == null) {
                    return true;
                }
                Security security = (Security)element;
                String[] stringArray = properties = new String[]{security.getName(), security.getIsin(), security.getTickerSymbol(), security.getWkn(), security.getNote()};
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    String property = stringArray[n2];
                    if (property != null && SecurityListView.this.filterPattern.matcher(property).matches()) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        this.securities.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                for (Predicate<Security> predicate : SecurityListView.this.filter) {
                    if (predicate.test((Security)element)) continue;
                    return false;
                }
                return true;
            }
        });
        this.setSecurityTableInput();
    }

    private void setSecurityTableInput() {
        if (this.watchlist != null) {
            this.securities.setInput(this.watchlist);
        } else {
            this.securities.setInput(this.getClient().getSecurities());
        }
    }

    private void onSecurityChanged(Security security) {
        this.prices.setData(Security.class.toString(), (Object)security);
        this.prices.setInput((Object)(security != null ? security.getPrices() : new ArrayList(0)));
        this.prices.refresh();
        this.latest.setInput(security);
        this.metrics.setInput(security);
        this.transactions.setInput(security != null ? security.getTransactions(this.getClient()) : new ArrayList(0));
        this.events.setInput((Object)(security != null ? security.getEvents() : Collections.emptyList()));
        this.chart.updateChart(security);
    }

    @Override
    protected void createBottomTable(Composite parent) {
        Composite sash = new Composite(parent, 0);
        sash.setLayout((Layout)new SashLayout(sash, 0x1000108));
        CTabFolder folder = new CTabFolder(sash, 2048);
        this.latest = new SecurityDetailsViewer(sash, 2048, this.getClient());
        this.latest.getControl().setLayoutData((Object)new SashLayoutData(SWTHelper.getPackedWidth(this.latest.getControl())));
        CTabItem item = new CTabItem(folder, 0);
        item.setText(Messages.SecurityTabChart);
        Composite chartComposite = new Composite((Composite)folder, 0);
        item.setControl((Control)chartComposite);
        this.chart = new SecuritiesChart(chartComposite, this.getClient(), (CurrencyConverter)new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency()));
        item = new CTabItem(folder, 0);
        item.setText(Messages.SecurityTabHistoricalQuotes);
        item.setControl((Control)this.createPricesTable((Composite)folder));
        item = new CTabItem(folder, 0);
        item.setText(Messages.SecurityTabTransactions);
        item.setControl((Control)this.createTransactionTable((Composite)folder));
        item = new CTabItem(folder, 0);
        item.setText(Messages.SecurityTabEvents);
        item.setControl((Control)this.createEventsTable((Composite)folder));
        this.metrics = this.make(SecurityQuoteQualityMetricsViewer.class, new Object[0]);
        item = new CTabItem(folder, 0);
        item.setText(Messages.GroupLabelDataQuality);
        item.setControl(this.metrics.createViewControl((Composite)folder));
        folder.setSelection(0);
    }

    protected Composite createPricesTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.prices = new TableViewer(container, 65538);
        ColumnEditingSupport.prepare((ColumnViewer)this.prices);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(SecurityListView.class.getSimpleName()) + "@prices", this.getPreferenceStore(), this.prices, layout);
        Column column = new Column(Messages.ColumnDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Values.Date.format((Object)((SecurityPrice)element).getDate());
            }

            public Color getBackground(Object element) {
                SecurityPrice current = (SecurityPrice)element;
                List all = (List)SecurityListView.this.prices.getInput();
                int index = all.indexOf(current);
                if (index == 0) {
                    return null;
                }
                SecurityPrice previous = (SecurityPrice)all.get(index - 1);
                Security security = (Security)SecurityListView.this.prices.getData(Security.class.toString());
                TradeCalendar calendar = TradeCalendarManager.getInstance((Security)security);
                boolean hasMissing = false;
                LocalDate date = current.getDate().minusDays(1L);
                while (!hasMissing && date.isAfter(previous.getDate())) {
                    hasMissing = !calendar.isHoliday(date);
                    date = date.minusDays(1L);
                }
                return hasMissing ? Colors.theme().warningBackground() : null;
            }
        });
        ColumnViewerSorter.create(SecurityPrice.class, "date").attachTo(column, 128);
        new DateEditingSupport(SecurityPrice.class, "date").addListener(this).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnQuote, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Security security = (Security)SecurityListView.this.prices.getData(Security.class.toString());
                SecurityPrice price = (SecurityPrice)element;
                return Values.Quote.format(security.getCurrencyCode(), price.getValue(), SecurityListView.this.getClient().getBaseCurrency());
            }
        });
        ColumnViewerSorter.create(SecurityPrice.class, "value").attachTo(column);
        new ValueEditingSupport(SecurityPrice.class, "value", (Values<? extends Number>)Values.Quote, number -> number.longValue() != 0L).addListener(this).attachTo(column);
        support.addColumn(column);
        support.createColumns();
        this.prices.getTable().setHeaderVisible(true);
        this.prices.getTable().setLinesVisible(true);
        this.prices.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.hookContextMenu((Control)this.prices.getTable(), this::fillPricesContextMenu);
        return container;
    }

    private void fillPricesContextMenu(IMenuManager manager) {
        Security security = (Security)this.prices.getData(Security.class.toString());
        if (security != null) {
            manager.add((IAction)new SimpleAction(Messages.SecurityMenuAddPrice, a -> {
                SecurityPriceDialog dialog = new SecurityPriceDialog(Display.getDefault().getActiveShell(), this.getClient(), security);
                if (dialog.open() != 0) {
                    return;
                }
                this.markDirty();
                this.prices.setInput((Object)security.getPrices());
                this.latest.setInput(security);
                this.metrics.setInput(security);
                this.transactions.setInput((Object)security.getTransactions(this.getClient()));
                this.events.setInput((Object)security.getEvents());
                this.chart.updateChart(security);
            }));
            manager.add((IContributionItem)new Separator());
        }
        if (((IStructuredSelection)this.prices.getSelection()).getFirstElement() != null) {
            manager.add((IAction)new Action(Messages.SecurityMenuDeletePrice){

                public void run() {
                    Security security = (Security)SecurityListView.this.prices.getData(Security.class.toString());
                    if (security == null) {
                        return;
                    }
                    for (SecurityPrice price : (IStructuredSelection)SecurityListView.this.prices.getSelection()) {
                        if (price == null) continue;
                        security.removePrice(price);
                    }
                    SecurityListView.this.markDirty();
                    SecurityListView.this.prices.setInput((Object)security.getPrices());
                    SecurityListView.this.latest.setInput(security);
                    SecurityListView.this.metrics.setInput(security);
                    SecurityListView.this.transactions.setInput((Object)security.getTransactions(SecurityListView.this.getClient()));
                    SecurityListView.this.events.setInput((Object)security.getEvents());
                    SecurityListView.this.chart.updateChart(security);
                }
            });
        }
        if (this.prices.getTable().getItemCount() > 0) {
            manager.add((IAction)new Action(Messages.SecurityMenuDeleteAllPrices){

                public void run() {
                    Security security = (Security)SecurityListView.this.prices.getData(Security.class.toString());
                    if (security == null) {
                        return;
                    }
                    security.removeAllPrices();
                    SecurityListView.this.markDirty();
                    SecurityListView.this.prices.setInput((Object)security.getPrices());
                    SecurityListView.this.latest.setInput(security);
                    SecurityListView.this.metrics.setInput(security);
                    SecurityListView.this.transactions.setInput((Object)security.getTransactions(SecurityListView.this.getClient()));
                    SecurityListView.this.events.setInput((Object)security.getEvents());
                    SecurityListView.this.chart.updateChart(security);
                }
            });
        }
        if (security != null) {
            manager.add((IContributionItem)new Separator());
            new QuotesContextMenu(this).menuAboutToShow(manager, security);
        }
    }

    protected Composite createTransactionTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.transactions = new TableViewer(container, 65536);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.transactions, (int)2);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(SecurityListView.class.getSimpleName()) + "@transactions4", this.getPreferenceStore(), this.transactions, layout);
        Column column = new Column(Messages.ColumnDate, 0, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Values.DateTime.format((Object)((TransactionPair)element).getTransaction().getDateTime());
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> ((TransactionPair)o1).getTransaction().getDateTime().compareTo(((TransactionPair)o2).getTransaction().getDateTime())), 128);
        support.addColumn(column);
        column = new Column(Messages.ColumnTransactionType, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Transaction t = ((TransactionPair)element).getTransaction();
                if (t instanceof PortfolioTransaction) {
                    return ((PortfolioTransaction)t).getType().toString();
                }
                if (t instanceof AccountTransaction) {
                    return ((AccountTransaction)t).getType().toString();
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnShares, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){

            @Override
            public Long getValue(Object element) {
                Transaction t = ((TransactionPair)element).getTransaction();
                if (t instanceof PortfolioTransaction) {
                    return ((PortfolioTransaction)t).getShares();
                }
                if (t instanceof AccountTransaction) {
                    long shares = ((AccountTransaction)t).getShares();
                    return shares != 0L ? Long.valueOf(shares) : null;
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnAmount, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Transaction t = ((TransactionPair)element).getTransaction();
                return Values.Money.format(t.getMonetaryAmount(), SecurityListView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            long a1 = ((TransactionPair)o1).getTransaction().getAmount();
            long a2 = ((TransactionPair)o2).getTransaction().getAmount();
            return Long.compare(a1, a2);
        }));
        support.addColumn(column);
        column = new CalculatedQuoteColumn("4", this.getClient(), element -> {
            long shares;
            Transaction t = ((TransactionPair)element).getTransaction();
            if (t instanceof PortfolioTransaction) {
                return ((PortfolioTransaction)t).getGrossPricePerShare();
            }
            if (t instanceof AccountTransaction && (shares = ((AccountTransaction)t).getShares()) != 0L) {
                long perShare = Math.round((double)((AccountTransaction)t).getGrossValueAmount() * Values.Share.divider() * (double)Values.Quote.factorToMoney() / (double)shares);
                return Quote.of((String)t.getCurrencyCode(), (long)perShare);
            }
            return null;
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnFees, 131072, 80);
        column.setDescription(Messages.ColumnFees_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Transaction t = ((TransactionPair)element).getTransaction();
                return Values.Money.format(t.getUnitSum(Transaction.Unit.Type.FEE), SecurityListView.this.getClient().getBaseCurrency());
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnTaxes, 131072, 80);
        column.setDescription(Messages.ColumnTaxes_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Transaction t = ((TransactionPair)element).getTransaction();
                return Values.Money.format(t.getUnitSum(Transaction.Unit.Type.TAX), SecurityListView.this.getClient().getBaseCurrency());
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnPortfolio, 0, 120);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TransactionOwner owner = ((TransactionPair)element).getOwner();
                if (owner instanceof Portfolio) {
                    return owner.toString();
                }
                return null;
            }

            public Image getImage(Object element) {
                TransactionOwner owner = ((TransactionPair)element).getOwner();
                if (owner instanceof Portfolio) {
                    return LogoManager.instance().getDefaultColumnImage(owner, SecurityListView.this.getClient().getSettings());
                }
                return null;
            }
        });
        new TransactionOwnerListEditingSupport(this.getClient(), TransactionOwnerListEditingSupport.EditMode.OWNER).addListener(this).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnOffsetAccount, 0, 120);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TransactionPair pair = (TransactionPair)element;
                Transaction t = pair.getTransaction();
                if (t instanceof PortfolioTransaction) {
                    return t.getCrossEntry() != null ? t.getCrossEntry().getCrossOwner(t).toString() : null;
                }
                return pair.getOwner().toString();
            }

            public Image getImage(Object element) {
                TransactionPair pair = (TransactionPair)element;
                Transaction t = pair.getTransaction();
                if (t instanceof PortfolioTransaction) {
                    return t.getCrossEntry() != null ? LogoManager.instance().getDefaultColumnImage(t.getCrossEntry().getCrossOwner(t), SecurityListView.this.getClient().getSettings()) : null;
                }
                return LogoManager.instance().getDefaultColumnImage(pair.getOwner(), SecurityListView.this.getClient().getSettings());
            }
        });
        new TransactionOwnerListEditingSupport(this.getClient(), TransactionOwnerListEditingSupport.EditMode.CROSSOWNER).addListener(this).attachTo(column);
        support.addColumn(column);
        column = new NoteColumn();
        column.setEditingSupport(null);
        support.addColumn(column);
        support.createColumns();
        this.transactions.getTable().setHeaderVisible(true);
        this.transactions.getTable().setLinesVisible(true);
        this.transactions.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.hookContextMenu(this.transactions.getControl(), this::transactionMenuAboutToShow);
        this.hookKeyListener();
        return container;
    }

    private void hookKeyListener() {
        this.transactions.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TransactionPair pair;
                if (e.keyCode == 101 && e.stateMask == SWT.MOD1 && (pair = (TransactionPair)((IStructuredSelection)SecurityListView.this.transactions.getSelection()).getFirstElement()) != null) {
                    SecurityListView.this.createEditAction(pair).run();
                }
            }
        });
    }

    private void transactionMenuAboutToShow(IMenuManager manager) {
        Security security = (Security)this.prices.getData(Security.class.toString());
        if (security == null) {
            return;
        }
        TransactionPair pair = (TransactionPair)((IStructuredSelection)this.transactions.getSelection()).getFirstElement();
        if (pair != null) {
            Action action = this.createEditAction(pair);
            action.setAccelerator(SWT.MOD1 | 0x45);
            manager.add((IAction)action);
            manager.add((IContributionItem)new Separator());
            if (pair.getTransaction() instanceof PortfolioTransaction) {
                Portfolio p = (Portfolio)pair.getOwner();
                PortfolioTransaction t = (PortfolioTransaction)pair.getTransaction();
                if (t.getType() == PortfolioTransaction.Type.BUY || t.getType() == PortfolioTransaction.Type.SELL) {
                    manager.add((IAction)new ConvertBuySellToDeliveryAction(this.getClient(), (TransactionPair<PortfolioTransaction>)new TransactionPair((TransactionOwner)p, (Transaction)t)));
                    manager.add((IContributionItem)new Separator());
                }
                if (t.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND || t.getType() == PortfolioTransaction.Type.DELIVERY_OUTBOUND) {
                    manager.add((IAction)new ConvertDeliveryToBuySellAction(this.getClient(), (TransactionPair<PortfolioTransaction>)new TransactionPair((TransactionOwner)p, (Transaction)t)));
                    manager.add((IContributionItem)new Separator());
                }
            }
        }
        new SecurityContextMenu(this).menuAboutToShow(manager, security);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.MenuTransactionDelete){

            public void run() {
                TransactionPair pair = (TransactionPair)((IStructuredSelection)SecurityListView.this.transactions.getSelection()).getFirstElement();
                if (pair == null) {
                    return;
                }
                pair.deleteTransaction(SecurityListView.this.getClient());
                SecurityListView.this.getClient().markDirty();
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ConfirmAction(Messages.MenuDeleteAllTransactions, MessageFormat.format((String)Messages.MenuConfirmDeleteAllTransactions, (Object[])new Object[]{security.getName()}), a -> {
            List txs = security.getTransactions(this.getClient());
            Iterator iterator = txs.iterator();
            while (iterator.hasNext()) {
                TransactionPair tx;
                TransactionPair t = tx = (TransactionPair)iterator.next();
                t.getOwner().deleteTransaction(t.getTransaction(), this.getClient());
            }
            this.getClient().markDirty();
        }));
    }

    private void eventsMenuAboutToShow(IMenuManager manager) {
        final Security security = (Security)this.prices.getData(Security.class.toString());
        if (security == null) {
            return;
        }
        manager.add((IAction)new Action(Messages.SecurityMenuAddEvent){

            public void run() {
                CustomEventWizard wizard = new CustomEventWizard(SecurityListView.this.getClient(), security);
                WizardDialog dialog = new WizardDialog(SecurityListView.this.getActiveShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    SecurityListView.this.markDirty();
                    SecurityListView.this.notifyModelUpdated();
                }
            }
        });
        IStructuredSelection selection = this.events.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.MenuTransactionDelete){

            public void run() {
                IStructuredSelection selection = SecurityListView.this.events.getStructuredSelection();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    security.removeEvent((SecurityEvent)iter.next());
                }
                SecurityListView.this.markDirty();
                SecurityListView.this.notifyModelUpdated();
            }
        });
    }

    private Action createEditAction(TransactionPair<?> transactionPair) {
        if (transactionPair.getTransaction().getCrossEntry() instanceof BuySellEntry) {
            BuySellEntry entry = (BuySellEntry)transactionPair.getTransaction().getCrossEntry();
            return new OpenDialogAction(this, Messages.MenuEditTransaction).type(SecurityTransactionDialog.class, d -> d.setBuySellEntry(entry)).parameters(entry.getPortfolioTransaction().getType());
        }
        if (transactionPair.getTransaction().getCrossEntry() instanceof PortfolioTransferEntry) {
            PortfolioTransferEntry entry = (PortfolioTransferEntry)transactionPair.getTransaction().getCrossEntry();
            return new OpenDialogAction(this, Messages.MenuEditTransaction).type(SecurityTransferDialog.class, d -> d.setEntry(entry));
        }
        if (transactionPair.getTransaction() instanceof PortfolioTransaction) {
            TransactionPair<?> pair = transactionPair;
            return new OpenDialogAction(this, Messages.MenuEditTransaction).type(SecurityTransactionDialog.class, d -> d.setDeliveryTransaction((TransactionPair<PortfolioTransaction>)pair)).parameters(((PortfolioTransaction)pair.getTransaction()).getType());
        }
        if (transactionPair.getTransaction() instanceof AccountTransaction) {
            TransactionPair<?> pair = transactionPair;
            return new OpenDialogAction(this, Messages.MenuEditTransaction).type(AccountTransactionDialog.class, d -> d.setTransaction((Account)pair.getOwner(), (AccountTransaction)pair.getTransaction())).parameters(((AccountTransaction)pair.getTransaction()).getType());
        }
        throw new IllegalArgumentException();
    }

    protected Composite createEventsTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.events = new TableViewer(container, 65538);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(SecurityListView.class.getSimpleName()) + "@events2", this.getPreferenceStore(), this.events, layout);
        Column column = new Column(Messages.ColumnDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Values.Date.format((Object)((SecurityEvent)element).getDate());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((SecurityEvent)e).getDate()), 128);
        column.setEditingSupport(new DateEditingSupport(SecurityEvent.class, "date"){

            @Override
            public boolean canEdit(Object element) {
                return ((SecurityEvent)element).getType().isUserEditable();
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnTransactionType, 0, 120);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((SecurityEvent)element).getType().toString();
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((SecurityEvent)e).getType()), 128);
        support.addColumn(column);
        column = new Column(Messages.ColumnPaymentDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element instanceof SecurityEvent.DividendEvent ? Values.Date.format((Object)((SecurityEvent.DividendEvent)element).getPaymentDate()) : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> e instanceof SecurityEvent.DividendEvent ? ((SecurityEvent.DividendEvent)e).getPaymentDate() : null), 128);
        support.addColumn(column);
        column = new Column(Messages.ColumnAmount, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element instanceof SecurityEvent.DividendEvent ? Values.Money.format(((SecurityEvent.DividendEvent)element).getAmount(), SecurityListView.this.getClient().getBaseCurrency()) : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> e instanceof SecurityEvent.DividendEvent ? ((SecurityEvent.DividendEvent)e).getAmount() : null), 128);
        support.addColumn(column);
        column = new Column(Messages.ColumnDetails, 0, 300);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((SecurityEvent)element).getDetails();
            }
        });
        column.setSorter(ColumnViewerSorter.createIgnoreCase(e -> ((SecurityEvent)e).getDetails()), 128);
        column.setEditingSupport(new StringEditingSupport(SecurityEvent.class, "details"){

            @Override
            public boolean canEdit(Object element) {
                return ((SecurityEvent)element).getType().isUserEditable();
            }
        });
        support.addColumn(column);
        support.createColumns();
        this.events.getTable().setHeaderVisible(true);
        this.events.getTable().setLinesVisible(true);
        this.events.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.hookContextMenu(this.events.getControl(), this::eventsMenuAboutToShow);
        return container;
    }

    private class CreateSecurityDropDown
    extends DropDown
    implements IMenuListener {
        public CreateSecurityDropDown() {
            super(Messages.SecurityMenuAddNewSecurity, Images.PLUS, 0);
            this.setMenuListener(this);
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)new SimpleAction(Messages.SecurityMenuNewSecurity, a -> {
                Security newSecurity = new Security();
                newSecurity.setFeed("MANUAL");
                newSecurity.setCurrencyCode(SecurityListView.this.getClient().getBaseCurrency());
                this.openEditDialog(newSecurity);
            }));
            manager.add((IAction)new SimpleAction(Messages.SecurityMenuNewExchangeRate, a -> {
                Security newSecurity = new Security();
                newSecurity.setFeed("MANUAL");
                newSecurity.setCurrencyCode(SecurityListView.this.getClient().getBaseCurrency());
                newSecurity.setTargetCurrencyCode(SecurityListView.this.getClient().getBaseCurrency());
                this.openEditDialog(newSecurity);
            }));
            MenuManager newHICP = new MenuManager(Messages.SecurityMenuNewHICP);
            manager.add((IContributionItem)newHICP);
            new EurostatHICPQuoteFeed().getExchanges(new Security(), new ArrayList()).stream().forEach(region -> newHICP.add((IAction)new SimpleAction(region.getName(), a -> {
                Security newSecurity = new Security();
                newSecurity.setFeed("EUROSTATHICP");
                newSecurity.setLatestFeed("MANUAL");
                newSecurity.setCurrencyCode(null);
                newSecurity.setTickerSymbol(region.getId());
                newSecurity.setName(String.valueOf(region.getName()) + Messages.LabelSuffix_HICP);
                newSecurity.setCalendar("empty");
                this.openEditDialog(newSecurity);
            })));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new SimpleAction(Messages.SecurityMenuSearch4Securities, a -> {
                SearchSecurityWizardDialog dialog = new SearchSecurityWizardDialog(Display.getDefault().getActiveShell(), SecurityListView.this.getClient());
                if (dialog.open() == 0) {
                    this.openEditDialog(dialog.getSecurity());
                }
            }));
        }

        private void openEditDialog(Security newSecurity) {
            Dialog dialog = SecurityListView.this.make(EditSecurityDialog.class, newSecurity);
            if (dialog.open() == 0) {
                SecurityListView.this.markDirty();
                SecurityListView.this.getClient().addSecurity(newSecurity);
                if (SecurityListView.this.watchlist != null) {
                    SecurityListView.this.watchlist.getSecurities().add(newSecurity);
                }
                SecurityListView.this.setSecurityTableInput();
                SecurityListView.this.securities.updateQuotes(newSecurity);
            }
        }
    }

    private class FilterDropDown
    extends DropDown
    implements IMenuListener {
        private final Predicate<Security> securityIsNotInactive;
        private final Predicate<Security> onlySecurities;
        private final Predicate<Security> onlyExchangeRates;
        private final Predicate<Security> sharesGreaterZero;
        private final Predicate<Security> sharesEqualZero;

        public FilterDropDown(IPreferenceStore preferenceStore) {
            super(Messages.SecurityListFilter, Images.FILTER_OFF, 0);
            this.securityIsNotInactive = record -> !record.isRetired();
            this.onlySecurities = record -> !record.isExchangeRate();
            this.onlyExchangeRates = record -> record.isExchangeRate();
            this.sharesGreaterZero = record -> this.getSharesHeld(SecurityListView.this.getClient(), (Security)record) > 0L;
            this.sharesEqualZero = record -> this.getSharesHeld(SecurityListView.this.getClient(), (Security)record) == 0L;
            this.setMenuListener(this);
            int savedFilters = SecurityListView.this.watchlist != null ? preferenceStore.getInt(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "-filterSettings" + "-" + SecurityListView.this.watchlist.getName()) : preferenceStore.getInt(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "-filterSettings");
            if ((savedFilters & 2) != 0) {
                SecurityListView.this.filter.add(this.securityIsNotInactive);
            }
            if ((savedFilters & 4) != 0) {
                SecurityListView.this.filter.add(this.onlySecurities);
            }
            if ((savedFilters & 8) != 0) {
                SecurityListView.this.filter.add(this.onlyExchangeRates);
            }
            if ((savedFilters & 0x10) != 0) {
                SecurityListView.this.filter.add(this.sharesGreaterZero);
            }
            if ((savedFilters & 0x20) != 0) {
                SecurityListView.this.filter.add(this.sharesEqualZero);
            }
            if (!SecurityListView.this.filter.isEmpty()) {
                this.setImage(Images.FILTER_ON);
            }
            this.addDisposeListener(e -> {
                int savedFilter = 0;
                if (SecurityListView.this.filter.contains(this.securityIsNotInactive)) {
                    savedFilter += 2;
                }
                if (SecurityListView.this.filter.contains(this.onlySecurities)) {
                    savedFilter += 4;
                }
                if (SecurityListView.this.filter.contains(this.onlyExchangeRates)) {
                    savedFilter += 8;
                }
                if (SecurityListView.this.filter.contains(this.sharesGreaterZero)) {
                    savedFilter += 16;
                }
                if (SecurityListView.this.filter.contains(this.sharesEqualZero)) {
                    savedFilter += 32;
                }
                if (SecurityListView.this.watchlist != null) {
                    preferenceStore.setValue(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "-filterSettings" + "-" + SecurityListView.this.watchlist.getName(), savedFilter);
                } else {
                    preferenceStore.setValue(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "-filterSettings", savedFilter);
                }
            });
        }

        private long getSharesHeld(Client client, Security security) {
            return Math.max(security.getTransactions(client).stream().filter(t -> t.getTransaction() instanceof PortfolioTransaction).map(t -> (PortfolioTransaction)t.getTransaction()).mapToLong(t -> {
                switch (t.getType()) {
                    case BUY: 
                    case DELIVERY_INBOUND: {
                        return t.getShares();
                    }
                    case SELL: 
                    case DELIVERY_OUTBOUND: {
                        return -t.getShares();
                    }
                }
                return 0L;
            }).sum(), 0L);
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)this.createAction(Messages.SecurityListFilterHideInactive, this.securityIsNotInactive));
            manager.add((IAction)this.createAction(Messages.SecurityListFilterOnlySecurities, this.onlySecurities));
            manager.add((IAction)this.createAction(Messages.SecurityListFilterOnlyExchangeRates, this.onlyExchangeRates));
            manager.add((IAction)this.createAction(Messages.SecurityFilterSharesHeldGreaterZero, this.sharesGreaterZero));
            manager.add((IAction)this.createAction(Messages.SecurityFilterSharesHeldEqualZero, this.sharesEqualZero));
        }

        private Action createAction(String label, final Predicate<Security> predicate) {
            Action action = new Action(label, 2){

                public void run() {
                    boolean isChecked = ((FilterDropDown)FilterDropDown.this).SecurityListView.this.filter.contains(predicate);
                    if (isChecked) {
                        ((FilterDropDown)FilterDropDown.this).SecurityListView.this.filter.remove(predicate);
                    } else {
                        ((FilterDropDown)FilterDropDown.this).SecurityListView.this.filter.add(predicate);
                    }
                    if (!isChecked) {
                        if (predicate == FilterDropDown.this.onlySecurities) {
                            ((FilterDropDown)FilterDropDown.this).SecurityListView.this.filter.remove(FilterDropDown.this.onlyExchangeRates);
                        } else if (predicate == FilterDropDown.this.onlyExchangeRates) {
                            ((FilterDropDown)FilterDropDown.this).SecurityListView.this.filter.remove(FilterDropDown.this.onlySecurities);
                        } else if (predicate == FilterDropDown.this.sharesEqualZero) {
                            ((FilterDropDown)FilterDropDown.this).SecurityListView.this.filter.remove(FilterDropDown.this.sharesGreaterZero);
                        } else if (predicate == FilterDropDown.this.sharesGreaterZero) {
                            ((FilterDropDown)FilterDropDown.this).SecurityListView.this.filter.remove(FilterDropDown.this.sharesEqualZero);
                        }
                    }
                    FilterDropDown.this.setImage(((FilterDropDown)FilterDropDown.this).SecurityListView.this.filter.isEmpty() ? Images.FILTER_OFF : Images.FILTER_ON);
                    ((FilterDropDown)FilterDropDown.this).SecurityListView.this.securities.refresh(false);
                }
            };
            action.setChecked(SecurityListView.this.filter.contains(predicate));
            return action;
        }
    }
}

