/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import name.abuchen.portfolio.datatransfer.csv.CSVExporter;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.dialogs.SecurityPriceDialog;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.jobs.UpdateQuotesJob;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.wizards.datatransfer.CSVImportWizard;
import name.abuchen.portfolio.ui.wizards.datatransfer.ImportQuotesWizard;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityDialog;
import name.abuchen.portfolio.ui.wizards.security.RawResponsesDialog;
import name.abuchen.portfolio.util.QuoteFromTransactionExtractor;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class QuotesContextMenu {
    private AbstractFinanceView owner;

    public QuotesContextMenu(AbstractFinanceView owner) {
        this.owner = owner;
    }

    public void menuAboutToShow(IMenuManager parent, final Security security) {
        MenuManager manager = new MenuManager(Messages.SecurityMenuQuotes);
        parent.add((IContributionItem)manager);
        Action action = new Action(Messages.SecurityMenuUpdateQuotes){

            public void run() {
                new UpdateQuotesJob(QuotesContextMenu.this.owner.getClient(), security).schedule();
            }
        };
        action.setEnabled(!"MANUAL".equals(security.getFeed()) || security.getLatestFeed() != null && !"MANUAL".equals(security.getLatestFeed()));
        manager.add((IAction)action);
        action = new SimpleAction(Messages.SecurityMenuDebugGetHistoricalQuotes, a -> {
            try {
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, m -> {
                    if ("MANUAL".equals(security.getFeed())) {
                        return;
                    }
                    QuoteFeed feed = Factory.getQuoteFeedProvider((String)security.getFeed());
                    QuoteFeedData data = feed.getHistoricalQuotes(security, true);
                    PortfolioPlugin.log(data.getErrors());
                    Display.getDefault().asyncExec(() -> {
                        if (!data.getResponses().isEmpty() || data.getErrors().isEmpty()) {
                            new RawResponsesDialog(Display.getDefault().getActiveShell(), data.getResponses()).open();
                        } else {
                            MultiStatus status = new MultiStatus("name.abuchen.portfolio.ui", 4, security.getName(), null);
                            data.getErrors().forEach(e -> status.add((IStatus)new Status(4, "name.abuchen.portfolio.ui", e.getMessage())));
                            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)security.getName(), (IStatus)status);
                        }
                    });
                });
            }
            catch (InvocationTargetException e) {
                PortfolioPlugin.log(e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)e.getCause().getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        action.setEnabled(!"MANUAL".equals(security.getFeed()));
        manager.add((IAction)action);
        manager.add((IAction)new Action(Messages.SecurityMenuConfigureOnlineUpdate){

            public void run() {
                EditSecurityDialog dialog = QuotesContextMenu.this.owner.make(EditSecurityDialog.class, security);
                dialog.setShowQuoteConfigurationInitially(true);
                if (dialog.open() != 0) {
                    return;
                }
                QuotesContextMenu.this.owner.markDirty();
                QuotesContextMenu.this.owner.notifyModelUpdated();
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.SecurityMenuImportCSV){

            public void run() {
                FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                fileDialog.setFilterNames(new String[]{Messages.CSVImportLabelFileCSV, Messages.CSVImportLabelFileAll});
                fileDialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                String fileName = fileDialog.open();
                if (fileName == null) {
                    return;
                }
                CSVImportWizard wizard = new CSVImportWizard(QuotesContextMenu.this.owner.getClient(), QuotesContextMenu.this.owner.getPreferenceStore(), new File(fileName));
                QuotesContextMenu.this.owner.inject((Object)wizard);
                wizard.setTarget(security);
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                if (dialog.open() != 0) {
                    return;
                }
                QuotesContextMenu.this.owner.markDirty();
                QuotesContextMenu.this.owner.notifyModelUpdated();
            }
        });
        manager.add((IAction)new Action(Messages.SecurityMenuImportHTML){

            public void run() {
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)new ImportQuotesWizard(security));
                if (dialog.open() != 0) {
                    return;
                }
                QuotesContextMenu.this.owner.markDirty();
                QuotesContextMenu.this.owner.notifyModelUpdated();
            }
        });
        manager.add((IAction)new Action(Messages.SecurityMenuCreateManually){

            public void run() {
                SecurityPriceDialog dialog = new SecurityPriceDialog(Display.getDefault().getActiveShell(), QuotesContextMenu.this.owner.getClient(), security);
                if (dialog.open() != 0) {
                    return;
                }
                QuotesContextMenu.this.owner.markDirty();
                QuotesContextMenu.this.owner.notifyModelUpdated();
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.SecurityMenuExportCSV){

            public void run() {
                FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                fileDialog.setFileName(TextUtil.sanitizeFilename((String)(String.valueOf(security.getName()) + ".csv")));
                fileDialog.setOverwrite(true);
                String fileName = fileDialog.open();
                if (fileName == null) {
                    return;
                }
                try {
                    new CSVExporter().exportSecurityPrices(new File(fileName), security);
                }
                catch (IOException e) {
                    PortfolioPlugin.log(e);
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)e.getMessage());
                }
            }
        });
        manager.add((IContributionItem)new Separator());
        if (security.getCurrencyCode() != null) {
            manager.add((IAction)new Action(Messages.SecurityMenuCreateQuotesFromTransactions){

                public void run() {
                    ExchangeRateProviderFactory factory = QuotesContextMenu.this.owner.getFromContext(ExchangeRateProviderFactory.class);
                    CurrencyConverterImpl converter = new CurrencyConverterImpl(factory, security.getCurrencyCode());
                    QuoteFromTransactionExtractor qte = new QuoteFromTransactionExtractor(QuotesContextMenu.this.owner.getClient(), (CurrencyConverter)converter);
                    if (qte.extractQuotes(security)) {
                        QuotesContextMenu.this.owner.markDirty();
                        QuotesContextMenu.this.owner.notifyModelUpdated();
                    }
                }
            });
        }
        if (security.getLatest() != null) {
            manager.add((IAction)new SimpleAction(Messages.SecurityMenuDeleteLatestQuote, a -> {
                security.setLatest(null);
                this.owner.markDirty();
                this.owner.notifyModelUpdated();
            }));
        }
        manager.add((IAction)new SimpleAction(Messages.SecurityMenuRoundToXDecimalPlaces, a -> {
            IInputValidator validator = newText -> {
                try {
                    int decimalPlaces = Integer.parseInt(newText);
                    if (decimalPlaces < 0 || decimalPlaces > Values.Quote.precision()) {
                        return MessageFormat.format((String)Messages.SecurityMenuErrorMessageRoundingMustBeBetween0AndX, (Object[])new Object[]{Values.Quote.precision()});
                    }
                    return null;
                }
                catch (NumberFormatException e) {
                    return String.format(Messages.CellEditor_NotANumber, newText);
                }
            };
            InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.SecurityMenuRoundToXDecimalPlaces, Messages.SecurityMenuLabelNumberOfDecimalPlaces, String.valueOf(4), validator);
            if (dialog.open() != 0) {
                return;
            }
            int newPrecision = Integer.parseInt(dialog.getValue());
            boolean isDirty = false;
            for (SecurityPrice price : security.getPrices()) {
                long newValue;
                long oldValue = price.getValue();
                if (oldValue == (newValue = BigDecimal.valueOf(oldValue).movePointLeft(Values.Quote.precision()).setScale(newPrecision, Values.MC.getRoundingMode()).movePointRight(Values.Quote.precision()).longValue())) continue;
                price.setValue(newValue);
                isDirty = true;
            }
            if (isDirty) {
                this.owner.markDirty();
                this.owner.notifyModelUpdated();
            }
        }));
    }
}

