/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.PortfolioSnapshot;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.snapshot.filter.EmptyFilter;
import name.abuchen.portfolio.snapshot.filter.PortfolioClientFilter;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.handlers.ImportPDFHandler;
import name.abuchen.portfolio.ui.util.ConfirmAction;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.ListEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.AbstractListView;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.StatementOfAssetsViewer;
import name.abuchen.portfolio.ui.views.TransactionsViewer;
import name.abuchen.portfolio.ui.views.columns.AttributeColumn;
import name.abuchen.portfolio.ui.views.columns.NameColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class PortfolioListView
extends AbstractListView
implements ColumnEditingSupport.ModificationListener {
    private static final String FILTER_INACTIVE_PORTFOLIOS = "filter-retired-portfolios";
    @Inject
    private ExchangeRateProviderFactory factory;
    private TableViewer portfolios;
    private StatementOfAssetsViewer statementOfAssets;
    private TransactionsViewer transactions;
    private ShowHideColumnHelper portfolioColumns;
    private boolean isFiltered = false;

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelPortfolios;
    }

    @PostConstruct
    public void setup() {
        this.isFiltered = this.getPreferenceStore().getBoolean(FILTER_INACTIVE_PORTFOLIOS);
    }

    @Override
    protected int getSashStyle() {
        return 513;
    }

    private void setInput() {
        this.portfolios.setInput((Object)(this.isFiltered ? this.getClient().getActivePortfolios() : this.getClient().getPortfolios()));
    }

    @Override
    public void notifyModelUpdated() {
        ISelection selection = this.portfolios.getSelection();
        this.setInput();
        this.portfolios.setSelection(selection);
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        this.markDirty();
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        this.addNewButton(toolBar);
        this.addFilterButton(toolBar);
        this.addConfigButton(toolBar);
    }

    private void addNewButton(ToolBarManager toolBar) {
        SimpleAction.Runnable newPortfolioAction = a -> {
            Portfolio portfolio = new Portfolio();
            portfolio.setName(Messages.LabelNoName);
            if (!this.getClient().getAccounts().isEmpty()) {
                portfolio.setReferenceAccount((Account)this.getClient().getAccounts().get(0));
            } else {
                Account account = new Account();
                account.setName(Messages.LabelDefaultReferenceAccountName);
                this.getClient().addAccount(account);
                portfolio.setReferenceAccount(account);
            }
            this.getClient().addPortfolio(portfolio);
            this.markDirty();
            this.setInput();
            this.portfolios.editElement((Object)portfolio, 0);
        };
        toolBar.add((IContributionItem)new DropDown(Messages.MenuCreatePortfolioOrTransaction, Images.PLUS, 0, manager -> {
            manager.add((IAction)new SimpleAction(Messages.PortfolioMenuAdd, newPortfolioAction));
            manager.add((IContributionItem)new Separator());
            Portfolio portfolio = (Portfolio)this.portfolios.getStructuredSelection().getFirstElement();
            new SecurityContextMenu(this).menuAboutToShow(manager, null, portfolio);
        }));
    }

    private void addFilterButton(ToolBarManager toolBar) {
        Action filter = new Action(){

            public void run() {
                PortfolioListView.this.isFiltered = !PortfolioListView.this.isFiltered;
                PortfolioListView.this.getPart().getPreferenceStore().setValue(PortfolioListView.FILTER_INACTIVE_PORTFOLIOS, PortfolioListView.this.isFiltered);
                this.setImageDescriptor(PortfolioListView.this.isFiltered ? Images.FILTER_ON.descriptor() : Images.FILTER_OFF.descriptor());
                PortfolioListView.this.setInput();
            }
        };
        filter.setImageDescriptor(this.isFiltered ? Images.FILTER_ON.descriptor() : Images.FILTER_OFF.descriptor());
        filter.setToolTipText(Messages.PortfolioFilterRetiredPortfolios);
        toolBar.add((IAction)filter);
    }

    private void addConfigButton(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> {
            MenuManager m = new MenuManager(Messages.LabelPortfolios);
            this.portfolioColumns.menuAboutToShow((IMenuManager)m);
            manager.add((IContributionItem)m);
            m = new MenuManager(Messages.LabelTransactions);
            this.transactions.getColumnSupport().menuAboutToShow((IMenuManager)m);
            manager.add((IContributionItem)m);
        }));
    }

    @Override
    protected void createTopTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.portfolios = new TableViewer(container, 65536);
        ColumnEditingSupport.prepare((ColumnViewer)this.portfolios);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.portfolios, (int)2);
        this.portfolioColumns = new ShowHideColumnHelper(String.valueOf(PortfolioListView.class.getSimpleName()) + "@top2", this.getPreferenceStore(), this.portfolios, layout);
        Column column = new NameColumn("0", Messages.ColumnPortfolio, 0, 100, this.getClient());
        column.setLabelProvider((CellLabelProvider)new NameColumn.NameColumnLabelProvider(this.getClient()){

            public Color getForeground(Object e) {
                boolean isRetired = ((Portfolio)e).isRetired();
                return isRetired ? Display.getDefault().getSystemColor(16) : null;
            }
        });
        column.getEditingSupport().addListener(this);
        this.portfolioColumns.addColumn(column);
        column = new Column("1", Messages.ColumnReferenceAccount, 0, 160);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Portfolio p = (Portfolio)e;
                return p.getReferenceAccount() != null ? p.getReferenceAccount().getName() : null;
            }
        });
        ColumnViewerSorter.create(Portfolio.class, "referenceAccount").attachTo(column);
        new ListEditingSupport(Portfolio.class, "referenceAccount", this.getClient().getAccounts()).addListener(this).attachTo(column);
        this.portfolioColumns.addColumn(column);
        column = new Column("volume", Messages.ColumnVolumeOfSecurityDeposits, 131072, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            CurrencyConverter converter;
            {
                this.converter = new CurrencyConverterImpl(PortfolioListView.this.factory, PortfolioListView.this.getClient().getBaseCurrency());
            }

            public String getText(Object element) {
                PortfolioSnapshot snapshot = PortfolioSnapshot.create((Portfolio)((Portfolio)element), (CurrencyConverter)this.converter, (LocalDate)LocalDate.now());
                return Values.Money.format(snapshot.getValue(), PortfolioListView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency());
            PortfolioSnapshot p1 = PortfolioSnapshot.create((Portfolio)((Portfolio)o1), (CurrencyConverter)converter, (LocalDate)LocalDate.now());
            PortfolioSnapshot p2 = PortfolioSnapshot.create((Portfolio)((Portfolio)o2), (CurrencyConverter)converter, (LocalDate)LocalDate.now());
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            if (p2 == null) {
                return 1;
            }
            return p1.getValue().compareTo(p2.getValue());
        }));
        this.portfolioColumns.addColumn(column);
        column = new NoteColumn();
        column.getEditingSupport().addListener(this);
        this.portfolioColumns.addColumn(column);
        this.addAttributeColumns(this.portfolioColumns);
        this.portfolioColumns.createColumns();
        this.portfolios.getTable().setHeaderVisible(true);
        this.portfolios.getTable().setLinesVisible(true);
        this.portfolios.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setInput();
        this.portfolios.addSelectionChangedListener(event -> {
            Portfolio portfolio = (Portfolio)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (portfolio != null) {
                this.transactions.setInput(portfolio.getTransactions().stream().map(t -> new TransactionPair((TransactionOwner)portfolio, (Transaction)t)).collect(Collectors.toList()));
                this.transactions.refresh();
                CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, portfolio.getReferenceAccount().getCurrencyCode());
                PortfolioClientFilter clientFilter = new PortfolioClientFilter(portfolio);
                this.statementOfAssets.setInput((ClientFilter)clientFilter, LocalDate.now(), (CurrencyConverter)converter);
            } else {
                this.transactions.setInput(null);
                this.transactions.refresh();
                CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency());
                this.statementOfAssets.setInput((ClientFilter)new EmptyFilter(), LocalDate.now(), (CurrencyConverter)converter);
            }
        });
        this.hookContextMenu((Control)this.portfolios.getTable(), this::fillPortfolioContextMenu);
    }

    private void addAttributeColumns(ShowHideColumnHelper support) {
        AttributeColumn.createFor(this.getClient(), Portfolio.class).forEach(column -> {
            column.getEditingSupport().addListener(this);
            support.addColumn((Column)column);
        });
    }

    private void fillPortfolioContextMenu(IMenuManager manager) {
        Portfolio portfolio = (Portfolio)((IStructuredSelection)this.portfolios.getSelection()).getFirstElement();
        if (portfolio == null) {
            return;
        }
        new SecurityContextMenu(this).menuAboutToShow(manager, null, portfolio);
        if (!portfolio.isRetired()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new SimpleAction(Messages.AccountMenuImportPDF, a -> ImportPDFHandler.runImport(this.getPart(), Display.getDefault().getActiveShell(), this.getClient(), portfolio.getReferenceAccount(), portfolio)));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(portfolio.isRetired() ? Messages.PortfolioMenuActivate : Messages.PortfolioMenuDeactivate, a -> {
            portfolio.setRetired(!portfolio.isRetired());
            this.markDirty();
            this.setInput();
        }));
        manager.add((IAction)new ConfirmAction(Messages.PortfolioMenuDelete, MessageFormat.format(Messages.PortfolioMenuDeleteConfirm, portfolio.getName()), a -> {
            this.getClient().removePortfolio(portfolio);
            this.markDirty();
            this.setInput();
        }));
    }

    @Override
    protected void createBottomTable(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2048);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(Messages.LabelStatementOfAssets);
        this.statementOfAssets = this.make(StatementOfAssetsViewer.class, new Object[0]);
        item.setControl(this.statementOfAssets.createControl((Composite)folder));
        this.hookContextMenu(this.statementOfAssets.getTableViewer().getControl(), manager -> this.statementOfAssets.hookMenuListener(manager, this));
        item = new CTabItem(folder, 0);
        item.setText(Messages.TabTransactions);
        this.transactions = new TransactionsViewer((Composite)folder, this);
        this.inject(this.transactions);
        item.setControl(this.transactions.getControl());
        folder.setSelection(0);
        if (!this.getClient().getActivePortfolios().isEmpty()) {
            this.portfolios.setSelection((ISelection)new StructuredSelection(this.portfolios.getElementAt(0)), true);
        }
    }
}

