/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.function.Function;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.CrossEntry;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientPerformanceSnapshot;
import name.abuchen.portfolio.snapshot.GroupEarningsByAccount;
import name.abuchen.portfolio.snapshot.filter.WithoutTaxesFilter;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.ClientFilterDropDown;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.TableViewerCSVExporter;
import name.abuchen.portfolio.ui.util.TreeViewerCSVExporter;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.MoneyTrailToolTipSupport;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.AbstractHistoricView;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.StatementOfAssetsViewer;
import name.abuchen.portfolio.ui.views.columns.NameColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PerformanceView
extends AbstractHistoricView {
    @Inject
    private SelectionService selectionService;
    @Inject
    private ExchangeRateProviderFactory factory;
    private ClientFilterDropDown clientFilter;
    private boolean preTax = false;
    private TreeViewer calculation;
    private StatementOfAssetsViewer snapshotStart;
    private StatementOfAssetsViewer snapshotEnd;
    private TableViewer earnings;
    private TableViewer earningsByAccount;
    private TableViewer taxes;
    private TableViewer fees;

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelPerformanceCalculation;
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        super.addButtons(toolBar);
        this.clientFilter = new ClientFilterDropDown(this.getClient(), this.getPreferenceStore(), PerformanceView.class.getSimpleName(), filter -> this.notifyModelUpdated());
        toolBar.add((IContributionItem)this.clientFilter);
        toolBar.add((IContributionItem)new ExportDropDown());
        toolBar.add((IContributionItem)new DropDown(Messages.MenuConfigureView, Images.CONFIG, 0, manager -> {
            SimpleAction action = new SimpleAction(Messages.LabelPreTax, a -> {
                this.preTax = !this.preTax;
                this.reportingPeriodUpdated();
            });
            action.setChecked(this.preTax);
            manager.add((IAction)action);
        }));
    }

    @Override
    public void reportingPeriodUpdated() {
        Interval period = this.getReportingPeriod().toInterval(LocalDate.now());
        CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency());
        Client filteredClient = this.clientFilter.getSelectedFilter().filter(this.getClient());
        if (this.preTax) {
            filteredClient = new WithoutTaxesFilter().filter(filteredClient);
        }
        ClientPerformanceSnapshot snapshot = new ClientPerformanceSnapshot(filteredClient, (CurrencyConverter)converter, period);
        try {
            this.calculation.getTree().setRedraw(false);
            this.calculation.setInput((Object)snapshot);
            this.calculation.expandAll();
            this.calculation.getTree().getParent().layout();
        }
        finally {
            this.calculation.getTree().setRedraw(true);
        }
        this.snapshotStart.setInput(this.clientFilter.getSelectedFilter(), snapshot.getStartClientSnapshot().getTime(), (CurrencyConverter)converter);
        this.snapshotEnd.setInput(this.clientFilter.getSelectedFilter(), snapshot.getEndClientSnapshot().getTime(), (CurrencyConverter)converter);
        this.earnings.setInput((Object)snapshot.getEarnings());
        this.earningsByAccount.setInput((Object)new GroupEarningsByAccount(snapshot).getItems());
        this.taxes.setInput((Object)snapshot.getTaxes());
        this.fees.setInput((Object)snapshot.getFees());
    }

    @Override
    public void notifyModelUpdated() {
        this.reportingPeriodUpdated();
    }

    @Override
    protected Control createBody(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2048);
        this.createCalculationItem(folder, Messages.PerformanceTabCalculation);
        this.snapshotStart = this.createStatementOfAssetsItem(folder, Messages.PerformanceTabAssetsAtStart);
        this.snapshotEnd = this.createStatementOfAssetsItem(folder, Messages.PerformanceTabAssetsAtEnd);
        this.earnings = this.createTransactionViewer(folder, Messages.PerformanceTabEarnings);
        this.createEarningsByAccountsItem(folder, Messages.PerformanceTabEarningsByAccount);
        this.taxes = this.createTransactionViewer(folder, Messages.PerformanceTabTaxes);
        this.fees = this.createTransactionViewer(folder, Messages.PerformanceTabFees);
        folder.setSelection(0);
        this.reportingPeriodUpdated();
        return folder;
    }

    private StatementOfAssetsViewer createStatementOfAssetsItem(CTabFolder folder, String title) {
        StatementOfAssetsViewer viewer = this.make(StatementOfAssetsViewer.class, new Object[0]);
        Control control = viewer.createControl((Composite)folder);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(title);
        item.setControl(control);
        return viewer;
    }

    private void createCalculationItem(CTabFolder folder, String title) {
        Composite container = new Composite((Composite)folder, 0);
        TreeColumnLayout layout = new TreeColumnLayout();
        container.setLayout((Layout)layout);
        this.calculation = new TreeViewer(container, 65536);
        MoneyTrailToolTipSupport.enableFor((ColumnViewer)this.calculation, 2);
        final Font boldFont = JFaceResources.getFontRegistry().getBold(container.getFont().getFontData()[0].getName());
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(this.getClass().getSimpleName()) + "-calculation@v2", this.getPreferenceStore(), this.calculation, layout);
        NameColumn column = new NameColumn("label", Messages.ColumnLabel, 0, 350, this.getClient());
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ClientPerformanceSnapshot.Category) {
                    ClientPerformanceSnapshot.Category cat = (ClientPerformanceSnapshot.Category)element;
                    return cat.getLabel();
                }
                if (element instanceof ClientPerformanceSnapshot.Position) {
                    ClientPerformanceSnapshot.Position pos = (ClientPerformanceSnapshot.Position)element;
                    return pos.getLabel();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof ClientPerformanceSnapshot.Category) {
                    return Images.CATEGORY.image();
                }
                if (element instanceof ClientPerformanceSnapshot.Position) {
                    ClientPerformanceSnapshot.Position position = (ClientPerformanceSnapshot.Position)element;
                    Security security = position.getSecurity();
                    if (security != null) {
                        boolean hasHoldings;
                        ClientPerformanceSnapshot snapshot = ((PerformanceContentProvider)PerformanceView.this.calculation.getContentProvider()).getSnapshot();
                        boolean bl = hasHoldings = snapshot.getEndClientSnapshot().getPositionsByVehicle().get(security) != null;
                        if (hasHoldings) {
                            return LogoManager.instance().getDefaultColumnImage(security, PerformanceView.this.getClient().getSettings());
                        }
                        return Images.SECURITY_RETIRED.image();
                    }
                    return null;
                }
                return null;
            }

            public Font getFont(Object element) {
                if (element instanceof ClientPerformanceSnapshot.Category) {
                    return boldFont;
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new NameColumn("value", Messages.ColumnValue, 131072, 80, this.getClient());
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ClientPerformanceSnapshot.Category) {
                    ClientPerformanceSnapshot.Category cat = (ClientPerformanceSnapshot.Category)element;
                    return Values.Money.format(cat.getValuation(), PerformanceView.this.getClient().getBaseCurrency());
                }
                if (element instanceof ClientPerformanceSnapshot.Position) {
                    ClientPerformanceSnapshot.Position pos = (ClientPerformanceSnapshot.Position)element;
                    return Values.Money.format(pos.getValue(), PerformanceView.this.getClient().getBaseCurrency());
                }
                return null;
            }

            public Font getFont(Object element) {
                if (element instanceof ClientPerformanceSnapshot.Category) {
                    return boldFont;
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof ClientPerformanceSnapshot.Position)) {
                    return null;
                }
                ClientPerformanceSnapshot.Position position = (ClientPerformanceSnapshot.Position)element;
                return position.explain("value").isPresent() ? "value" : null;
            }
        });
        support.addColumn(column);
        column = new NameColumn("forex", Messages.ColumnThereofForeignCurrencyGains, 131072, 80, this.getClient());
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ClientPerformanceSnapshot.Position) {
                    ClientPerformanceSnapshot.Position pos = (ClientPerformanceSnapshot.Position)element;
                    return Values.Money.formatNonZero(pos.getForexGain(), PerformanceView.this.getClient().getBaseCurrency());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof ClientPerformanceSnapshot.Position)) {
                    return null;
                }
                ClientPerformanceSnapshot.Position position = (ClientPerformanceSnapshot.Position)element;
                return position.explain("forexGain").isPresent() ? "forexGain" : null;
            }
        });
        support.addColumn(column);
        support.createColumns();
        this.calculation.getTree().setHeaderVisible(true);
        this.calculation.getTree().setLinesVisible(true);
        this.calculation.setContentProvider((IContentProvider)new PerformanceContentProvider());
        this.calculation.addSelectionChangedListener(event -> {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selection instanceof ClientPerformanceSnapshot.Position && ((ClientPerformanceSnapshot.Position)selection).getSecurity() != null) {
                this.selectionService.setSelection(new SecuritySelection(this.getClient(), ((ClientPerformanceSnapshot.Position)selection).getSecurity()));
            }
        });
        CTabItem item = new CTabItem(folder, 0);
        item.setText(title);
        item.setControl((Control)container);
        this.hookContextMenu((Control)this.calculation.getTree(), this::fillContextMenu);
    }

    private void fillContextMenu(IMenuManager manager) {
        Object selection = ((IStructuredSelection)this.calculation.getSelection()).getFirstElement();
        if (!(selection instanceof ClientPerformanceSnapshot.Position)) {
            return;
        }
        Security security = ((ClientPerformanceSnapshot.Position)selection).getSecurity();
        new SecurityContextMenu(this).menuAboutToShow(manager, security);
    }

    private TableViewer createTransactionViewer(CTabFolder folder, String title) {
        Composite container = new Composite((Composite)folder, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        TableViewer transactionViewer = new TableViewer(container, 65536);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)transactionViewer, (int)2);
        transactionViewer.addSelectionChangedListener(event -> {
            TransactionPair tx = (TransactionPair)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (tx != null && tx.getTransaction().getSecurity() != null) {
                this.selectionService.setSelection(new SecuritySelection(this.getClient(), tx.getTransaction().getSecurity()));
            }
        });
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(PerformanceView.class.getSimpleName()) + "@2" + title, this.getPreferenceStore(), transactionViewer, layout);
        Column column = new Column(Messages.ColumnDate, 0, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Values.DateTime.format((Object)((TransactionPair)element).getTransaction().getDateTime());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getDateTime()), 128);
        support.addColumn(column);
        column = new Column(Messages.ColumnTransactionType, 16384, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Transaction t = ((TransactionPair)element).getTransaction();
                return t instanceof AccountTransaction ? ((AccountTransaction)t).getType().toString() : ((PortfolioTransaction)t).getType().toString();
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> {
            Transaction t = ((TransactionPair)e).getTransaction();
            return t instanceof AccountTransaction ? ((AccountTransaction)t).getType().toString() : ((PortfolioTransaction)t).getType().toString();
        }));
        support.addColumn(column);
        column = new Column(Messages.ColumnAmount, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Values.Money.format(((TransactionPair)element).getTransaction().getMonetaryAmount(), PerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getMonetaryAmount()));
        support.addColumn(column);
        this.addTaxesColumn(support);
        this.addFeesColumn(support);
        this.addSecurityColumn(support);
        this.addPortfolioColumn(support);
        this.addAccountColumn(support);
        column = new NoteColumn();
        column.setEditingSupport(null);
        support.addColumn(column);
        support.createColumns();
        transactionViewer.getTable().setHeaderVisible(true);
        transactionViewer.getTable().setLinesVisible(true);
        transactionViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        CTabItem item = new CTabItem(folder, 0);
        item.setText(title);
        item.setControl((Control)container);
        return transactionViewer;
    }

    private void addTaxesColumn(ShowHideColumnHelper support) {
        Column column = new Column(Messages.ColumnTaxes, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Transaction t = ((TransactionPair)element).getTransaction();
                if (t instanceof AccountTransaction) {
                    AccountTransaction at = (AccountTransaction)t;
                    switch (at.getType()) {
                        case TAXES: {
                            return Values.Money.format(at.getMonetaryAmount(), PerformanceView.this.getClient().getBaseCurrency());
                        }
                        case TAX_REFUND: {
                            return Values.Money.format(at.getMonetaryAmount().multiply(-1L), PerformanceView.this.getClient().getBaseCurrency());
                        }
                    }
                }
                return Values.Money.format(t.getUnitSum(Transaction.Unit.Type.TAX), PerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getUnitSum(Transaction.Unit.Type.TAX)));
        support.addColumn(column);
    }

    private void addFeesColumn(ShowHideColumnHelper support) {
        Column column = new Column(Messages.ColumnFees, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Transaction t = ((TransactionPair)element).getTransaction();
                if (t instanceof AccountTransaction) {
                    AccountTransaction at = (AccountTransaction)t;
                    switch (at.getType()) {
                        case FEES: {
                            return Values.Money.format(t.getMonetaryAmount(), PerformanceView.this.getClient().getBaseCurrency());
                        }
                        case FEES_REFUND: {
                            return Values.Money.format(t.getMonetaryAmount().multiply(-1L), PerformanceView.this.getClient().getBaseCurrency());
                        }
                    }
                }
                return Values.Money.format(t.getUnitSum(Transaction.Unit.Type.FEE), PerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getUnitSum(Transaction.Unit.Type.FEE)));
        support.addColumn(column);
    }

    private void addSecurityColumn(ShowHideColumnHelper support) {
        Column column = new Column(Messages.ColumnSecurity, 16384, 250);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Security security = ((TransactionPair)element).getTransaction().getSecurity();
                return security != null ? security.getName() : null;
            }

            public Image getImage(Object element) {
                Security security = ((TransactionPair)element).getTransaction().getSecurity();
                return security != null ? LogoManager.instance().getDefaultColumnImage(security, PerformanceView.this.getClient().getSettings()) : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> {
            Security security = ((TransactionPair)e).getTransaction().getSecurity();
            return security != null ? security.getName() : null;
        }));
        support.addColumn(column);
    }

    private void addPortfolioColumn(ShowHideColumnHelper support) {
        Column column = new Column(Messages.ColumnPortfolio, 16384, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Portfolio portfolio = ((TransactionPair)element).getOwner() instanceof Portfolio ? (Portfolio)((TransactionPair)element).getOwner() : null;
                return portfolio != null ? portfolio.getName() : null;
            }

            public Image getImage(Object element) {
                Portfolio portfolio = ((TransactionPair)element).getOwner() instanceof Portfolio ? (Portfolio)((TransactionPair)element).getOwner() : null;
                return portfolio != null ? LogoManager.instance().getDefaultColumnImage(portfolio, PerformanceView.this.getClient().getSettings()) : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> {
            Portfolio portfolio = ((TransactionPair)e).getOwner() instanceof Portfolio ? (Portfolio)((TransactionPair)e).getOwner() : null;
            return portfolio != null ? portfolio.getName() : null;
        }));
        support.addColumn(column);
    }

    private void addAccountColumn(ShowHideColumnHelper support) {
        Column column = new Column(Messages.ColumnAccount, 16384, 100);
        final Function<Object, Account> getAccount = element -> {
            TransactionPair pair = (TransactionPair)element;
            if (pair.getOwner() instanceof Account) {
                return (Account)pair.getOwner();
            }
            CrossEntry crossEntry = pair.getTransaction().getCrossEntry();
            if (crossEntry == null) {
                return null;
            }
            TransactionOwner other = crossEntry.getCrossOwner(pair.getTransaction());
            return other instanceof Account ? (Account)other : null;
        };
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Account account = (Account)getAccount.apply(element);
                return account != null ? account.getName() : null;
            }

            public Image getImage(Object element) {
                Account account = (Account)getAccount.apply(element);
                return account != null ? LogoManager.instance().getDefaultColumnImage(account, PerformanceView.this.getClient().getSettings()) : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> {
            Account account = (Account)getAccount.apply(e);
            return account != null ? account.getName() : null;
        }));
        support.addColumn(column);
    }

    private void createEarningsByAccountsItem(CTabFolder folder, String title) {
        Composite container = new Composite((Composite)folder, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.earningsByAccount = new TableViewer(container, 65536);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.earningsByAccount, (int)2);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(PerformanceView.class.getSimpleName()) + "@byaccounts2", this.getPreferenceStore(), this.earningsByAccount, layout);
        Column column = new Column(Messages.ColumnSource, 16384, 400);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GroupEarningsByAccount.Item item = (GroupEarningsByAccount.Item)element;
                return item.getAccount().getName();
            }

            public Image getImage(Object element) {
                GroupEarningsByAccount.Item item = (GroupEarningsByAccount.Item)element;
                return LogoManager.instance().getDefaultColumnImage(item.getAccount(), PerformanceView.this.getClient().getSettings());
            }
        });
        column.setSorter(ColumnViewerSorter.create(GroupEarningsByAccount.Item.class, "account"));
        support.addColumn(column);
        column = new Column(Messages.ColumnDividendPayment, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GroupEarningsByAccount.Item item = (GroupEarningsByAccount.Item)element;
                return Values.Money.format(item.getDividends(), PerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(GroupEarningsByAccount.Item.class, "dividends"));
        support.addColumn(column);
        column = new Column(Messages.ColumnInterest, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GroupEarningsByAccount.Item item = (GroupEarningsByAccount.Item)element;
                return Values.Money.format(item.getInterest(), PerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(GroupEarningsByAccount.Item.class, "interest"));
        support.addColumn(column);
        column = new Column(Messages.ColumnEarnings, 131072, 80);
        column.setDescription(Messages.ColumnEarnings_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GroupEarningsByAccount.Item item = (GroupEarningsByAccount.Item)element;
                return Values.Money.format(item.getSum(), PerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(GroupEarningsByAccount.Item.class, "sum"));
        support.addColumn(column);
        column = new Column(Messages.ColumnFees, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GroupEarningsByAccount.Item item = (GroupEarningsByAccount.Item)element;
                return Values.Money.format(item.getFees(), PerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(GroupEarningsByAccount.Item.class, "fees"));
        support.addColumn(column);
        column = new Column(Messages.ColumnTaxes, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GroupEarningsByAccount.Item item = (GroupEarningsByAccount.Item)element;
                return Values.Money.format(item.getTaxes(), PerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(GroupEarningsByAccount.Item.class, "taxes"));
        support.addColumn(column);
        support.createColumns();
        this.earningsByAccount.getTable().setHeaderVisible(true);
        this.earningsByAccount.getTable().setLinesVisible(true);
        this.earningsByAccount.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        CTabItem item = new CTabItem(folder, 0);
        item.setText(title);
        item.setControl((Control)container);
    }

    private final class ExportDropDown
    extends DropDown
    implements IMenuListener {
        private ExportDropDown() {
            super(Messages.MenuExportData, Images.EXPORT, 0);
            this.setMenuListener(this);
        }

        public void menuAboutToShow(IMenuManager manager) {
            String fileSuffix = ".csv";
            manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, Messages.PerformanceTabCalculation), a -> new TreeViewerCSVExporter(PerformanceView.this.calculation).export(String.valueOf(Messages.PerformanceTabCalculation) + ".csv")));
            manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, Messages.PerformanceTabAssetsAtStart), a -> new TableViewerCSVExporter(PerformanceView.this.snapshotStart.getTableViewer()).export(String.valueOf(Messages.PerformanceTabAssetsAtStart) + ".csv")));
            manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, Messages.PerformanceTabAssetsAtEnd), a -> new TableViewerCSVExporter(PerformanceView.this.snapshotEnd.getTableViewer()).export(String.valueOf(Messages.PerformanceTabAssetsAtEnd) + ".csv")));
            manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, Messages.PerformanceTabEarnings), a -> new TableViewerCSVExporter(PerformanceView.this.earnings).export(String.valueOf(Messages.PerformanceTabEarnings) + ".csv")));
            manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, Messages.PerformanceTabEarningsByAccount), a -> new TableViewerCSVExporter(PerformanceView.this.earningsByAccount).export(String.valueOf(Messages.PerformanceTabEarningsByAccount) + ".csv")));
            manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, Messages.PerformanceTabTaxes), a -> new TableViewerCSVExporter(PerformanceView.this.taxes).export(String.valueOf(Messages.PerformanceTabTaxes) + ".csv")));
            manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, Messages.PerformanceTabFees), a -> new TableViewerCSVExporter(PerformanceView.this.fees).export(String.valueOf(Messages.PerformanceTabFees) + ".csv")));
        }
    }

    private static class PerformanceContentProvider
    implements ITreeContentProvider {
        private ClientPerformanceSnapshot snapshot;
        private ClientPerformanceSnapshot.Category[] categories;

        private PerformanceContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.snapshot = null;
                this.categories = new ClientPerformanceSnapshot.Category[0];
            } else if (newInput instanceof ClientPerformanceSnapshot) {
                this.snapshot = (ClientPerformanceSnapshot)newInput;
                this.categories = this.snapshot.getCategories().toArray(new ClientPerformanceSnapshot.Category[0]);
            } else {
                throw new IllegalArgumentException("Unsupported type: " + newInput.getClass().getName());
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.categories;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ClientPerformanceSnapshot.Category) {
                return ((ClientPerformanceSnapshot.Category)parentElement).getPositions().toArray(new ClientPerformanceSnapshot.Position[0]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ClientPerformanceSnapshot.Position) {
                ClientPerformanceSnapshot.Category[] categoryArray = this.categories;
                int n = this.categories.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientPerformanceSnapshot.Category c = categoryArray[n2];
                    if (c.getPositions().contains(element)) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ClientPerformanceSnapshot.Category && !((ClientPerformanceSnapshot.Category)element).getPositions().isEmpty();
        }

        public void dispose() {
        }

        public ClientPerformanceSnapshot getSnapshot() {
            return this.snapshot;
        }
    }
}

