/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import name.abuchen.portfolio.json.JClient;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.TableViewerCSVExporter;
import name.abuchen.portfolio.ui.views.TransactionsViewer;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AllTransactionsView
extends AbstractFinanceView {
    private TransactionsViewer table;
    private String filter;

    @Override
    public void notifyModelUpdated() {
        this.table.setInput(this.getClient().getAllTransactions());
    }

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelAllTransactions;
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        this.addSearchButton(toolBar);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IContributionItem)new DropDown(Messages.MenuExportData, Images.EXPORT, 0, manager -> {
            manager.add((IAction)new SimpleAction(String.valueOf(Messages.LabelAllTransactions) + " (CSV)", a -> new TableViewerCSVExporter(this.table.getTableViewer()).export(String.valueOf(Messages.LabelAllTransactions) + ".csv")));
            String label = this.table.getTableViewer().getSelection().isEmpty() ? Messages.LabelAllTransactions : Messages.LabelSelectedTransactions;
            manager.add((IAction)new SimpleAction(String.valueOf(label) + " (JSON)", a -> {
                IStructuredSelection selection = this.table.getTableViewer().getStructuredSelection();
                List transactions = selection.isEmpty() ? (List)this.table.getTableViewer().getInput() : selection.toList();
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                dialog.setFileName(TextUtil.sanitizeFilename((String)(String.valueOf(Messages.LabelAllTransactions) + ".json")));
                dialog.setOverwrite(true);
                String name = dialog.open();
                if (name == null) {
                    return;
                }
                File file = new File(name);
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                        ((Writer)writer).append(JClient.from((List)transactions).toJson());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    PortfolioPlugin.log(e);
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)e.getMessage());
                }
            }));
        }));
        toolBar.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> this.table.getColumnSupport().menuAboutToShow(manager)));
    }

    private void addSearchButton(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)new ControlContribution("searchbox"){

            protected Control createControl(Composite parent) {
                Text search = new Text(parent, 384);
                search.setMessage(Messages.LabelSearch);
                search.setSize(300, -1);
                search.addModifyListener(e -> {
                    String filterText = search.getText().trim();
                    if (filterText.length() == 0) {
                        AllTransactionsView.this.filter = null;
                        AllTransactionsView.this.table.refresh(false);
                    } else {
                        AllTransactionsView.this.filter = filterText.toLowerCase();
                        AllTransactionsView.this.table.refresh(false);
                    }
                });
                return search;
            }

            protected int computeWidth(Control control) {
                return control.computeSize((int)100, (int)-1, (boolean)true).x;
            }
        });
    }

    @Override
    protected Control createBody(Composite parent) {
        this.table = new TransactionsViewer(AllTransactionsView.class.getName(), parent, this);
        this.inject(this.table);
        final ArrayList<Function<TransactionPair, Object>> searchLabels = new ArrayList<Function<TransactionPair, Object>>();
        searchLabels.add(tx -> tx.getTransaction().getSecurity());
        searchLabels.add(tx -> tx.getTransaction().getOptionalSecurity().map(Security::getIsin).orElse(null));
        searchLabels.add(tx -> tx.getTransaction().getOptionalSecurity().map(Security::getWkn).orElse(null));
        searchLabels.add(tx -> tx.getTransaction().getOptionalSecurity().map(Security::getTickerSymbol).orElse(null));
        searchLabels.add(TransactionPair::getOwner);
        searchLabels.add(tx -> tx.getTransaction().getCrossEntry() != null ? tx.getTransaction().getCrossEntry().getCrossOwner(tx.getTransaction()) : null);
        searchLabels.add(tx -> tx.getTransaction() instanceof AccountTransaction ? ((AccountTransaction)tx.getTransaction()).getType() : ((PortfolioTransaction)tx.getTransaction()).getType());
        searchLabels.add(tx -> tx.getTransaction().getNote());
        searchLabels.add(tx -> tx.getTransaction().getShares());
        searchLabels.add(tx -> tx.getTransaction().getMonetaryAmount());
        this.table.addFilter(new ViewerFilter(){

            public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
                return AllTransactionsView.this.filter == null ? elements : super.filter(viewer, parent, elements);
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                TransactionPair tx = (TransactionPair)element;
                for (Function label : searchLabels) {
                    Object l = label.apply(tx);
                    if (l == null || l.toString().toLowerCase().indexOf(AllTransactionsView.this.filter) < 0) continue;
                    return true;
                }
                return false;
            }
        });
        this.notifyModelUpdated();
        return this.table.getControl();
    }
}

