/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.AccountSnapshot;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ISeries;

public class AccountBalanceChart
extends TimelineChart {
    public AccountBalanceChart(Composite parent) {
        super(parent);
        this.getTitle().setVisible(false);
    }

    public void updateChart(Account account, ExchangeRateProviderFactory exchangeRateProviderFactory) {
        try {
            this.suspendUpdate(true);
            ISeries[] iSeriesArray = this.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            if (account == null) {
                return;
            }
            List tx = account.getTransactions();
            if (tx.isEmpty()) {
                return;
            }
            LocalDate now = LocalDate.now();
            LocalDate start = ((AccountTransaction)tx.get(0)).getDateTime().toLocalDate();
            LocalDate end = ((AccountTransaction)tx.get(tx.size() - 1)).getDateTime().toLocalDate();
            CurrencyConverterImpl converter = new CurrencyConverterImpl(exchangeRateProviderFactory, account.getCurrencyCode());
            Collections.sort(tx, new Transaction.ByDate());
            if (now.isAfter(end)) {
                end = now;
            }
            if (now.isBefore(start)) {
                start = now;
            }
            int days = (int)ChronoUnit.DAYS.between(start, end) + 2;
            LocalDate[] dates = new LocalDate[days];
            double[] values = new double[days];
            dates[0] = start.minusDays(1L);
            values[0] = 0.0;
            int ii = 1;
            while (ii < dates.length) {
                values[ii] = (double)AccountSnapshot.create((Account)account, (CurrencyConverter)converter, (LocalDate)start).getFunds().getAmount() / Values.Amount.divider();
                dates[ii] = start;
                start = start.plusDays(1L);
                ++ii;
            }
            this.addDateSeries(dates, values, Colors.CASH, account.getName());
        }
        finally {
            this.adjustRange();
            this.suspendUpdate(false);
        }
    }
}

