/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractTabbedView<T extends Tab>
extends AbstractFinanceView {
    private CTabFolder folder;
    private int initiallySelectedTab = 0;

    protected abstract List<T> createTabs();

    @Inject
    @Optional
    public void init(@Named(value="name.abuchen.portfolio.ui.param.viewparameter") Integer parameter) {
        this.initiallySelectedTab = parameter;
    }

    private void updateToolBar() {
        ToolBarManager manager = this.getToolBarManager();
        manager.removeAll();
        this.getSelection().addButtons(this.getToolBarManager());
        manager.update(true);
    }

    @Override
    protected final Control createBody(Composite parent) {
        this.folder = new CTabFolder(parent, 2048);
        for (Tab tab : this.createTabs()) {
            Composite container = tab.createTab((Composite)this.folder);
            CTabItem item = new CTabItem(this.folder, 0);
            item.setText(tab.getTitle());
            item.setControl((Control)container);
            item.setData((Object)tab);
        }
        this.folder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateToolBar()));
        if (this.initiallySelectedTab >= 0 && this.initiallySelectedTab < this.folder.getItemCount()) {
            this.folder.setSelection(this.initiallySelectedTab);
        } else {
            this.folder.setSelection(0);
        }
        this.updateToolBar();
        return this.folder;
    }

    protected T getSelection() {
        CTabItem item = this.folder.getSelection();
        return (T)((Tab)item.getData());
    }

    public static interface Tab {
        public String getTitle();

        public Composite createTab(Composite var1);

        default public void addButtons(ToolBarManager toolBarManager) {
        }
    }
}

