/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.text.DecimalFormatSymbols;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.util.FormatHelper;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class SharesLabelProvider
extends OwnerDrawLabelProvider {
    private static final String POINT = String.valueOf(new DecimalFormatSymbols().getDecimalSeparator());
    private ColumnViewer viewer;
    private TextLayout cachedTextLayout;

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public abstract Long getValue(Object var1);

    public String getToolTipText(Object element) {
        Long value = this.getValue(element);
        return value != null ? Values.Share.format((Object)value) : null;
    }

    private TextLayout getSharedTextLayout(Display display) {
        if (this.cachedTextLayout == null) {
            int orientation = this.viewer.getControl().getStyle() & 0x6000000;
            this.cachedTextLayout = new TextLayout((Device)display);
            this.cachedTextLayout.setOrientation(orientation);
        }
        return this.cachedTextLayout;
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        this.viewer = viewer;
        super.initialize(viewer, column);
    }

    private Rectangle getSize(Event event, String text) {
        StringBuilder builder = new StringBuilder(text);
        int p = builder.indexOf(POINT);
        if (p >= 0) {
            builder.delete(p, builder.length());
        }
        builder.append(',');
        builder.append(FormatHelper.getSharesDecimalPartPlaceholder());
        builder.append(' ');
        TextLayout textLayout = this.getSharedTextLayout(event.display);
        textLayout.setText(builder.toString());
        return textLayout.getBounds();
    }

    private Rectangle getBounds(Widget widget, int index) {
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getBounds(index);
        }
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getBounds(index);
        }
        throw new IllegalArgumentException();
    }

    protected void measure(Event event, Object element) {
        Long value = this.getValue(element);
        if (value != null) {
            String text = FormatHelper.getSharesFormat().format((double)value.longValue() / Values.Share.divider());
            Rectangle size = this.getSize(event, text);
            event.setBounds(new Rectangle(event.x, event.y, size.width, event.height));
        }
    }

    protected void paint(Event event, Object element) {
        Color newForeground;
        Long value;
        boolean isSelected;
        Rectangle tableItem = this.getBounds(event.item, event.index);
        boolean bl = isSelected = (event.detail & 2) != 0 || (event.detail & 0x20) != 0;
        if (!isSelected) {
            this.fillBackground(event, element, tableItem);
        }
        if ((value = this.getValue(element)) == null) {
            return;
        }
        Color oldForeground = null;
        Color color = newForeground = isSelected ? null : this.getForeground(element);
        if (newForeground != null) {
            oldForeground = event.gc.getForeground();
            event.gc.setForeground(newForeground);
        }
        String text = FormatHelper.getSharesFormat().format((double)value.longValue() / Values.Share.divider());
        Rectangle size = this.getSize(event, text);
        TextLayout textLayout = this.getSharedTextLayout(event.display);
        textLayout.setText(text);
        Rectangle layoutBounds = textLayout.getBounds();
        int x = event.x + tableItem.width - Math.min(size.width, tableItem.width);
        int y = event.y + Math.max(0, (tableItem.height - layoutBounds.height) / 2);
        textLayout.draw(event.gc, x, y);
        if (oldForeground != null) {
            event.gc.setForeground(oldForeground);
        }
    }

    private void fillBackground(Event event, Object element, Rectangle bounds) {
        Color newBackground = this.getBackground(element);
        if (newBackground != null) {
            Color oldBackground = event.gc.getBackground();
            event.gc.setBackground(newBackground);
            event.gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            event.gc.setBackground(oldBackground);
        }
    }

    protected void erase(Event event, Object element) {
    }
}

