/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.swt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StyledLabel
extends Canvas {
    private TextLayout textLayout;
    private SAXParserFactory spf;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public StyledLabel(Composite parent, int style) {
        super(parent, style);
        try {
            this.spf = SAXParserFactory.newInstance();
            this.spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.textLayout = new TextLayout((Device)parent.getDisplay());
        this.textLayout.setFont(this.getFont());
        this.addListener(9, this::handlePaint);
        this.addListener(12, this::handleDispose);
        this.addListener(3, this::openBrowser);
    }

    public void setText(String text) {
        this.checkWidget();
        try {
            SAXParser parser = this.spf.newSAXParser();
            StyleRangeParser handler = new StyleRangeParser();
            parser.parse((InputStream)new ByteArrayInputStream(("<text>" + text + "</text>").getBytes(StandardCharsets.UTF_8)), (DefaultHandler)handler);
            this.textLayout.setText(handler.getPlainText());
            handler.getStyleRanges().forEach(r -> {
                if (r.fontStyle != 0) {
                    Font font = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.textLayout.getFont()).setStyle(r.fontStyle));
                    this.textLayout.setStyle(new TextStyle(font, r.foreground, r.background), r.start, r.start + r.length - 1);
                } else {
                    this.textLayout.setStyle((TextStyle)r, r.start, r.start + r.length - 1);
                }
            });
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.textLayout.setFont(font);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.textLayout.setWidth(wHint == -1 ? -1 : Math.max(wHint - 4, 1));
        Rectangle bounds = this.textLayout.getBounds();
        return new Point(bounds.width + 4, bounds.height + 1);
    }

    private void handlePaint(Event e) {
        this.textLayout.draw(e.gc, 0, 0);
        e.type = 0;
    }

    private void handleDispose(Event e) {
        this.textLayout.dispose();
        e.type = 0;
    }

    private void openBrowser(Event event) {
        int offset = this.textLayout.getOffset(event.x, event.y, null);
        if (offset == -1) {
            return;
        }
        TextStyle style = this.textLayout.getStyle(offset);
        if (style != null && style.data != null) {
            DesktopAPI.browse(String.valueOf(style.data));
        }
    }

    private static final class StyleRangeParser
    extends DefaultHandler {
        private StringBuilder plainText = new StringBuilder();
        private List<StyleRange> styleRanges = new ArrayList<StyleRange>();
        private LinkedList<Tag> stack = new LinkedList();

        private StyleRangeParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"text".equals(qName)) {
                Tag tag = new Tag(qName, this.plainText.length());
                int l = attributes.getLength();
                int ii = 0;
                while (ii < l) {
                    tag.attributes.put(attributes.getQName(ii), attributes.getValue(ii));
                    ++ii;
                }
                this.stack.add(tag);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Tag tag = null;
            while (!this.stack.isEmpty()) {
                Tag t = this.stack.removeLast();
                if (!t.tagName.equals(qName)) continue;
                tag = t;
                break;
            }
            if (tag == null) {
                return;
            }
            if ("red".equals(qName)) {
                this.styleRanges.add(new StyleRange(tag.start, this.plainText.length() - tag.start, Colors.theme().redForeground(), null));
            } else if ("green".equals(qName)) {
                this.styleRanges.add(new StyleRange(tag.start, this.plainText.length() - tag.start, Colors.theme().greenForeground(), null));
            } else if ("strong".equals(qName)) {
                this.styleRanges.add(new StyleRange(tag.start, this.plainText.length() - tag.start, null, null, 1));
            } else if ("em".equals(qName)) {
                this.styleRanges.add(new StyleRange(tag.start, this.plainText.length() - tag.start, null, null, 2));
            } else if ("a".equals(qName)) {
                StyleRange style = new StyleRange();
                style.underline = true;
                style.underlineStyle = 4;
                style.underlineColor = Colors.theme().hyperlink();
                style.foreground = Colors.theme().hyperlink();
                style.data = tag.attributes.get("href");
                style.start = tag.start;
                style.length = this.plainText.length() - tag.start;
                this.styleRanges.add(style);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.plainText.append(ch, start, length);
        }

        public List<StyleRange> getStyleRanges() {
            return this.styleRanges;
        }

        public String getPlainText() {
            return this.plainText.toString();
        }
    }

    private static class Tag {
        private String tagName;
        private int start;
        private Map<String, String> attributes = new HashMap<String, String>();

        public Tag(String tagName, int start) {
            this.tagName = tagName;
            this.start = start;
        }
    }
}

