/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import name.abuchen.portfolio.ui.PortfolioPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tracker;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.Range;

public class ZoomInAreaListener
implements Listener {
    private final Chart chart;

    public static void attachTo(Chart chart) {
        ZoomInAreaListener listener = new ZoomInAreaListener(chart);
        chart.getPlotArea().addListener(3, (Listener)listener);
    }

    private ZoomInAreaListener(Chart chart) {
        this.chart = chart;
    }

    public void handleEvent(Event event) {
        if (event.button == 1 && event.stateMask == SWT.MOD1) {
            Tracker tracker = new Tracker(this.chart.getPlotArea(), 16);
            tracker.setRectangles(new Rectangle[]{new Rectangle(event.x, event.y, 0, 0)});
            if (tracker.open()) {
                Rectangle rectangle = tracker.getRectangles()[0];
                try {
                    Range range;
                    IAxis axis;
                    IAxis[] iAxisArray = this.chart.getAxisSet().getXAxes();
                    int n = iAxisArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        axis = iAxisArray[n2];
                        range = new Range(axis.getDataCoordinate(rectangle.x), axis.getDataCoordinate(rectangle.x + rectangle.width));
                        axis.setRange(range);
                        ++n2;
                    }
                    iAxisArray = this.chart.getAxisSet().getYAxes();
                    n = iAxisArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        axis = iAxisArray[n2];
                        range = new Range(axis.getDataCoordinate(rectangle.y), axis.getDataCoordinate(rectangle.y + rectangle.height));
                        axis.setRange(range);
                        ++n2;
                    }
                }
                catch (IllegalArgumentException ignore) {
                    PortfolioPlugin.log(ignore);
                }
                this.chart.redraw();
            }
            tracker.dispose();
        }
    }
}

