/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.chart.ChartContextMenu;
import name.abuchen.portfolio.ui.util.chart.ChartUtil;
import name.abuchen.portfolio.ui.util.chart.MovePlotKeyListener;
import name.abuchen.portfolio.ui.util.chart.TimelineChartToolTip;
import name.abuchen.portfolio.ui.util.chart.ZoomInAreaListener;
import name.abuchen.portfolio.ui.util.chart.ZoomMouseWheelListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class TimelineChart
extends Chart {
    private List<MarkerLine> markerLines = new ArrayList<MarkerLine>();
    private List<NonTradingDayMarker> nonTradingDayMarkers = new ArrayList<NonTradingDayMarker>();
    private TimelineChartToolTip toolTip;
    private ChartContextMenu contextMenu;

    public TimelineChart(Composite parent) {
        super(parent, 0);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "chart");
        this.getLegend().setVisible(false);
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        xAxis.getTitle().setVisible(false);
        xAxis.getTick().setVisible(false);
        xAxis.getGrid().setStyle(LineStyle.NONE);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        yAxis.getTitle().setVisible(false);
        yAxis.setPosition(IAxis.Position.Secondary);
        int axisId = this.getAxisSet().createYAxis();
        IAxis y2Axis = this.getAxisSet().getYAxis(axisId);
        y2Axis.getTitle().setVisible(false);
        y2Axis.getTick().setVisible(false);
        y2Axis.getGrid().setStyle(LineStyle.NONE);
        y2Axis.setPosition(IAxis.Position.Primary);
        ((IPlotArea)this.getPlotArea()).addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                TimelineChart.this.paintTimeGrid(e);
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
        ((IPlotArea)this.getPlotArea()).addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent eventNonTradingDay) {
                TimelineChart.this.paintNonTradingDayMarker(eventNonTradingDay);
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
        this.getPlotArea().addPaintListener(this::paintMarkerLines);
        this.toolTip = new TimelineChartToolTip(this);
        ZoomMouseWheelListener.attachTo(this);
        MovePlotKeyListener.attachTo(this);
        ZoomInAreaListener.attachTo(this);
        this.getPlotArea().addTraverseListener(event -> {
            boolean bl = event.doit = true;
        });
        this.contextMenu = new ChartContextMenu(this);
    }

    public void addMarkerLine(LocalDate date, Color color, String label) {
        this.addMarkerLine(date, color, label, null);
    }

    public void addMarkerLine(LocalDate date, Color color, String label, Double value) {
        this.markerLines.add(new MarkerLine(date, color, label, value));
        Collections.sort(this.markerLines, (ml1, ml2) -> ml1.date.compareTo(ml2.date));
    }

    public void clearMarkerLines() {
        this.markerLines.clear();
    }

    public void addNonTradingDayMarker(LocalDate date, Color color) {
        this.nonTradingDayMarkers.add(new NonTradingDayMarker(date, color));
        Collections.sort(this.nonTradingDayMarkers, (ml1, ml2) -> ml1.date.compareTo(ml2.date));
    }

    public void removeNonTradingDayMarker(LocalDate date, Color color) {
        this.nonTradingDayMarkers.remove(new NonTradingDayMarker(date, color));
    }

    public void clearNonTradingDayMarker() {
        this.nonTradingDayMarkers.clear();
    }

    public ILineSeries addDateSeries(LocalDate[] dates, double[] values, String label) {
        return this.addDateSeries(dates, values, Colors.BLACK, false, label);
    }

    public ILineSeries addDateSeries(LocalDate[] dates, double[] values, Color color, String label) {
        return this.addDateSeries(dates, values, color, false, label);
    }

    private ILineSeries addDateSeries(LocalDate[] dates, double[] values, Color color, boolean showArea, String label) {
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, label);
        lineSeries.setXDateSeries(TimelineChart.toJavaUtilDate(dates));
        lineSeries.enableArea(showArea);
        lineSeries.setLineWidth(2);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setYSeries(values);
        lineSeries.setLineColor(color);
        lineSeries.setAntialias(1);
        return lineSeries;
    }

    public IBarSeries addDateBarSeries(LocalDate[] dates, double[] values, String label) {
        IBarSeries barSeries = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, label);
        barSeries.setXDateSeries(TimelineChart.toJavaUtilDate(dates));
        barSeries.setYSeries(values);
        barSeries.setBarColor(Colors.DARK_GRAY);
        barSeries.setBarPadding(100);
        return barSeries;
    }

    public TimelineChartToolTip getToolTip() {
        return this.toolTip;
    }

    private void paintTimeGrid(PaintEvent e) {
        DateTimeFormatter format;
        Period period;
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        Range range = xAxis.getRange();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate start = Instant.ofEpochMilli((long)range.lower).atZone(zoneId).toLocalDate();
        LocalDate end = Instant.ofEpochMilli((long)range.upper).atZone(zoneId).toLocalDate();
        LocalDate cursor = start.getDayOfMonth() == 1 ? start : start.plusMonths(1L).withDayOfMonth(1);
        long days = ChronoUnit.DAYS.between(start, end);
        if (days < 250L) {
            period = Period.ofMonths(1);
            format = DateTimeFormatter.ofPattern("MMMM yyyy");
        } else if (days < 800L) {
            period = Period.ofMonths(3);
            format = DateTimeFormatter.ofPattern("QQQ yyyy");
            cursor = cursor.plusMonths((12 - cursor.getMonthValue() + 1) % 3);
        } else if (days < 1200L) {
            period = Period.ofMonths(6);
            format = DateTimeFormatter.ofPattern("QQQ yyyy");
            cursor = cursor.plusMonths((12 - cursor.getMonthValue() + 1) % 6);
        } else {
            period = Period.ofYears(days > 5000L ? 2 : 1);
            format = DateTimeFormatter.ofPattern("yyyy");
            if (cursor.getMonthValue() > 1) {
                cursor = cursor.plusYears(1L).withDayOfYear(1);
            }
        }
        e.gc.setForeground(this.getTitle().getForeground());
        while (cursor.isBefore(end)) {
            int y = xAxis.getPixelCoordinate((double)cursor.atStartOfDay(zoneId).toInstant().toEpochMilli());
            e.gc.drawLine(y, 0, y, e.height);
            e.gc.drawText(format.format(cursor), y + 5, 5, true);
            cursor = cursor.plus(period);
        }
    }

    private void paintMarkerLines(PaintEvent e) {
        if (this.markerLines.isEmpty()) {
            return;
        }
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        int labelExtentX = 0;
        int labelStackY = 0;
        for (MarkerLine marker : this.markerLines) {
            int x = xAxis.getPixelCoordinate((double)marker.getTimeMillis());
            String label = marker.label != null ? marker.label : "";
            Point textExtent = e.gc.textExtent(label);
            boolean flip = x + 5 + textExtent.x > e.width;
            int textX = flip ? x - 5 - textExtent.x : x + 5;
            labelStackY = labelExtentX > textX ? labelStackY + textExtent.y : 0;
            labelExtentX = x + 5 + textExtent.x;
            e.gc.setLineStyle(1);
            e.gc.setForeground(marker.color);
            e.gc.setLineWidth(2);
            e.gc.drawLine(x, 0, x, e.height);
            e.gc.drawText(label, textX, e.height - 20 - labelStackY, true);
            if (marker.value == null) continue;
            int y = yAxis.getPixelCoordinate(marker.value.doubleValue());
            e.gc.drawLine(x - 5, y, x + 5, y);
        }
    }

    private void paintNonTradingDayMarker(PaintEvent eventNonTradingDay) {
        if (this.nonTradingDayMarkers.isEmpty()) {
            return;
        }
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        Range range = xAxis.getRange();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate start = Instant.ofEpochMilli((long)range.lower).atZone(zoneId).toLocalDate();
        LocalDate end = Instant.ofEpochMilli((long)range.upper).atZone(zoneId).toLocalDate();
        long days = ChronoUnit.DAYS.between(start, end);
        double dayWidth = Math.ceil((double)eventNonTradingDay.width / ((double)days - 1.0));
        int markerWidthXLeft = (int)(dayWidth / 2.0);
        ArrayList<LocalDate> nonTradingDayDates = new ArrayList<LocalDate>();
        for (NonTradingDayMarker marker : this.nonTradingDayMarkers) {
            nonTradingDayDates.add(marker.date);
        }
        for (NonTradingDayMarker marker : this.nonTradingDayMarkers) {
            int x = xAxis.getPixelCoordinate((double)marker.getTimeMillis());
            double barWidth = 0.0;
            LocalDate date = marker.date;
            while (date.isBefore(end)) {
                if (!nonTradingDayDates.contains(date)) break;
                barWidth += dayWidth;
                date = date.plusDays(1L);
            }
            if (nonTradingDayDates.contains(marker.date.minusDays(1L))) continue;
            if (barWidth < 3.0) {
                barWidth = 3.0;
            }
            eventNonTradingDay.gc.setBackground(marker.color);
            eventNonTradingDay.gc.setLineWidth(0);
            eventNonTradingDay.gc.setAlpha(100);
            eventNonTradingDay.gc.fillRectangle(x - markerWidthXLeft, 25, (int)barWidth, eventNonTradingDay.height - 25);
            eventNonTradingDay.gc.setBackgroundPattern(null);
            eventNonTradingDay.gc.setAlpha(255);
        }
    }

    public void exportMenuAboutToShow(IMenuManager manager, String label) {
        this.contextMenu.exportMenuAboutToShow(manager, label);
    }

    public static Date[] toJavaUtilDate(LocalDate[] dates) {
        ZoneId zoneId = ZoneId.systemDefault();
        Date[] answer = new Date[dates.length];
        int ii = 0;
        while (ii < answer.length) {
            answer[ii] = Date.from(dates[ii].atStartOfDay().atZone(zoneId).toInstant());
            ++ii;
        }
        return answer;
    }

    public void adjustRange() {
        try {
            this.setRedraw(false);
            this.getAxisSet().adjustRange();
            ChartUtil.addYMargins(this, 0.03);
        }
        finally {
            this.setRedraw(true);
        }
    }

    public void save(String filename, int format) {
        ChartUtil.save(this, filename, format);
    }

    private static class MarkerLine {
        private LocalDate date;
        private Color color;
        private String label;
        private Double value;

        private MarkerLine(LocalDate date, Color color, String label, Double value) {
            this.date = date;
            this.color = color;
            this.label = label;
            this.value = value;
        }

        public long getTimeMillis() {
            return Date.from(this.date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()).getTime();
        }
    }

    private static class NonTradingDayMarker {
        private LocalDate date;
        private Color color;

        private NonTradingDayMarker(LocalDate date, Color color) {
            this.date = date;
            this.color = color;
        }

        public long getTimeMillis() {
            return Date.from(this.date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()).getTime();
        }
    }

    public static class ThousandsNumberFormat
    extends Format {
        private static final long serialVersionUID = 1L;

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            if (!(obj instanceof Number)) {
                throw new IllegalArgumentException();
            }
            return toAppendTo.append(Values.Thousands.format((Object)((Number)obj).doubleValue()));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            pos.setErrorIndex(0);
            return null;
        }
    }
}

