/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.chart.ChartContextMenu;
import name.abuchen.portfolio.ui.util.chart.ChartUtil;
import name.abuchen.portfolio.ui.util.chart.MovePlotKeyListener;
import name.abuchen.portfolio.ui.util.chart.ScatterChartToolTip;
import name.abuchen.portfolio.ui.util.chart.ZoomInAreaListener;
import name.abuchen.portfolio.ui.util.chart.ZoomMouseWheelListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class ScatterChart
extends Chart {
    private ChartContextMenu contextMenu;
    private Color highlightColor = Colors.BLACK;

    public ScatterChart(Composite parent) {
        super(parent, 0);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "chart");
        this.getLegend().setVisible(false);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        yAxis.setPosition(IAxis.Position.Secondary);
        ((IPlotArea)this.getPlotArea()).addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                Color oldForebround = e.gc.getForeground();
                e.gc.setForeground(ScatterChart.this.highlightColor);
                IAxis xAxis = ScatterChart.this.getAxisSet().getXAxes()[0];
                int y = xAxis.getPixelCoordinate(0.0);
                e.gc.drawLine(y, 0, y, e.height);
                IAxis yAxis = ScatterChart.this.getAxisSet().getYAxes()[0];
                int x = yAxis.getPixelCoordinate(0.0);
                e.gc.drawLine(0, x, e.width, x);
                e.gc.setForeground(oldForebround);
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
        new ScatterChartToolTip(this);
        ZoomMouseWheelListener.attachTo(this);
        MovePlotKeyListener.attachTo(this);
        ZoomInAreaListener.attachTo(this);
        this.getPlotArea().addTraverseListener(event -> {
            boolean bl = event.doit = true;
        });
        this.contextMenu = new ChartContextMenu(this);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public ILineSeries addScatterSeries(double[] xSeries, double[] ySeries, String label) {
        ILineSeries scatterSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, label);
        scatterSeries.setLineStyle(LineStyle.NONE);
        scatterSeries.setXSeries(xSeries);
        scatterSeries.setYSeries(ySeries);
        scatterSeries.setAntialias(1);
        scatterSeries.setSymbolSize(10);
        return scatterSeries;
    }

    public void adjustRange() {
        try {
            this.setRedraw(false);
            this.getAxisSet().adjustRange();
            ChartUtil.addMargins(this, 0.1);
        }
        finally {
            this.setRedraw(true);
        }
    }

    public void exportMenuAboutToShow(IMenuManager manager, String label) {
        this.contextMenu.exportMenuAboutToShow(manager, label);
    }

    public void save(String filename, int format) {
        ChartUtil.save(this, filename, format);
    }
}

