/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.Range;

public final class ChartUtil {
    private ChartUtil() {
    }

    public static void addMargins(Chart chart, double zoomRatio) {
        IAxis[] iAxisArray = chart.getAxisSet().getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ChartUtil.addMargin(axis, zoomRatio);
            ++n2;
        }
    }

    public static void addYMargins(Chart chart, double zoomRatio) {
        IAxis[] iAxisArray = chart.getAxisSet().getYAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ChartUtil.addMargin(axis, zoomRatio);
            ++n2;
        }
    }

    public static void addMargin(IAxis axis, double zoomRatio) {
        Range range = axis.getRange();
        double midPoint = (range.upper - range.lower) / 2.0 + range.lower;
        double lower = (range.lower - 2.0 * zoomRatio * midPoint) / (1.0 - 2.0 * zoomRatio);
        double upper = (range.upper - 2.0 * zoomRatio * midPoint) / (1.0 - 2.0 * zoomRatio);
        axis.setRange(new Range(lower, upper));
    }

    public static void save(Chart chart, String filename, int format) {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{ChartUtil.getImageData(chart)};
        imageLoader.save(filename, format);
    }

    private static ImageData getImageData(Chart chart) {
        chart.redraw();
        chart.update();
        Point chartSize = chart.getSize();
        ImageDataProvider chartImageDataProvider = zoom -> {
            if (zoom != 100) {
                return null;
            }
            PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
            return new ImageData(point.x, point.y, 32, palette);
        };
        Image image = null;
        GC gc = null;
        try {
            image = new Image((Device)chart.getDisplay(), chartImageDataProvider);
            gc = new GC((Drawable)chart);
            gc.copyArea(image, 0, 0);
            ImageData imageData = image.getImageData();
            return imageData;
        }
        finally {
            if (gc != null && !gc.isDisposed()) {
                gc.dispose();
            }
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
        }
    }
}

