/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import name.abuchen.portfolio.ui.Images;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class ToolBarDropdownMenu<E>
extends SelectionAdapter {
    private static final String INDEX = "$index";
    private ToolBar toolBar;
    private ToolItem dropdown;
    private Menu menu;

    public ToolBarDropdownMenu(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.dropdown = new ToolItem(toolBar, 4);
        this.dropdown.addSelectionListener((SelectionListener)this);
        this.menu = new Menu((Control)this.dropdown.getParent().getShell());
        toolBar.addDisposeListener(e -> {
            if (!this.menu.isDisposed()) {
                this.menu.dispose();
            }
        });
    }

    public int getSelectedIndex() {
        return (Integer)this.dropdown.getData(INDEX);
    }

    public void select(int index) {
        int selected = index >= 0 && index < this.menu.getItemCount() ? index : 0;
        this.menu.getItem(selected).notifyListeners(13, new Event());
    }

    public void select(E data) {
        MenuItem[] menuItemArray = this.menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.getData() == data) {
                item.notifyListeners(13, new Event());
                return;
            }
            ++n2;
        }
        this.select(0);
    }

    public final void add(E data, String label) {
        this.add(data, label, null);
    }

    public final void add(final E data, String label, Images image) {
        MenuItem menuItem = new MenuItem(this.menu, 32);
        menuItem.setText(label);
        if (image != null) {
            menuItem.setImage(image.image());
        }
        menuItem.setData(data);
        menuItem.setData(INDEX, (Object)(this.menu.getItemCount() - 1));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem selected = (MenuItem)event.widget;
                MenuItem[] menuItemArray = ToolBarDropdownMenu.this.menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.setSelection(false);
                    ++n2;
                }
                selected.setSelection(true);
                if (selected.getImage() != null) {
                    ToolBarDropdownMenu.this.dropdown.setImage(selected.getImage());
                } else {
                    ToolBarDropdownMenu.this.dropdown.setText(selected.getText());
                }
                ToolBarDropdownMenu.this.dropdown.setToolTipText(selected.getText());
                ToolBarDropdownMenu.this.dropdown.setData(ToolBarDropdownMenu.INDEX, selected.getData(ToolBarDropdownMenu.INDEX));
                ToolBarDropdownMenu.this.toolBar.getParent().layout();
                ToolBarDropdownMenu.this.itemSelected(data);
            }
        });
    }

    public void widgetSelected(SelectionEvent event) {
        ToolItem item = (ToolItem)event.widget;
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        this.menu.setLocation(pt.x, pt.y + rect.height);
        this.menu.setVisible(true);
    }

    protected abstract void itemSelected(E var1);
}

