/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import name.abuchen.portfolio.ui.Images;
import org.eclipse.core.runtime.Platform;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.nebula.widgets.cdatetime.CDateTimeBuilder;
import org.eclipse.nebula.widgets.cdatetime.Footer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;

public class DatePicker {
    protected Control control;

    public DatePicker(Composite parent) {
        boolean isLinux = "linux".equals(Platform.getOS());
        if (isLinux) {
            CDateTime boxDate = new CDateTime(parent, 3);
            boxDate.setFormat(0x200000);
            boxDate.setButtonImage(Images.CALENDAR_OFF.image());
            CDateTimeBuilder builder = CDateTimeBuilder.getStandard();
            builder.setFooter(new Footer[]{Footer.Today()});
            boxDate.setBuilder(builder);
            this.control = boxDate;
        } else {
            this.control = new DateTime(parent, 2084);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void setSelection(LocalDate date) {
        if (this.control instanceof CDateTime) {
            Date d = Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            ((CDateTime)this.control).setSelection(d);
        } else {
            ((DateTime)this.control).setDate(date.getYear(), date.getMonthValue() - 1, date.getDayOfMonth());
        }
    }

    public LocalDate getSelection() {
        if (this.control instanceof CDateTime) {
            Date d = ((CDateTime)this.control).getSelection();
            if (d == null) {
                Date now = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
                ((CDateTime)this.control).setSelection(now);
                return LocalDate.now();
            }
            return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
        DateTime dateTime = (DateTime)this.control;
        return LocalDate.of(dateTime.getYear(), dateTime.getMonth() + 1, dateTime.getDay());
    }

    public void setLayoutData(Object layoutData) {
        this.control.setLayoutData(layoutData);
    }
}

