/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.snapshot.filter.PortfolioClientFilter;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.EditClientFilterDialog;
import name.abuchen.portfolio.ui.dialogs.ListSelectionDialog;
import name.abuchen.portfolio.ui.util.ClientFilterDropDown;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.SimpleAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class ClientFilterMenu
implements IMenuListener {
    public static final String PREF_KEY_POSTFIX = "-client-filter";
    private static final String PREF_KEY = String.valueOf(ClientFilterDropDown.class.getSimpleName()) + "@json";
    private static final int MAXIMUM_NO_CUSTOM_ITEMS = 30;
    private final Client client;
    private final IPreferenceStore preferences;
    private final List<Consumer<ClientFilter>> listeners = new ArrayList<Consumer<ClientFilter>>();
    private List<Item> defaultItems = new ArrayList<Item>();
    private LinkedList<Item> customItems = new LinkedList();
    private Item selectedItem;

    public ClientFilterMenu(Client client, IPreferenceStore preferences) {
        this.client = client;
        this.preferences = preferences;
        this.selectedItem = new Item(Messages.PerformanceChartLabelEntirePortfolio, "", ClientFilter.NO_FILTER);
        this.defaultItems.add(this.selectedItem);
        client.getActivePortfolios().forEach(portfolio -> {
            this.defaultItems.add(new Item(portfolio.getName(), portfolio.getUUID(), (ClientFilter)new PortfolioClientFilter(portfolio)));
            this.defaultItems.add(new Item(String.valueOf(portfolio.getName()) + " + " + portfolio.getReferenceAccount().getName(), String.valueOf(portfolio.getUUID()) + "," + portfolio.getReferenceAccount().getUUID(), (ClientFilter)new PortfolioClientFilter(portfolio, portfolio.getReferenceAccount())));
        });
        this.loadCustomItems();
    }

    public ClientFilterMenu(Client client, IPreferenceStore preferences, Consumer<ClientFilter> listener) {
        this(client, preferences);
        this.listeners.add(listener);
    }

    private void loadCustomItems() {
        String json = this.preferences.getString(PREF_KEY);
        if (json != null && !json.isEmpty()) {
            this.loadCustomItemsFromJSON(json);
        } else {
            String code = this.preferences.getString(ClientFilterDropDown.class.getSimpleName());
            if (code != null && !code.isEmpty()) {
                this.loadCustomItemsLegacy(code);
            }
        }
    }

    private void loadCustomItemsFromJSON(String json) {
        Type listType = new TypeToken<ArrayList<Item>>(){}.getType();
        List fromJson = (List)new Gson().fromJson(json, listType);
        if (fromJson.isEmpty()) {
            return;
        }
        for (Item item : fromJson) {
            this.buildItem(item.uuids).ifPresent(i -> {
                i.label = item.label;
                this.customItems.add((Item)i);
            });
        }
    }

    private void loadCustomItemsLegacy(String code) {
        String[] items;
        HashMap uuid2object = new HashMap();
        this.client.getPortfolios().forEach(p -> {
            Portfolio portfolio = uuid2object.put(p.getUUID(), p);
        });
        this.client.getAccounts().forEach(a -> {
            Account account = uuid2object.put(a.getUUID(), a);
        });
        String[] stringArray = items = code.split(";");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.buildItem(item).ifPresent(i -> {
                boolean bl = this.customItems.add((Item)i);
            });
            ++n2;
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.defaultItems.forEach(item -> {
            SimpleAction action = new SimpleAction(item.label, a -> {
                this.selectedItem = item;
                this.listeners.forEach(l -> l.accept(item.filter));
            });
            action.setChecked(item.equals(this.selectedItem));
            manager.add((IAction)action);
        });
        manager.add((IContributionItem)new Separator());
        this.customItems.forEach(item -> {
            SimpleAction action = new SimpleAction(item.label, a -> {
                this.selectedItem = item;
                this.customItems.remove(item);
                this.customItems.addFirst((Item)item);
                this.listeners.forEach(l -> l.accept(item.filter));
            });
            action.setChecked(item.equals(this.selectedItem));
            manager.add((IAction)action);
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(Messages.LabelClientFilterNew, a -> this.createCustomFilter()));
        manager.add((IAction)new SimpleAction(Messages.LabelClientFilterManage, a -> this.editCustomFilter()));
        manager.add((IAction)new SimpleAction(Messages.LabelClientClearCustomItems, a -> {
            if (this.customItems.contains(this.selectedItem)) {
                this.selectedItem = this.defaultItems.get(0);
                this.listeners.forEach(l -> l.accept(this.selectedItem.filter));
            }
            this.customItems.clear();
            this.preferences.setToDefault(PREF_KEY);
            this.preferences.setToDefault(ClientFilterDropDown.class.getSimpleName());
        }));
    }

    private void editCustomFilter() {
        if (this.customItems.isEmpty()) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelInfo, (String)Messages.LabelClientFilterNoCustomFilterExisting);
            return;
        }
        boolean isCustomItemSelected = this.customItems.contains(this.selectedItem);
        EditClientFilterDialog dialog = new EditClientFilterDialog(Display.getDefault().getActiveShell(), this.client, this.preferences);
        dialog.setItems(this.customItems);
        dialog.open();
        this.preferences.putValue(PREF_KEY, new Gson().toJson(this.customItems));
        if (isCustomItemSelected && !this.customItems.contains(this.selectedItem)) {
            this.selectedItem = this.defaultItems.get(0);
            this.listeners.forEach(l -> l.accept(this.selectedItem.filter));
        }
    }

    private void createCustomFilter() {
        Object[] selected;
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LogoManager.instance().getDefaultColumnImage(element, ClientFilterMenu.this.client.getSettings());
            }
        };
        ListSelectionDialog dialog = new ListSelectionDialog(Display.getDefault().getActiveShell(), labelProvider);
        dialog.setTitle(Messages.LabelClientFilterDialogTitle);
        dialog.setMessage(Messages.LabelClientFilterDialogMessage);
        dialog.setPropertyLabel(Messages.ColumnName);
        ArrayList elements = new ArrayList();
        elements.addAll(this.client.getPortfolios());
        elements.addAll(this.client.getAccounts());
        dialog.setElements(elements);
        if (dialog.open() == 0 && (selected = dialog.getResult()).length > 0) {
            Item newItem = this.buildItem(selected);
            String label = dialog.getProperty();
            if (!label.isEmpty()) {
                newItem.label = label;
            }
            this.selectedItem = newItem;
            this.customItems.addFirst(newItem);
            if (this.customItems.size() > 30) {
                this.customItems.removeLast();
            }
            this.preferences.putValue(PREF_KEY, new Gson().toJson(this.customItems));
            this.listeners.forEach(l -> l.accept(item.filter));
        }
    }

    private Optional<Item> buildItem(String uuids) {
        if (uuids == null || uuids.isEmpty()) {
            return Optional.empty();
        }
        String[] ids = uuids.split(",");
        if (ids.length == 0) {
            return Optional.empty();
        }
        HashMap uuid2object = new HashMap();
        this.client.getPortfolios().forEach(p -> {
            Portfolio portfolio = uuid2object.put(p.getUUID(), p);
        });
        this.client.getAccounts().forEach(a -> {
            Account account = uuid2object.put(a.getUUID(), a);
        });
        return Optional.of(this.buildItem(Arrays.stream(ids).map(uuid2object::get).filter(Objects::nonNull).toArray()));
    }

    private Item buildItem(Object[] selected) {
        List portfolios = Arrays.stream(selected).filter(o -> o instanceof Portfolio).map(o -> (Portfolio)o).collect(Collectors.toList());
        List accounts = Arrays.stream(selected).filter(o -> o instanceof Account).map(o -> (Account)o).collect(Collectors.toList());
        String label = Arrays.stream(selected).map(String::valueOf).collect(Collectors.joining(", "));
        String uuids = Arrays.stream(selected).map(o -> o instanceof Account ? ((Account)o).getUUID() : ((Portfolio)o).getUUID()).collect(Collectors.joining(","));
        return new Item(label, uuids, (ClientFilter)new PortfolioClientFilter(portfolios, accounts));
    }

    public boolean hasActiveFilter() {
        return this.defaultItems.indexOf(this.selectedItem) != 0;
    }

    public ClientFilter getSelectedFilter() {
        return this.selectedItem.filter;
    }

    public Item getSelectedItem() {
        return this.selectedItem;
    }

    public void addListener(Consumer<ClientFilter> listener) {
        this.listeners.add(listener);
    }

    public Stream<Item> getAllItems() {
        return Stream.concat(this.defaultItems.stream(), this.customItems.stream());
    }

    public List<Item> getCustomItems() {
        return Collections.unmodifiableList(this.customItems);
    }

    public void select(Item item) {
        this.selectedItem = item;
    }

    public static class Item {
        String label;
        String uuids;
        transient ClientFilter filter;

        public Item(String label, String uuids, ClientFilter filter) {
            this.label = label;
            this.uuids = Objects.requireNonNull(uuids);
            this.filter = filter;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getUUIDs() {
            return this.uuids;
        }

        public ClientFilter getFilter() {
            return this.filter;
        }

        public String toString() {
            return this.label;
        }
    }
}

