/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.ui.Messages;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ThemePreferencePage
extends PreferencePage {
    private IThemeEngine engine;
    private ComboViewer themeIdCombo;
    private ITheme currentTheme;
    private String defaultTheme = "name.abuchen.portfolio.light";

    public ThemePreferencePage(IThemeEngine themeEngine) {
        this.engine = themeEngine;
        this.setTitle(Messages.LabelTheme);
    }

    protected Control createContents(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(area);
        Label label = new Label(area, 0);
        label.setText(Messages.LabelTheme);
        this.themeIdCombo = new ComboViewer(area, 8);
        this.themeIdCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ITheme)element).getLabel();
            }
        });
        this.themeIdCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.themeIdCombo.setInput(this.getCSSThemes());
        this.themeIdCombo.getControl().setLayoutData((Object)new GridData(768));
        this.currentTheme = this.engine.getActiveTheme();
        if (this.currentTheme != null) {
            this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentTheme));
        }
        ControlDecoration themeComboDecorator = new ControlDecoration((Control)this.themeIdCombo.getCombo(), 16512);
        this.themeIdCombo.addSelectionChangedListener(event -> {
            ITheme selection = this.getSelectedTheme();
            if (!selection.equals(this.currentTheme)) {
                themeComboDecorator.setDescriptionText(Messages.MsgThemeRestartRequired);
                Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
                themeComboDecorator.setImage(decorationImage);
                themeComboDecorator.show();
            } else {
                themeComboDecorator.hide();
            }
        });
        return area;
    }

    private List<ITheme> getCSSThemes() {
        ArrayList<ITheme> themes = new ArrayList<ITheme>();
        for (ITheme theme : this.engine.getThemes()) {
            if (!theme.getId().startsWith("name.abuchen.portfolio.")) continue;
            themes.add(theme);
        }
        themes.sort((t1, t2) -> t1.getLabel().compareTo(t2.getLabel()));
        return themes;
    }

    private ITheme getSelectedTheme() {
        if (this.themeIdCombo == null) {
            return null;
        }
        return (ITheme)this.themeIdCombo.getStructuredSelection().getFirstElement();
    }

    public boolean performOk() {
        ITheme theme = this.getSelectedTheme();
        if (theme != null) {
            this.engine.setTheme(theme, true);
        }
        return super.performOk();
    }

    public boolean performCancel() {
        if (this.currentTheme != null) {
            this.engine.setTheme(this.currentTheme, false);
        }
        return super.performCancel();
    }

    protected void performDefaults() {
        this.engine.setTheme(this.defaultTheme, true);
        if (this.engine.getActiveTheme() != null) {
            this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.engine.getActiveTheme()));
        }
        super.performDefaults();
    }
}

