/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.log;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.DisplayTextDialog;
import name.abuchen.portfolio.ui.log.LogEntry;
import name.abuchen.portfolio.ui.log.LogEntryCache;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ErrorLogPart {
    private List<LogEntry> entries = new ArrayList<LogEntry>();
    private TreeViewer logViewer;
    @Inject
    UISynchronize sync;

    @PostConstruct
    public void createComposite(Composite parent, LogEntryCache cache) {
        this.entries = cache.getEntries();
        Composite container = new Composite(parent, 0);
        TreeColumnLayout layout = new TreeColumnLayout();
        container.setLayout((Layout)layout);
        this.logViewer = new TreeViewer(container, 65536);
        TreeViewerColumn column = new TreeViewerColumn(this.logViewer, 0);
        column.getColumn().setText(Messages.ColumnDate);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(140));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);

            public String getText(Object element) {
                return this.dateFormat.format(((LogEntry)element).getDate());
            }
        });
        column = new TreeViewerColumn(this.logViewer, 0);
        column.getColumn().setText(Messages.ColumnMessage);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(500));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LogEntry)element).getMessage();
            }

            public Image getImage(Object element) {
                LogEntry entry = (LogEntry)element;
                switch (entry.getSeverity()) {
                    case 4: {
                        return Images.ERROR.image();
                    }
                    case 2: {
                        return Images.WARNING.image();
                    }
                }
                return Images.INFO.image();
            }
        });
        this.logViewer.getTree().setHeaderVisible(true);
        this.logViewer.getTree().setLinesVisible(true);
        this.logViewer.setContentProvider((IContentProvider)new LogEntryContentProvider());
        this.logViewer.setInput(this.entries);
        this.logViewer.addDoubleClickListener(event -> {
            LogEntry entry = (LogEntry)((IStructuredSelection)event.getSelection()).getFirstElement();
            DisplayTextDialog dialog = new DisplayTextDialog(Display.getCurrent().getActiveShell(), entry.getText());
            dialog.open();
        });
    }

    @Focus
    public void setFocus() {
        this.logViewer.getTree().setFocus();
    }

    @Inject
    @Optional
    public void onLogEntryCreated(@UIEventTopic(value="errorlog/created") LogEntry entry) {
        this.entries.add(entry);
        this.logViewer.refresh();
    }

    @Inject
    @Optional
    public void onLogEntriesDeleted(@UIEventTopic(value="errorlog/cleared") LogEntry entry) {
        this.entries.clear();
        this.logViewer.refresh();
    }

    public static class LogEntryContentProvider
    implements ITreeContentProvider {
        private List<?> entries;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.entries = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.entries.toArray();
        }

        public boolean hasChildren(Object element) {
            return ((LogEntry)element).getChildren() != null;
        }

        public Object[] getChildren(Object parentElement) {
            return ((LogEntry)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return null;
        }
    }
}

