/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.jobs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityEvent;
import name.abuchen.portfolio.online.DividendFeed;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.impl.DivvyDiaryDividendFeed;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.jobs.AbstractClientJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class UpdateDividendsJob
extends AbstractClientJob {
    private final List<Security> securities;

    public UpdateDividendsJob(Client client) {
        this(client, client.getSecurities());
    }

    public UpdateDividendsJob(Client client, Security security) {
        this(client, Arrays.asList(security));
    }

    public UpdateDividendsJob(Client client, List<Security> securities) {
        super(client, Messages.JobLabelUpdatingDividendEvents);
        this.securities = new ArrayList<Security>(securities);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.JobLabelUpdatingDividendEvents, -1);
        DividendFeed feed = Factory.getDividendFeed(DivvyDiaryDividendFeed.class);
        boolean isDirty = false;
        for (Security security : this.securities) {
            try {
                List dividends = feed.getDividendPayments(security);
                if (dividends.isEmpty()) continue;
                List current = security.getEvents().stream().filter(event -> event.getType() == SecurityEvent.Type.DIVIDEND_PAYMENT).map(event -> (SecurityEvent.DividendEvent)event).collect(Collectors.toList());
                for (SecurityEvent.DividendEvent dividendEvent : dividends) {
                    if (current.contains(dividendEvent)) {
                        current.remove(dividendEvent);
                        continue;
                    }
                    security.addEvent((SecurityEvent)dividendEvent);
                    isDirty = true;
                }
                security.removeEventIf(event -> current.contains(event));
                isDirty = isDirty || !current.isEmpty();
            }
            catch (IOException e) {
                PortfolioPlugin.log(e);
            }
        }
        if (isDirty) {
            this.getClient().markDirty();
        }
        return Status.OK_STATUS;
    }
}

