/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.jobs;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.online.SecuritySearchProvider;
import name.abuchen.portfolio.online.impl.PortfolioReportNet;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.jobs.AbstractClientJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class SyncOnlineSecuritiesJob
extends AbstractClientJob {
    public SyncOnlineSecuritiesJob(Client client) {
        super(client, Messages.JobLabelSyncSecuritiesOnline);
    }

    protected IStatus run(IProgressMonitor monitor) {
        List toBeSynced = this.getClient().getSecurities().stream().filter(s -> s.getOnlineId() != null).collect(Collectors.toList());
        if (toBeSynced.isEmpty()) {
            return Status.OK_STATUS;
        }
        monitor.beginTask(MessageFormat.format((String)Messages.JobLabelSyncSecuritiesOnline, (Object[])new Object[]{"https://portfolio-report.net"}), toBeSynced.size());
        boolean isDirty = false;
        PortfolioReportNet portfolioReport = new PortfolioReportNet();
        for (Security security : toBeSynced) {
            monitor.worked(1);
            try {
                Optional item = portfolioReport.getUpdatedValues(security.getOnlineId());
                if (item.isPresent()) {
                    boolean hasUpdate = PortfolioReportNet.updateWith((Security)security, (SecuritySearchProvider.ResultItem)((SecuritySearchProvider.ResultItem)item.get()));
                    isDirty = isDirty || hasUpdate;
                    continue;
                }
                PortfolioPlugin.info(MessageFormat.format((String)"No data found for ''{0}'' with OnlineId {1}", (Object[])new Object[]{security.getName(), security.getOnlineId()}));
            }
            catch (IOException e) {
                PortfolioPlugin.log(e);
            }
        }
        if (isDirty) {
            this.getClient().markDirty();
        }
        return Status.OK_STATUS;
    }
}

