/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.jobs;

import com.google.common.base.Strings;
import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.online.SecuritySearchProvider;
import name.abuchen.portfolio.online.impl.ETFDataCom;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.jobs.AbstractClientJob;
import name.abuchen.portfolio.util.WebAccess;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class SyncETFDataJob
extends AbstractClientJob {
    public SyncETFDataJob(Client client) {
        super(client, MessageFormat.format((String)Messages.JobLabelSyncSecuritiesOnline, (Object[])new Object[]{"https://etf-data.com"}));
    }

    protected IStatus run(IProgressMonitor monitor) {
        List toBeSynced = this.getClient().getSecurities().stream().filter(s -> !Strings.isNullOrEmpty((String)s.getIsin())).collect(Collectors.toList());
        Collections.shuffle(toBeSynced);
        if (toBeSynced.isEmpty()) {
            return Status.OK_STATUS;
        }
        monitor.beginTask(this.getName(), toBeSynced.size());
        boolean isDirty = false;
        List countries = this.getClient().getTaxonomies().stream().filter(t -> "etf-data.com$country-allocation".equals(t.getSource())).collect(Collectors.toList());
        List sectors = this.getClient().getTaxonomies().stream().filter(t -> "etf-data.com$sector-allocation".equals(t.getSource())).collect(Collectors.toList());
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ETFDataCom etfdata = new ETFDataCom();
        for (Security security : toBeSynced) {
            monitor.worked(1);
            try {
                List items = etfdata.search(security.getIsin());
                if (!items.isEmpty()) {
                    boolean hasUpdate = ETFDataCom.updateWith((Security)security, (ClientSettings)this.getClient().getSettings(), (SecuritySearchProvider.ResultItem)((SecuritySearchProvider.ResultItem)items.get(0)));
                    isDirty = isDirty || hasUpdate;
                    for (Taxonomy taxonomy : countries) {
                        hasUpdate = ETFDataCom.updateCountryAllocation((Security)security, (Taxonomy)taxonomy, (SecuritySearchProvider.ResultItem)((SecuritySearchProvider.ResultItem)items.get(0)));
                        boolean bl = isDirty = isDirty || hasUpdate;
                    }
                    for (Taxonomy taxonomy : sectors) {
                        hasUpdate = ETFDataCom.updateSectorAllocation((Security)security, (Taxonomy)taxonomy, (SecuritySearchProvider.ResultItem)((SecuritySearchProvider.ResultItem)items.get(0)));
                        boolean bl = isDirty = isDirty || hasUpdate;
                    }
                    continue;
                }
                PortfolioPlugin.info(MessageFormat.format((String)"No etf-data.com information found for ''{0}'' with ISIN {1}", (Object[])new Object[]{security.getName(), security.getIsin()}));
            }
            catch (WebAccess.WebAccessException e) {
                errors.add(e);
                if (e.getHttpErrorCode() != 401) continue;
                break;
            }
            catch (IOException e) {
                errors.add(e);
            }
        }
        if (isDirty) {
            this.getClient().markDirty();
        }
        if (!errors.isEmpty()) {
            Display.getDefault().asyncExec(() -> {
                MultiStatus status = new MultiStatus("name.abuchen.portfolio.ui", 4, this.getName(), null);
                errors.forEach(e -> status.add((IStatus)new Status(4, SyncETFDataJob.class, e.getMessage())));
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)this.getName(), (IStatus)status);
            });
        }
        return Status.OK_STATUS;
    }
}

