/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.io.IOException;
import javax.inject.Named;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.online.impl.DivvyDiaryUploader;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.ClientInput;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.jobs.AbstractClientJob;
import name.abuchen.portfolio.ui.util.swt.ActiveShell;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UploadToDivvyDiaryHandler {
    @CanExecute
    boolean isVisible(@Named(value="e4ActivePart") MPart part, @Optional @Preference(value="DIVVYDIARY_API_KEY") String divvyDiaryApiKey) {
        return MenuHelper.isClientPartActive(part);
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, @Optional @Preference(value="DIVVYDIARY_API_KEY") String divvyDiaryApiKey) {
        if (divvyDiaryApiKey == null) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.LabelInfo, (String)Messages.DivvyDiaryMissingAPIKey);
            return;
        }
        if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.LabelInfo, (String)Messages.DivvyDiaryConfirmUpload)) {
            return;
        }
        MenuHelper.getActiveClientInput(part).ifPresent(clientInput -> new AbstractClientJob(clientInput.getClient(), Messages.DivvyDiaryMsgUploading, (ClientInput)clientInput, divvyDiaryApiKey){
            private final /* synthetic */ ClientInput val$clientInput;
            private final /* synthetic */ String val$divvyDiaryApiKey;
            {
                this.val$clientInput = clientInput;
                this.val$divvyDiaryApiKey = string;
                super($anonymous0, $anonymous1);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CurrencyConverterImpl converter = new CurrencyConverterImpl(this.val$clientInput.getExchangeRateProviderFacory(), this.val$clientInput.getClient().getBaseCurrency());
                    new DivvyDiaryUploader().upload(this.val$clientInput.getClient(), (CurrencyConverter)converter, this.val$divvyDiaryApiKey);
                    Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)ActiveShell.get(), (String)Messages.LabelInfo, (String)Messages.DivvyDiaryUploadSuccessfulMsg));
                    return Status.OK_STATUS;
                }
                catch (IOException e) {
                    PortfolioPlugin.log(e);
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)ActiveShell.get(), (String)Messages.LabelError, (String)e.getMessage()));
                    return new Status(4, "name.abuchen.portfolio.ui", e.getMessage(), (Throwable)e);
                }
            }
        }.schedule());
    }
}

