/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientFactory;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.editor.ClientEditorSidebar;
import name.abuchen.portfolio.ui.editor.ClientInput;
import name.abuchen.portfolio.ui.editor.ClientInputFactory;
import name.abuchen.portfolio.ui.editor.ClientInputListener;
import name.abuchen.portfolio.ui.editor.ClientProgressProvider;
import name.abuchen.portfolio.ui.editor.LoadClientThread;
import name.abuchen.portfolio.ui.editor.Navigation;
import name.abuchen.portfolio.ui.editor.PageBook;
import name.abuchen.portfolio.ui.editor.PartPersistedState;
import name.abuchen.portfolio.ui.editor.ProgressProvider;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.swt.SashLayout;
import name.abuchen.portfolio.ui.util.swt.SashLayoutData;
import name.abuchen.portfolio.ui.views.ExceptionView;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PortfolioPart
implements ClientInputListener {
    private ClientInput clientInput;
    private ReportingPeriod selectedPeriod;
    private Navigation.Item selectedItem;
    private Composite container;
    private ProgressBar progressBar;
    private PageBook book;
    private ClientEditorSidebar sidebar;
    private AbstractFinanceView view;
    private Control focus;
    @Inject
    MPart part;
    @Inject
    MDirtyable dirty;
    @Inject
    IEclipseContext context;
    @Inject
    IEventBroker broker;
    @Inject
    ClientInputFactory clientInputFactory;

    @PostConstruct
    public void createComposite(Composite parent) {
        String filename;
        this.clientInput = (ClientInput)this.part.getTransientData().get(ClientInput.class.getName());
        if (this.clientInput == null && (filename = (String)this.part.getPersistedState().get("file")) != null) {
            this.clientInput = this.clientInputFactory.lookup(new File(filename));
            this.part.getTransientData().put(ClientInput.class.getName(), this.clientInput);
            this.broker.post("file/opened", (Object)this.clientInput.getFile().getAbsolutePath());
        }
        if (this.clientInput == null) {
            throw new IllegalArgumentException();
        }
        if (this.clientInput.getFile() != null) {
            this.part.getPersistedState().put("file", this.clientInput.getFile().getAbsolutePath());
        }
        this.clientInput.addListener(this);
        this.dirty.setDirty(this.clientInput.isDirty());
        if (this.clientInput.getClient() != null) {
            this.context.set(Client.class, (Object)this.clientInput.getClient());
            this.createContainerWithViews(parent);
        } else if (ClientFactory.isEncrypted((File)this.clientInput.getFile())) {
            this.createContainerWithMessage(parent, MessageFormat.format(Messages.MsgOpenFile, this.clientInput.getFile().getName()), false, true);
        } else {
            this.progressBar = this.createContainerWithMessage(parent, MessageFormat.format(Messages.MsgLoadingFile, this.clientInput.getFile().getName()), true, false);
        }
        this.clientInputFactory.incrementEditorCount(this.clientInput);
    }

    private void createContainerWithViews(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FillLayout());
        Composite sash = new Composite(this.container, 0);
        SashLayout sashLayout = new SashLayout(sash, 257);
        sash.setLayout((Layout)sashLayout);
        Composite navigationBar = new Composite(sash, 0);
        navigationBar.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"sidebar");
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).margins(0, 0).applyTo(navigationBar);
        this.sidebar = new ClientEditorSidebar(this);
        Control control = this.sidebar.createSidebarControl(navigationBar);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        sashLayout.addQuickNavigation(menuManager -> this.addToNavigationMenu(menuManager, 0, this.clientInput.getNavigation().getRoots()));
        Composite divider = new Composite(navigationBar, 0);
        divider.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"sidebarBorder");
        GridDataFactory.fillDefaults().span(0, 2).hint(1, -1).applyTo((Control)divider);
        ClientProgressProvider provider = this.make(ClientProgressProvider.class, this.clientInput.getClient(), navigationBar);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(provider.getControl());
        this.book = new PageBook(sash, 0);
        String sashIdentifier = String.valueOf(PortfolioPart.class.getSimpleName()) + "-newsash";
        int size = 0;
        try {
            String value = (String)this.part.getPersistedState().get(sashIdentifier);
            if (value != null && !value.isEmpty()) {
                size = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException ignore) {
            PortfolioPlugin.log(ignore);
        }
        navigationBar.setLayoutData((Object)new SashLayoutData(size != 0 ? size : 180));
        sash.addDisposeListener(e -> {
            String string2 = this.part.getPersistedState().put(sashIdentifier, String.valueOf(((SashLayoutData)navigationBar.getLayoutData()).getSize()));
        });
        Optional<Navigation.Item> item = this.clientInput.getNavigation().findByIdentifier((String)this.part.getPersistedState().get("initial-view"));
        if (!item.isPresent()) {
            item = this.clientInput.getNavigation().findByIdentifier((String)this.part.getPersistedState().get("view"));
        }
        if (!item.isPresent()) {
            item = this.clientInput.getNavigation().findAll(Navigation.Tag.DEFAULT_VIEW).findAny();
        }
        item.ifPresent(this::activateView);
        this.focus = this.book;
    }

    private void addToNavigationMenu(IMenuManager menuManager, int depth, Stream<Navigation.Item> items) {
        items.forEach(item -> {
            if (item.getViewClass() == null) {
                MenuManager subMenu = new MenuManager(item.getLabel());
                menuManager.add((IContributionItem)subMenu);
                this.addToNavigationMenu((IMenuManager)subMenu, depth + 1, item.getChildren());
            } else {
                String label = depth > 1 ? "- " + item.getLabel() : item.getLabel();
                SimpleAction menuAction = new SimpleAction(label, a -> this.activateView((Navigation.Item)item));
                if (item.getImage() != null) {
                    menuAction.setImageDescriptor(item.getImage().descriptor());
                }
                menuManager.add((IAction)menuAction);
                this.addToNavigationMenu(menuManager, depth + 1, item.getChildren());
            }
        });
    }

    private ProgressBar createContainerWithMessage(Composite parent, String message, boolean showProgressBar, boolean showPasswordField) {
        ProgressBar bar = null;
        this.container = new Composite(parent, 0);
        this.container.setBackground(Display.getDefault().getSystemColor(1));
        this.container.setLayout((Layout)new FormLayout());
        Label image = new Label(this.container, 0);
        image.setBackground(this.container.getBackground());
        image.setImage(Images.LOGO_48.image());
        FormData data = new FormData();
        data.top = new FormAttachment(50, -50);
        data.left = new FormAttachment(50, -24);
        image.setLayoutData((Object)data);
        if (showPasswordField) {
            Text pwd = this.createPasswordField(this.container);
            data = new FormData();
            data.top = new FormAttachment((Control)image, 10);
            data.left = new FormAttachment((Control)image, 0, 0x1000000);
            data.width = 100;
            pwd.setLayoutData((Object)data);
            this.focus = pwd;
        } else if (showProgressBar) {
            bar = new ProgressBar(this.container, 65536);
            data = new FormData();
            data.top = new FormAttachment((Control)image, 10);
            data.left = new FormAttachment(50, -100);
            data.width = 200;
            bar.setLayoutData((Object)data);
        }
        Label label = new Label(this.container, 0x1000040);
        label.setBackground(this.container.getBackground());
        if (message != null) {
            label.setText(message);
        }
        data = new FormData();
        data.top = new FormAttachment((Control)image, 40);
        data.left = new FormAttachment(50, -100);
        data.width = 200;
        label.setLayoutData((Object)data);
        return bar;
    }

    private Text createPasswordField(Composite container) {
        final Text pwd = new Text(container, 0x400800);
        pwd.setFocus();
        pwd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String password = pwd.getText();
                new LoadClientThread(PortfolioPart.this.clientInput, PortfolioPart.this.broker, new ProgressProvider(PortfolioPart.this.clientInput), password.toCharArray()).start();
            }
        });
        return pwd;
    }

    private void rebuildContainer(Consumer<Composite> builder) {
        if (this.container != null && !this.container.isDisposed()) {
            Composite parent = this.container.getParent();
            parent.setRedraw(false);
            try {
                this.container.dispose();
                builder.accept(parent);
                parent.layout(true);
            }
            finally {
                parent.setRedraw(true);
            }
        }
    }

    @Override
    public void onLoading(int totalWork, int worked) {
        int max;
        if (this.progressBar == null || this.progressBar.isDisposed()) {
            this.rebuildContainer(parent -> {
                this.progressBar = this.createContainerWithMessage((Composite)parent, MessageFormat.format(Messages.MsgLoadingFile, this.clientInput.getFile().getName()), true, false);
            });
        }
        if ((max = this.progressBar.getMaximum()) != totalWork) {
            this.progressBar.setMaximum(totalWork);
        }
        this.progressBar.setSelection(worked);
    }

    @Override
    public void onLoaded() {
        this.context.set(Client.class, (Object)this.clientInput.getClient());
        this.rebuildContainer(this::createContainerWithViews);
    }

    @Override
    public void onError(String message) {
        this.rebuildContainer(parent -> {
            ProgressBar progressBar = this.createContainerWithMessage((Composite)parent, message, false, ClientFactory.isEncrypted((File)this.clientInput.getFile()));
        });
    }

    @Override
    public void onSaved() {
        this.part.getPersistedState().put("file", this.clientInput.getFile().getAbsolutePath());
        this.part.setLabel(this.clientInput.getLabel());
        this.part.setTooltip(this.clientInput.getFile().getAbsolutePath());
    }

    @Override
    public void onDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
    }

    @Override
    public void onRecalculationNeeded() {
        if (this.view != null && this.view.getControl() != null && !this.view.getControl().isDisposed()) {
            this.view.notifyModelUpdated();
        }
    }

    @Inject
    public void setQuotePrecision(@Preference(value="FORMAT_CALCULATED_QUOTE_DIGITS") int quotePrecision) {
        this.onRecalculationNeeded();
    }

    @Focus
    public void setFocus() {
        if (this.focus != null && !this.focus.isDisposed()) {
            this.focus.setFocus();
        }
    }

    @PreDestroy
    public void destroy() {
        Navigation navigation = this.getClientInput().getNavigation();
        if (navigation != null) {
            this.part.getPersistedState().put("view", this.selectedItem != null ? navigation.getIdentifier(this.selectedItem) : "");
        }
        this.clientInput.removeListener(this);
        this.clientInput.savePreferences();
        this.clientInputFactory.decrementEditorCount(this.clientInput);
        this.clientInput = null;
    }

    @Persist
    public void save(@Named(value="activeShell") Shell shell) {
        this.clientInput.save(shell);
    }

    public void doSaveAs(Shell shell, String extension, String encryptionMethod) {
        this.clientInput.doSaveAs(shell, extension, encryptionMethod);
    }

    public ClientInput getClientInput() {
        return this.clientInput;
    }

    public Client getClient() {
        return this.clientInput.getClient();
    }

    public IPreferenceStore getPreferenceStore() {
        return this.clientInput.getPreferenceStore();
    }

    public List<ReportingPeriod> getReportingPeriods() {
        return this.clientInput.getReportingPeriods();
    }

    public Optional<AbstractFinanceView> getCurrentView() {
        return Optional.ofNullable(this.view);
    }

    public Optional<Navigation.Item> getSelectedItem() {
        return Optional.ofNullable(this.selectedItem);
    }

    public ReportingPeriod getSelectedPeriod() {
        if (this.selectedPeriod != null) {
            return this.selectedPeriod;
        }
        try {
            String code = (String)this.part.getPersistedState().get("reporting-period");
            if (code != null) {
                this.selectedPeriod = ReportingPeriod.from((String)code);
            }
        }
        catch (IOException ignore) {
            PortfolioPlugin.log(ignore);
        }
        if (this.selectedPeriod == null) {
            List<ReportingPeriod> periods = this.clientInput.getReportingPeriods();
            this.selectedPeriod = periods.isEmpty() ? new ReportingPeriod.LastX(1, 0) : periods.get(0);
        }
        return this.selectedPeriod;
    }

    public void setSelectedPeriod(ReportingPeriod selectedPeriod) {
        this.selectedPeriod = Objects.requireNonNull(selectedPeriod);
        this.part.getPersistedState().put("reporting-period", selectedPeriod.getCode());
    }

    void markDirty() {
        this.clientInput.markDirty();
    }

    public void activateView(Class<? extends AbstractFinanceView> view, Object parameter) {
        this.getClientInput().getNavigation().findAll(i -> view.equals(i.getViewClass())).findAny().ifPresent(item -> this.activateView((Navigation.Item)item, parameter));
    }

    public void activateView(Navigation.Item item) {
        this.activateView(item, item.getParameter());
    }

    public void activateView(Navigation.Item item, Object parameter) {
        if (item.getViewClass() == null) {
            return;
        }
        this.disposeView();
        try {
            this.createView(item.getViewClass(), parameter);
            this.selectedItem = item;
            this.sidebar.select(item);
        }
        catch (Exception e) {
            PortfolioPlugin.log(e);
            this.createView(ExceptionView.class, e);
        }
    }

    private void createView(Class<? extends AbstractFinanceView> clazz, Object parameter) {
        IEclipseContext viewContext = this.context.createChild(clazz.getName());
        viewContext.set(Client.class, (Object)this.clientInput.getClient());
        viewContext.set(IPreferenceStore.class, (Object)this.clientInput.getPreferenceStore());
        viewContext.set(PortfolioPart.class, (Object)this);
        viewContext.set(ExchangeRateProviderFactory.class, (Object)this.clientInput.getExchangeRateProviderFacory());
        viewContext.set(PartPersistedState.class, (Object)new PartPersistedState(this.part.getPersistedState()));
        if (parameter != null) {
            viewContext.set("name.abuchen.portfolio.ui.param.viewparameter", parameter);
        }
        AbstractFinanceView underConstruction = (AbstractFinanceView)ContextInjectionFactory.make(clazz, (IEclipseContext)viewContext);
        viewContext.set(AbstractFinanceView.class, (Object)underConstruction);
        underConstruction.createViewControl(this.book);
        this.view = underConstruction;
        this.book.showPage(this.view.getControl());
        this.view.setFocus();
    }

    private void disposeView() {
        if (this.view != null) {
            AbstractFinanceView toBeDisposed = this.view;
            this.view = null;
            if (!toBeDisposed.getControl().isDisposed()) {
                toBeDisposed.getControl().dispose();
            }
        }
    }

    public <T> T make(Class<T> type, Object ... parameters) {
        IEclipseContext c2 = EclipseContextFactory.create();
        if (parameters != null) {
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                c2.set(param.getClass().getName(), param);
                ++n2;
            }
        }
        return (T)ContextInjectionFactory.make(type, (IEclipseContext)this.context, (IEclipseContext)c2);
    }

    public void inject(Object object) {
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)this.context);
    }
}

