/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientFactory;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.dialogs.PasswordDialog;
import name.abuchen.portfolio.ui.editor.ClientInputListener;
import name.abuchen.portfolio.ui.editor.Navigation;
import name.abuchen.portfolio.ui.jobs.AutoSaveJob;
import name.abuchen.portfolio.ui.jobs.CreateInvestmentPlanTxJob;
import name.abuchen.portfolio.ui.jobs.SyncOnlineSecuritiesJob;
import name.abuchen.portfolio.ui.jobs.UpdateDividendsJob;
import name.abuchen.portfolio.ui.jobs.UpdateQuotesJob;
import name.abuchen.portfolio.ui.wizards.client.ClientMigrationDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ClientInput {
    private static final String REPORTING_PERIODS_KEY = "AbstractHistoricView";
    private String label;
    private File clientFile;
    private Client client;
    private Navigation navigation;
    private PreferenceStore preferenceStore = new PreferenceStore();
    private ExchangeRateProviderFactory exchangeRateProviderFacory;
    private List<ReportingPeriod> reportingPeriods;
    private boolean isDirty = false;
    private List<Job> regularJobs = new ArrayList<Job>();
    private List<Runnable> disposeJobs = new ArrayList<Runnable>();
    private List<ClientInputListener> listeners = new ArrayList<ClientInputListener>();
    @Inject
    private IEventBroker broker;
    @Inject
    private IEclipseContext context;
    @Inject
    @Preference
    private IEclipsePreferences preferences;

    ClientInput(String label, File clientFile) {
        this.label = label;
        this.clientFile = clientFile;
    }

    public void dispose() {
        for (Job job : this.regularJobs) {
            job.cancel();
        }
        for (Runnable runnable : this.disposeJobs) {
            runnable.run();
        }
        this.client = null;
        this.clientFile = null;
    }

    public void addListener(ClientInputListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ClientInputListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty() {
        this.setDirty(true, true);
    }

    public void touch() {
        this.setDirty(true, false);
    }

    private void setDirty(boolean isDirty, boolean recalculate) {
        this.isDirty = isDirty;
        this.listeners.forEach(l -> l.onDirty(this.isDirty));
        if (isDirty && recalculate) {
            this.listeners.forEach(ClientInputListener::onRecalculationNeeded);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public Client getClient() {
        return this.client;
    }

    public File getFile() {
        return this.clientFile;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public ExchangeRateProviderFactory getExchangeRateProviderFacory() {
        return this.exchangeRateProviderFacory;
    }

    public PreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void savePreferences() {
        this.storePreferences(false);
    }

    public void save(Shell shell) {
        if (this.clientFile == null) {
            this.doSaveAs(shell, null, null);
            return;
        }
        BusyIndicator.showWhile((Display)shell.getDisplay(), () -> {
            try {
                if (this.preferences.getBoolean("CREATE_BACKUP_BEFORE_SAVING", true)) {
                    this.createBackup(this.clientFile, "backup");
                }
                ClientFactory.save((Client)this.client, (File)this.clientFile, null, null);
                this.storePreferences(false);
                this.broker.post("file/saved", (Object)this.clientFile.getAbsolutePath());
                this.setDirty(false, false);
                this.listeners.forEach(ClientInputListener::onSaved);
            }
            catch (IOException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.LabelError, (String)e.getMessage(), (IStatus)new Status(4, "name.abuchen.portfolio.ui", e.getMessage(), (Throwable)e));
            }
        });
    }

    public void doSaveAs(Shell shell, String extension, String encryptionMethod) {
        String fileNameProposal;
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setOverwrite(true);
        String string = fileNameProposal = this.clientFile != null ? this.clientFile.getName() : this.getLabel();
        if (extension != null && !fileNameProposal.endsWith(String.valueOf('.') + extension)) {
            int p = fileNameProposal.lastIndexOf(46);
            fileNameProposal = String.valueOf(p > 0 ? fileNameProposal.substring(0, p + 1) : String.valueOf(fileNameProposal) + '.') + extension;
        }
        dialog.setFileName(fileNameProposal);
        if ("macosx".equals(Platform.getOS())) {
            dialog.setFilterPath(System.getProperty("user.home"));
        } else {
            dialog.setFilterPath(this.clientFile != null ? this.clientFile.getAbsoluteFile().getParent() : System.getProperty("user.home"));
        }
        String path = dialog.open();
        if (path == null) {
            return;
        }
        if (extension != null && !path.endsWith(String.valueOf('.') + extension)) {
            path = String.valueOf(path) + '.' + extension;
        }
        File localFile = new File(path);
        char[] password = null;
        if (ClientFactory.isEncrypted((File)localFile)) {
            PasswordDialog pwdDialog = new PasswordDialog(shell);
            if (pwdDialog.open() != 0) {
                return;
            }
            password = pwdDialog.getPassword().toCharArray();
        }
        this.clientFile = localFile;
        this.label = localFile.getName();
        char[] pwd = password;
        BusyIndicator.showWhile((Display)shell.getDisplay(), () -> {
            try {
                ClientFactory.save((Client)this.client, (File)this.clientFile, (String)encryptionMethod, (char[])pwd);
                this.storePreferences(true);
                this.broker.post("file/saved", (Object)this.clientFile.getAbsolutePath());
                this.setDirty(false, false);
                this.listeners.forEach(ClientInputListener::onSaved);
            }
            catch (IOException e) {
                PortfolioPlugin.log(e);
                ErrorDialog.openError((Shell)shell, (String)Messages.LabelError, (String)e.getMessage(), (IStatus)new Status(4, "name.abuchen.portfolio.ui", e.getMessage(), (Throwable)e));
            }
        });
    }

    public void autoSave() {
        if (this.clientFile != null) {
            String backupName = this.constructFilename(this.clientFile, "autosave");
            File autosaveFile = this.clientFile.toPath().resolveSibling(backupName).toFile();
            try {
                ClientFactory.save((Client)this.client, (File)autosaveFile, null, null);
            }
            catch (IOException e) {
                PortfolioPlugin.log(e);
            }
        }
    }

    private long getAutoSavePrefs() {
        int delay = this.preferences.getInt("AUTO_SAVE_FILE", 0);
        return delay > 0 ? 60000 * delay : 0;
    }

    public void createBackupAfterOpen() {
        if (this.clientFile != null && this.preferences.getBoolean("CREATE_BACKUP_BEFORE_SAVING", true) && this.preferences.getInt("AUTO_SAVE_FILE", 0) == 0) {
            this.createBackup(this.clientFile, "backup-after-open");
        }
    }

    private void createBackup(File file, String suffix) {
        try {
            String backupName = this.constructFilename(file, suffix);
            Path sourceFile = file.toPath();
            Path backupFile = sourceFile.resolveSibling(backupName);
            Files.copy(sourceFile, backupFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            PortfolioPlugin.log(e);
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)e.getMessage()));
        }
    }

    private String constructFilename(File file, String suffix) {
        String filename = file.getName();
        int l = filename.lastIndexOf(46);
        return l > 0 ? String.valueOf(filename.substring(0, l)) + '.' + suffix + filename.substring(l) : String.valueOf(filename) + '.' + suffix;
    }

    private void storePreferences(boolean forceWrite) {
        if (this.clientFile == null) {
            return;
        }
        this.storeReportingPeriods();
        if (!forceWrite && !this.preferenceStore.needsSaving()) {
            return;
        }
        try {
            this.preferenceStore.setFilename(this.getPreferenceStoreFile(this.clientFile).getAbsolutePath());
            this.preferenceStore.save();
        }
        catch (IOException ignore) {
            PortfolioPlugin.log(ignore);
        }
    }

    private void loadPreferences() {
        if (this.clientFile == null) {
            return;
        }
        try {
            File preferenceFile = this.getPreferenceStoreFile(this.clientFile);
            this.preferenceStore.setFilename(preferenceFile.getAbsolutePath());
            if (preferenceFile.exists()) {
                this.preferenceStore.load();
            }
        }
        catch (IOException ignore) {
            PortfolioPlugin.log(ignore);
        }
    }

    private File getPreferenceStoreFile(File file) throws IOException {
        boolean storeNextToFile = this.preferences.getBoolean("STORE_SETTINGS_NEXT_TO_FILE", false);
        if (storeNextToFile) {
            String filename = file.getName();
            int last = filename.lastIndexOf(46);
            if (last > 0) {
                filename = filename.substring(0, last);
            }
            return new File(file.getParentFile(), String.valueOf(filename) + ".settings");
        }
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(file.getAbsolutePath().getBytes());
            StringBuilder filename = new StringBuilder();
            filename.append("prf_");
            int i = 0;
            while (i < digest.length) {
                filename.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
                ++i;
            }
            filename.append(".txt");
            return new File(PortfolioPlugin.getDefault().getStateLocation().toFile(), filename.toString());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public List<ReportingPeriod> getReportingPeriods() {
        if (this.reportingPeriods != null) {
            return this.reportingPeriods;
        }
        ArrayList<ReportingPeriod> answer = new ArrayList<ReportingPeriod>();
        String config = this.getPreferenceStore().getString(REPORTING_PERIODS_KEY);
        if (config != null && config.trim().length() > 0) {
            String[] codes;
            String[] stringArray = codes = config.split(";");
            int n = codes.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                try {
                    answer.add(ReportingPeriod.from((String)c));
                }
                catch (IOException | RuntimeException ignore) {
                    PortfolioPlugin.log(ignore);
                }
                ++n2;
            }
        }
        if (answer.isEmpty()) {
            int ii = 1;
            while (ii <= 3) {
                answer.add((ReportingPeriod)new ReportingPeriod.LastX(ii, 0));
                ++ii;
            }
        }
        this.reportingPeriods = answer;
        return this.reportingPeriods;
    }

    private void storeReportingPeriods() {
        if (this.reportingPeriods == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (ReportingPeriod p : this.reportingPeriods) {
            p.writeTo(buf);
            buf.append(';');
        }
        this.getPreferenceStore().setValue(REPORTING_PERIODS_KEY, buf.toString());
    }

    @Inject
    @Optional
    public void onExchangeRatesLoaded(@UIEventTopic(value="exchangeRates/loaded") Object obj) {
        if (this.exchangeRateProviderFacory != null) {
            this.exchangeRateProviderFacory.clearCache();
            this.listeners.forEach(ClientInputListener::onRecalculationNeeded);
        }
    }

    private void scheduleOnlineUpdateJobs() {
        if (this.preferences.getBoolean("UPDATE_QUOTES_AFTER_FILE_OPEN", true)) {
            UpdateQuotesJob initialQuoteUpdate = new UpdateQuotesJob(this.client, EnumSet.of(UpdateQuotesJob.Target.LATEST, UpdateQuotesJob.Target.HISTORIC));
            initialQuoteUpdate.schedule(1000L);
            CreateInvestmentPlanTxJob checkInvestmentPlans = new CreateInvestmentPlanTxJob(this.client, this.exchangeRateProviderFacory);
            checkInvestmentPlans.startAfter(initialQuoteUpdate);
            checkInvestmentPlans.schedule(1100L);
            int thirtyMinutes = 1800000;
            UpdateQuotesJob job = new UpdateQuotesJob(this.client, EnumSet.of(UpdateQuotesJob.Target.LATEST)).repeatEvery(thirtyMinutes);
            job.schedule(thirtyMinutes);
            this.regularJobs.add(job);
            int sixHours = 21600000;
            job = new UpdateQuotesJob(this.client, EnumSet.of(UpdateQuotesJob.Target.HISTORIC)).repeatEvery(sixHours);
            job.schedule(sixHours);
            this.regularJobs.add(job);
            new SyncOnlineSecuritiesJob(this.client).schedule(2000L);
            new UpdateDividendsJob(this.getClient()).schedule(5000L);
        }
    }

    private void scheduleAutoSaveJob() {
        IEclipsePreferences.IPreferenceChangeListener listener = event -> {
            if (event.getKey().contentEquals("AUTO_SAVE_FILE")) {
                for (Job j : this.regularJobs) {
                    if (!(j instanceof AutoSaveJob)) continue;
                    ((AutoSaveJob)j).setDelay(this.getAutoSavePrefs());
                    ((AutoSaveJob)j).schedule(this.getAutoSavePrefs());
                    ((AutoSaveJob)j).wakeUp(this.getAutoSavePrefs());
                }
            }
        };
        this.preferences.addPreferenceChangeListener(listener);
        this.disposeJobs.add(() -> this.preferences.removePreferenceChangeListener(listener));
        long delay = this.getAutoSavePrefs();
        AutoSaveJob job = new AutoSaveJob(this, delay);
        this.regularJobs.add(job);
        if (delay > 0L) {
            job.schedule(delay);
        }
    }

    void setErrorMessage(String message) {
        this.listeners.forEach(l -> l.onError(message));
    }

    void setClient(Client client) {
        if (this.client != null) {
            throw new IllegalArgumentException();
        }
        this.client = client;
        IEclipseContext c2 = EclipseContextFactory.create();
        c2.set(Client.class, (Object)client);
        this.exchangeRateProviderFacory = (ExchangeRateProviderFactory)ContextInjectionFactory.make(ExchangeRateProviderFactory.class, (IEclipseContext)this.context, (IEclipseContext)c2);
        this.navigation = new Navigation(client);
        client.addPropertyChangeListener(event -> {
            boolean recalculate;
            boolean bl = recalculate = !"touch".equals(event.getPropertyName());
            if (Display.getDefault().getThread() == Thread.currentThread()) {
                this.setDirty(true, recalculate);
            } else {
                Display.getDefault().asyncExec(() -> this.setDirty(true, recalculate));
            }
        });
        this.loadPreferences();
        this.scheduleOnlineUpdateJobs();
        this.scheduleAutoSaveJob();
        this.listeners.forEach(ClientInputListener::onLoaded);
        if (client.getFileVersionAfterRead() < 29) {
            Display.getDefault().asyncExec(() -> {
                ClientMigrationDialog dialog = new ClientMigrationDialog(Display.getDefault().getActiveShell(), client);
                dialog.open();
            });
        }
    }

    void notifyListeners(Consumer<ClientInputListener> consumer) {
        this.listeners.forEach(consumer::accept);
    }
}

