/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.model.Adaptable;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.dnd.SecurityTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;

public class SecurityDragListener
extends DragSourceAdapter {
    private StructuredViewer viewer;

    public SecurityDragListener(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void dragSetData(DragSourceEvent event) {
        SecurityTransfer.getTransfer().setSecurities(this.getSecurities());
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.getSecurities() != null;
    }

    private List<Security> getSecurities() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return null;
        }
        ArrayList<Security> selectedSecurities = new ArrayList<Security>();
        for (Object object : selection) {
            Security selectedSecurity;
            if (object instanceof Security) {
                selectedSecurities.add((Security)object);
                continue;
            }
            if (!(object instanceof Adaptable) || (selectedSecurity = (Security)((Adaptable)object).adapt(Security.class)) == null) continue;
            selectedSecurities.add(selectedSecurity);
        }
        return selectedSecurities;
    }
}

