/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.util.Objects;
import java.util.function.Consumer;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractTransactionDialog;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class OpenDialogAction
extends Action {
    private AbstractFinanceView owner;
    private Class<? extends AbstractTransactionDialog> type;
    private Consumer<? extends AbstractTransactionDialog> prepare;
    private Object[] parameters;
    private Account account;
    private Portfolio portfolio;
    private Security security;

    public OpenDialogAction(AbstractFinanceView owner, String label) {
        super(label);
        this.owner = owner;
    }

    public OpenDialogAction type(Class<? extends AbstractTransactionDialog> type) {
        this.type = type;
        this.prepare = null;
        return this;
    }

    public <D extends AbstractTransactionDialog> OpenDialogAction type(Class<D> type, Consumer<D> prepare) {
        this.type = type;
        this.prepare = prepare;
        return this;
    }

    public OpenDialogAction parameters(Object ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public OpenDialogAction with(Account account) {
        this.account = account;
        return this;
    }

    public OpenDialogAction with(Portfolio portfolio) {
        this.portfolio = portfolio;
        return this;
    }

    public OpenDialogAction with(Security security) {
        this.security = security;
        return this;
    }

    public void addTo(IMenuManager manager) {
        manager.add((IAction)this);
    }

    public void run() {
        Objects.requireNonNull(this.type);
        AbstractTransactionDialog dialog = this.owner.make(this.type, this.parameters);
        if (this.prepare != null) {
            this.prepare.accept(dialog);
        }
        if (this.account != null) {
            dialog.setAccount(this.account);
        }
        if (this.portfolio != null) {
            dialog.setPortfolio(this.portfolio);
        }
        if (this.security != null) {
            dialog.setSecurity(this.security);
        }
        dialog.open();
        if (dialog.hasAtLeastOneSuccessfulEdit()) {
            this.owner.markDirty();
        }
    }
}

