/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.InvestmentPlanModel;
import name.abuchen.portfolio.ui.dialogs.transactions.WarningMessages;
import name.abuchen.portfolio.ui.util.DatePicker;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.util.SimpleDateTimeDateSelectionProperty;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class InvestmentPlanDialog
extends AbstractTransactionDialog {
    private Client client;
    private final Class<? extends Transaction> planType;

    @Inject
    public InvestmentPlanDialog(@Named(value="activeShell") Shell parentShell, Client client, Class<? extends Transaction> planType) {
        super(parentShell);
        this.client = client;
        this.planType = planType;
        this.setModel(new InvestmentPlanModel(client, planType));
    }

    private InvestmentPlanModel model() {
        return (InvestmentPlanModel)this.model;
    }

    @Override
    protected void createFormElements(Composite editArea) {
        Label lblName = new Label(editArea, 131072);
        lblName.setText(Messages.ColumnName);
        Text valueName = new Text(editArea, 2048);
        IValidator validator = v -> v != null && v.trim().length() > 0 ? ValidationStatus.ok() : ValidationStatus.error((String)MessageFormat.format(Messages.MsgDialogInputRequired, Messages.ColumnName));
        ISWTObservableValue nameTarget = WidgetProperties.text((int)24).observe((Widget)valueName);
        IObservableValue nameModel = BeanProperties.value((String)InvestmentPlanModel.Properties.name.name(), String.class).observe((Object)this.model);
        this.context.bindValue((IObservableValue)nameTarget, nameModel, new UpdateValueStrategy().setAfterConvertValidator(validator), null);
        AbstractTransactionDialog.ComboInput securities = null;
        AbstractTransactionDialog.ComboInput portfolio = null;
        if (this.planType == PortfolioTransaction.class) {
            portfolio = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnPortfolio);
            List<Portfolio> portfolios = this.including(this.client.getActivePortfolios(), this.model().getPortfolio());
            portfolio.value.setInput(portfolios);
            portfolio.bindValue(InvestmentPlanModel.Properties.portfolio.name(), Messages.MsgMissingPortfolio);
            securities = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnSecurity);
            securities.value.setInput(this.including(this.client.getActiveSecurities(), this.model().getSecurity()));
            securities.bindValue(InvestmentPlanModel.Properties.security.name(), Messages.MsgMissingSecurity);
            securities.bindCurrency(InvestmentPlanModel.Properties.securityCurrencyCode.name());
        }
        AbstractTransactionDialog.ComboInput account = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnAccount);
        List<Account> accounts = this.including(this.client.getActiveAccounts(), this.model().getAccount());
        if (this.planType == PortfolioTransaction.class) {
            accounts = this.including(accounts, InvestmentPlanModel.DELIVERY);
        }
        account.value.setInput(accounts);
        account.bindValue(InvestmentPlanModel.Properties.account.name(), Messages.MsgMissingAccount);
        account.bindCurrency(InvestmentPlanModel.Properties.accountCurrencyCode.name());
        Label labelAutoGenerate = new Label(editArea, 0);
        labelAutoGenerate.setText(Messages.MsgCreateTransactionsAutomaticallyUponOpening);
        Button buttonAutoGenerate = new Button(editArea, 32);
        ISWTObservableValue targetAutoGenerate = WidgetProperties.buttonSelection().observe((Widget)buttonAutoGenerate);
        IObservableValue modelAutoGenerate = BeanProperties.value((String)InvestmentPlanModel.Properties.autoGenerate.name()).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetAutoGenerate, modelAutoGenerate);
        Label lblDate = new Label(editArea, 131072);
        lblDate.setText(Messages.ColumnDate);
        DatePicker valueDate = new DatePicker(editArea);
        ISWTObservableValue targetDate = new SimpleDateTimeDateSelectionProperty().observe((Widget)valueDate.getControl());
        IObservableValue modelDate = BeanProperties.value((String)InvestmentPlanModel.Properties.start.name()).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetDate, modelDate);
        ArrayList<Integer> available = new ArrayList<Integer>();
        int ii = 1;
        while (ii <= 12) {
            available.add(ii);
            ++ii;
        }
        AbstractTransactionDialog.ComboInput interval = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnInterval);
        interval.value.setInput(available);
        interval.value.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                int interval = (Integer)element;
                return MessageFormat.format(Messages.InvestmentPlanIntervalLabel, interval);
            }
        });
        interval.bindValue(InvestmentPlanModel.Properties.interval.name(), MessageFormat.format(Messages.MsgDialogInputRequired, Messages.ColumnInterval));
        AbstractTransactionDialog.Input amount = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnAmount);
        amount.bindValue(InvestmentPlanModel.Properties.amount.name(), Messages.ColumnAmount, Values.Amount, true);
        amount.bindCurrency(InvestmentPlanModel.Properties.transactionCurrencyCode.name());
        AbstractTransactionDialog.Input fees = null;
        if (this.planType == PortfolioTransaction.class) {
            fees = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnFees);
            fees.bindValue(InvestmentPlanModel.Properties.fees.name(), Messages.ColumnAmount, Values.Amount, false);
            fees.bindCurrency(InvestmentPlanModel.Properties.transactionCurrencyCode.name());
        }
        int amountWidth = SWTHelper.amountWidth((Drawable)amount.value);
        int currencyWidth = SWTHelper.currencyWidth((Drawable)amount.currency);
        FormDataFactory factory = FormDataFactory.startingWith((Control)valueName, lblName).width(3 * amountWidth);
        if (portfolio != null) {
            factory = factory.thenBelow(portfolio.value.getControl()).label(portfolio.label).thenBelow(securities.value.getControl()).label(securities.label).suffix(securities.currency, currencyWidth);
        }
        factory = factory.thenBelow(account.value.getControl()).label(account.label).suffix(account.currency, currencyWidth).thenBelow((Control)labelAutoGenerate, 10).thenBelow(valueDate.getControl(), 10).label(lblDate).thenBelow((Control)amount.value, 10).width(amountWidth).label(amount.label).suffix(amount.currency, currencyWidth);
        if (fees != null) {
            factory.thenBelow((Control)fees.value).width(amountWidth).label(fees.label).suffix(fees.currency, currencyWidth);
        }
        FormDataFactory.startingWith((Control)labelAutoGenerate).thenLeft((Control)buttonAutoGenerate);
        FormDataFactory.startingWith(valueDate.getControl()).thenRight((Control)interval.label).thenRight(interval.value.getControl());
        int widest = SWTHelper.widest(new Control[]{lblName, securities != null ? securities.label : null, portfolio != null ? portfolio.label : null, account.label, lblDate, interval.label, amount.label, fees != null ? fees.label : null});
        FormDataFactory.startingWith((Control)lblName).width(widest);
        WarningMessages warnings = new WarningMessages(this);
        warnings.add(() -> this.model().getStart().isAfter(LocalDate.now()) ? Messages.MsgDateIsInTheFuture : null);
        warnings.add(() -> this.model().getSecurity() != null && this.model().getSecurity().getPrices().isEmpty() ? Messages.MsgSecurityHasNoQuotes : null);
        this.model.addPropertyChangeListener(InvestmentPlanModel.Properties.start.name(), e -> warnings.check());
        this.model.addPropertyChangeListener(InvestmentPlanModel.Properties.security.name(), e -> warnings.check());
    }

    public void setPlan(InvestmentPlan plan) {
        this.model().setSource(plan);
    }

    @Override
    public void setSecurity(Security security) {
        this.model().setSecurity(security);
    }
}

