/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.time.LocalDateTime;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractSecurityTransactionModel;

class BuySellModel
extends AbstractSecurityTransactionModel {
    private BuySellEntry source;
    protected Account account;

    public BuySellModel(Client client, PortfolioTransaction.Type type) {
        super(client, type);
        if (!this.accepts(type)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean accepts(PortfolioTransaction.Type type) {
        return type == PortfolioTransaction.Type.BUY || type == PortfolioTransaction.Type.SELL;
    }

    @Override
    public void setSource(Object entry) {
        this.source = (BuySellEntry)entry;
        this.type = this.source.getPortfolioTransaction().getType();
        this.portfolio = (Portfolio)this.source.getOwner((Transaction)this.source.getPortfolioTransaction());
        this.account = (Account)this.source.getOwner((Transaction)this.source.getAccountTransaction());
        this.fillFromTransaction(this.source.getPortfolioTransaction());
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    @Override
    public void applyChanges() {
        BuySellEntry entry;
        if (this.security == null) {
            throw new UnsupportedOperationException(Messages.MsgMissingSecurity);
        }
        if (this.account == null) {
            throw new UnsupportedOperationException(Messages.MsgMissingReferenceAccount);
        }
        if (this.source != null && this.source.getOwner((Transaction)this.source.getPortfolioTransaction()).equals(this.portfolio) && this.source.getOwner((Transaction)this.source.getAccountTransaction()).equals(this.account)) {
            entry = this.source;
        } else {
            if (this.source != null) {
                TransactionOwner owner = this.source.getOwner((Transaction)this.source.getPortfolioTransaction());
                owner.deleteTransaction((Transaction)this.source.getPortfolioTransaction(), this.client);
                this.source = null;
            }
            entry = new BuySellEntry(this.portfolio, this.account);
            entry.setCurrencyCode(this.account.getCurrencyCode());
            entry.insert();
        }
        entry.setDate(LocalDateTime.of(this.date, this.time));
        entry.setCurrencyCode(this.account.getCurrencyCode());
        entry.setSecurity(this.security);
        entry.setShares(this.shares);
        entry.setAmount(this.total);
        entry.setType(this.type);
        entry.setNote(this.note);
        this.writeToTransaction(entry.getPortfolioTransaction());
    }

    @Override
    public void resetToNewTransaction() {
        this.source = null;
        super.resetToNewTransaction();
    }

    @Override
    public void setPortfolio(Portfolio portfolio) {
        this.setAccount(portfolio.getReferenceAccount());
        super.setPortfolio(portfolio);
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        String oldAccountCurrency = this.getTransactionCurrencyCode();
        String oldExchangeRateCurrencies = this.getExchangeRateCurrencies();
        String oldInverseExchangeRateCurrencies = this.getInverseExchangeRateCurrencies();
        this.account = account;
        this.firePropertyChange(AbstractSecurityTransactionModel.Properties.account.name(), this.account, this.account);
        this.firePropertyChange(AbstractSecurityTransactionModel.Properties.transactionCurrencyCode.name(), oldAccountCurrency, this.getTransactionCurrencyCode());
        this.firePropertyChange(AbstractSecurityTransactionModel.Properties.exchangeRateCurrencies.name(), oldExchangeRateCurrencies, this.getExchangeRateCurrencies());
        this.firePropertyChange(AbstractSecurityTransactionModel.Properties.inverseExchangeRateCurrencies.name(), oldInverseExchangeRateCurrencies, this.getInverseExchangeRateCurrencies());
        if (this.getSecurity() != null) {
            this.updateSharesAndQuote();
            this.updateExchangeRate();
        }
    }

    @Override
    public String getTransactionCurrencyCode() {
        return this.account != null ? this.account.getCurrencyCode() : "";
    }
}

