/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.dialogs.palette.BookmarkElements;
import name.abuchen.portfolio.ui.dialogs.palette.NavigationElements;
import name.abuchen.portfolio.ui.dialogs.palette.TransactionElements;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.SimpleAction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CommandPalettePopup
extends PopupDialog {
    private List<Element> elements = new ArrayList<Element>();
    private Text filterText;
    private Table table;
    private TextLayout textLayout;

    @Inject
    public CommandPalettePopup(IEclipseContext context, PortfolioPart part) {
        super(Display.getDefault().getActiveShell(), 4, true, true, false, true, true, null, Messages.LabelStartTyping);
        ArrayList<Class<TransactionElements>> provider = new ArrayList<Class<TransactionElements>>();
        provider.add(NavigationElements.class);
        provider.add(BookmarkElements.class);
        provider.add(TransactionElements.class);
        for (Class clazz : provider) {
            this.elements.addAll(((ElementProvider)ContextInjectionFactory.make((Class)clazz, (IEclipseContext)context)).getElements());
        }
        Collections.sort(this.elements, (r, l) -> r.getTitel().compareTo(l.getTitel()));
        this.create();
    }

    protected Color getForeground() {
        return Colors.BLACK;
    }

    protected Color getBackground() {
        return Colors.INFO_TOOLTIP_BACKGROUND;
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = new Text(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(-1, Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1)).applyTo((Control)this.filterText);
        this.filterText.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            switch (e.keyCode) {
                case 13: {
                    this.handleSelection();
                    return;
                }
                case 0x1000002: {
                    if (this.table.getItemCount() > 0) {
                        this.table.setSelection(0);
                        this.table.setFocus();
                    }
                    return;
                }
                case 0x1000001: {
                    int ix = this.table.getSelectionIndex();
                    if (ix >= 1) {
                        this.table.setSelection(ix - 1);
                        this.table.setFocus();
                    }
                    return;
                }
            }
            if (e.character == '\u001b') {
                this.close();
            }
        }));
        this.filterText.addModifyListener(e -> this.refresh(((Text)e.widget).getText()));
        return this.filterText;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        boolean isWin32 = "win32".equals(SWT.getPlatform());
        GridLayoutFactory.fillDefaults().extendedMargins(isWin32 ? 0 : 3, 3, 2, 2).applyTo(composite);
        Composite tableComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout layout = new TableColumnLayout();
        tableComposite.setLayout((Layout)layout);
        this.table = new Table(tableComposite, 65540);
        this.textLayout = new TextLayout((Device)this.table.getDisplay());
        this.textLayout.setOrientation(CommandPalettePopup.getDefaultOrientation());
        this.textLayout.setFont(this.table.getFont());
        layout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.table.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(e -> this.handleSelection()));
        this.table.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 0x1000001 && this.table.getSelectionIndex() == 0) {
                this.filterText.setFocus();
            } else if (e.character == '\u001b') {
                this.close();
            } else if (e.keyCode == 13 && e.stateMask != 0) {
                this.handleSelection();
            }
        }));
        Listener listener = event -> {
            Item entry = (Item)event.item.getData();
            switch (event.type) {
                case 41: {
                    entry.measure(event, this.textLayout);
                    break;
                }
                case 42: {
                    entry.paint(event, this.textLayout);
                    break;
                }
                case 40: {
                    entry.erase(event);
                }
            }
        };
        this.table.addListener(41, listener);
        this.table.addListener(40, listener);
        this.table.addListener(42, listener);
        this.refresh("");
        return composite;
    }

    protected Control getFocusControl() {
        return this.filterText;
    }

    public boolean close() {
        if (this.textLayout != null && !this.textLayout.isDisposed()) {
            this.textLayout.dispose();
        }
        return super.close();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PortfolioPlugin.getDefault().getDialogSettings();
        IDialogSettings result = settings.getSection("command-palette");
        if (result == null) {
            result = settings.addNewSection("command-palette");
        }
        return result;
    }

    protected Point getDefaultSize() {
        return new Point(400, 200);
    }

    protected Point getDefaultLocation(Point initialSize) {
        Rectangle parentBounds = this.getParentShell().getBounds();
        int x = parentBounds.x + parentBounds.width / 2 - initialSize.x / 2;
        int y = parentBounds.y + parentBounds.height / 2 - initialSize.y / 2;
        return new Point(x, y);
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        dialogMenu.add((IAction)new SimpleAction(Messages.LabelClose, a -> {
            boolean bl = this.close();
        }));
        dialogMenu.add((IContributionItem)new Separator());
        super.fillDialogMenu(dialogMenu);
    }

    private void handleSelection() {
        if (this.table.getSelectionCount() == 1) {
            Item item = (Item)this.table.getItem(this.table.getSelectionIndex()).getData();
            item.element.execute();
        }
        this.close();
    }

    private void refresh(String filter) {
        this.updateTableWith(this.match(filter));
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(0);
        }
        if (filter.length() == 0) {
            this.setInfoText(Messages.LabelStartTyping);
        } else {
            this.setInfoText("");
        }
    }

    private void updateTableWith(List<Item> items) {
        TableItem[] tableItems = this.table.getItems();
        this.table.clearAll();
        int index = 0;
        for (Item item : items) {
            TableItem tableItem = index < tableItems.length ? tableItems[index] : new TableItem(this.table, 0);
            tableItem.setData((Object)item);
            tableItem.setText(0, item.element.getTitel());
            ++index;
        }
        if (index < tableItems.length) {
            this.table.remove(index, tableItems.length - 1);
        }
    }

    private List<Item> match(String filter) {
        if (filter.isEmpty()) {
            return this.elements.stream().map(Item::new).collect(Collectors.toList());
        }
        Pattern filterPattern = Pattern.compile(".*" + filter + ".*", 2);
        ArrayList result = new ArrayList();
        this.elements.stream().filter(e -> filterPattern.matcher(e.getTitel()).matches()).forEach(result::add);
        this.elements.stream().filter(e -> e.getSubtitle() != null && filterPattern.matcher(e.getSubtitle()).matches()).filter(e -> !result.contains(e)).forEach(result::add);
        return result.stream().map(Item::new).collect(Collectors.toList());
    }

    public static interface Element {
        public String getTitel();

        default public String getSubtitle() {
            return null;
        }

        default public Images getImage() {
            return Images.VIEW;
        }

        default public void execute() {
        }
    }

    public static interface ElementProvider {
        public List<Element> getElements();
    }

    private static class Item {
        private final Element element;

        Item(Element element) {
            this.element = Objects.requireNonNull(element);
        }

        public void measure(Event event, TextLayout textLayout) {
            this.setup(event, textLayout);
            Image image = this.element.getImage().image();
            Rectangle imageBounds = image.getBounds();
            event.width += imageBounds.width + 2;
            event.height = Math.max(event.height, imageBounds.height + 2);
            Rectangle textBounds = textLayout.getBounds();
            event.width += textBounds.width + 2;
            event.height = Math.max(event.height, textBounds.height + 2);
        }

        public void paint(Event event, TextLayout textLayout) {
            this.setup(event, textLayout);
            Rectangle tableItemBounds = ((TableItem)event.item).getTextBounds(event.index);
            Image image = this.element.getImage().image();
            event.gc.drawImage(image, event.x + 1, event.y + 1);
            tableItemBounds.x += 1 + image.getBounds().width;
            Rectangle textBounds = textLayout.getBounds();
            textLayout.draw(event.gc, tableItemBounds.x, tableItemBounds.y + (tableItemBounds.height - textBounds.height) / 2);
        }

        private void setup(Event event, TextLayout textLayout) {
            Table table = ((TableItem)event.item).getParent();
            textLayout.setFont(table.getFont());
            String title = this.element.getTitel();
            String subtitle = this.element.getSubtitle();
            if (subtitle == null) {
                textLayout.setText(title);
            } else {
                textLayout.setText(String.valueOf(title) + " " + subtitle);
                textLayout.setStyle(new TextStyle(null, Colors.GRAY, null), title.length() + 1, title.length() + 1 + subtitle.length());
            }
        }

        public void erase(Event event) {
            event.detail &= 0xFFFFFFEF;
        }
    }
}

