/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.time.LocalDate;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.AbstractDialog;
import name.abuchen.portfolio.ui.util.BindingHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SecurityPriceDialog
extends AbstractDialog {
    public SecurityPriceDialog(Shell parentShell, Client client, Security security) {
        super(parentShell, Messages.LabelQuote, new SecurityPriceModel(client, security));
    }

    @Override
    protected void createFormElements(Composite editArea) {
        this.bindings().bindDatePicker(editArea, Messages.ColumnDate, "date");
        this.bindings().bindMandatoryQuoteInput(editArea, Messages.ColumnQuote, "price");
    }

    static class SecurityPriceModel
    extends BindingHelper.Model {
        private final Security security;
        private LocalDate date = LocalDate.now();
        private long price;

        public SecurityPriceModel(Client client, Security security) {
            super(client);
            this.security = security;
        }

        public Security getSecurity() {
            return this.security;
        }

        public long getPrice() {
            return this.price;
        }

        public void setPrice(long price) {
            this.price = price;
            this.firePropertyChange("price", this.price, this.price);
        }

        public LocalDate getDate() {
            return this.date;
        }

        public void setDate(LocalDate date) {
            this.date = date;
            this.firePropertyChange("date", this.date, this.date);
        }

        @Override
        public void applyChanges() {
            SecurityPrice p = new SecurityPrice(this.date, this.price);
            this.security.addPrice(p);
        }
    }
}

