/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.time.LocalDate;
import java.util.Objects;
import java.util.function.Predicate;
import name.abuchen.portfolio.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Shell;

public class DateSelectionDialog
extends Dialog {
    private LocalDate selection = LocalDate.now();
    private Predicate<LocalDate> validator;

    public DateSelectionDialog(Shell parentShell) {
        this(parentShell, date -> true);
    }

    public DateSelectionDialog(Shell parentShell, Predicate<LocalDate> validator) {
        super(parentShell);
        this.validator = Objects.requireNonNull(validator);
    }

    public LocalDate getSelection() {
        return this.selection;
    }

    public void setSelection(LocalDate selection) {
        this.selection = selection;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.DialogTitlePickDate);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        DateTime dateTime = new DateTime(container, 3072);
        dateTime.setDate(this.selection.getYear(), this.selection.getMonthValue() - 1, this.selection.getDayOfMonth());
        dateTime.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.selection = LocalDate.of(dateTime.getYear(), dateTime.getMonth() + 1, dateTime.getDay());
            this.getButton(0).setEnabled(this.validator.test(this.selection));
        }));
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 4).applyTo((Control)dateTime);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(this.validator.test(this.selection));
    }
}

