=head1 NAME

iPE::Sequence::Dna - Dna sequence class for iPE.

=head1 DESCRIPTION

=head1 FUNCTIONS

=over 8

=cut

package iPE::Sequence::Dna;
use iPE;
use iPE::Util::DNATools;
use base ("iPE::Sequence");
use strict;

our @alphabet = ("A","C","G","T");
our %ambigCodes = ( R => [ "A", "G" ],
                    Y => [ "C", "T" ],
                    W => [ "A", "T" ],
                    S => [ "C", "G" ],
                    M => [ "A", "C" ],
                    K => [ "G", "T" ],
                    B => [ "C", "G", "T" ],
                    D => [ "A", "G", "T" ],
                    H => [ "A", "C", "T" ],
                    V => [ "A", "C", "G" ],
                    N => [ "A", "C", "G", "T" ] );
our $wildCard = "N";

sub new {
    my $class = shift;
    my ($m) = @_;
    my $this = $class->SUPER::new(@_);

    return undef if not defined $this;

    if($this->seqReader->type eq "load") {
        $this->{seqRef_} = fast_uc($this->{seqRef_}, $this->length);
        $this->{rcRef_} = reverseComplement($this->{seqRef_});
    }

    return $this;
}

=item rcRef ()

Return a string with the reverse complement of the sequence.

=cut
sub rcRef  { shift->{rcRef_} }
sub type { "dna" }

=back

=head1 SEE ALSO

L<iPE::Sequence>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;
