=head1 NAME

iPE::Sequence::Array - Tiling array sequence (take 2) class for iPE.

=head1 DESCRIPTION

The functionality of this class is described in the superclass L<iPE::Sequence>.

The characters represent the following:

# not yet defined

=cut

package iPE::Sequence::Array;
use iPE;
use base ("iPE::Sequence");
use strict;

our @alphabet = ("0", "1", "2");
our %ambigCodes = ( "w" => [ "0", "1", "2" ] );
our $wildCard = "w";

sub new {

    my $class = shift;
    my ($m) = @_;
    my $this = $class->SUPER::new(@_);

    return undef if not defined $this;

    if($this->seqReader->type eq "load") {
        my $rev = reverse ${$this->{seqRef_}};
        $this->{revRef_} = \$rev;
    }

    return $this;
}

sub rcRef { shift->{revRef_} }

sub type { "array" }

=head1 SEE ALSO

L<iPE::Sequence>

=head1 AUTHOR

Aaron Tenney (tenney@cse.wustl.edu)

=cut

1;
