=head1 NAME

iPE::Model::Emission::BNTREE_ARRAY - Coding Sequence model for N-SCAN phylogenetic parameters.

=head1 DESCRIPTION

=head1 FUNCTIONS

=cut

package iPE::Model::Emission::BNTREE_ARRAY;
use iPE;
use iPE::Globals;
use iPE::Model;
use File::Temp;
use base ("iPE::Model::Emission::WAM");
use strict;

sub getZoeHeader { 
  my($this) = @_;
  return $this->name."\tBNTREE_ARRAY\t".
      $this->order." ".$this->length." ".$this->zFocus."\n"; 
}

sub normalize {
    my ($this) = @_;

    my $g = new iPE::Globals();

    my $order = $this->order > $this->targetOrder ? 
        $this->order : $this->targetOrder;

    my $phylo_text = "" ;
    for my $pos (0 .. $this->length-1) { # this is how it works with N-SCAN...
        $phylo_text .= $g->bntree->optimizeTuples(
            $this, $this->posCounts->[$pos], $order, $this->name."_$pos");
    }

    $this->setParamString($phylo_text);
}

sub outputPrepare { } # handled in normalize, no counts or prob output


=back

=head1 SEE ALSO

L<iPE::Model::Emission>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;


