=head1 NAME

iPE::Sequence::Tile - Tiling array sequence class for iPE.

=head1 DESCRIPTION

The functionality of this class is described in the superclass L<iPE::Sequence>.

The characters represent the following:

 0 - region not queried by tiling array
 1 - region queried but not transcribed (not in a transfrag)
 2 - region queried and transcribed (in a transfrag)

=cut

package iPE::Sequence::Tile;
use iPE;
use base ("iPE::Sequence");
use strict;

our @alphabet = ("0", "1", "2");
our %ambigCodes = ( "w" => [ "0", "1", "2" ] );
our $wildCard = "w";

sub new {
    my $class = shift;
    my ($m) = @_;
    my $this = $class->SUPER::new(@_);

    return undef if not defined $this;

    if($this->seqReader->type eq "load") {
        my $rev = reverse ${$this->{seqRef_}};
        $this->{revRef_} = \$rev;
    }

    return $this;
}

sub rcRef { shift->{revRef_} }

sub type { "tile" }

=head1 SEE ALSO

L<iPE::Sequence>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;
