=head1 NAME

iPE::Sequence::Repeat - Repeat sequence class for iPE.

=head1 DESCRIPTION

The functionality of this class is described in the superclass L<iPE::Sequence>.

The sequence characters represent the following:

 0 - plus strand SINE
 1 - plus strand LINE
 2 - other plus strand interspersed repeat
 3 - no repeat
 4 - other minus strand interspersed repeat
 5 - minus strand LINE
 6 - minus strand SINE

Note that this is symmetric, making complementation easier.

=cut

package iPE::Sequence::Repeat;
use iPE;
use base ("iPE::Sequence");
use strict;

our @alphabet = ("0", "1", "2", "3", "4", "5", "6");
our %ambigCodes = ( "w" => [ "0", "1", "2", "3", "4", "5", "6" ] );
our $wildCard = "w";

sub new {
    my $class = shift;
    my ($m) = @_;
    my $this = $class->SUPER::new(@_);

    return undef if not defined $this;

    if($this->seqReader->type eq "load") {
        my $rev = reverse ${$this->{seqRef_}};
        $rev =~ tr/01234567/76543210/;
        $this->{revRef_} = \$rev;
    }

    return $this;
}

sub rcRef { shift->{revRef_} }

sub type { "rep" }

=head1 SEE ALSO

L<iPE::Sequence>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;
