=head1 NAME

iPE::Sequence::Cola - Collapsed alphabet sequence class for iPE.

=head1 DESCRIPTION

The functionality of this class is described in the superclass L<iPE::Sequence>.

The significance of the alphabet varies.

Note that this is symmetric, making complementation easier.

=cut

package iPE::Sequence::Cola;
use iPE;
use base ("iPE::Sequence");
use strict;

our @alphabet = ("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l");#, "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y") ;
our %ambigCodes = ( "z" => ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"]);#, "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y"] );
our $wildCard = "z";

sub new {
    my $class = shift;
    my ($m) = @_;
    my $this = $class->SUPER::new(@_);

    return undef if not defined $this;

    if($this->seqReader->type eq "load") {
        my $rev = reverse ${$this->{seqRef_}};
        $this->{revRef_} = \$rev;
    }

    return $this;
}

sub rcRef { shift->{revRef_} }

sub type { "cola" }

=head1 SEE ALSO

L<iPE::Sequence>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;
