################################################################################
#
# PseudoState
#
# PseudoState data structure for gHMM
#
################################################################################

package iPE::State::PseudoState;
use strict;

sub new
{
    my($class, $m) = @_;
    my $this = bless {}, $class;

    die "Incomplete instantiation of class $class.  \n".
        "Required attributes are name and frame_name.\n"
        unless exists $m->{name} and
               exists $m->{frame_name};


    for my $member (keys %$m) {
        $this->{$member."_"} = $m->{$member};
    }

    return $this;
}

sub name      { return shift->{name_} }
sub frameName { return shift->{frame_name_} }

1;
