=head1 NAME

iPE::Sequence::Asest - Alternative splice indicating EST sequence class for iPE.

=head1 DESCRIPTION

The functionality of this class is described in the superclass L<iPE::Sequence>.

The characters represent the following:

 0 - unknown (not an exon or intron)
 1 - exon in EST alignment
 2 - intron in an EST alignment
 3 - optional exon in EST alignment
 4 - multisite extension of an exon in EST alignment

=cut

package iPE::Sequence::Asest;
use iPE;
use base ("iPE::Sequence");
use strict;

our @alphabet = ("0", "1", "2", "3", "4");
our %ambigCodes = ( "w" => [ "0", "1", "2", "3", "4" ] );
our $wildCard = "w";

sub new {
    my $class = shift;
    my ($m) = @_;
    my $this = $class->SUPER::new(@_);

    return undef if not defined $this;

    if($this->seqReader->type eq "load") {
        my $rev = reverse ${$this->{seqRef_}};
        $this->{revRef_} = \$rev;
    }

    return $this;
}

sub rcRef { shift->{revRef_} }

sub type { "asest" }

=head1 SEE ALSO

L<iPE::Sequence>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;
