/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.nesc.wiring;

import java.io.IOException;
import java.util.ListIterator;
import net.tinyos.nesc.dump.NDReader;
import net.tinyos.nesc.dump.xml.WiringEndpoint;
import net.tinyos.nesc.dump.xml.WiringNode;
import net.tinyos.nesc.dump.xml.WiringScan;
import net.tinyos.nesc.dump.xml.WiringScanBackwards;
import net.tinyos.nesc.dump.xml.WiringScanForwards;
import net.tinyos.nesc.dump.xml.Xattribute_value;
import net.tinyos.nesc.dump.xml.Xcomponent;
import net.tinyos.nesc.dump.xml.Xinterface;
import net.tinyos.nesc.dump.xml.Xmodule;
import net.tinyos.nesc.dump.xml.Xnesc;
import net.tinyos.nesc.dump.xml.Xwire;
import net.tinyos.nesc.dump.xml.Xwiring;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WiringCheck {
    static final boolean DEBUG = false;

    boolean check1Wire(WiringScan wiringScan, int n, int n2) {
        int n3 = this.count(0, wiringScan);
        if (n >= 0 && n3 < n) {
            return this.explain("underwired", wiringScan);
        }
        if (n2 >= 0 && n3 > n2) {
            return this.explain("overwired", wiringScan);
        }
        return false;
    }

    boolean explain(String string, WiringScan wiringScan) {
        System.err.println(wiringScan.node.ep.location + ": interface " + wiringScan.node.ep + " " + string);
        this.printPath(2, wiringScan);
        return true;
    }

    int count(int n, WiringScan wiringScan) {
        ListIterator listIterator = wiringScan.edges();
        int n2 = 0;
        WiringScan wiringScan2 = null;
        while (listIterator.hasNext()) {
            Xwire xwire = (Xwire)listIterator.next();
            if (wiringScan2 == null) {
                wiringScan2 = wiringScan.duplicate();
            } else {
                wiringScan2.copy(wiringScan);
            }
            if (!wiringScan2.follow(xwire)) continue;
            if (this.inModule(wiringScan2)) {
                ++n2;
            }
            n2 += this.count(n + 1, wiringScan2);
        }
        return n2;
    }

    static String repeat(int n, char c) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
        }
        return new String(cArray);
    }

    void printPath(int n, WiringScan wiringScan) {
        ListIterator listIterator = wiringScan.edges();
        WiringScan wiringScan2 = null;
        while (listIterator.hasNext()) {
            Xwire xwire = (Xwire)listIterator.next();
            if (wiringScan2 == null) {
                wiringScan2 = wiringScan.duplicate();
            } else {
                wiringScan2.copy(wiringScan);
            }
            if (!wiringScan2.follow(xwire)) continue;
            System.err.println(WiringCheck.repeat(n, ' ') + (wiringScan.isForwards() ? "-> " : "<- ") + wiringScan2.node.ep + (this.inModule(wiringScan2) ? " (module)" : "") + " [" + xwire.location + "]");
            this.printPath(n + 2, wiringScan2);
        }
    }

    boolean inModule(WiringEndpoint wiringEndpoint) {
        Xcomponent xcomponent = (Xcomponent)wiringEndpoint.node.ep.container;
        return xcomponent.implementation instanceof Xmodule;
    }

    void checkWiring() {
        ListIterator listIterator = Xnesc.interfaceList.listIterator();
        while (listIterator.hasNext()) {
            int n = -1;
            int n2 = -1;
            Xinterface xinterface = (Xinterface)listIterator.next();
            Xattribute_value xattribute_value = xinterface.attributeLookup("exactlyonce");
            boolean bl = false;
            if (xinterface.attributeLookup("atmostonce") != null || xattribute_value != null) {
                n2 = 1;
            }
            if (xinterface.attributeLookup("atleastonce") != null || xattribute_value != null) {
                n = 1;
            }
            if (n == -1 && n2 == -1) continue;
            WiringNode wiringNode = Xwiring.wg.lookup(xinterface);
            if (xinterface.provided) {
                bl = this.check1Wire(new WiringScanBackwards(wiringNode), n, n2);
                continue;
            }
            this.check1Wire(new WiringScanForwards(wiringNode), n, n2);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            new NDReader().parse(new InputSource(System.in));
            new WiringCheck().checkWiring();
        }
        catch (SAXException sAXException) {
            System.err.println("no xml reader found");
        }
    }
}

