/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.nesc.dump.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Location {
    public final int lineno;
    public final String filename;
    public final String instance;
    protected static Pattern locPattern = Pattern.compile("([0-9]+)(\\([a-zA-Z0-9_.]+\\))?:(.*)");

    public static Location decode(String string) {
        int n;
        if (string == null) {
            return null;
        }
        Matcher matcher = locPattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return Location.make(n, string4, string3);
    }

    protected Location(int n, String string, String string2) {
        this.lineno = n;
        this.filename = string;
        this.instance = string2;
    }

    public static Location make(int n, String string, String string2) {
        return new Location(n, string, string2);
    }

    public String toString() {
        if (this.instance != null) {
            return this.filename + "(" + this.instance + "):" + this.lineno;
        }
        return this.filename + ":" + this.lineno;
    }
}

