/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.nesc.dump;

import java.io.IOException;
import java.util.Stack;
import net.tinyos.nesc.dump.xml.NDElement;
import net.tinyos.nesc.dump.xml.Xnesc;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class NDReader
extends DefaultHandler {
    protected XMLReader parser;
    protected Stack activeElements = new Stack();
    protected String userPkg;
    static final String standardPkg = "net.tinyos.nesc.dump.xml";

    public NDReader() throws SAXException {
        this(null);
    }

    public NDReader(String string) throws SAXException {
        this.userPkg = string;
        try {
            this.parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            try {
                this.parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException sAXException2) {
                this.parser = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
        }
        this.parser.setContentHandler(this);
    }

    public boolean parse(InputSource inputSource) throws IOException {
        try {
            Xnesc.reset();
            this.parser.parse(inputSource);
            return true;
        }
        catch (SAXException sAXException) {
            return false;
        }
    }

    public boolean parse(String string) throws IOException {
        return this.parse(new InputSource(string));
    }

    protected NDElement makeElementIn(String string, String string2) throws Exception {
        return (NDElement)Class.forName(string + "." + string2).newInstance();
    }

    public NDElement makeElement(String string) throws Exception {
        string = "X" + string.replace('-', '_');
        if (this.userPkg != null) {
            try {
                return this.makeElementIn(this.userPkg, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.makeElementIn(standardPkg, string);
    }

    public NDElement parent() {
        return (NDElement)this.activeElements.elementAt(this.activeElements.size() - 2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        NDElement nDElement = null;
        try {
            nDElement = this.makeElement(string2);
        }
        catch (Exception exception) {
            System.err.println("element " + string2 + " not supported. " + exception);
        }
        if (nDElement != null) {
            nDElement = nDElement.start(this, attributes);
        }
        this.activeElements.push(nDElement);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        NDElement nDElement = (NDElement)this.activeElements.pop();
        if (nDElement == null) {
            return;
        }
        if ((nDElement = nDElement.end(this)) == null) {
            return;
        }
        if (!this.activeElements.empty()) {
            NDElement nDElement2 = (NDElement)this.activeElements.peek();
            nDElement2.child(this, nDElement);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        NDElement nDElement = (NDElement)this.activeElements.peek();
        if (nDElement != null) {
            nDElement.whitespace();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        NDElement nDElement = (NDElement)this.activeElements.peek();
        if (nDElement != null) {
            nDElement.characters(cArray, n, n2);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (new NDReader().parse(stringArray[i])) {
                    System.out.println("parse ok");
                    continue;
                }
                System.out.println("parse exceptions occured");
            }
        }
        catch (SAXException sAXException) {
            System.err.println("no xml reader found");
        }
    }
}

