/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: SPIRVOps.td                                                          *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace spirv {
/// Create a pointer into a composite object.
/// Result Type must be an OpTypePointer. Its Type operand must be the type
///     reached by walking the Base’s type hierarchy down to the last provided
///     index in Indexes, and its Storage Class operand must be the same as the
///     Storage Class of Base.
/// 
///     Base must be a pointer, pointing to the base of a composite object.
/// 
///     Indexes walk the type hierarchy to the desired depth, potentially down
///     to scalar granularity. The first index in Indexes will select the top-
///     level member/element/component/element of the base composite. All
///     composite constituents use zero-based numbering, as described by their
///     OpType… instruction. The second index will apply similarly to that
///     result, and so on. Once any non-composite type is reached, there must be
///     no remaining (unused) indexes.
/// 
///      Each index in Indexes
/// 
///     - must be a scalar integer type,
/// 
///     - is treated as a signed count, and
/// 
///     - must be an OpConstant when indexing into a structure.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = "spirv.Constant"() { value = 1: i32} : () -> i32
///     %1 = spirv.Variable : !spirv.ptr<!spirv.struct<f32, !spirv.array<4xf32>>, Function>
///     %2 = spirv.AccessChain %1[%0] : !spirv.ptr<!spirv.struct<f32, !spirv.array<4xf32>>, Function> -> !spirv.ptr<!spirv.array<4xf32>, Function>
///     %3 = spirv.Load "Function" %2 ["Volatile"] : !spirv.array<4xf32>
///     ```
class AccessChainOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Get the address of a global variable.
/// Variables in module scope are defined using symbol names. This op generates
///     an SSA value that can be used to refer to the symbol within function scope
///     for use in ops that expect an SSA value. This operation has no corresponding
///     SPIR-V instruction; it's merely used for modelling purpose in the SPIR-V
///     dialect. Since variables in module scope in SPIR-V dialect are of pointer
///     type, this op returns a pointer type as well, and the type is the same as
///     the variable referenced.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.mlir.addressof @global_var : !spirv.ptr<f32, Input>
///     ```
class AddressOfOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by the bitwise AND of Original Value and Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicAnd <Device> <None> %pointer, %value :
///                        !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicAndOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value from Value only if Original Value equals Comparator,
///     and
/// 
///     3) store the New Value back through Pointer'only if 'Original Value
///     equaled Comparator.
/// 
///     The instruction's result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///     Use Equal for the memory semantics of this instruction when Value and
///     Original Value compare equal.
/// 
///     Use Unequal for the memory semantics of this instruction when Value and
///     Original Value compare unequal. Unequal must not be set to Release or
///     Acquire and Release. In addition, Unequal cannot be set to a stronger
///     memory-order then Equal.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.  This type
///     must also match the type of Comparator.
/// 
///     Memory is a memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```
///     %0 = spirv.AtomicCompareExchange <Workgroup> <Acquire> <None>
///                                     %pointer, %value, %comparator
///                                     : !spirv.ptr<i32, WorkGroup>
///     ```
class AtomicCompareExchangeOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Deprecated (use OpAtomicCompareExchange).
/// Has the same semantics as OpAtomicCompareExchange.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicCompareExchangeWeak <Workgroup> <Acquire> <None>
///                                        %pointer, %value, %comparator
///                                        : !spirv.ptr<i32, WorkGroup>
///     ```
class AtomicCompareExchangeWeakOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value from copying Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction's result is the Original Value.
/// 
///     Result Type must be a scalar of integer type or floating-point type.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory is a memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicExchange <Workgroup> <Acquire> %pointer, %value,
///                             : !spirv.ptr<i32, WorkGroup>
///     ```
class AtomicExchangeOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by integer addition of Original Value and Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicIAdd <Device> <None> %pointer, %value :
///                         !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicIAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value through integer subtraction of 1 from Original Value,
///     and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.  The type of the value
///     pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicIDecrement <Device> <None> %pointer :
///                               !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicIDecrementOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value through integer addition of 1 to Original Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.  The type of the value
///     pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicIncrement <Device> <None> %pointer :
///                              !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicIIncrementOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by integer subtraction of Value from Original Value,
///     and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicISub <Device> <None> %pointer, %value :
///                         !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicISubOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by the bitwise OR of Original Value and Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicOr <Device> <None> %pointer, %value :
///                       !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicOrOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by finding the largest signed integer of Original
///     Value and Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicSMax <Device> <None> %pointer, %value :
///                         !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicSMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by finding the smallest signed integer of Original
///     Value and Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicSMin <Device> <None> %pointer, %value :
///                         !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicSMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by finding the largest unsigned integer of Original
///     Value and Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicUMax <Device> <None> %pointer, %value :
///                         !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicUMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by finding the smallest unsigned integer of Original
///     Value and Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicUMin <Device> <None> %pointer, %value :
///                         !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicUMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by the bitwise exclusive OR of Original Value and
///     Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction’s result is the Original Value.
/// 
///     Result Type must be an integer type scalar.
/// 
///      The type of Value must be the same as Result Type.  The type of the
///     value pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.AtomicXor <Device> <None> %pointer, %value :
///                        !spirv.ptr<i32, StorageBuffer>
///     ```
class AtomicXorOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Count the number of set bits in an object.
/// Results are computed per component.
/// 
///     Result Type must be a scalar or vector of integer type.  The components
///     must be wide enough to hold the unsigned Width of Base as an unsigned
///     value. That is, no sign bit is needed or counted when checking for a
///     wide enough result width.
/// 
///     Base must be a scalar or vector of integer type.  It must have the same
///     number of components as Result Type.
/// 
///     The result is the unsigned value that is the number of bits in Base that
///     are 1.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.BitCount %0: i32
///     %3 = spirv.BitCount %1: vector<4xi32>
///     ```
class BitCountOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Make a copy of an object, with a modified bit field that comes from
///     another object.
/// Results are computed per component.
/// 
///     Result Type must be a scalar or vector of integer type.
/// 
///     The type of Base and Insert must be the same as Result Type.
/// 
///     Any result bits numbered outside [Offset, Offset + Count -  1]
///     (inclusive) will come from the corresponding bits in Base.
/// 
///     Any result bits numbered in [Offset, Offset + Count -  1] come, in
///     order, from the bits numbered [0, Count - 1] of Insert.
/// 
///     Count  must be an integer type scalar. Count is the number of bits taken
///     from Insert. It will be consumed as an unsigned value. Count can be 0,
///     in which case the result will be Base.
/// 
///     Offset  must be an integer type scalar. Offset is the lowest-order bit
///     of the bit field.  It will be consumed as an unsigned value.
/// 
///     The resulting value is undefined if Count or Offset or their sum is
///     greater than the number of bits in the result.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.BitFieldInsert %base, %insert, %offset, %count : vector<3xi32>, i8, i8
///     ```
class BitFieldInsertOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Extract a bit field from an object, with sign extension.
/// Results are computed per component.
/// 
///     Result Type must be a scalar or vector of integer type.
/// 
///     The type of Base must be the same as Result Type.
/// 
///     If Count is greater than 0: The bits of Base numbered in [Offset, Offset
///     + Count -  1] (inclusive) become the bits numbered [0, Count - 1] of the
///     result. The remaining bits of the result will all be the same as bit
///     Offset + Count -  1 of Base.
/// 
///     Count  must be an integer type scalar. Count is the number of bits
///     extracted from Base. It will be consumed as an unsigned value. Count can
///     be 0, in which case the result will be 0.
/// 
///     Offset  must be an integer type scalar. Offset is the lowest-order bit
///     of the bit field to extract from Base.  It will be consumed as an
///     unsigned value.
/// 
///     The resulting value is undefined if Count or Offset or their sum is
///     greater than the number of bits in the result.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.BitFieldSExtract %base, %offset, %count : vector<3xi32>, i8, i8
///     ```
class BitFieldSExtractOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Extract a bit field from an object, without sign extension.
/// The semantics are the same as with OpBitFieldSExtract with the exception
///     that there is no sign extension. The remaining bits of the result will
///     all be 0.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.BitFieldUExtract %base, %offset, %count : vector<3xi32>, i8, i8
///     ```
class BitFieldUExtractOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Reverse the bits in an object.
/// Results are computed per component.
/// 
///     Result Type must be a scalar or vector of integer type.
/// 
///     The type of Base must be the same as Result Type.
/// 
///     The bit-number n of the result will be taken from bit-number Width - 1 -
///     n of Base, where Width is the OpTypeInt operand of the Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.BitReverse %0 : i32
///     %3 = spirv.BitReverse %1 : vector<4xi32>
///     ```
class BitReverseOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Bit pattern-preserving type conversion.
/// Result Type must be an OpTypePointer, or a scalar or vector of
///     numerical-type.
/// 
///     Operand must have a type of OpTypePointer, or a scalar or vector of
///     numerical-type. It must be a different type than Result Type.
/// 
///     If either Result Type or Operand is a pointer, the other must be a
///     pointer (diverges from the SPIR-V spec).
/// 
///     If Result Type has a different number of components than Operand, the
///     total number of bits in Result Type must equal the total number of bits
///     in Operand. Let L be the type, either Result Type or Operand's type,
///     that has the larger number of components. Let S be the other type, with
///     the smaller number of components. The number of components in L must be
///     an integer multiple of the number of components in S. The first
///     component (that is, the only or lowest-numbered component) of S maps to
///     the first components of L, and so on,  up to the last component of S
///     mapping to the last components of L. Within this mapping, any single
///     component of S (mapping to multiple components of L) maps its lower-
///     ordered bits to the lower-numbered components of L.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.Bitcast %0 : f32 to i32
///     %1 = spirv.Bitcast %0 : vector<2xf32> to i64
///     %1 = spirv.Bitcast %0 : !spirv.ptr<f32, Function> to !spirv.ptr<i32, Function>
///     ```
class BitcastOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is 1 if both Operand 1 and Operand 2 are 1. Result is 0 if either
///     Operand 1 or Operand 2 are 0.
/// Results are computed per component, and within each component, per bit.
/// 
///     Result Type must be a scalar or vector of integer type.  The type of
///     Operand 1 and Operand 2  must be a scalar or vector of integer type.
///     They must have the same number of components as Result Type. They must
///     have the same component width as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.BitwiseAnd %0, %1 : i32
///     %2 = spirv.BitwiseAnd %0, %1 : vector<4xi32>
///     ```
class BitwiseAndOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is 1 if either Operand 1 or Operand 2 is 1. Result is 0 if both
///     Operand 1 and Operand 2 are 0.
/// Results are computed per component, and within each component, per bit.
/// 
///     Result Type must be a scalar or vector of integer type.  The type of
///     Operand 1 and Operand 2  must be a scalar or vector of integer type.
///     They must have the same number of components as Result Type. They must
///     have the same component width as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.BitwiseOr %0, %1 : i32
///     %2 = spirv.BitwiseOr %0, %1 : vector<4xi32>
///     ```
class BitwiseOrOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is 1 if exactly one of Operand 1 or Operand 2 is 1. Result is 0
///     if Operand 1 and Operand 2 have the same value.
/// Results are computed per component, and within each component, per bit.
/// 
///     Result Type must be a scalar or vector of integer type.  The type of
///     Operand 1 and Operand 2  must be a scalar or vector of integer type.
///     They must have the same number of components as Result Type. They must
///     have the same component width as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.BitwiseXor %0, %1 : i32
///     %2 = spirv.BitwiseXor %0, %1 : vector<4xi32>
///     ```
class BitwiseXorOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// If Condition is true, branch to true block, otherwise branch to false
///     block.
/// Condition must be a Boolean type scalar.
/// 
///     Branch weights are unsigned 32-bit integer literals. There must be
///     either no Branch Weights or exactly two branch weights. If present, the
///     first is the weight for branching to True Label, and the second is the
///     weight for branching to False Label. The implied probability that a
///     branch is taken is its weight divided by the sum of the two Branch
///     weights. At least one weight must be non-zero. A weight of zero does not
///     imply a branch is dead or permit its removal; branch weights are only
///     hints. The two weights must not overflow a 32-bit unsigned integer when
///     added together.
/// 
///     This instruction must be the last instruction in a block.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     branch-conditional-op ::= `spirv.BranchConditional` ssa-use
///                               (`[` integer-literal, integer-literal `]`)?
///                               `,` successor `,` successor
///     successor ::= bb-id branch-use-list?
///     branch-use-list ::= `(` ssa-use-list `:` type-list-no-parens `)`
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.BranchConditional %condition, ^true_branch, ^false_branch
///     spirv.BranchConditional %condition, ^true_branch(%0: i32), ^false_branch(%1: i32)
///     ```
class BranchConditionalOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unconditional branch to target block.
/// This instruction must be the last instruction in a block.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.Branch ^target
///     spirv.Branch ^target(%0, %1: i32, f32)
///     ```
class BranchOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the arc cosine of x.
/// Result is an angle in radians.
/// 
///     Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.acos %0 : f32
///     %3 = spirv.CL.acos %1 : vector<4xf16>
///     ```
class CLAcosOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the inverse hyperbolic cosine of x .
/// Result is an angle in radians.
/// 
///     Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.acosh %0 : f32
///     %3 = spirv.CL.acosh %1 : vector<4xf16>
///     ```
class CLAcoshOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the arc sine of x.
/// Result is an angle in radians.
/// 
///     Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.asin %0 : f32
///     %3 = spirv.CL.asin %1 : vector<4xf16>
///     ```
class CLAsinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the inverse hyperbolic sine of x.
/// Result is an angle in radians.
/// 
///     Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.asinh %0 : f32
///     %3 = spirv.CL.asinh %1 : vector<4xf16>
///     ```
class CLAsinhOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the arc tangent of y / x.
/// Result is an angle in radians.
/// 
///     Result Type, y and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.atan2 %0, %1 : f32
///     %3 = spirv.CL.atan2 %0, %1 : vector<4xf16>
///     ```
class CLAtan2Op;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the arc tangent of x.
/// Result is an angle in radians.
/// 
///     Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.atan %0 : f32
///     %3 = spirv.CL.atan %1 : vector<4xf16>
///     ```
class CLAtanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the hyperbolic arc tangent of x.
/// Result is an angle in radians.
/// 
///     Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.atanh %0 : f32
///     %3 = spirv.CL.atanh %1 : vector<4xf16>
///     ```
class CLAtanhOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Round x to integral value using the round to positive infinity rounding
///     mode.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.ceil %0 : f32
///     %3 = spirv.CL.ceil %1 : vector<3xf16>
///     ```
class CLCeilOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the cosine of x radians.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.cos %0 : f32
///     %3 = spirv.CL.cos %1 : vector<3xf16>
///     ```
class CLCosOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the hyperbolic cosine of x radians.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.cosh %0 : f32
///     %3 = spirv.CL.cosh %1 : vector<4xf16>
///     ```
class CLCoshOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Error function of x encountered in integrating the normal distribution.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.erf %0 : f32
///     %3 = spirv.CL.erf %1 : vector<3xf16>
///     ```
class CLErfOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Exponentiation of Operand 1
/// Compute the base-e exponential of x. (i.e. ex)
/// 
///     Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand,
///     must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.exp %0 : f32
///     %3 = spirv.CL.exp %1 : vector<3xf16>
///     ```
class CLExpOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Absolute value of operand
/// Compute the absolute value of x.
/// 
///     Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand,
///     must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.fabs %0 : f32
///     %3 = spirv.CL.fabs %1 : vector<3xf16>
///     ```
class CLFAbsOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return maximum of two floating-point operands
/// Returns y if x < y, otherwise it returns x. If one argument is a NaN,
///     Fmax returns the other argument. If both arguments are NaNs, Fmax returns a NaN.
/// 
///     Result Type, x and y must be floating-point or vector(2,3,4,8,16)
///     of floating-point values.
/// 
///     All of the operands, including the Result Type operand,
///     must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.fmax %0, %1 : f32
///     %3 = spirv.CL.fmax %0, %1 : vector<3xf16>
///     ```
class CLFMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return minimum of two floating-point operands
/// Returns y if y < x, otherwise it returns x. If one argument is a NaN, Fmin returns the other argument.
///     If both arguments are NaNs, Fmin returns a NaN.
/// 
///     Result Type,x and y must be floating-point or vector(2,3,4,8,16) of floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.fmin %0, %1 : f32
///     %3 = spirv.CL.fmin %0, %1 : vector<3xf16>
///     ```
class CLFMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Round x to the integral value using the round to negative infinity
///     rounding mode.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.floor %0 : f32
///     %3 = spirv.CL.floor %1 : vector<3xf16>
///     ```
class CLFloorOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the correctly rounded floating-point representation of the sum
///     of c with the infinitely precise product of a and b. Rounding of
///     intermediate products shall not occur. Edge case results are per the
///     IEEE 754-2008 standard.
/// Result Type, a, b and c must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.CL.fma %a, %b, %c : f32
///     %1 = spirv.CL.fma %a, %b, %c : vector<3xf16>
///     ```
class CLFmaOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute the natural logarithm of x.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.log %0 : f32
///     %3 = spirv.CL.log %1 : vector<3xf16>
///     ```
class CLLogOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Returns the linear blend of x & y implemented as: x + (y - x) * a
/// Result Type, x, y and a must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     Note: This instruction can be implemented using contractions such as mad
///     or fma.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.CL.mix %a, %b, %c : f32
///     %1 = spirv.CL.mix %a, %b, %c : vector<3xf16>
///     ```
class CLMixOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute x to the power y.
/// Result Type, x and y must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.pow %0, %1 : f32
///     %3 = spirv.CL.pow %0, %1 : vector<3xf16>
///     ```
class CLPowOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// The printf extended instruction writes output to an implementation-
///     defined stream such as stdout under control of the string pointed to by
///     format that specifies how subsequent arguments are converted for output.
/// printf returns 0 if it was executed successfully and -1 otherwise.
/// 
///     Result Type must be i32.
/// 
///     Format must be a pointer(constant) to i8. If there are insufficient 
///     arguments for the format, the behavior is undefined. If the format 
///     is exhausted while arguments remain, the excess arguments are evaluated
///     (as always) but are otherwise ignored. The printf instruction returns 
///     when the end of the format string is encountered.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.CL.printf %fmt %1, %2  : !spirv.ptr<i8, UniformConstant>, i32, i32 -> i32
///     ```
class CLPrintfOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Round x to integral value (using round to nearest even rounding mode) in
///     floating-point format.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.CL.rint %0 : f32
///     %1 = spirv.CL.rint %1 : vector<3xf16>
///     ```
class CLRintOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return the integral value nearest to x rounding halfway cases away from
///     zero, regardless of the current rounding direction.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.round %0 : f32
///     %3 = spirv.CL.round %0 : vector<3xf16>
///     ```
class CLRoundOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute inverse square root of x.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.rsqrt %0 : f32
///     %3 = spirv.CL.rsqrt %1 : vector<3xf16>
///     ```
class CLRsqrtOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Absolute value of operand
/// Returns |x|, where x is treated as signed integer.
/// 
///     Result Type and x must be integer or vector(2,3,4,8,16) of
///     integer values.
/// 
///     All of the operands, including the Result Type operand,
///     must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.s_abs %0 : i32
///     %3 = spirv.CL.s_abs %1 : vector<3xi16>
///     ```
class CLSAbsOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return maximum of two signed integer operands
/// Returns y if x < y, otherwise it returns x, where x and y are treated as signed integers.
/// 
///     Result Type,x and y must be integer or vector(2,3,4,8,16) of integer values.
/// 
///     All of the operands, including the Result Type operand, must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.s_max %0, %1 : i32
///     %3 = spirv.CL.s_max %0, %1 : vector<3xi16>
///     ```
class CLSMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return minimum of two signed integer operands
/// Returns y if x < y, otherwise it returns x, where x and y are treated as signed integers.
/// 
///     Result Type,x and y must be integer or vector(2,3,4,8,16) of integer values.
/// 
///     All of the operands, including the Result Type operand, must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.s_min %0, %1 : i32
///     %3 = spirv.CL.s_min %0, %1 : vector<3xi16>
///     ```
class CLSMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute sine of x radians.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.sin %0 : f32
///     %3 = spirv.CL.sin %1 : vector<3xf16>
///     ```
class CLSinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute hyperbolic sine of x radians.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.sinh %0 : f32
///     %3 = spirv.CL.sinh %1 : vector<4xf16>
///     ```
class CLSinhOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute square root of x.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.sqrt %0 : f32
///     %3 = spirv.CL.sqrt %1 : vector<3xf16>
///     ```
class CLSqrtOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute tangent of x radians.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.tan %0 : f32
///     %3 = spirv.CL.tan %1 : vector<4xf16>
///     ```
class CLTanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Compute hyperbolic tangent of x radians.
/// Result Type and x must be floating-point or vector(2,3,4,8,16) of
///     floating-point values.
/// 
///     All of the operands, including the Result Type operand, must be of the
///     same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.tanh %0 : f32
///     %3 = spirv.CL.tanh %1 : vector<3xf16>
///     ```
class CLTanhOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return maximum of two unsigned integer operands
/// Returns y if x < y, otherwise it returns x, where x and y are treated as unsigned integers.
/// 
///     Result Type,x and y must be integer or vector(2,3,4,8,16) of integer values.
/// 
///     All of the operands, including the Result Type operand, must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.u_max %0, %1 : i32
///     %3 = spirv.CL.u_max %0, %1 : vector<3xi16>
///     ```
class CLUMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return minimum of two unsigned integer operands
/// Returns y if x < y, otherwise it returns x, where x and y are treated as unsigned integers.
/// 
///     Result Type,x and y must be integer or vector(2,3,4,8,16) of integer values.
/// 
///     All of the operands, including the Result Type operand, must be of the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.CL.u_min %0, %1 : i32
///     %3 = spirv.CL.u_min %0, %1 : vector<3xi16>
///     ```
class CLUMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Construct a new composite object from a set of constituent objects.
/// Result Type must be a composite type, whose top-level
///     members/elements/components/columns have the same type as the types of
///     the operands, with one exception. The exception is that for constructing
///     a vector, the operands may also be vectors with the same component type
///     as the Result Type component type. When constructing a vector, the total
///     number of components in all the operands must equal the number of
///     components in Result Type.
/// 
///     Constituents will become members of a structure, or elements of an
///     array, or components of a vector, or columns of a matrix. There must be
///     exactly one Constituent for each top-level
///     member/element/component/column of the result, with one exception. The
///     exception is that for constructing a vector, a contiguous subset of the
///     scalars consumed can be represented by a vector operand instead. The
///     Constituents must appear in the order needed by the definition of the
///     type of the result. When constructing a vector, there must be at least
///     two Constituent operands.
/// 
///     #### Example:
/// 
///     ```mlir
///     %a = spirv.CompositeConstruct %1, %2, %3 : vector<3xf32>
///     %b = spirv.CompositeConstruct %a, %1 : (vector<3xf32>, f32) -> vector<4xf32>
/// 
///     %c = spirv.CompositeConstruct %1 :
///       (f32) -> !spirv.coopmatrix<4x4xf32, Subgroup, MatrixA>
/// 
///     %d = spirv.CompositeConstruct %a, %4, %5 :
///       (vector<3xf32>, !spirv.array<4xf32>, !spirv.struct<(f32)>) ->
///         !spirv.struct<(vector<3xf32>, !spirv.array<4xf32>, !spirv.struct<(f32)>)>
///     ```
class CompositeConstructOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Extract a part of a composite object.
/// Result Type must be the type of object selected by the last provided
///     index.  The instruction result is the extracted object.
/// 
///     Composite is the composite to extract from.
/// 
///     Indexes walk the type hierarchy, potentially down to component
///     granularity, to select the part to extract. All indexes must be in
///     bounds.  All composite constituents use zero-based numbering, as
///     described by their OpType… instruction.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     composite-extract-op ::= ssa-id `=` `spirv.CompositeExtract` ssa-use
///                              `[` integer-literal (',' integer-literal)* `]`
///                              `:` composite-type
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Variable : !spirv.ptr<!spirv.array<4x!spirv.array<4xf32>>, Function>
///     %1 = spirv.Load "Function" %0 ["Volatile"] : !spirv.array<4x!spirv.array<4xf32>>
///     %2 = spirv.CompositeExtract %1[1 : i32] : !spirv.array<4x!spirv.array<4xf32>>
///     ```
class CompositeExtractOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Make a copy of a composite object, while modifying one part of it.
/// Result Type must be the same type as Composite.
/// 
///     Object is the object to use as the modified part.
/// 
///     Composite is the composite to copy all but the modified part from.
/// 
///     Indexes walk the type hierarchy of Composite to the desired depth,
///     potentially down to component granularity, to select the part to modify.
///     All indexes must be in bounds. All composite constituents use zero-based
///     numbering, as described by their OpType… instruction. The type of the
///     part selected to modify must match the type of Object.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     composite-insert-op ::= ssa-id `=` `spirv.CompositeInsert` ssa-use, ssa-use
///                             `[` integer-literal (',' integer-literal)* `]`
///                             `:` object-type `into` composite-type
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.CompositeInsert %object, %composite[1 : i32] : f32 into !spirv.array<4xf32>
///     ```
class CompositeInsertOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare a new integer-type or floating-point-type scalar constant.
/// This op declares a SPIR-V normal constant. SPIR-V has multiple constant
///     instructions covering different constant types:
/// 
///     * `OpConstantTrue` and `OpConstantFalse` for boolean constants
///     * `OpConstant` for scalar constants
///     * `OpConstantComposite` for composite constants
///     * `OpConstantNull` for null constants
///     * ...
/// 
///     Having such a plethora of constant instructions renders IR transformations
///     more tedious. Therefore, we use a single `spirv.Constant` op to represent
///     them all. Note that conversion between those SPIR-V constant instructions
///     and this op is purely mechanical; so it can be scoped to the binary
///     (de)serialization process.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     spirv.Constant-op ::= ssa-id `=` `spirv.Constant` attribute-value
///                         (`:` spirv-type)?
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Constant true
///     %1 = spirv.Constant dense<[2.0, 3.0]> : vector<2xf32>
///     %2 = spirv.Constant [dense<3.0> : vector<2xf32>] : !spirv.array<1xvector<2xf32>>
///     ```
/// 
///     TODO: support constant structs
class ConstantOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Wait for other invocations of this module to reach the current point of
///     execution.
/// All invocations of this module within Execution scope must reach this
///     point of execution before any invocation will proceed beyond it.
/// 
///     When Execution is Workgroup or larger, behavior is undefined if this
///     instruction is used in control flow that is non-uniform within
///     Execution. When Execution is Subgroup or Invocation, the behavior of
///     this instruction in non-uniform control flow is defined by the client
///     API.
/// 
///     If Semantics is not None, this instruction also serves as an
///     OpMemoryBarrier instruction, and must also perform and adhere to the
///     description and semantics of an OpMemoryBarrier instruction with the
///     same Memory and Semantics operands.  This allows atomically specifying
///     both a control barrier and a memory barrier (that is, without needing
///     two instructions). If Semantics is None, Memory is ignored.
/// 
///     Before version 1.3, it is only valid to use this instruction with
///     TessellationControl, GLCompute, or Kernel execution models. There is no
///     such restriction starting with version 1.3.
/// 
///     When used with the TessellationControl execution model, it also
///     implicitly synchronizes the Output Storage Class:  Writes to Output
///     variables performed by any invocation executed prior to a
///     OpControlBarrier will be visible to any other invocation after return
///     from that OpControlBarrier.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.ControlBarrier <Workgroup>, <Device>, <Acquire|UniformMemory>
///     ```
class ControlBarrierOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert value numerically from floating point to signed integer, with
///     round toward 0.0.
/// Result Type must be a scalar or vector of integer type.
/// 
///     Float Value must be a scalar or vector of floating-point type.  It must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.ConvertFToS %0 : f32 to i32
///     %3 = spirv.ConvertFToS %2 : vector<3xf32> to vector<3xi32>
///     ```
class ConvertFToSOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert value numerically from floating point to unsigned integer, with
///     round toward 0.0.
/// Result Type must be a scalar or vector of integer type, whose Signedness
///     operand is 0.
/// 
///     Float Value must be a scalar or vector of floating-point type.  It must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.ConvertFToU %0 : f32 to i32
///     %3 = spirv.ConvertFToU %2 : vector<3xf32> to vector<3xi32>
///     ```
class ConvertFToUOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Bit pattern-preserving conversion of a pointer to
///     an unsigned scalar integer of possibly different bit width.
/// Result Type must be a scalar of integer type, whose Signedness operand is 0.
/// 
///     Pointer must be a physical pointer type. If the bit width of Pointer is
///     smaller than that of Result Type, the conversion zero extends Pointer.
///     If the bit width of Pointer is larger than that of Result Type,
///     the conversion truncates Pointer.
/// 
///     For same bit width Pointer and Result Type, this is the same as OpBitcast.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.ConvertPtrToU %0 : !spirv.ptr<i32, Generic> to i32
///     ```
class ConvertPtrToUOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert value numerically from signed integer to floating point.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     Signed Value must be a scalar or vector of integer type.  It must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.ConvertSToF %0 : i32 to f32
///     %3 = spirv.ConvertSToF %2 : vector<3xi32> to vector<3xf32>
///     ```
class ConvertSToFOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert value numerically from unsigned integer to floating point.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     Unsigned Value must be a scalar or vector of integer type.  It must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.ConvertUToF %0 : i32 to f32
///     %3 = spirv.ConvertUToF %2 : vector<3xi32> to vector<3xf32>
///     ```
class ConvertUToFOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Bit pattern-preserving conversion of an unsigned scalar integer
///     to a pointer.
/// Result Type must be a physical pointer type.
/// 
///     Integer Value must be a scalar of integer type, whose Signedness
///     operand is 0. If the bit width of Integer Value is smaller
///     than that of Result Type, the conversion zero extends Integer Value.
///     If the bit width of Integer Value is larger than that of Result Type,
///     the conversion truncates Integer Value.
/// 
///     For same-width Integer Value and Result Type, this is the same as OpBitcast.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.ConvertUToPtr %0 :  i32 to !spirv.ptr<i32, Generic>
///     ```
class ConvertUToPtrOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Copy from the memory pointed to by Source to the memory pointed to by
///     Target. Both operands must be non-void pointers and having the same <id>
///     Type operand in their OpTypePointer type declaration.  Matching Storage
///     Class is not required.  The amount of memory copied is the size of the
///     type pointed to. The copied type must have a fixed size; i.e., it must
///     not be, nor include, any OpTypeRuntimeArray types.
/// If present, any Memory Operands must begin with a memory operand
///     literal. If not present, it is the same as specifying the memory operand
///     None. Before version 1.4, at most one memory operands mask can be
///     provided. Starting with version 1.4 two masks can be provided, as
///     described in Memory Operands. If no masks or only one mask is present,
///     it applies to both Source and Target. If two masks are present, the
///     first applies to Target and cannot include MakePointerVisible, and the
///     second applies to Source and cannot include MakePointerAvailable.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     copy-memory-op ::= `spirv.CopyMemory ` storage-class ssa-use
///                        storage-class ssa-use
///                        (`[` memory-access `]` (`, [` memory-access `]`)?)?
///                        ` : ` spirv-element-type
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Variable : !spirv.ptr<f32, Function>
///     %1 = spirv.Variable : !spirv.ptr<f32, Function>
///     spirv.CopyMemory "Function" %0, "Function" %1 : f32
///     ```
class CopyMemoryOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Dot product of Vector 1 and Vector 2
/// Result Type must be a floating point scalar.
/// 
///     Vector 1 and Vector 2 must be vectors of the same type, and their component
///     type must be Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Dot %v1, %v2 : vector<4xf32> -> f32
///     ```
class DotOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// TBD
/// <!-- End of AutoGen section -->
/// 
///     Perform the following steps atomically with respect to any other atomic
///     accesses within Scope to the same location:
/// 
///     1) load through Pointer to get an Original Value,
/// 
///     2) get a New Value by float addition of Original Value and Value, and
/// 
///     3) store the New Value back through Pointer.
/// 
///     The instruction's result is the Original Value.
/// 
///     Result Type must be a floating-point type scalar.
/// 
///     The type of Value must be the same as Result Type. The type of the value
///     pointed to by Pointer must be the same as Result Type.
/// 
///     Memory must be a valid memory Scope.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.EXT.AtomicFAdd <Device> <None> %pointer, %value :
///                            !spirv.ptr<f32, StorageBuffer>
///     ```
class EXTAtomicFAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare a new replicated composite constant op.
/// Represents a splat composite constant i.e., all elements of composite constant
///     have the same value.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.EXT.ConstantCompositeReplicate [1 : i32] : vector<2xi32>
///     %1 = spirv.EXT.ConstantCompositeReplicate [1 : i32] : !spirv.array<2 x vector<2xi32>>
///     %2 = spirv.EXT.ConstantCompositeReplicate [dense<[1, 2]> : vector<2xi32>] : !spirv.array<2 x vector<2xi32>>
///     ```
class EXTConstantCompositeReplicateOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Defines the grid size of subsequent mesh shader workgroups to generate upon
///     completion of the task shader workgroup.
/// Defines the grid size of subsequent mesh shader workgroups to generate upon
///     completion of the task shader workgroup.
/// 
///     Group Count X Y Z must each be a 32-bit unsigned integer value. They
///     configure the number of local workgroups in each respective dimensions for the
///     launch of child mesh tasks. See Vulkan API specification for more detail.
/// 
///     Payload is an optional pointer to the payload structure to pass to the
///     generated mesh shader invocations. Payload must be the result of an OpVariable
///     with a storage class of TaskPayloadWorkgroupEXT.
/// 
///     The arguments are taken from the first invocation in each workgroup.
///     Behaviour is undefined if any invocation terminates without executing this
///     instruction, or if any invocation executes this instruction in non-uniform
///     control flow.
/// 
///     This instruction also serves as an OpControlBarrier instruction, and also
///     performs and adheres to the description and semantics of an OpControlBarrier
///     instruction with the Execution and Memory operands set to Workgroup and the
///     Semantics operand set to a combination of WorkgroupMemory and AcquireRelease.
/// 
///     Ceases all further processing: Only instructions executed before
///     OpEmitMeshTasksEXT have observable side effects.
/// 
///     This instruction must be the last instruction in a block.
/// 
///     This instruction is only valid in the TaskEXT Execution Model.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.EmitMeshTasksEXT %x, %y, %z : i32, i32, i32
///     spirv.EmitMeshTasksEXT %x, %x, %z, %payload : i32, i32, i32, !spirv.ptr<i32, TaskPayloadWorkgroupEXT>
///     ```
class EXTEmitMeshTasksOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Sets the actual output size of the primitives and vertices that the mesh
///     shader workgroup will emit upon completion.
/// Vertex Count must be a 32-bit unsigned integer value. It defines the array size
///     of per-vertex outputs.
/// 
///     Primitive Count must a 32-bit unsigned integer value. It defines the array size
///     of per-primitive outputs.
/// 
///     The arguments are taken from the first invocation in each workgroup. Behavior
///     is undefined if any invocation executes this instruction more than once or
///     under non-uniform control flow. Behavior is undefined if there is any control
///     flow path to an output write that is not preceded by this instruction.
/// 
///     This instruction is only valid in the MeshEXT Execution Model.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.SetMeshOutputsEXT %vcount, %pcount : i32, i32
///     ```
class EXTSetMeshOutputsOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare a new replicated composite specialization constant op.
/// Represents a splat spec composite constant i.e., all elements of spec composite
///     constant have the same value. The splat value must come from a symbol reference
///     of spec constant instruction.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.SpecConstant @sc_i32_1 = 1 : i32
///     spirv.EXT.SpecConstantCompositeReplicate @scc_splat_array_of_i32 (@sc_i32_1) : !spirv.array<3 x i32>
///     spirv.EXT.SpecConstantCompositeReplicate @scc_splat_struct_of_i32 (@sc_i32_1) : !spirv.struct<(i32, i32, i32)>
///     ```
class EXTSpecConstantCompositeReplicateOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Emits the current values of all output variables to the current output
///     primitive. After execution, the values of all output variables are
///     undefined.
/// This instruction must only be used when only one stream is present.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.EmitVertex
///     ```
class EmitVertexOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Finish the current primitive and start a new one. No vertex is emitted.
/// This instruction must only be used when only one stream is present.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.EndPrimitive
///     ```
class EndPrimitiveOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare an entry point, its execution model, and its interface.
/// Execution Model is the execution model for the entry point and its
///     static call tree. See Execution Model.
/// 
///     Entry Point must be the Result <id> of an OpFunction instruction.
/// 
///     Name is a name string for the entry point. A module cannot have two
///     OpEntryPoint instructions with the same Execution Model and the same
///     Name string.
/// 
///     Interface is a list of symbol references to `spirv.GlobalVariable`
///     operations. These declare the set of global variables from a
///     module that form the interface of this entry point. The set of
///     Interface symbols must be equal to or a superset of the
///     `spirv.GlobalVariable`s referenced by the entry point’s static call
///     tree, within the interface’s storage classes.  Before version 1.4,
///     the interface’s storage classes are limited to the Input and
///     Output storage classes. Starting with version 1.4, the interface’s
///     storage classes are all storage classes used in declaring all
///     global variables referenced by the entry point’s call tree.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     execution-model ::= "Vertex" | "TesellationControl" |
///                         <and other SPIR-V execution models...>
/// 
///     entry-point-op ::= ssa-id `=` `spirv.EntryPoint` execution-model
///                        symbol-reference (`, ` symbol-reference)*
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.EntryPoint "GLCompute" @foo
///     spirv.EntryPoint "Kernel" @foo, @var1, @var2
/// 
///     ```
class EntryPointOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare an execution mode for an entry point.
/// Entry Point must be the Entry Point <id> operand of an OpEntryPoint
///     instruction.
/// 
///     Mode is the execution mode. See Execution Mode.
/// 
///     This instruction is only valid when the Mode operand is an execution
///     mode that takes no Extra Operands, or takes Extra Operands that are not
///     <id> operands.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     execution-mode ::= "Invocations" | "SpacingEqual" |
///                        <and other SPIR-V execution modes...>
/// 
///     execution-mode-op ::= `spirv.ExecutionMode ` ssa-use execution-mode
///                           (integer-literal (`, ` integer-literal)* )?
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.ExecutionMode @foo "ContractionOff"
///     spirv.ExecutionMode @bar "LocalSizeHint", 3, 4, 5
///     ```
class ExecutionModeOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point addition of Operand 1 and Operand 2.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     The types of Operand 1 and Operand 2 both must be the same as Result
///     Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FAdd %0, %1 : f32
///     %5 = spirv.FAdd %2, %3 : vector<4xf32>
///     ```
class FAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert value numerically from one floating-point width to another
///     width.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     Float Value must be a scalar or vector of floating-point type.  It must
///     have the same number of components as Result Type.  The component width
///     cannot equal the component width in Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.FConvertOp %0 : f32 to f64
///     %3 = spirv.FConvertOp %2 : vector<3xf32> to vector<3xf64>
///     ```
class FConvertOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point division of Operand 1 divided by Operand 2.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     The types of Operand 1 and Operand 2 both must be the same as Result
///     Type.
/// 
///     Results are computed per component.  The resulting value is undefined
///     if Operand 2 is 0.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FDiv %0, %1 : f32
///     %5 = spirv.FDiv %2, %3 : vector<4xf32>
///     ```
class FDivOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// The floating-point remainder whose sign matches the sign of Operand 2.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     The types of Operand 1 and Operand 2 both must be the same as Result
///     Type.
/// 
///     Results are computed per component.  The resulting value is undefined
///     if Operand 2 is 0.  Otherwise, the result is the remainder r of Operand
///     1 divided by Operand 2 where if r ≠ 0, the sign of r is the same as the
///     sign of Operand 2.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FMod %0, %1 : f32
///     %5 = spirv.FMod %2, %3 : vector<4xf32>
///     ```
class FModOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point multiplication of Operand 1 and Operand 2.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     The types of Operand 1 and Operand 2 both must be the same as Result
///     Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FMul %0, %1 : f32
///     %5 = spirv.FMul %2, %3 : vector<4xf32>
///     ```
class FMulOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Inverts the sign bit of Operand. (Note, however, that OpFNegate is still
///     considered a floating-point instruction, and so is subject to the
///     general floating-point rules regarding, for example, subnormals and NaN
///     propagation).
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     The type of Operand must be the same as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.FNegate %0 : f32
///     %3 = spirv.FNegate %2 : vector<4xf32>
///     ```
class FNegateOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison for being ordered and equal.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FOrdEqual %0, %1 : f32
///     %5 = spirv.FOrdEqual %2, %3 : vector<4xf32>
///     ```
class FOrdEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison if operands are ordered and Operand 1 is
///     greater than or equal to Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FOrdGreaterThanEqual %0, %1 : f32
///     %5 = spirv.FOrdGreaterThanEqual %2, %3 : vector<4xf32>
///     ```
class FOrdGreaterThanEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison if operands are ordered and Operand 1 is
///     greater than  Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FOrdGreaterThan %0, %1 : f32
///     %5 = spirv.FOrdGreaterThan %2, %3 : vector<4xf32>
///     ```
class FOrdGreaterThanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison if operands are ordered and Operand 1 is less
///     than or equal to Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FOrdLessThanEqual %0, %1 : f32
///     %5 = spirv.FOrdLessThanEqual %2, %3 : vector<4xf32>
///     ```
class FOrdLessThanEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison if operands are ordered and Operand 1 is less
///     than Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FOrdLessThan %0, %1 : f32
///     %5 = spirv.FOrdLessThan %2, %3 : vector<4xf32>
///     ```
class FOrdLessThanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison for being ordered and not equal.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FOrdNotEqual %0, %1 : f32
///     %5 = spirv.FOrdNotEqual %2, %3 : vector<4xf32>
///     ```
class FOrdNotEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// The floating-point remainder whose sign matches the sign of Operand 1.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     The types of Operand 1 and Operand 2 both must be the same as Result
///     Type.
/// 
///     Results are computed per component.  The resulting value is undefined
///     if Operand 2 is 0.  Otherwise, the result is the remainder r of Operand
///     1 divided by Operand 2 where if r ≠ 0, the sign of r is the same as the
///     sign of Operand 1.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FRemOp %0, %1 : f32
///     %5 = spirv.FRemOp %2, %3 : vector<4xf32>
///     ```
class FRemOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point subtraction of Operand 2 from Operand 1.
/// Result Type must be a scalar or vector of floating-point type.
/// 
///     The types of Operand 1 and Operand 2 both must be the same as Result
///     Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FRemOp %0, %1 : f32
///     %5 = spirv.FRemOp %2, %3 : vector<4xf32>
///     ```
class FSubOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison for being unordered or equal.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FUnordEqual %0, %1 : f32
///     %5 = spirv.FUnordEqual %2, %3 : vector<4xf32>
///     ```
class FUnordEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison if operands are unordered or Operand 1 is
///     greater than or equal to Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FUnordGreaterThanEqual %0, %1 : f32
///     %5 = spirv.FUnordGreaterThanEqual %2, %3 : vector<4xf32>
///     ```
class FUnordGreaterThanEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison if operands are unordered or Operand 1 is
///     greater than  Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FUnordGreaterThan %0, %1 : f32
///     %5 = spirv.FUnordGreaterThan %2, %3 : vector<4xf32>
///     ```
class FUnordGreaterThanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison if operands are unordered or Operand 1 is less
///     than or equal to Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FUnordLessThanEqual %0, %1 : f32
///     %5 = spirv.FUnordLessThanEqual %2, %3 : vector<4xf32>
///     ```
class FUnordLessThanEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison if operands are unordered or Operand 1 is less
///     than Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FUnordLessThan %0, %1 : f32
///     %5 = spirv.FUnordLessThan %2, %3 : vector<4xf32>
///     ```
class FUnordLessThanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Floating-point comparison for being unordered or not equal.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     floating-point type.  They must have the same type, and they must have
///     the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.FUnordNotEqual %0, %1 : f32
///     %5 = spirv.FUnordNotEqual %2, %3 : vector<4xf32>
///     ```
class FUnordNotEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare or define a function
/// This op declares or defines a SPIR-V function using one region, which
///     contains one or more blocks.
/// 
///     Different from the SPIR-V binary format, this op is not allowed to
///     implicitly capture global values, and all external references must use
///     function arguments or symbol references. This op itself defines a symbol
///     that is unique in the enclosing module op.
/// 
///     This op itself takes no operands and generates no results. Its region
///     can take zero or more arguments and return zero or one values.
/// 
///     From `SPV_KHR_physical_storage_buffer`:
///     If a parameter of function is
///     - a pointer (or contains a pointer) in the PhysicalStorageBuffer storage
///       class, the function parameter must be decorated with exactly one of
///       `Aliased` or `Restrict`.
///     - a pointer (or contains a pointer) and the type it points to is a pointer
///       in the PhysicalStorageBuffer storage class, the function parameter must
///       be decorated with exactly one of `AliasedPointer` or `RestrictPointer`.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     spv-function-control ::= "None" | "Inline" | "DontInline" | ...
///     spv-function-op ::= `spirv.func` function-signature
///                          spv-function-control region
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.func @foo() -> () "None" { ... }
///     spirv.func @bar() -> () "Inline|Pure" { ... }
/// 
///     spirv.func @aliased_pointer(%arg0: !spirv.ptr<i32, PhysicalStorageBuffer>,
///         { spirv.decoration = #spirv.decoration<Aliased> }) -> () "None" { ... }
/// 
///     spirv.func @restrict_pointer(%arg0: !spirv.ptr<i32, PhysicalStorageBuffer>,
///         { spirv.decoration = #spirv.decoration<Restrict> }) -> () "None" { ... }
/// 
///     spirv.func @aliased_pointee(%arg0: !spirv.ptr<!spirv.ptr<i32,
///         PhysicalStorageBuffer>, Generic> { spirv.decoration =
///         #spirv.decoration<AliasedPointer> }) -> () "None" { ... }
/// 
///     spirv.func @restrict_pointee(%arg0: !spirv.ptr<!spirv.ptr<i32,
///         PhysicalStorageBuffer>, Generic> { spirv.decoration =
///         #spirv.decoration<RestrictPointer> }) -> () "None" { ... }
///     ```
class FuncOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Call a function.
/// Result Type is the type of the return value of the function. It must be
///     the same as the Return Type operand of the Function Type operand of the
///     Function operand.
/// 
///     Function is an OpFunction instruction.  This could be a forward
///     reference.
/// 
///     Argument N is the object to copy to parameter N of Function.
/// 
///     Note: A forward call is possible because there is no missing type
///     information: Result Type must match the Return Type of the function, and
///     the calling argument types must match the formal parameter types.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.FunctionCall @f_void(%arg0) : (i32) ->  ()
///     %0 = spirv.FunctionCall @f_iadd(%arg0, %arg1) : (i32, i32) -> i32
///     ```
class FunctionCallOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Arc Cosine of operand in radians
/// The standard trigonometric arc cosine of x radians.
/// 
///     Result is an angle, in radians, whose cosine is x. The range of result
///     values is [0, π]. Result is undefined if abs x > 1.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Acos %0 : f32
///     %3 = spirv.GL.Acos %1 : vector<3xf16>
///     ```
class GLAcosOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Arc hyperbolic cosine of operand in radians.
/// Arc hyperbolic cosine; result is the non-negative inverse of cosh. The resulting
///     value is NaN if x < 1.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Acosh %0 : f32
///     %3 = spirv.GL.Acosh %1 : vector<3xf16>
///     ```
class GLAcoshOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Arc Sine of operand in radians
/// The standard trigonometric arc sine of x radians.
/// 
///     Result is an angle, in radians, whose sine is x. The range of result values
///     is [-π / 2, π / 2]. Result is undefined if abs x > 1.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Asin %0 : f32
///     %3 = spirv.GL.Asin %1 : vector<3xf16>
///     ```
class GLAsinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Arc hyperbolic sine of operand in radians.
/// Arc hyperbolic sine; result is the inverse of sinh.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Asinh %0 : f32
///     %3 = spirv.GL.Asinh %1 : vector<3xf16>
///     ```
class GLAsinhOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Arc Tangent of operand in radians
/// The standard trigonometric arc tangent of x radians.
/// 
///     Result is an angle, in radians, whose tangent is y_over_x. The range of
///     result values is [-π / 2, π / 2].
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Atan %0 : f32
///     %3 = spirv.GL.Atan %1 : vector<3xf16>
///     ```
class GLAtanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Arc hyperbolic tangent of operand in radians.
/// Arc hyperbolic tangent; result is the inverse of tanh. The resulting value
///     is NaN if abs x ≥ 1.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Atanh %0 : f32
///     %3 = spirv.GL.Atanh %1 : vector<3xf16>
///     ```
class GLAtanhOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Rounds up to the next whole number
/// Result is the value equal to the nearest whole number that is greater than
///     or equal to x.
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Ceil %0 : f32
///     %3 = spirv.GL.Ceil %1 : vector<3xf16>
///     ```
class GLCeilOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Cosine of operand in radians
/// The standard trigonometric cosine of x radians.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Cos %0 : f32
///     %3 = spirv.GL.Cos %1 : vector<3xf16>
///     ```
class GLCosOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Hyperbolic cosine of operand in radians
/// Hyperbolic cosine of x radians.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Cosh %0 : f32
///     %3 = spirv.GL.Cosh %1 : vector<3xf16>
///     ```
class GLCoshOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return the cross product of two 3-component vectors
/// Result is the cross product of x and y, i.e., the resulting components are, in order:
/// 
///     x[1] * y[2] - y[1] * x[2]
/// 
///     x[2] * y[0] - y[2] * x[0]
/// 
///     x[0] * y[1] - y[0] * x[1]
/// 
///     All the operands must be vectors of 3 components of a floating-point type.
/// 
///     Result Type and the type of all operands must be the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Cross %0, %1 : vector<3xf32>
///     %3 = spirv.GL.Cross %0, %1 : vector<3xf16>
///     ```
class GLCrossOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return distance between two points
/// Result is the distance between p0 and p1, i.e., length(p0 - p1).
/// 
///     The operands must all be a scalar or vector whose component type is floating-point.
/// 
///     Result Type must be a scalar of the same type as the component type of the operands.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Distance %0, %1 : vector<3xf32>, vector<3xf32> -> f32
///     ```
class GLDistanceOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is 2 raised to the x power
/// Result is 2 raised to the x power; 2**x.
/// 
///     ```
///     exp2(Inf) = Inf.
///     exp2(-Inf) = +0.
///     ```
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Exp2 %0 : f32
///     %3 = spirv.GL.Exp2 %1 : vector<3xf16>
///     ```
class GLExp2Op;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Exponentiation of Operand 1
/// Result is the natural exponentiation of x; e^x.
/// 
///     The operand x must be a scalar or vector whose component type is
///     16-bit or 32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are
///     computed per component.";
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Exp %0 : f32
///     %3 = spirv.GL.Exp %1 : vector<3xf16>
///     ```
class GLExpOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Absolute value of operand
/// Result is x if x >= 0; otherwise result is -x.
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.FAbs %0 : f32
///     %3 = spirv.GL.FAbs %1 : vector<3xf16>
///     ```
class GLFAbsOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Clamp x between min and max values.
/// Result is min(max(x, minVal), maxVal). The resulting value is undefined if
///     minVal > maxVal. The semantics used by min() and max() are those of FMin and
///     FMax.
/// 
///     The operands must all be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of all operands must be the same type. Results are
///     computed per component.
/// 
///     <!-- End of AutoGen section -->
///     ```
///     fclamp-op ::= ssa-id `=` `spirv.GL.FClamp` ssa-use, ssa-use, ssa-use `:`
///                float-scalar-vector-type
///     ```
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.FClamp %x, %min, %max : f32
///     %3 = spirv.GL.FClamp %x, %min, %max : vector<3xf16>
///     ```
class GLFClampOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return maximum of two floating-point operands
/// Result is y if x < y; otherwise result is x. Which operand is the
///     result is undefined if one of the operands is a NaN.
/// 
///     The operands must all be a scalar or vector whose component type
///     is floating-point.
/// 
///     Result Type and the type of all operands must be the same
///     type. Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.FMax %0, %1 : f32
///     %3 = spirv.GL.FMax %0, %1 : vector<3xf16>
///     ```
class GLFMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return minimum of two floating-point operands
/// Result is y if y < x; otherwise result is x. Which operand is the result is
///     undefined if one of the operands is a NaN.
/// 
///     The operands must all be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of all operands must be the same type. Results are
///     computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.FMin %0, %1 : f32
///     %3 = spirv.GL.FMin %0, %1 : vector<3xf16>
///     ```
class GLFMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Builds the linear blend of x and y
/// Result is the linear blend of x and y, i.e., x * (1 - a) + y * a.
/// 
///     The operands must all be a scalar or vector whose component type is floating-point.
/// 
///     Result Type and the type of all operands must be the same type. Results are computed per component.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GL.FMix %x : f32, %y : f32, %a : f32 -> f32
///     %0 = spirv.GL.FMix %x : vector<4xf32>, %y : vector<4xf32>, %a : vector<4xf32> -> vector<4xf32>
///     ```
class GLFMixOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Returns the sign of the operand
/// Result is 1.0 if x > 0, 0.0 if x = 0, or -1.0 if x < 0.
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.FSign %0 : f32
///     %3 = spirv.GL.FSign %1 : vector<3xf16>
///     ```
class GLFSignOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Integer least-significant bit
/// Results in the bit number of the least-significant 1-bit in the binary
///     representation of Value. If Value is 0, the result is -1.
/// 
///     Result Type and the type of Value must both be integer scalar or
///     integer vector types. Result Type and operand types must have the
///     same number of components with the same component width. Results are
///     computed per component.
class GLFindILsbOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed-integer most-significant bit, with Value interpreted as a signed integer
/// For positive numbers, the result will be the bit number of the most significant
///     1-bit. For negative numbers, the result will be the bit number of the most
///     significant 0-bit. For a Value of 0 or -1, the result is -1.
/// 
///     Result Type and the type of Value must both be integer scalar or
///     integer vector types. Result Type and operand types must have the
///     same number of components with the same component width. Results are
///     computed per component.
/// 
///     This instruction is currently limited to 32-bit width components.
class GLFindSMsbOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned-integer most-significant bit
/// Results in the bit number of the most-significant 1-bit in the binary
///     representation of Value. If Value is 0, the result is -1.
/// 
///     Result Type and the type of Value must both be integer scalar or
///     integer vector types. Result Type and operand types must have the
///     same number of components with the same component width. Results are
///     computed per component.
/// 
///     This instruction is currently limited to 32-bit width components.
class GLFindUMsbOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Rounds down to the next whole number
/// Result is the value equal to the nearest whole number that is less than or
///     equal to x.
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Floor %0 : f32
///     %3 = spirv.GL.Floor %1 : vector<3xf16>
///     ```
class GLFloorOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Computes a * b + c.
/// In uses where this operation is decorated with NoContraction:
/// 
///     - fma is considered a single operation, whereas the expression a * b + c
///       is considered two operations.
///     - The precision of fma can differ from the precision of the expression
///       a * b + c.
///     - fma will be computed with the same precision as any other fma decorated
///       with NoContraction, giving invariant results for the same input values
///       of a, b, and c.
/// 
///     Otherwise, in the absence of a NoContraction decoration, there are no
///     special constraints on the number of operations or difference in precision
///     between fma and the expression a * b +c.
/// 
///     The operands must all be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of all operands must be the same type. Results
///     are computed per component.
/// 
///     <!-- End of AutoGen section -->
///     ```
///     fma-op ::= ssa-id `=` `spirv.GL.Fma` ssa-use, ssa-use, ssa-use `:`
///                float-scalar-vector-type
///     ```
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GL.Fma %a, %b, %c : f32
///     %1 = spirv.GL.Fma %a, %b, %c : vector<3xf16>
///     ```
class GLFmaOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Returns the `x - floor(x)` of the operand
/// Result is:
/// 
///     ```
///     fract(x) = x - floor(x)
///     fract(±0) = +0
///     fract(±Inf) = NaN
///     ```
/// 
///     The operand x must be a scalar or vector whose component type is floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %result = spirv.GL.Sqrt %x : f32
///     %result = spirv.GL.Sqrt %x : vector<3xf16>
///     ```
class GLFractOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Splits x into two components such that x = significand * 2^exponent
/// Result is a structure containing x split into a floating-point significand
///     in the range (-1.0, 0.5] or [0.5, 1.0) and an integral exponent of 2, such that:
/// 
///     x = significand * 2^exponent
/// 
///     If x is a zero, the exponent is 0.0. If x is an infinity or a NaN, the
///     exponent is undefined. If x is 0.0, the significand is 0.0. If x is -0.0,
///     the significand is -0.0
/// 
///     Result Type must be an OpTypeStruct with two members. Member 0 must have
///     the same type as the type of x. Member 0 holds the significand. Member 1
///     must be a scalar or vector with integer component type, with 32-bit
///     component width. Member 1 holds the exponent. These two members and x must
///     have the same number of components.
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.FrexpStruct %0 : f32 -> !spirv.struct<f32, i32>
///     %3 = spirv.GL.FrexpStruct %0 : vector<3xf32> -> !spirv.struct<vector<3xf32>, vector<3xi32>>
///     ```
class GLFrexpStructOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Reciprocal of sqrt(operand)
/// Result is the reciprocal of sqrt x. Result is undefined if x <= 0.
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.InverseSqrt %0 : f32
///     %3 = spirv.GL.InverseSqrt %1 : vector<3xf16>
///     ```
class GLInverseSqrtOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Builds y such that y = significand * 2^exponent
/// Builds a floating-point number from x and the corresponding
///     integral exponent of two in exp:
/// 
///     significand * 2^exponent
/// 
///     If this product is too large to be represented in the floating-point
///     type, the resulting value is undefined. If exp is greater than +128
///     (single precision) or +1024 (double precision), the resulting value is
///     undefined. If exp is less than -126 (single precision) or -1022 (double precision),
///     the result may be flushed to zero. Additionally, splitting the value
///     into a significand and exponent using frexp and then reconstructing a
///     floating-point value using ldexp should yield the original input for
///     zero and all finite non-denormalized values.
/// 
///     The operand x must be a scalar or vector whose component type is floating-point.
/// 
///     The exp operand must be a scalar or vector with integer component type.
///     The number of components in x and exp must be the same.
/// 
///     Result Type must be the same type as the type of x. Results are computed per
///     component.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %y = spirv.GL.Ldexp %x : f32, %exp : i32 -> f32
///     %y = spirv.GL.Ldexp %x : vector<3xf32>, %exp : vector<3xi32> -> vector<3xf32>
///     ```
class GLLdexpOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return the length of a vector x
/// Result is the length of vector x, i.e., sqrt(x[0]**2 + x[1]**2 + ...).
/// 
///     The operand x must be a scalar or vector whose component type is floating-point.
/// 
///     Result Type must be a scalar of the same type as the component type of x.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Length %0 : vector<3xf32> -> f32
///     %3 = spirv.GL.Length %1 : f32 -> f32
///     ```
class GLLengthOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the base-2 logarithm of x
/// Result is the base-2 logarithm of x, i.e., the value y which satisfies the
///     equation x = 2**y. The resulting value is NaN if x < 0. Moreover:
/// 
///     ```
///     log(Inf) = Inf
///     log(1.0) = +0
///     log(±0) = -Inf
///     ```
///     
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
///     
///     ```mlir
///     %2 = spirv.GL.Log2 %0 : f32
///     %3 = spirv.GL.Log2 %1 : vector<3xf16>
///     ```
class GLLog2Op;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Natural logarithm of the operand
/// Result is the natural logarithm of x, i.e., the value y which satisfies the
///     equation x = ey. Result is undefined if x <= 0.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Log %0 : f32
///     %3 = spirv.GL.Log %1 : vector<3xf16>
///     ```
class GLLogOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Normalizes a vector operand
/// Result is the vector in the same direction as x but with a length of 1.
/// 
///     The operand x must be a scalar or vector whose component type is floating-point.
/// 
///     Result Type and the type of x must be the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Normalize %0 : vector<3xf32>
///     %3 = spirv.GL.Normalize %1 : vector<4xf16>
///     ```
class GLNormalizeOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Pack two-component vector of 32-bit floats into a 32-bit integer
/// Result is the unsigned integer obtained by converting the components of a
///     two-component floating-point vector to the 16-bit OpTypeFloat, and then packing
///     these two 16-bit integers into a 32-bit unsigned integer. The first vector
///     component specifies the 16 least-significant bits of the result; the second
///     component specifies the 16 most-significant bits.
/// 
///     The RelaxedPrecision Decoration only affects the conversion step of the instruction.
/// 
///     The v operand must be a vector of 2 components whose type is a 32-bit floating-point.
/// 
///     Result Type must be a 32-bit integer type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.GL.PackHalf2x16 %0 : vector<2xf32> -> i32
///     ```
class GLPackHalf2x16Op;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return x raised to the y power of two operands
/// Result is x raised to the y power; x^y.
/// 
///     Result is undefined if x = 0 and y ≤ 0.
/// 
///     The operand x and y must be a scalar or vector whose component type is
///     16-bit or 32-bit floating-point.
/// 
///     Result Type and the type of all operands must be the same type. Results are
///     computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Pow %0, %1 : f32
///     %3 = spirv.GL.Pow %0, %1 : vector<3xf16>
///     ```
class GLPowOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Calculate reflection direction vector
/// For the incident vector I and surface orientation N, the result is the reflection direction:
/// 
///     I - 2 * dot(N, I) * N
/// 
///     N must already be normalized in order to achieve the desired result.
/// 
///     The operands must all be a scalar or vector whose component type is floating-point.
/// 
///     Result Type and the type of all operands must be the same type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Reflect %0, %1 : f32
///     %3 = spirv.GL.Reflect %0, %1 : vector<3xf32>
///     ```
class GLReflectOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Rounds to the nearest even whole number
/// Result is the value equal to the nearest whole number to x. A fractional
///     part of 0.5 will round toward the nearest even whole number. (Both 3.5 and
///     4.5 for x will be 4.0.)
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.RoundEven %0 : f32
///     %3 = spirv.GL.RoundEven %1 : vector<3xf16>
///     ```
class GLRoundEvenOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Rounds to the nearest whole number
/// Result is the value equal to the nearest whole number to x. The fraction
///     0.5 will round in a direction chosen by the implementation, presumably
///     the direction that is fastest. This includes the possibility that
///     Round x is the same value as RoundEven x for all values of x.
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Round %0 : f32
///     %3 = spirv.GL.Round %1 : vector<3xf16>
///     ```
class GLRoundOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Absolute value of operand
/// Result is x if x ≥ 0; otherwise result is -x, where x is interpreted as a
///     signed integer.
/// 
///     Result Type and the type of x must both be integer scalar or integer vector
///     types. Result Type and operand types must have the same number of components
///     with the same component width. Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.SAbs %0 : i32
///     %3 = spirv.GL.SAbs %1 : vector<3xi16>
///     ```
class GLSAbsOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Clamp x between min and max values.
/// Result is min(max(x, minVal), maxVal), where x, minVal and maxVal are
///     interpreted as signed integers. The resulting value is undefined if
///     minVal > maxVal.
/// 
///     Result Type and the type of the operands must both be integer scalar or
///     integer vector types. Result Type and operand types must have the same number
///     of components with the same component width. Results are computed per
///     component.
/// 
///     <!-- End of AutoGen section -->
///     ```
///     uclamp-op ::= ssa-id `=` `spirv.GL.UClamp` ssa-use, ssa-use, ssa-use `:`
///                sgined-scalar-vector-type
///     ```
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.SClamp %x, %min, %max : si32
///     %3 = spirv.GL.SClamp %x, %min, %max : vector<3xsi16>
///     ```
class GLSClampOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return maximum of two signed integer operands
/// Result is y if x < y; otherwise result is x, where x and y are interpreted
///     as signed integers.
/// 
///     Result Type and the type of x and y must both be integer scalar or integer
///     vector types. Result Type and operand types must have the same number of
///     components with the same component width. Results are computed per
///     component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.SMax %0, %1 : i32
///     %3 = spirv.GL.SMax %0, %1 : vector<3xi16>
///     ```
class GLSMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return minimum of two signed integer operands
/// Result is y if y < x; otherwise result is x, where x and y are interpreted
///     as signed integers.
/// 
///     Result Type and the type of x and y must both be integer scalar or integer
///     vector types. Result Type and operand types must have the same number of
///     components with the same component width. Results are computed per
///     component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.SMin %0, %1 : i32
///     %3 = spirv.GL.SMin %0, %1 : vector<3xi16>
///     ```
class GLSMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Returns the sign of the operand
/// Result is 1 if x > 0, 0 if x = 0, or -1 if x < 0, where x is interpreted as
///     a signed integer.
/// 
///     Result Type and the type of x must both be integer scalar or integer vector
///     types. Result Type and operand types must have the same number of components
///     with the same component width. Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.SSign %0 : i32
///     %3 = spirv.GL.SSign %1 : vector<3xi16>
///     ```
class GLSSignOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Sine of operand in radians
/// The standard trigonometric sine of x radians.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Sin %0 : f32
///     %3 = spirv.GL.Sin %1 : vector<3xf16>
///     ```
class GLSinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Hyperbolic sine of operand in radians
/// Hyperbolic sine of x radians.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Sinh %0 : f32
///     %3 = spirv.GL.Sinh %1 : vector<3xf16>
///     ```
class GLSinhOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Returns the square root of the operand
/// Result is the square root of x. Result is undefined if x < 0.
/// 
///     The operand x must be a scalar or vector whose component type is
///     floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Sqrt %0 : f32
///     %3 = spirv.GL.Sqrt %1 : vector<3xf16>
///     ```
class GLSqrtOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Tangent of operand in radians
/// The standard trigonometric tangent of x radians.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Tan %0 : f32
///     %3 = spirv.GL.Tan %1 : vector<3xf16>
///     ```
class GLTanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Hyperbolic tangent of operand in radians
/// Hyperbolic tangent of x radians.
/// 
///     The operand x must be a scalar or vector whose component type is 16-bit or
///     32-bit floating-point.
/// 
///     Result Type and the type of x must be the same type. Results are computed
///     per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.Tanh %0 : f32
///     %3 = spirv.GL.Tanh %1 : vector<3xf16>
///     ```
class GLTanhOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Clamp x between min and max values.
/// Result is min(max(x, minVal), maxVal), where x, minVal and maxVal are
///     interpreted as unsigned integers. The resulting value is undefined if
///     minVal > maxVal.
/// 
///     Result Type and the type of the operands must both be integer scalar or
///     integer vector types. Result Type and operand types must have the same number
///     of components with the same component width. Results are computed per
///     component.
/// 
///     <!-- End of AutoGen section -->
///     ```
///     uclamp-op ::= ssa-id `=` `spirv.GL.UClamp` ssa-use, ssa-use, ssa-use `:`
///                unsigned-signless-scalar-vector-type
///     ```
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.UClamp %x, %min, %max : i32
///     %3 = spirv.GL.UClamp %x, %min, %max : vector<3xui16>
///     ```
class GLUClampOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return maximum of two unsigned integer operands
/// Result is y if x < y; otherwise result is x, where x and y are interpreted
///     as unsigned integers.
/// 
///     Result Type and the type of x and y must both be integer scalar or integer
///     vector types. Result Type and operand types must have the same number of
///     components with the same component width. Results are computed per
///     component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.UMax %0, %1 : i32
///     %3 = spirv.GL.UMax %0, %1 : vector<3xi16>
///     ```
class GLUMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return minimum of two unsigned integer operands
/// Result is y if y < x; otherwise result is x, where x and y are interpreted
///     as unsigned integers.
/// 
///     Result Type and the type of x and y must both be integer scalar or integer
///     vector types. Result Type and operand types must have the same number of
///     components with the same component width. Results are computed per
///     component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.GL.UMin %0, %1 : i32
///     %3 = spirv.GL.UMin %0, %1 : vector<3xi16>
///     ```
class GLUMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unpack 32-bit integer into two-component vector of 32-bit floats
/// Result is the two-component floating-point vector with components obtained by
///     unpacking a 32-bit unsigned integer into a pair of 16-bit values, interpreting
///     those values as 16-bit floating-point numbers according to the OpenGL
///     Specification, and converting them to 32-bit floating-point values. Subnormal
///     numbers are either preserved or flushed to zero, consistently within an
///     implementation.
/// 
///     The first component of the vector is obtained from the 16 least-significant bits
///     of v; the second component is obtained from the 16 most-significant bits of v.
/// 
///     The RelaxedPrecision Decoration only affects the conversion step of the instruction.
/// 
///     The v operand must be a scalar with 32-bit integer type.
/// 
///     Result Type must be a vector of 2 components whose type is 32-bit floating point.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.GL.UnpackHalf2x16 %0 : i32 -> vector<2xf32>
///     ```
class GLUnpackHalf2x16Op;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Attempts to explicitly convert Pointer to Storage storage-class pointer
///     value.
/// Result Type must be an OpTypePointer. Its Storage Class must be Storage.
/// 
///     Pointer must have a type of OpTypePointer whose Type is the same as the
///     Type of Result Type.Pointer must point to the Generic Storage Class. If
///     the cast fails, the instruction result is an OpConstantNull pointer in
///     the Storage Storage Class.
/// 
///     Storage must be one of the following literal values from Storage Class:
///     Workgroup, CrossWorkgroup, or Function.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///        %1 = spirv.GenericCastToPtrExplicitOp %0 : !spirv.ptr<f32, Generic> to
///        !spirv.ptr<f32, CrossWorkGroup>
///     ```
class GenericCastToPtrExplicitOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert a pointer’s Storage Class to a non-Generic class.
/// Result Type must be an OpTypePointer. Its Storage Class must be
///     Workgroup, CrossWorkgroup, or Function.
/// 
///     Pointer must point to the Generic Storage Class.
/// 
///     Result Type and Pointer must point to the same type.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///        %1 = spirv.GenericCastToPtrOp %0 : !spirv.ptr<f32, Generic> to
///        !spirv.ptr<f32, CrossWorkGroup>
///     ```
class GenericCastToPtrOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Allocate an object in memory at module scope. The object is
///     referenced using a symbol name.
/// The variable type must be an OpTypePointer. Its type operand is the type of
///     object in memory.
/// 
///     Storage Class is the Storage Class of the memory holding the object. It
///     cannot be Generic. It must be the same as the Storage Class operand of
///     the variable types. Only those storage classes that are valid at module
///     scope (like Input, Output, StorageBuffer, etc.) are valid.
/// 
///     Initializer is optional.  If Initializer is present, it will be
///     the initial value of the variable’s memory content. Initializer
///     must be an symbol defined from a constant instruction or other
///     `spirv.GlobalVariable` operation in module scope. Initializer must
///     have the same type as the type of the defined symbol.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     variable-op ::= `spirv.GlobalVariable` spirv-type symbol-ref-id
///                     (`initializer(` symbol-ref-id `)`)?
///                     (`bind(` integer-literal, integer-literal `)`)?
///                     (`built_in(` string-literal `)`)?
///                     attribute-dict?
///     ```
/// 
///     where `initializer` specifies initializer and `bind` specifies the
///     descriptor set and binding number. `built_in` specifies SPIR-V
///     BuiltIn decoration associated with the op.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.GlobalVariable @var0 : !spirv.ptr<f32, Input> @var0
///     spirv.GlobalVariable @var1 initializer(@var0) : !spirv.ptr<f32, Output>
///     spirv.GlobalVariable @var2 bind(1, 2) : !spirv.ptr<f32, Uniform>
///     spirv.GlobalVariable @var3 built_in("GlobalInvocationId") : !spirv.ptr<vector<3xi32>, Input>
///     ```
class GlobalVariableOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Broadcast the Value of the invocation identified by the local id LocalId
///     to the result of all invocations in the group.
/// All invocations of this module within Execution must reach this point of
///     execution.
/// 
///     Behavior is undefined if this instruction is used in control flow that
///     is non-uniform within Execution.
/// 
///     Result Type  must be a scalar or vector of floating-point type, integer
///     type, or Boolean type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     LocalId must be an integer datatype. It can be a scalar, or a vector
///     with 2 components or a vector with 3 components. LocalId must be the
///     same for all invocations in the group.
/// 
///     #### Example:
/// 
///     ```mlir
///     %scalar_value = ... : f32
///     %vector_value = ... : vector<4xf32>
///     %scalar_localid = ... : i32
///     %vector_localid = ... : vector<3xi32>
///     %0 = spirv.GroupBroadcast "Subgroup" %scalar_value, %scalar_localid : f32, i32
///     %1 = spirv.GroupBroadcast "Workgroup" %vector_value, %vector_localid :
///       vector<4xf32>, vector<3xi32>
///     ```
class GroupBroadcastOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A floating-point add group operation specified for all values of X
///     specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     Execution reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within Execution execute
///     the same dynamic instance of this instruction.
/// 
///     Result Type  must be a scalar or vector of floating-point type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is 0.
/// 
///     The type of X must be the same as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupFAdd <Workgroup> <Reduce> %value : f32
///     ```
class GroupFAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A floating-point maximum group operation specified for all values of X
///     specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     Execution reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within Execution execute
///     the same dynamic instance of this instruction.
/// 
///     Result Type  must be a scalar or vector of floating-point type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is -INF.
/// 
///     The type of X must be the same as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupFMax <Workgroup> <Reduce> %value : f32
///     ```
class GroupFMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A floating-point minimum group operation specified for all values of X
///     specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     Execution reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within Execution execute
///     the same dynamic instance of this instruction.
/// 
///     Result Type  must be a scalar or vector of floating-point type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is +INF.
/// 
///     The type of X must be the same as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupFMin <Workgroup> <Reduce> %value : f32
///     ```
class GroupFMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A floating-point multiplication group operation specified for all values of
///     'X' specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     'Execution' reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within 'Execution' execute the
///     same dynamic instance of this instruction.
/// 
///     'Result Type' must be a scalar or vector of floating-point type.
/// 
///     'Execution' is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for 'Operation' is 1.
/// 
///     The type of 'X' must be the same as 'Result Type'.
/// 
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.KHR.GroupFMul <Workgroup> <Reduce> %value : f32
///     ```
class GroupFMulKHROp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// An integer add group operation specified for all values of X specified
///     by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     Execution reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within Execution execute
///     the same dynamic instance of this instruction.
/// 
///     Result Type  must be a scalar or vector of integer type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is 0.
/// 
///     The type of X must be the same as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupIAdd <Workgroup> <Reduce> %value : i32
///     ```
class GroupIAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// An integer multiplication group operation specified for all values of 'X'
///     specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     'Execution' reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within 'Execution' execute the
///     same dynamic instance of this instruction.
/// 
///     'Result Type' must be a scalar or vector of integer type.
/// 
///     'Execution' is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for 'Operation' is 1.
/// 
///     The type of 'X' must be the same as 'Result Type'.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.KHR.GroupIMul <Workgroup> <Reduce> %value : i32
///     ```
class GroupIMulKHROp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Evaluates a value for all tangled invocations within the Execution
///     scope. The result is true if Value is equal for all tangled invocations
///     within the Execution scope. Otherwise, the result is false.
/// Result Type must be a Boolean type.
/// 
///     Execution is the scope defining the scope restricted tangle affected by
///     this command. It must be Subgroup.
/// 
///     Value must be a scalar or vector of floating-point type, integer type,
///     or Boolean type. The compare operation is based on this type, and if it
///     is a floating-point type, an ordered-and-equal compare is used.
/// 
///     An invocation will not execute a dynamic instance of this instruction
///     (X') until all invocations in its scope restricted tangle have executed
///     all dynamic instances that are program-ordered before X'.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %scalar_value = ... : f32
///     %vector_value = ... : vector<4xf32>
///     %0 = spirv.GroupNonUniformAllEqual <Subgroup> %scalar_value : f32, i1
///     %1 = spirv.GroupNonUniformAllEqual <Subgroup> %vector_value : vector<4xf32>, i1
///     ```
class GroupNonUniformAllEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Evaluates a predicate for all tangled invocations within the Execution
///     scope, resulting in true if predicate evaluates to true for all tangled
///     invocations within the Execution scope, otherwise the result is false.
/// Result Type must be a Boolean type.
/// 
///     Execution is the scope defining the scope restricted tangle affected by
///     this command. It must be Subgroup.
/// 
///     Predicate must be a Boolean type.
/// 
///     An invocation will not execute a dynamic instance of this instruction
///     (X') until all invocations in its scope restricted tangle have executed
///     all dynamic instances that are program-ordered before X'.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %predicate = ... : i1
///     %0 = spirv.GroupNonUniformAll "Subgroup" %predicate : i1
///     ```
class GroupNonUniformAllOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Evaluates a predicate for all tangled invocations within the Execution
///     scope, resulting in true if predicate evaluates to true for any tangled
///     invocations within the Execution scope, otherwise the result is false.
/// Result Type must be a Boolean type.
/// 
///     Execution is the scope defining the scope restricted tangle affected by
///     this command. It must be Subgroup.
/// 
///     Predicate must be a Boolean type.
/// 
///     An invocation will not execute a dynamic instance of this instruction
///     (X') until all invocations in its scope restricted tangle have executed
///     all dynamic instances that are program-ordered before X'.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %predicate = ... : i1
///     %0 = spirv.GroupNonUniformAny "Subgroup" %predicate : i1
///     ```
class GroupNonUniformAnyOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the number of bits that are set to 1 in Value, considering
///     only the bits in Value required to represent all bits of the scope
///     restricted tangle.
/// Result Type must be a scalar of integer type, whose Signedness operand
///     is 0.
/// 
///     Execution is the scope defining the scope restricted tangle affected by
///     this command. It must be Subgroup.
/// 
///     The identity I for Operation is 0.
/// 
///     Value must be a vector of four components of integer type scalar, whose
///     Width operand is 32 and whose Signedness operand is 0.
/// 
///     Value is a set of bitfields where the first invocation is represented in
///     the lowest bit of the first vector component and the last (up to the
///     size of the scope) is the higher bit number of the last bitmask needed
///     to represent all bits of the invocations in the scope restricted tangle.
/// 
///     An invocation will not execute a dynamic instance of this instruction
///     (X') until all invocations in its scope restricted tangle have executed
///     all dynamic instances that are program-ordered before X'.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %count = spirv.GroupNonUniformBallotBitCount <Subgroup> <Reduce> %val : vector<4xi32> -> i32
///     ```
class GroupNonUniformBallotBitCountOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Find the least significant bit set to 1 in Value, considering only the
///     bits in Value required to represent all bits of the group's invocations.
///     If none of the considered bits is set to 1, the resulting value is
///     undefined.
/// Result Type must be a scalar of integer type, whose Signedness operand
///     is 0.
/// 
///     Execution is a Scope that identifies the group of invocations affected
///     by this command. It must be Subgroup.
/// 
///     Value must be a vector of four components of integer type scalar, whose
///     Width operand is 32 and whose Signedness operand is 0.
/// 
///     Value is a set of bitfields where the first invocation is represented in
///     the lowest bit of the first vector component and the last (up to the
///     size of the group) is the higher bit number of the last bitmask needed
///     to represent all bits of the group invocations.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformBallotFindLSB <Subgroup> %vector : vector<4xi32>, i32
///     ```
class GroupNonUniformBallotFindLSBOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Find the most significant bit set to 1 in Value, considering only the
///     bits in Value required to represent all bits of the group's invocations.
///     If none of the considered bits is set to 1, the resulting value is
///     undefined.
/// Result Type must be a scalar of integer type, whose Signedness operand
///     is 0.
/// 
///     Execution is a Scope that identifies the group of invocations affected
///     by this command. It must be Subgroup.
/// 
///     Value must be a vector of four components of integer type scalar, whose
///     Width operand is 32 and whose Signedness operand is 0.
/// 
///     Value is a set of bitfields where the first invocation is represented in
///     the lowest bit of the first vector component and the last (up to the
///     size of the group) is the higher bit number of the last bitmask needed
///     to represent all bits of the group invocations.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformBallotFindMSB <Subgroup> %vector : vector<4xi32>, i32
///     ```
class GroupNonUniformBallotFindMSBOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is a bitfield value combining the Predicate value from all
///     invocations in the group that execute the same dynamic instance of this
///     instruction. The bit is set to one if the corresponding invocation is
///     active and the Predicate for that invocation evaluated to true;
///     otherwise, it is set to zero.
/// Result Type  must be a vector of four components of integer type scalar,
///     whose Signedness operand is 0.
/// 
///     Result is a set of bitfields where the first invocation is represented
///     in the lowest bit of the first vector component and the last (up to the
///     size of the group) is the higher bit number of the last bitmask needed
///     to represent all bits of the group invocations.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     Predicate must be a Boolean type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupNonUniformBallot <Subgroup> %predicate : vector<4xi32>
///     ```
class GroupNonUniformBallotOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A bitwise `and` group operation of all Value operands contributed by active
///     invocations in the group.
/// Result Type must be a scalar or vector of integer type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is ~0. If Operation is ClusteredReduce,
///     ClusterSize must be present.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformBitwiseAnd <Workgroup> <Reduce> %scalar : i32 -> i32
///     %1 = spirv.GroupNonUniformBitwiseAnd <Subgroup> <ClusteredReduce>
///            %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformBitwiseAndOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A bitwise `or` group operation of all Value operands contributed by active
///     invocations in the group.
/// Result Type must be a scalar or vector of integer type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is 0. If Operation is ClusteredReduce,
///     ClusterSize must be present.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformBitwiseOr <Workgroup> <Reduce> %scalar : i32 -> i32
///     %1 = spirv.GroupNonUniformBitwiseOr <Subgroup> <ClusteredReduce>
///            %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformBitwiseOrOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A bitwise `xor` group operation of all Value operands contributed by active
///     invocations in the group.
/// Result Type must be a scalar or vector of integer type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is 0. If Operation is ClusteredReduce,
///     ClusterSize must be present.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformBitwiseXor <Workgroup> <Reduce> %scalar : i32 -> i32
///     %1 = spirv.GroupNonUniformBitwiseXor <Subgroup> <ClusteredReduce>
///            %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformBitwiseXorOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the Value of the invocation identified by the id Id to all
///     active invocations in the group.
/// Result Type  must be a scalar or vector of floating-point type, integer
///     type, or Boolean type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     Id  must be a scalar of integer type, whose Signedness operand is 0.
/// 
///     Before version 1.5, Id must come from a constant instruction. Starting
///     with version 1.5, Id must be dynamically uniform.
/// 
///     The resulting value is undefined if Id is an inactive invocation, or is
///     greater than or equal to the size of the group.
/// 
///     #### Example:
/// 
///     ```mlir
///     %scalar_value = ... : f32
///     %vector_value = ... : vector<4xf32>
///     %id = ... : i32
///     %0 = spirv.GroupNonUniformBroadcast "Subgroup" %scalar_value, %id : f32, i32
///     %1 = spirv.GroupNonUniformBroadcast "Workgroup" %vector_value, %id :
///       vector<4xf32>, i32
///     ```
class GroupNonUniformBroadcastOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true only in the active invocation with the lowest id in the
///     group, otherwise result is false.
/// Result Type must be a Boolean type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupNonUniformElect : i1
///     ```
class GroupNonUniformElectOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A floating point add group operation of all Value operands contributed
///     by active invocations in the group.
/// Result Type  must be a scalar or vector of floating-point type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is 0. If Operation is ClusteredReduce,
///     ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.  The method used to
///     perform the group operation on the contributed Value(s) from active
///     invocations is implementation defined.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : f32
///     %vector = ... : vector<4xf32>
///     %0 = spirv.GroupNonUniformFAdd <Workgroup> <Reduce> %scalar : f32 -> f32
///     %1 = spirv.GroupNonUniformFAdd <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xf32>, i32 -> vector<4xf32>
///     ```
class GroupNonUniformFAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A floating point maximum group operation of all Value operands
///     contributed by active invocations in by group.
/// Result Type  must be a scalar or vector of floating-point type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is -INF. If Operation is ClusteredReduce,
///     ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.  The method used to
///     perform the group operation on the contributed Value(s) from active
///     invocations is implementation defined. From the set of Value(s) provided
///     by active invocations within a subgroup, if for any two Values one of
///     them is a NaN, the other is chosen. If all Value(s) that are used by the
///     current invocation are NaN, then the result is an undefined value.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : f32
///     %vector = ... : vector<4xf32>
///     %0 = spirv.GroupNonUniformFMax <Workgroup> <Reduce> %scalar : f32 -> f32
///     %1 = spirv.GroupNonUniformFMax <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xf32>, i32 -> vector<4xf32>
///     ```
class GroupNonUniformFMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A floating point minimum group operation of all Value operands
///     contributed by active invocations in the group.
/// Result Type  must be a scalar or vector of floating-point type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is +INF. If Operation is ClusteredReduce,
///     ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.  The method used to
///     perform the group operation on the contributed Value(s) from active
///     invocations is implementation defined. From the set of Value(s) provided
///     by active invocations within a subgroup, if for any two Values one of
///     them is a NaN, the other is chosen. If all Value(s) that are used by the
///     current invocation are NaN, then the result is an undefined value.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : f32
///     %vector = ... : vector<4xf32>
///     %0 = spirv.GroupNonUniformFMin <Workgroup> <Reduce> %scalar : f32 -> i32
///     %1 = spirv.GroupNonUniformFMin <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xf32>, i32 -> vector<4xf32>
///     ```
class GroupNonUniformFMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A floating point multiply group operation of all Value operands
///     contributed by active invocations in the group.
/// Result Type  must be a scalar or vector of floating-point type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is 1. If Operation is ClusteredReduce,
///     ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.  The method used to
///     perform the group operation on the contributed Value(s) from active
///     invocations is implementation defined.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : f32
///     %vector = ... : vector<4xf32>
///     %0 = spirv.GroupNonUniformFMul <Workgroup> <Reduce> %scalar : f32 -> f32
///     %1 = spirv.GroupNonUniformFMul <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xf32>, i32 -> vector<4xf32>
///     ```
class GroupNonUniformFMulOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// An integer add group operation of all Value operands contributed by
///     active invocations in the group.
/// Result Type  must be a scalar or vector of integer type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is 0. If Operation is ClusteredReduce,
///     ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformIAdd <Workgroup> <Reduce> %scalar : i32 -> i32
///     %1 = spirv.GroupNonUniformIAdd <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformIAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// An integer multiply group operation of all Value operands contributed by
///     active invocations in the group.
/// Result Type  must be a scalar or vector of integer type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is 1. If Operation is ClusteredReduce,
///     ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformIMul <Workgroup> <Reduce> %scalar : i32 -> i32
///     %1 = spirv.GroupNonUniformIMul <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformIMulOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A logical `and` group operation of all Value operands contributed by active
///     invocations in the group.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is ~0. If Operation is ClusteredReduce,
///     ClusterSize must be present.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i1
///     %vector = ... : vector<4xi1>
///     %0 = spirv.GroupNonUniformLogicalAnd <Workgroup> <Reduce> %scalar : i1 -> i1
///     %1 = spirv.GroupNonUniformLogicalAnd <Subgroup> <ClusteredReduce>
///            %vector cluster_size(%four) : vector<4xi1>, i32 -> vector<4xi1>
///     ```
class GroupNonUniformLogicalAndOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A logical `or` group operation of all Value operands contributed by active
///     invocations in the group.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is 0. If Operation is ClusteredReduce,
///     ClusterSize must be present.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i1
///     %vector = ... : vector<4xi1>
///     %0 = spirv.GroupNonUniformLogicalOr <Workgroup> <Reduce> %scalar : i1 -> i1
///     %1 = spirv.GroupNonUniformLogicalOr <Subgroup> <ClusteredReduce>
///            %vector cluster_size(%four) : vector<4xi1>, i32 -> vector<4xi1>
///     ```
class GroupNonUniformLogicalOrOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A logical `xor` group operation of all Value operands contributed by active
///     invocations in the group.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is 0. If Operation is ClusteredReduce,
///     ClusterSize must be present.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i1
///     %vector = ... : vector<4xi1>
///     %0 = spirv.GroupNonUniformLogicalXor <Workgroup> <Reduce> %scalar : i1 -> i1
///     %1 = spirv.GroupNonUniformLogicalXor <Subgroup> <ClusteredReduce>
///            %vector cluster_size(%four) : vector<4xi1>, i32 -> vector<4xi1>
///     ```
class GroupNonUniformLogicalXorOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Rotate values across invocations within a subgroup.
/// Return the Value of the invocation whose id within the group is calculated
///     as follows:
/// 
///     LocalId = SubgroupLocalInvocationId if Execution is Subgroup or
///               LocalInvocationId if Execution is Workgroup
///     RotationGroupSize = ClusterSize when ClusterSize is present, otherwise
///     RotationGroupSize = SubgroupMaxSize if the Kernel capability is declared
///                         and SubgroupSize if not.
///     Invocation ID = ( (LocalId + Delta) & (RotationGroupSize - 1) ) +
///                     (LocalId & ~(RotationGroupSize - 1))
/// 
///     Result Type must be a scalar or vector of floating-point type, integer
///     type, or Boolean type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The type of Value must be the same as Result Type.
/// 
///     Delta must be a scalar of integer type, whose Signedness operand is 0.
///     Delta must be dynamically uniform within Execution.
/// 
///     Delta is treated as unsigned and the resulting value is undefined if the
///     selected lane is inactive.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar of
///     integer type, whose Signedness operand is 0. ClusterSize must come from a
///     constant instruction. Behavior is undefined unless ClusterSize is at least
///     1 and a power of 2. If ClusterSize is greater than the declared
///     SubGroupSize, executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %0 = spirv.GroupNonUniformRotateKHR <Subgroup> %value, %delta : f32, i32 -> f32
///     %1 = spirv.GroupNonUniformRotateKHR <Workgroup> %value, %delta,
///          clustersize(%four) : f32, i32, i32 -> f32
///     ```
class GroupNonUniformRotateKHROp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A signed integer maximum group operation of all Value operands
///     contributed by active invocations in the group.
/// Result Type  must be a scalar or vector of integer type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is INT_MIN. If Operation is
///     ClusteredReduce, ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformSMax <Workgroup> <Reduce> %scalar : i32
///     %1 = spirv.GroupNonUniformSMax <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformSMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A signed integer minimum group operation of all Value operands
///     contributed by active invocations in the group.
/// Result Type  must be a scalar or vector of integer type.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is INT_MAX. If Operation is
///     ClusteredReduce, ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformSMin <Workgroup> <Reduce> %scalar : i32 -> i32
///     %1 = spirv.GroupNonUniformSMin <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformSMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the Value of the invocation identified by the current
///     invocation’s id within the group + Delta.
/// Result Type  must be a scalar or vector of floating-point type, integer
///     type, or Boolean type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     Delta  must be a scalar of integer type, whose Signedness operand is 0.
/// 
///     Delta is treated as unsigned and the resulting value is undefined if
///     Delta is greater than or equal to the size of the group, or if the
///     current invocation’s id within the group + Delta is either an inactive
///     invocation or greater than or equal to the size of the group.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupNonUniformShuffleDown <Subgroup> %val, %delta : f32, i32
///     ```
class GroupNonUniformShuffleDownOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the Value of the invocation identified by the id Id.
/// Result Type  must be a scalar or vector of floating-point type, integer
///     type, or Boolean type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     Id  must be a scalar of integer type, whose Signedness operand is 0.
/// 
///     The resulting value is undefined if Id is an inactive invocation, or is
///     greater than or equal to the size of the group.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupNonUniformShuffle <Subgroup> %val, %id : f32, i32
///     ```
class GroupNonUniformShuffleOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the Value of the invocation identified by the current
///     invocation’s id within the group - Delta.
/// Result Type  must be a scalar or vector of floating-point type, integer
///     type, or Boolean type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     Delta  must be a scalar of integer type, whose Signedness operand is 0.
/// 
///     Delta is treated as unsigned and the resulting value is undefined if
///     Delta is greater than the current invocation’s id within the group or if
///     the selected lane is inactive.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupNonUniformShuffleUp <Subgroup> %val, %delta : f32, i32
///     ```
class GroupNonUniformShuffleUpOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the Value of the invocation identified by the current
///     invocation’s id within the group xor’ed with Mask.
/// Result Type  must be a scalar or vector of floating-point type, integer
///     type, or Boolean type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     Mask  must be a scalar of integer type, whose Signedness operand is 0.
/// 
///     The resulting value is undefined if current invocation’s id within the
///     group xor’ed with Mask is an inactive invocation, or is greater than or
///     equal to the size of the group.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupNonUniformShuffleXor <Subgroup> %val, %mask : f32, i32
///     ```
class GroupNonUniformShuffleXorOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// An unsigned integer maximum group operation of all Value operands
///     contributed by active invocations in the group.
/// Result Type  must be a scalar or vector of integer type, whose
///     Signedness operand is 0.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is 0. If Operation is ClusteredReduce,
///     ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformUMax <Workgroup> <Reduce> %scalar : i32 -> i32
///     %1 = spirv.GroupNonUniformUMax <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformUMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// An unsigned integer minimum group operation of all Value operands
///     contributed by active invocations in the group.
/// Result Type  must be a scalar or vector of integer type, whose
///     Signedness operand is 0.
/// 
///     Execution must be Workgroup or Subgroup Scope.
/// 
///     The identity I for Operation is UINT_MAX. If Operation is
///     ClusteredReduce, ClusterSize must be specified.
/// 
///      The type of Value must be the same as Result Type.
/// 
///     ClusterSize is the size of cluster to use. ClusterSize must be a scalar
///     of integer type, whose Signedness operand is 0. ClusterSize must come
///     from a constant instruction. ClusterSize must be at least 1, and must be
///     a power of 2. If ClusterSize is greater than the declared SubGroupSize,
///     executing this instruction results in undefined behavior.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %four = spirv.Constant 4 : i32
///     %scalar = ... : i32
///     %vector = ... : vector<4xi32>
///     %0 = spirv.GroupNonUniformUMin <Workgroup> <Reduce> %scalar : i32 -> i32
///     %1 = spirv.GroupNonUniformUMin <Subgroup> <ClusteredReduce> %vector cluster_size(%four) : vector<4xi32>, i32 -> vector<4xi32>
///     ```
class GroupNonUniformUMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A signed integer maximum group operation specified for all values of X
///     specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     Execution reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within Execution execute
///     the same dynamic instance of this instruction.
/// 
///     Result Type  must be a scalar or vector of integer type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is INT_MIN when X is 32 bits wide and
///     LONG_MIN when X is 64 bits wide.
/// 
///     The type of X must be the same as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupSMax <Workgroup> <Reduce> %value : i32
///     ```
class GroupSMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A signed integer minimum group operation specified for all values of X
///     specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     Execution reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within Execution execute
///     the same dynamic instance of this instruction.
/// 
///     Result Type  must be a scalar or vector of integer type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is INT_MAX when X is 32 bits wide and
///     LONG_MAX when X is 64 bits wide.
/// 
///     The type of X must be the same as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupSMin <Workgroup> <Reduce> %value : i32
///     ```
class GroupSMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// An unsigned integer maximum group operation specified for all values of
///     X specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     Execution reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within Execution execute
///     the same dynamic instance of this instruction.
/// 
///     Result Type  must be a scalar or vector of integer type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is 0.
/// 
///     The type of X must be the same as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupUMax <Workgroup> <Reduce> %value : i32
///     ```
class GroupUMaxOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// An unsigned integer minimum group operation specified for all values of
///     X specified by invocations in the group.
/// Behavior is undefined if not all invocations of this module within
///     Execution reach this point of execution.
/// 
///     Behavior is undefined unless all invocations within Execution execute
///     the same dynamic instance of this instruction.
/// 
///     Result Type  must be a scalar or vector of integer type.
/// 
///     Execution is a Scope. It must be either Workgroup or Subgroup.
/// 
///     The identity I for Operation is UINT_MAX when X is 32 bits wide and
///     ULONG_MAX when X is 64 bits wide.
/// 
///     The type of X must be the same as Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.GroupUMin <Workgroup> <Reduce> %value : i32
///     ```
class GroupUMinOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Integer addition of Operand 1 and Operand 2, including the carry.
/// Result Type must be from OpTypeStruct.  The struct must have two
///     members, and the two members must be the same type.  The member type
///     must be a scalar or vector of integer type, whose Signedness operand is
///     0.
/// 
///     Operand 1 and Operand 2 must have the same type as the members of Result
///     Type. These are consumed as unsigned integers.
/// 
///      Results are computed per component.
/// 
///     Member 0 of the result gets the low-order bits (full component width) of
///     the addition.
/// 
///     Member 1 of the result gets the high-order (carry) bit of the result of
///     the addition. That is, it gets the value 1 if the addition overflowed
///     the component width, and 0 otherwise.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.IAddCarry %0, %1 : !spirv.struct<(i32, i32)>
///     %2 = spirv.IAddCarry %0, %1 : !spirv.struct<(vector<2xi32>, vector<2xi32>)>
///     ```
class IAddCarryOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Integer addition of Operand 1 and Operand 2.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same number of components as Result
///     Type. They must have the same component width as Result Type.
/// 
///     The resulting value will equal the low-order N bits of the correct
///     result R, where N is the component width and R is computed with enough
///     precision to avoid overflow and underflow.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.IAdd %0, %1 : i32
///     %5 = spirv.IAdd %2, %3 : vector<4xi32>
/// 
///     ```
class IAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Integer comparison for equality.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.IEqual %0, %1 : i32
///     %5 = spirv.IEqual %2, %3 : vector<4xi32>
///     ```
class IEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Integer multiplication of Operand 1 and Operand 2.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same number of components as Result
///     Type. They must have the same component width as Result Type.
/// 
///     The resulting value will equal the low-order N bits of the correct
///     result R, where N is the component width and R is computed with enough
///     precision to avoid overflow and underflow.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.IMul %0, %1 : i32
///     %5 = spirv.IMul %2, %3 : vector<4xi32>
/// 
///     ```
class IMulOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// See extension SPV_INTEL_split_barrier
/// Indicates that an invocation has arrived at a split control barrier. This
///     may allow other invocations waiting on the split control barrier to continue
///     executing.
/// 
///     When `Execution` is `Workgroup` or larger, behavior is undefined unless all
///     invocations within `Execution` execute the same dynamic instance of this
///     instruction. When `Execution` is `Subgroup` or `Invocation`, the behavior of
///     this instruction in non-uniform control flow is defined by the client API.
/// 
///     If `Semantics` is not `None`, this instruction also serves as the start of a
///     memory barrier similar to an `OpMemoryBarrier` instruction with the same
///     `Memory` and `Semantics` operands. This allows atomically specifying both a
///     control barrier and a memory barrier (that is, without needing two
///     instructions). If `Semantics` is `None`, `Memory` is ignored.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.ControlBarrierArrive <Workgroup> <Device> <Acquire|UniformMemory>
///     ```
class INTELControlBarrierArriveOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// See extension SPV_INTEL_split_barrier
/// Waits for other invocations of this module to arrive at a split control
///     barrier.
/// 
///     When `Execution` is `Workgroup` or larger, behavior is undefined unless all
///     invocations within `Execution` execute the same dynamic instance of this
///     instruction. When `Execution` is `Subgroup` or `Invocation`, the behavior of
///     this instruction in non-uniform control flow is defined by the client API.
/// 
///     If `Semantics` is not `None`, this instruction also serves as the end of a
///     memory barrier similar to an `OpMemoryBarrier` instruction with the same
///     `Memory` and `Semantics` operands. This ensures that memory accesses issued
///     before arriving at the split barrier are observed before memory accesses
///     issued after this instruction. This control is ensured only for memory
///     accesses issued by this invocation and observed by another invocation
///     executing within `Memory` scope. This allows atomically specifying both a
///     control barrier and a memory barrier (that is, without needing two
///     instructions). If `Semantics` is `None`, `Memory` is ignored.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.ControlBarrierWait <Workgroup> <Device> <Acquire|UniformMemory>
///     ```
class INTELControlBarrierWaitOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// See extension SPV_INTEL_bfloat16_conversion
/// Interpret a 16-bit integer as bfloat16 and convert the value numerically to 32-bit floating point type.
/// 
///     Result Type must be a scalar or vector of floating-point. The component width must be 32 bits.
/// 
///     Bfloat16 Value must be a scalar or vector of integer type, which is interpreted as a bfloat16 type.
///     The type must have the same number of components as the Result Type. The component width must be 16 bits.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.ConvertBF16ToF %0 : i16 to f32
///     %3 = spirv.ConvertBF16ToF %2 : vector<3xi16> to vector<3xf32>
///     ```
class INTELConvertBF16ToFOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// See extension SPV_INTEL_bfloat16_conversion
/// Convert value numerically from 32-bit floating point to bfloat16,
///     which is represented as a 16-bit unsigned integer.
/// 
///     Result Type must be a scalar or vector of integer type.
///     The component width must be 16 bits. Bit pattern in the Result represents a bfloat16 value.
/// 
///     Float Value must be a scalar or vector of floating-point type.
///     It must have the same number of components as Result Type. The component width must be 32 bits.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.ConvertFToBF16 %0 : f32 to i16
///     %3 = spirv.ConvertFToBF16 %2 : vector<3xf32> to vector<3xi16>
///     ```
class INTELConvertFToBF16Op;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// See extension SPV_INTEL_subgroups
/// Reads one or more components of Result data for each invocation in the
///     subgroup from the specified Ptr as a block operation.
/// 
///     The data is read strided, so the first value read is:
///     Ptr[ SubgroupLocalInvocationId ]
/// 
///     and the second value read is:
///     Ptr[ SubgroupLocalInvocationId + SubgroupMaxSize ]
///     etc.
/// 
///     Result Type may be a scalar or vector type, and its component type must be
///     equal to the type pointed to by Ptr.
/// 
///     The type of Ptr must be a pointer type, and must point to a scalar type.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     subgroup-block-read-INTEL-op ::= ssa-id `=` `spirv.INTEL.SubgroupBlockRead`
///                                 storage-class ssa_use `:` spirv-element-type
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.INTEL.SubgroupBlockRead "StorageBuffer" %ptr : i32
///     ```
class INTELSubgroupBlockReadOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// See extension SPV_INTEL_subgroups
/// Writes one or more components of Data for each invocation in the subgroup
///     from the specified Ptr as a block operation.
/// 
///     The data is written strided, so the first value is written to:
///     Ptr[ SubgroupLocalInvocationId ]
/// 
///     and the second value written is:
///     Ptr[ SubgroupLocalInvocationId + SubgroupMaxSize ]
///     etc.
/// 
///     The type of Ptr must be a pointer type, and must point to a scalar type.
/// 
///     The component type of Data must be equal to the type pointed to by Ptr.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     subgroup-block-write-INTEL-op ::= ssa-id `=` `spirv.INTEL.SubgroupBlockWrite`
///                       storage-class ssa_use `,` ssa-use `:` spirv-element-type
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.INTEL.SubgroupBlockWrite "StorageBuffer" %ptr, %value : i32
///     ```
class INTELSubgroupBlockWriteOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Integer comparison for inequality.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.INotEqual %0, %1 : i32
///     %5 = spirv.INotEqual %2, %3 : vector<4xi32>
/// 
///     ```
class INotEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the unsigned integer subtraction of Operand 2 from Operand 1,
///     and what it needed to borrow.
/// Result Type must be from OpTypeStruct.  The struct must have two
///     members, and the two members must be the same type.  The member type
///     must be a scalar or vector of integer type, whose Signedness operand is
///     0.
/// 
///     Operand 1 and Operand 2 must have the same type as the members of Result
///     Type. These are consumed as unsigned integers.
/// 
///      Results are computed per component.
/// 
///     Member 0 of the result gets the low-order bits (full component width) of
///     the subtraction. That is, if Operand 1 is larger than Operand 2, member
///     0 gets the full value of the subtraction;  if Operand 2 is larger than
///     Operand 1, member 0 gets 2w + Operand 1 - Operand 2, where w is the
///     component width.
/// 
///     Member 1 of the result gets 0 if Operand 1 ≥ Operand 2, and gets 1
///     otherwise.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.ISubBorrow %0, %1 : !spirv.struct<(i32, i32)>
///     %2 = spirv.ISubBorrow %0, %1 : !spirv.struct<(vector<2xi32>, vector<2xi32>)>
///     ```
class ISubBorrowOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Integer subtraction of Operand 2 from Operand 1.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same number of components as Result
///     Type. They must have the same component width as Result Type.
/// 
///     The resulting value will equal the low-order N bits of the correct
///     result R, where N is the component width and R is computed with enough
///     precision to avoid overflow and underflow.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.ISub %0, %1 : i32
///     %5 = spirv.ISub %2, %3 : vector<4xi32>
/// 
///     ```
class ISubOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Gathers the requested depth-comparison from four texels.
/// Result Type must be a vector of four components of floating-point type
///     or integer type. Its components must be the same as Sampled Type of the
///     underlying OpTypeImage (unless that underlying Sampled Type is
///     OpTypeVoid). It has one component per gathered texel.
/// 
///     Sampled Image must be an object whose type is OpTypeSampledImage. Its
///     OpTypeImage must have a Dim of 2D, Cube, or Rect. The MS operand of the
///     underlying OpTypeImage must be 0.
/// 
///     Coordinate must be a scalar or vector of floating-point type. It
///     contains (u[, v] ... [, array layer]) as needed by the definition of
///     Sampled Image.
/// 
///     Dref is the depth-comparison reference value. It must be a 32-bit
///     floating-point type scalar.
/// 
///     Image Operands encodes what operands follow, as per Image Operands.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.ImageDrefGather %1, %2, %3 : !spirv.sampled_image<!spirv.image<i32, Dim2D, NoDepth, NonArrayed, SingleSampled, NoSampler, Unknown>>, vector<4xf32>, f32 -> vector<4xi32>
///     %0 = spirv.ImageDrefGather %1, %2, %3 ["NonPrivateTexel"] : !spirv.sampled_image<!spirv.image<i32, Dim2D, NoDepth, NonArrayed, SingleSampled, NoSampler, Unknown>>, vector<4xf32>, f32 -> vector<4xi32>
///     ```
class ImageDrefGatherOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Fetch a single texel from an image whose Sampled operand is 1.
/// Result Type must be a vector of four components of floating-point type or
///     integer type. Its components must be the same as Sampled Type of the underlying
///     OpTypeImage (unless that underlying Sampled Type is OpTypeVoid).
/// 
///     Image must be an object whose type is OpTypeImage. Its Dim operand must not be
///     Cube, and its Sampled operand must be 1.
/// 
///     Coordinate must be a scalar or vector of integer type. It contains (u[, v] … [,
///     array layer]) as needed by the definition of Sampled Image.
/// 
///     Image Operands encodes what operands follow, as per Image Operands.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.ImageFetch %1, %2 : !spirv.image<f32, Dim2D, NoDepth, NonArrayed, SingleSampled, NeedSampler, R32f>, vector<2xsi32> -> vector<4xf32>
///     ```
class ImageFetchOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Extract the image from a sampled image.
/// Result Type must be OpTypeImage.
/// 
///     Sampled Image must have type OpTypeSampledImage whose Image Type is the
///     same as Result Type.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Image %1 : !spirv.sampled_image<!spirv.image<f32, Cube, NoDepth, NonArrayed, SingleSampled, NoSampler, Unknown>>
///     ```
class ImageOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Query the dimensions of Image, with no level of detail.
/// Result Type must be an integer type scalar or vector. The number of
///     components must be:
/// 
///     1 for the 1D and Buffer dimensionalities,
/// 
///     2 for the 2D, Cube, and Rect dimensionalities,
/// 
///     3 for the 3D dimensionality,
/// 
///     plus 1 more if the image type is arrayed. This vector is filled in with
///     (width [, height] [, elements]) where elements is the number of layers
///     in an image array or the number of cubes in a cube-map array.
/// 
///     Image must be an object whose type is OpTypeImage. Its Dim operand must
///     be one of those listed under Result Type, above. Additionally, if its
///     Dim is 1D, 2D, 3D, or Cube, it must also have either an MS of 1 or a
///     Sampled of 0 or 2. There is no implicit level-of-detail consumed by this
///     instruction. See OpImageQuerySizeLod for querying images having level of
///     detail. This operation is allowed on an image decorated as NonReadable.
///     See the client API specification for additional image type restrictions.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %3 = spirv.ImageQuerySize %0 : !spirv.image<i32, Dim1D, NoDepth, NonArrayed, SingleSampled, NoSampler, Unknown> -> i32
///     %4 = spirv.ImageQuerySize %1 : !spirv.image<i32, Dim2D, NoDepth, NonArrayed, SingleSampled, NoSampler, Unknown> -> vector<2xi32>
///     %5 = spirv.ImageQuerySize %2 : !spirv.image<i32, Dim2D, NoDepth, Arrayed, SingleSampled, NoSampler, Unknown> -> vector<3xi32>
///     ```
class ImageQuerySizeOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Read a texel from an image without a sampler.
/// Result Type must be a scalar or vector of floating-point type or integer
///     type. It must be a scalar or vector with component type the same as Sampled
///     Type of the OpTypeImage (unless that Sampled Type is OpTypeVoid).
/// 
///     Image must be an object whose type is OpTypeImage with a Sampled operand of
///     0 or 2. If the Arrayed operand is 1, then additional capabilities may be
///     required; e.g., ImageCubeArray, or ImageMSArray.
/// 
///     Coordinate must be a scalar or vector of floating-point type or integer
///     type. It contains non-normalized texel coordinates (u[, v] ... [, array
///     layer]) as needed by the definition of Image. See the client API
///     specification for handling of coordinates outside the image.
/// 
///     If the Image Dim operand is SubpassData, Coordinate is relative to the
///     current fragment location. See the client API specification for more detail
///     on how these coordinates are applied.
/// 
///     If the Image Dim operand is not SubpassData, the Image Format must not be
///     Unknown, unless the StorageImageReadWithoutFormat Capability was declared.
/// 
///     Image Operands encodes what operands follow, as per Image Operands.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.ImageRead %1, %2 : !spirv.image<f32, Dim2D, NoDepth, NonArrayed, SingleSampled, NoSampler, R32f>, vector<2xsi32> -> vector<4xf32>
///     ```
class ImageReadOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Sample an image using an explicit level of detail.
/// Result Type must be a vector of four components of floating-point type
///     or integer type. Its components must be the same as Sampled Type of the
///     underlying OpTypeImage (unless that underlying Sampled Type is
///     OpTypeVoid).
/// 
///     Sampled Image must be an object whose type is OpTypeSampledImage. Its
///     OpTypeImage must not have a Dim of Buffer. The MS operand of the
///     underlying OpTypeImage must be 0.
/// 
///     Coordinate must be a scalar or vector of floating-point type or integer
///     type. It contains (u[, v] ... [, array layer]) as needed by the
///     definition of Sampled Image. Unless the Kernel capability is declared,
///     it must be floating point. It may be a vector larger than needed, but
///     all unused components appear after all used components.
/// 
///     Image Operands encodes what operands follow, as per Image Operands.
///     Either Lod or Grad image operands must be present.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %result = spirv.ImageSampleExplicitLod %image, %coord ["Lod"](%lod) :
///       !spirv.sampled_image<!spirv.image<f32, Dim2D, NoDepth, NonArrayed, SingleSampled, NeedSampler, Unknown>>,
///       vector<2xf32> (f32) -> vector<4xf32>
///     ```
class ImageSampleExplicitLodOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Sample an image with an implicit level of detail.
/// An invocation will not execute a dynamic instance of this instruction
///     (X') until all invocations in its derivative group have executed all
///     dynamic instances that are program-ordered before X'.
/// 
///     Result Type must be a vector of four components of floating-point type
///     or integer type. Its components must be the same as Sampled Type of the
///     underlying OpTypeImage (unless that underlying Sampled Type is
///     OpTypeVoid).
/// 
///     Sampled Image must be an object whose type is OpTypeSampledImage. Its
///     OpTypeImage must not have a Dim of Buffer. The MS operand of the
///     underlying OpTypeImage must be 0.
/// 
///     Coordinate must be a scalar or vector of floating-point type. It
///     contains (u[, v] ... [, array layer]) as needed by the definition of
///     Sampled Image. It may be a vector larger than needed, but all unused
///     components appear after all used components.
/// 
///     Image Operands encodes what operands follow, as per Image Operands.
/// 
///     This instruction is only valid in the Fragment Execution Model. In
///     addition, it consumes an implicit derivative that can be affected by
///     code motion.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %result = spirv.ImageSampleImplicitLod %image, %coord :
///       !spirv.sampled_image<!spirv.image<f32, Cube, NoDepth, NonArrayed, SingleSampled, NeedSampler, Unknown>>,
///       vector<3xf32> -> vector<4xf32>
///     ```
class ImageSampleImplicitLodOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Sample an image with a project coordinate, doing depth-comparison, with
///     an implicit level of detail.
/// An invocation will not execute a dynamic instance of this instruction
///     (X') until all invocations in its derivative group have executed all
///     dynamic instances that are program-ordered before X'.
/// 
///     Result Type must be a scalar of integer type or floating-point type. It
///     must be the same as Sampled Type of the underlying OpTypeImage.
/// 
///     Sampled Image must be an object whose type is OpTypeSampledImage. The
///     Dim operand of the underlying OpTypeImage must be 1D, 2D, 3D, or Rect,
///     and the Arrayed and MS operands must be 0.
/// 
///     Coordinate must be a vector of floating-point type. It contains (u[,
///     v] [, w], q), as needed by the definition of Sampled Image, with the q
///     component consumed for the projective division. That is, the actual
///     sample coordinate is (u/q [, v/q] [, w/q]), as needed by the definition
///     of Sampled Image. It may be a vector larger than needed, but all unused
///     components appear after all used components.
/// 
///     Dref/q is the depth-comparison reference value. Dref must be a 32-bit
///     floating-point type scalar.
/// 
///     Image Operands encodes what operands follow, as per Image Operands.
/// 
///     This instruction is only valid in the Fragment Execution Model. In
///     addition, it consumes an implicit derivative that can be affected by
///     code motion.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %result = spirv.ImageSampleProjDrefImplicitLod %image, %coord, %dref :
///       !spirv.sampled_image<!spirv.image<f32, Dim2D, IsDepth, NonArrayed, SingleSampled, NeedSampler, Unknown>>,
///       vector<4xf16>, f32 -> f32
///     ```
class ImageSampleProjDrefImplicitLodOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Write a texel to an image without a sampler.
/// Image must be an object whose type is OpTypeImage with a Sampled operand
///     of 0 or 2. If the Arrayed operand is 1, then additional capabilities may
///     be required; e.g., ImageCubeArray, or ImageMSArray. Its Dim operand
///     must not be SubpassData.
/// 
///     Coordinate must be a scalar or vector of floating-point type or integer
///     type. It contains non-normalized texel coordinates (u[, v] ... [, array
///     layer]) as needed by the definition of Image. See the client API
///     specification for handling of coordinates outside the image.
/// 
///     Texel is the data to write. It must be a scalar or vector with component
///     type the same as Sampled Type of the OpTypeImage (unless that Sampled
///     Type is OpTypeVoid).
/// 
///     The Image Format must not be Unknown, unless the
///     StorageImageWriteWithoutFormat Capability was declared.
/// 
///     Image Operands encodes what operands follow, as per Image Operands.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.ImageWrite %0, %1, %2 : !spirv.image<f32, Dim2D, NoDepth, NonArrayed, SingleSampled, NoSampler, Rgba16>, vector<2xsi32>, vector<4xf32>
///     ```
class ImageWriteOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Has the same semantics as OpPtrAccessChain, with the addition that the
///     resulting pointer is known to point within the base object.
/// <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     func @inbounds_ptr_access_chain(%arg0: !spirv.ptr<f32, CrossWorkgroup>, %arg1 : i64) -> () {
///       %0 = spirv.InBoundsPtrAccessChain %arg0[%arg1] : !spirv.ptr<f32, CrossWorkgroup>, i64 -> !spirv.ptr<f32, CrossWorkgroup>
///       ...
///     }
///     ```
class InBoundsPtrAccessChainOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if x is an IEEE Inf, otherwise result is false
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     x must be a scalar or vector of floating-point type.  It must have the
///     same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.IsInf %0: f32
///     %3 = spirv.IsInf %1: vector<4xi32>
///     ```
class IsInfOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if x is an IEEE NaN, otherwise result is false.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     x must be a scalar or vector of floating-point type.  It must have the
///     same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.IsNan %0: f32
///     %3 = spirv.IsNan %1: vector<4xi32>
///     ```
class IsNanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// TBD
/// <!-- End of AutoGen section -->
/// 
///     ```
///     assumetruekhr-op ::= `spirv.KHR.AssumeTrue` ssa-use
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.KHR.AssumeTrue %arg
///     ```
class KHRAssumeTrueOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Queries the number of cooperative matrix components
/// Number of components of a cooperative matrix type accessible to each
///     invocation when treated as a composite.
/// 
///     The type attribute must be a cooperative matrix type.
/// 
///     #### Example:
/// 
///     ```
///     %0 = spirv.KHR.CooperativeMatrixLength :
///            !spirv.coopmatrix<8x16xi32, Subgroup, MatrixA>
///     ```
class KHRCooperativeMatrixLengthOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Loads a cooperative matrix through a pointer
/// Load a cooperative matrix through a pointer.
/// 
///     Result Type is the type of the loaded object. It must be a cooperative
///     matrix type.
/// 
///     Pointer is a pointer. Its type must be an OpTypePointer whose Type operand is
///     a scalar or vector type. If the Shader capability was declared, Pointer must
///     point into an array and any ArrayStride decoration on Pointer is ignored.
/// 
///     MemoryLayout specifies how matrix elements are laid out in memory. It must
///     come from a 32-bit integer constant instruction whose value corresponds to a
///     Cooperative Matrix Layout. See the Cooperative Matrix Layout table for a
///     description of the layouts and detailed layout-specific rules.
/// 
///     Stride further qualifies how matrix elements are laid out in memory. It must
///     be a scalar integer type and its exact semantics depend on MemoryLayout.
/// 
///     Memory Operand must be a Memory Operand literal. If not present, it is the
///     same as specifying None.
/// 
///     NOTE: In earlier versions of the SPIR-V spec, 'Memory Operand' was known
///     as 'Memory Access'.
/// 
///     For a given dynamic instance of this instruction, all operands of this
///     instruction must be the same for all invocations in a given scope instance
///     (where the scope is the scope the cooperative matrix type was created with).
///     All invocations in a given scope instance must be active or all must be
///     inactive.
/// 
///     TODO: In the SPIR-V spec, `stride` is an optional argument. We should also
///     support this optionality in the SPIR-V dialect.
/// 
///     #### Example:
/// 
///     ```
///     %0 = spirv.KHR.CooperativeMatrixLoad %ptr, %stride, <RowMajor>
///          : !spirv.ptr<i32, StorageBuffer>, i32
///              -> !spirv.KHR.coopmatrix<16x8xi32, Workgroup, MatrixA>
/// 
///     %1 = spirv.KHR.CooperativeMatrixLoad %ptr, %stride, <ColumnMajor>, <Volatile>
///          : !spirv.ptr<f32, StorageBuffer>, i64
///              -> !spirv.KHR.coopmatrix<8x8xf32, Subgroup, MatrixAcc>
///     ```
class KHRCooperativeMatrixLoadOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Returns the result of `(A x B) + C` of matrices A, B, and C
/// Linear-algebraic matrix multiply of A by B and then component-wise add C.
///     The order of the operations is implementation-dependent. The internal
///     precision of floating-point operations is defined by the client API. Integer
///     operations used in the multiplication of A by B are performed at the
///     precision of the Result Type and the resulting value will equal the
///     low-order N bits of the correct result R, where N is the result width and R
///     is computed with enough precision to avoid overflow and underflow if the
///     SaturatingAccumulation Cooperative Matrix Operand is not present. If the
///     SaturatingAccumulation Cooperative Matrix Operand is present and overflow or
///     underflow occurs as part of calculating that intermediate result, the result
///     of the instruction is undefined. Integer additions of the elements of that
///     intermediate result with those of C are performed at the precision of Result
///     Type, are exact, and are saturating if the SaturatingAccumulation
///     Cooperative Matrix Operand is present, with the signedness of the saturation
///     being that of the components of Result Type. If the SaturatingAccumulation
///     Cooperative Matrix Operand is not present then the resulting value will
///     equal the low-order N bits of the correct result R, where N is the result
///     width and R is computed with enough precision to avoid overflow and
///     underflow.
/// 
///     Result Type must be a cooperative matrix type with M rows and N columns
///     whose Use must be MatrixAccumulatorKHR.
/// 
///     A is a cooperative matrix with M rows and K columns whose Use must be
///     MatrixAKHR.
/// 
///     B is a cooperative matrix with K rows and N columns whose Use must be
///     MatrixBKHR.
/// 
///     C is a cooperative matrix with M rows and N columns whose Use must be
///     MatrixAccumulatorKHR.
/// 
///     The values of M, N, and K must be consistent across the result and operands.
///     This is referred to as an MxNxK matrix multiply.
/// 
///     A, B, C, and Result Type must have the same scope, and this defines the
///     scope of the operation. A, B, C, and Result Type need not necessarily have
///     the same component type, this is defined by the client API.
/// 
///     If the Component Type of any matrix operand is an integer type, then its
///     components are treated as signed if the Matrix{A,B,C,Result}SignedComponents
///     Cooperative Matrix Operand is present and are treated as unsigned otherwise.
/// 
///     Cooperative Matrix Operands is an optional Cooperative Matrix Operand
///     literal. If not present, it is the same as specifying the Cooperative Matrix
///     Operand None.
/// 
///     For a given dynamic instance of this instruction, all invocations in a given
///     scope instance must be active or all must be inactive (where the scope is
///     the scope of the operation).
/// 
///     ``` {.ebnf}
///     cooperative-matrixmuladd-op ::= ssa-id `=` `spirv.KHR.CooperativeMatrixMulAdd`
///                               ssa-use `,` ssa-use `,` ssa-use
///                               (`<` matrix-operands `>`)? `:`
///                               a-cooperative-matrix-type `,`
///                               b-cooperative-matrix-type `->`
///                                 result-cooperative-matrix-type
///     ```
/// 
///     #### Example:
/// 
///     ```
///     %0 = spirv.KHR.CooperativeMatrixMulAdd %matA, %matB, %matC :
///       !spirv.coopmatrix<4x4xf32, Subgroup, MatrixA>,
///       !spirv.coopmatrix<4x4xf32, Subgroup, MatrixB> ->
///         !spirv.coopmatrix<4x4xf32, Subgroup, MatrixAcc>
/// 
///     %1 = spirv.KHR.CooperativeMatrixMulAdd %matA, %matB, %matC, <ASigned | AccSat> :
///       !spirv.coopmatrix<8x16xi32, Subgroup, MatrixA>,
///       !spirv.coopmatrix<16x4xi32, Subgroup, MatrixB> ->
///         !spirv.coopmatrix<8x4xi32, Subgroup, MatrixAcc>
///     ```
class KHRCooperativeMatrixMulAddOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Stores a cooperative matrix through a pointer
/// Store a cooperative matrix through a pointer.
///     Pointer is a pointer. Its type must be an OpTypePointer whose Type operand
///     is a scalar or vector type. If the Shader capability was declared, Pointer
///     must point into an array and any ArrayStride decoration on Pointer is
///     ignored.
/// 
///     Object is the object to store. Its type must be an
///     OpTypeCooperativeMatrixKHR.
/// 
///     MemoryLayout specifies how matrix elements are laid out in memory. It must
///     come from a 32-bit integer constant instruction whose value corresponds to a
///     Cooperative Matrix Layout. See the Cooperative Matrix Layout table for a
///     description of the layouts and detailed layout-specific rules.
/// 
///     Stride further qualifies how matrix elements are laid out in memory. It must
///     be a scalar integer type and its exact semantics depend on MemoryLayout.
/// 
///     Memory Operand must be a Memory Operand literal. If not present, it is the
///     same as specifying None.
/// 
///     NOTE: In earlier versions of the SPIR-V spec, 'Memory Operand' was known
///     as 'Memory Access'.
/// 
///     For a given dynamic instance of this instruction, all operands of this
///     instruction must be the same for all invocations in a given scope instance
///     (where the scope is the scope the cooperative matrix type was created with).
///     All invocations in a given scope instance must be active or all must be
///     inactive.
/// 
///     TODO: In the SPIR-V spec, `stride` is an optional argument. We should also
///     support this optionality in the SPIR-V dialect.
/// 
///     #### Example:
/// 
///     ```
///       spirv.KHR.CooperativeMatrixStore %ptr, %obj, %stride, <RowMajor> :
///         !spirv.ptr<i32, StorageBuffer>, !spirv.coopmatrix<16x8xi32, Workgroup, MatrixA>, i32
/// 
///       spirv.KHR.CooperativeMatrixStore %ptr, %obj, %stride, <ColumnMajor>, <Volatile> :
///         !spirv.ptr<f32, StorageBuffer>, !spirv.coopmatrix<8x8xf32, Subgroup, MatrixAcc>, i64
///     ```
class KHRCooperativeMatrixStoreOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// See extension SPV_KHR_shader_ballot
/// Computes a bitfield value combining the Predicate value from all invocations
///     in the current Subgroup that execute the same dynamic instance of this
///     instruction. The bit is set to one if the corresponding invocation is active
///     and the predicate is evaluated to true; otherwise, it is set to zero.
/// 
///     Predicate must be a Boolean type.
/// 
///     Result Type must be a 4 component vector of 32 bit integer types.
/// 
///     Result is a set of bitfields where the first invocation is represented in bit
///     0 of the first vector component and the last (up to SubgroupSize) is the
///     higher bit number of the last bitmask needed to represent all bits of the
///     subgroup invocations.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     subgroup-ballot-op ::= ssa-id `=` `spirv.KHR.SubgroupBallot`
///                                 ssa-use `:` `vector` `<` 4 `x` `i32` `>`
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.KHR.SubgroupBallot %predicate : vector<4xi32>
///     ```
class KHRSubgroupBallotOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Deprecated (use OpTerminateInvocation or OpDemoteToHelperInvocation).
/// Fragment-shader discard.
/// 
///     Ceases all further processing in any invocation that executes it: Only
///     instructions these invocations executed before OpKill have observable
///     side effects. If this instruction is executed in non-uniform control
///     flow, all subsequent control flow is non-uniform (for invocations that
///     continue to execute).
/// 
///     This instruction must be the last instruction in a block.
/// 
///     This instruction is only valid in the Fragment Execution Model.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.Kill
///     ```
class KillOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Load through a pointer.
/// Result Type is the type of the loaded object. It must be a type with
///     fixed size; i.e., it cannot be, nor include, any OpTypeRuntimeArray
///     types.
/// 
///     Pointer is the pointer to load through.  Its type must be an
///     OpTypePointer whose Type operand is the same as Result Type.
/// 
///     If present, any Memory Operands must begin with a memory operand
///     literal. If not present, it is the same as specifying the memory operand
///     None.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     memory-access ::= `"None"` | `"Volatile"` | `"Aligned", ` integer-literal
///                     | `"NonTemporal"`
/// 
///     load-op ::= ssa-id ` = spirv.Load ` storage-class ssa-use
///                 (`[` memory-access `]`)? ` : ` spirv-element-type
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Variable : !spirv.ptr<f32, Function>
///     %1 = spirv.Load "Function" %0 : f32
///     %2 = spirv.Load "Function" %0 ["Volatile"] : f32
///     %3 = spirv.Load "Function" %0 ["Aligned", 4] : f32
///     ```
class LoadOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if both Operand 1 and Operand 2 are true. Result is false
///     if either Operand 1 or Operand 2 are false.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 must be the same as Result Type.
/// 
///     The type of Operand 2 must be the same as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.LogicalAnd %0, %1 : i1
///     %2 = spirv.LogicalAnd %0, %1 : vector<4xi1>
///     ```
class LogicalAndOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if Operand 1 and Operand 2 have the same value. Result is
///     false if Operand 1 and Operand 2 have different values.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 must be the same as Result Type.
/// 
///     The type of Operand 2 must be the same as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.LogicalEqual %0, %1 : i1
///     %2 = spirv.LogicalEqual %0, %1 : vector<4xi1>
///     ```
class LogicalEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if Operand 1 and Operand 2 have different values. Result
///     is false if Operand 1 and Operand 2 have the same value.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 must be the same as Result Type.
/// 
///     The type of Operand 2 must be the same as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.LogicalNotEqual %0, %1 : i1
///     %2 = spirv.LogicalNotEqual %0, %1 : vector<4xi1>
///     ```
class LogicalNotEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if Operand is false.  Result is false if Operand is true.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand must be the same as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.LogicalNot %0 : i1
///     %2 = spirv.LogicalNot %0 : vector<4xi1>
///     ```
class LogicalNotOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if either Operand 1 or Operand 2 is true. Result is false
///     if both Operand 1 and Operand 2 are false.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 must be the same as Result Type.
/// 
///     The type of Operand 2 must be the same as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.LogicalOr %0, %1 : i1
///     %2 = spirv.LogicalOr %0, %1 : vector<4xi1>
///     ```
class LogicalOrOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Define a structured loop.
/// SPIR-V can explicitly declare structured control-flow constructs using merge
///     instructions. These explicitly declare a header block before the control
///     flow diverges and a merge block where control flow subsequently converges.
///     These blocks delimit constructs that must nest, and can only be entered
///     and exited in structured ways. See "2.11. Structured Control Flow" of the
///     SPIR-V spec for more details.
/// 
///     Instead of having a `spirv.LoopMerge` op to directly model loop merge
///     instruction for indicating the merge and continue target, we use regions
///     to delimit the boundary of the loop: the merge target is the next op
///     following the `spirv.mlir.loop` op and the continue target is the block that
///     has a back-edge pointing to the entry block inside the `spirv.mlir.loop`'s region.
///     This way it's easier to discover all blocks belonging to a construct and
///     it plays nicer with the MLIR system.
/// 
///     The `spirv.mlir.loop` region should contain at least four blocks: one entry block,
///     one loop header block, one loop continue block, one loop merge block.
///     The entry block should be the first block and it should jump to the loop
///     header block, which is the second block. The loop merge block should be the
///     last block. The merge block should only contain a `spirv.mlir.merge` op.
///     The continue block should be the second to last block and it should have a
///     branch to the loop header block. The loop continue block should be the only
///     block, except the entry block, branching to the header block.
/// 
///     Values defined inside the loop regions cannot be directly used
///     outside of them; however, the loop region can yield values. These values are
///     yielded using a `spirv.mlir.merge` op and returned as a result of the loop op.
class LoopOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Linear-algebraic multiply of LeftMatrix X RightMatrix.
/// Result Type must be an OpTypeMatrix whose Column Type is a vector of
///     floating-point type.
/// 
///     LeftMatrix must be a matrix whose Column Type is the same as the Column
///     Type in Result Type.
/// 
///     RightMatrix must be a matrix with the same Component Type as the
///     Component Type in Result Type. Its number of columns must equal the
///     number of columns in Result Type. Its columns must have the same number
///     of components as the number of columns in LeftMatrix.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.MatrixTimesMatrix %matrix_1, %matrix_2 :
///         !spirv.matrix<4 x vector<3xf32>>, !spirv.matrix<3 x vector<4xf32>> ->
///         !spirv.matrix<4 x vector<4xf32>>
///     ```
class MatrixTimesMatrixOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Scale a floating-point matrix.
/// Result Type must be a matrix type with a float component type.
/// 
///     The type of Matrix must be the same as Result Type. Each component in
///     each column in Matrix is multiplied by Scalar.
/// 
///     Scalar must have the same type as the Component Type in Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.MatrixTimesScalar %matrix, %scalar :
///     !spirv.matrix<3 x vector<3xf32>>, f32 -> !spirv.matrix<3 x vector<3xf32>>
/// 
///     ```
class MatrixTimesScalarOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Linear-algebraic Matrix X Vector.
/// Result Type must be a vector of floating-point type.
/// 
///     Matrix must be an OpTypeMatrix whose Column Type is Result Type.
/// 
///     Vector must be a vector with the same Component Type as the Component Type in Result Type. Its number of components must equal the number of columns in Matrix.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.MatrixTimesVector %matrix, %vector : 
///         !spirv.matrix<3 x vector<2xf32>>, vector<3xf32> -> vector<2xf32>
///     ```
class MatrixTimesVectorOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Control the order that memory accesses are observed.
/// Ensures that memory accesses issued before this instruction will be
///     observed before memory accesses issued after this instruction. This
///     control is ensured only for memory accesses issued by this invocation
///     and observed by another invocation executing within Memory scope. If the
///     Vulkan memory model is declared, this ordering only applies to memory
///     accesses that use the NonPrivatePointer memory operand or
///     NonPrivateTexel image operand.
/// 
///     Semantics declares what kind of memory is being controlled and what kind
///     of control to apply.
/// 
///     To execute both a memory barrier and a control barrier, see
///     OpControlBarrier.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.MemoryBarrier "Device", "Acquire|UniformMemory"
///     ```
class MemoryBarrierOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// A special terminator for merging a structured selection/loop.
/// We use `spirv.mlir.selection`/`spirv.mlir.loop` for modelling structured selection/loop.
///     This op is a terminator used inside their regions to mean jumping to the
///     merge point, which is the next op following the `spirv.mlir.selection` or
///     `spirv.mlir.loop` op. This op does not have a corresponding instruction in the
///     SPIR-V binary format; it's solely for structural purpose.
/// 
///     The instruction is also used to yield values from inside the selection/loop region
///     to the outside, as values that were sunk into the region cannot otherwise escape it.
class MergeOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// The top-level op that defines a SPIR-V module
/// This op defines a SPIR-V module using a MLIR region. The region contains
///     one block. Module-level operations, including functions definitions,
///     are all placed in this block.
/// 
///     Using an op with a region to define a SPIR-V module enables "embedding"
///     SPIR-V modules in other dialects in a clean manner: this op guarantees
///     the validity and serializability of a SPIR-V module and thus serves as
///     a clear-cut boundary.
/// 
///     This op takes no operands and generates no results. This op should not
///     implicitly capture values from the enclosing environment.
/// 
///     This op has only one region, which only contains one block. The block
///     has no terminator.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     addressing-model ::= `Logical` | `Physical32` | `Physical64` | ...
///     memory-model ::= `Simple` | `GLSL450` | `OpenCL` | `Vulkan` | ...
///     spv-module-op ::= `spirv.module` addressing-model memory-model
///                       (requires  spirv-vce-attribute)?
///                       (`attributes` attribute-dict)?
///                       region
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.module Logical GLSL450  {}
/// 
///     spirv.module Logical Vulkan
///         requires #spirv.vce<v1.0, [Shader], [SPV_KHR_vulkan_memory_model]>
///         attributes { some_additional_attr = ... } {
///       spirv.func @do_nothing() -> () {
///         spirv.Return
///       }
///     }
///     ```
class ModuleOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Complement the bits of Operand.
/// Results are computed per component, and within each component, per bit.
/// 
///     Result Type must be a scalar or vector of integer type.
/// 
///     Operand's type  must be a scalar or vector of integer type.  It must
///     have the same number of components as Result Type.  The component width
///     must equal the component width in Result Type.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.Not %0 : i32
///     %3 = spirv.Not %1 : vector<4xi32>
///     ```
class NotOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if both x == x and y == y are true, where IEEE comparison
///     is used, otherwise result is false.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     x must be a scalar or vector of floating-point type.  It must have the
///     same number of components as Result Type.
/// 
///     y must have the same type as x.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.Ordered %0, %1 : f32
///     %5 = spirv.Ordered %2, %3 : vector<4xf32>
///     ```
class OrderedOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Has the same semantics as OpAccessChain, with the addition of the
///     Element operand.
/// Element is used to do an initial dereference of Base: Base is treated as
///     the address of an element in an array, and a new element address is
///     computed from Base and Element to become the OpAccessChain Base to
///     dereference as per OpAccessChain. This computed Base has the same type
///     as the originating Base.
/// 
///     To compute the new element address, Element is treated as a signed count
///     of elements E, relative to the original Base element B, and the address
///     of element B + E is computed using enough precision to avoid overflow
///     and underflow. For objects in the Uniform, StorageBuffer, or
///     PushConstant storage classes, the element's address or location is
///     calculated using a stride, which will be the Base-type's Array Stride if
///     the Base type is decorated with ArrayStride. For all other objects, the
///     implementation calculates the element's address or location.
/// 
///     With one exception, undefined behavior results when B + E is not an
///     element in the same array (same innermost array, if array types are
///     nested) as B. The exception being when B + E = L, where L is the length
///     of the array: the address computation for element L is done with the
///     same stride as any other B + E computation that stays within the array.
/// 
///     Note: If Base is typed to be a pointer to an array and the desired
///     operation is to select an element of that array, OpAccessChain should be
///     directly used, as its first Index selects the array element.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     func @ptr_access_chain(%arg0: !spirv.ptr<f32, CrossWorkgroup>, %arg1 : i64) -> () {
///       %0 = spirv.PtrAccessChain %arg0[%arg1] : !spirv.ptr<f32, CrossWorkgroup>, i64 -> !spirv.ptr<f32, CrossWorkgroup>
///       ...
///     }
///     ```
class PtrAccessChainOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert a pointer’s Storage Class to Generic.
/// Result Type must be an OpTypePointer. Its Storage Class must be Generic.
/// 
///     Pointer must point to the Workgroup, CrossWorkgroup, or Function Storage
///     Class.
/// 
///     Result Type and Pointer must point to the same type.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.PtrCastToGenericOp %0 : !spirv.ptr<f32, CrossWorkGroup> to
///          !spirv.ptr<f32, Generic>
///     ```
class PtrCastToGenericOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Reference a specialization constant.
/// Specialization constants in module scope are defined using symbol names.
///     This op generates an SSA value that can be used to refer to the symbol
///     within function scope for use in ops that expect an SSA value.
///     This operation has no corresponding SPIR-V instruction; it's merely used
///     for modelling purpose in the SPIR-V dialect. This op's return type is
///     the same as the specialization constant.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.mlir.referenceof @spec_const : f32
///     ```
/// 
///     TODO Add support for composite specialization constants.
class ReferenceOfOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return with no value from a function with void return type.
/// This instruction must be the last instruction in a block.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.Return
///     ```
class ReturnOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Return a value from a function.
/// Value is the value returned, by copy, and must match the Return Type
///     operand of the OpTypeFunction type of the OpFunction body this return
///     instruction is in.
/// 
///     This instruction must be the last instruction in a block.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.ReturnValue %0 : f32
///     ```
class ReturnValueOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert signed width.  This is either a truncate or a sign extend.
/// Result Type must be a scalar or vector of integer type.
/// 
///     Signed Value must be a scalar or vector of integer type.  It must have
///     the same number of components as Result Type.  The component width
///     cannot equal the component width in Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.SConvertOp %0 : i32 to i64
///     %3 = spirv.SConvertOp %2 : vector<3xi32> to vector<3xi64>
///     ```
class SConvertOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed-integer division of Operand 1 divided by Operand 2.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same number of components as Result
///     Type. They must have the same component width as Result Type.
/// 
///     Results are computed per component.  The resulting value is undefined
///     if Operand 2 is 0.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.SDiv %0, %1 : i32
///     %5 = spirv.SDiv %2, %3 : vector<4xi32>
/// 
///     ```
class SDivOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed integer dot product of Vector 1 and Vector 2 and signed
///     saturating addition of the result with Accumulator.
/// Result Type must be an integer type whose Width must be greater than or
///     equal to that of the components of Vector 1 and Vector 2.
/// 
///     Vector 1 and Vector 2 must have the same type.
/// 
///     Vector 1 and Vector 2 must be either 32-bit integers (enabled by the
///     DotProductInput4x8BitPacked capability) or vectors of integer type
///     (enabled by the DotProductInput4x8Bit or DotProductInputAll capability).
/// 
///     The type of Accumulator must be the same as Result Type.
/// 
///     When Vector 1 and Vector 2 are scalar integer types, Packed Vector
///     Format must be specified to select how the integers are to be
///     interpreted as vectors.
/// 
///     All components of the input vectors are sign-extended to the bit width
///     of the result's type. The sign-extended input vectors are then
///     multiplied component-wise and all components of the vector resulting
///     from the component-wise multiplication are added together. Finally, the
///     resulting sum is added to the input accumulator. This final addition is
///     saturating.
/// 
///     If any of the multiplications or additions, with the exception of the
///     final accumulation, overflow or underflow, the result of the instruction
///     is undefined.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %r = spirv.SDotAccSat %a, %b, %acc, <PackedVectorFormat4x8Bit> : i32 -> i32
///     %r = spirv.SDotAccSat %a, %b, %acc, <PackedVectorFormat4x8Bit> : i32 -> i64
///     %r = spirv.SDotAccSat %a, %b, %acc : vector<4xi8> -> i32
///     ```
class SDotAccSatOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed integer dot product of Vector 1 and Vector 2.
/// Result Type must be an integer type whose Width must be greater than or
///     equal to that of the components of Vector 1 and Vector 2.
/// 
///     Vector 1 and Vector 2 must have the same type.
/// 
///     Vector 1 and Vector 2 must be either 32-bit integers (enabled by the
///     DotProductInput4x8BitPacked capability) or vectors of integer type
///     (enabled by the DotProductInput4x8Bit or DotProductInputAll capability).
/// 
///     When Vector 1 and Vector 2 are scalar integer types, Packed Vector
///     Format must be specified to select how the integers are to be
///     interpreted as vectors.
/// 
///     All components of the input vectors are sign-extended to the bit width
///     of the result's type. The sign-extended input vectors are then
///     multiplied component-wise and all components of the vector resulting
///     from the component-wise multiplication are added together. The resulting
///     value will equal the low-order N bits of the correct result R, where N
///     is the result width and R is computed with enough precision to avoid
///     overflow and underflow.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %r = spirv.SDot %a, %b, <PackedVectorFormat4x8Bit> : i32 -> i32
///     %r = spirv.SDot %a, %b, <PackedVectorFormat4x8Bit> : i32 -> i64
///     %r = spirv.SDot %a, %b : vector<4xi8> -> i32
///     ```
class SDotOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed-integer comparison if Operand 1 is greater than or equal to
///     Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.SGreaterThanEqual %0, %1 : i32
///     %5 = spirv.SGreaterThanEqual %2, %3 : vector<4xi32>
///     ```
class SGreaterThanEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed-integer comparison if Operand 1 is greater than  Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.SGreaterThan %0, %1 : i32
///     %5 = spirv.SGreaterThan %2, %3 : vector<4xi32>
/// 
///     ```
class SGreaterThanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed-integer comparison if Operand 1 is less than or equal to Operand
///     2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.SLessThanEqual %0, %1 : i32
///     %5 = spirv.SLessThanEqual %2, %3 : vector<4xi32>
///     ```
class SLessThanEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed-integer comparison if Operand 1 is less than Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.SLessThan %0, %1 : i32
///     %5 = spirv.SLessThan %2, %3 : vector<4xi32>
/// 
///     ```
class SLessThanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed remainder operation for the remainder whose sign matches the sign
///     of Operand 2.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same number of components as Result
///     Type. They must have the same component width as Result Type.
/// 
///     Results are computed per component.  The resulting value is undefined
///     if Operand 2 is 0.  Otherwise, the result is the remainder r of Operand
///     1 divided by Operand 2 where if r ≠ 0, the sign of r is the same as the
///     sign of Operand 2.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.SMod %0, %1 : i32
///     %5 = spirv.SMod %2, %3 : vector<4xi32>
/// 
///     ```
class SModOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the full value of the signed integer multiplication of Operand
///     1 and Operand 2.
/// Result Type must be from OpTypeStruct.  The struct must have two
///     members, and the two members must be the same type.  The member type
///     must be a scalar or vector of integer type.
/// 
///     Operand 1 and Operand 2 must have the same type as the members of Result
///     Type. These are consumed as signed integers.
/// 
///     Results are computed per component.
/// 
///     Member 0 of the result gets the low-order bits of the multiplication.
/// 
///     Member 1 of the result gets the high-order bits of the multiplication.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.SMulExtended %0, %1 : !spirv.struct<(i32, i32)>
///     %2 = spirv.SMulExtended %0, %1 : !spirv.struct<(vector<2xi32>, vector<2xi32>)>
///     ```
class SMulExtendedOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed-integer subtract of Operand from zero.
/// Result Type must be a scalar or vector of integer type.
/// 
///     Operand's type  must be a scalar or vector of integer type.  It must
///     have the same number of components as Result Type.  The component width
///     must equal the component width in Result Type.
/// 
///      Results are computed per component.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.SNegate %0 : i32
///     %3 = spirv.SNegate %2 : vector<4xi32>
///     ```
class SNegateOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Signed remainder operation for the remainder whose sign matches the sign
///     of Operand 1.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same number of components as Result
///     Type. They must have the same component width as Result Type.
/// 
///     Results are computed per component.  The resulting value is undefined
///     if Operand 2 is 0.  Otherwise, the result is the remainder r of Operand
///     1 divided by Operand 2 where if r ≠ 0, the sign of r is the same as the
///     sign of Operand 1.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.SRem %0, %1 : i32
///     %5 = spirv.SRem %2, %3 : vector<4xi32>
/// 
///     ```
class SRemOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Mixed-signedness integer dot product of Vector 1 and Vector 2 and signed
///     saturating addition of the result with Accumulator. Components of Vector
///     1 are treated as signed, components of Vector 2 are treated as unsigned.
/// Result Type must be an integer type whose Width must be greater than or
///     equal to that of the components of Vector 1 and Vector 2.
/// 
///     Vector 1 and Vector 2 must be either 32-bit integers (enabled by the
///     DotProductInput4x8BitPacked capability) or vectors of integer type with
///     the same number of components and same component Width (enabled by the
///     DotProductInput4x8Bit or DotProductInputAll capability). When Vector 1
///     and Vector 2 are vectors, the components of Vector 2 must have a
///     Signedness of 0.
/// 
///     The type of Accumulator must be the same as Result Type.
/// 
///     When Vector 1 and Vector 2 are scalar integer types, Packed Vector
///     Format must be specified to select how the integers are to be
///     interpreted as vectors.
/// 
///     All components of Vector 1 are sign-extended to the bit width of the
///     result's type. All components of Vector 2 are zero-extended to the bit
///     width of the result's type. The sign- or zero-extended input vectors are
///     then multiplied component-wise and all components of the vector
///     resulting from the component-wise multiplication are added together.
///     Finally, the resulting sum is added to the input accumulator. This final
///     addition is saturating.
/// 
///     If any of the multiplications or additions, with the exception of the
///     final accumulation, overflow or underflow, the result of the instruction
///     is undefined.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %r = spirv.SUDotAccSat %a, %b, %acc, <PackedVectorFormat4x8Bit> : i32 -> i32
///     %r = spirv.SUDotAccSat %a, %b, %acc, <PackedVectorFormat4x8Bit> : i32 -> i64
///     %r = spirv.SUDotAccSat %a, %b, %acc : vector<4xi8> -> i32
///     ```
class SUDotAccSatOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Mixed-signedness integer dot product of Vector 1 and Vector 2.
///     Components of Vector 1 are treated as signed, components of Vector 2 are
///     treated as unsigned.
/// Result Type must be an integer type whose Width must be greater than or
///     equal to that of the components of Vector 1 and Vector 2.
/// 
///     Vector 1 and Vector 2 must be either 32-bit integers (enabled by the
///     DotProductInput4x8BitPacked capability) or vectors of integer type with
///     the same number of components and same component Width (enabled by the
///     DotProductInput4x8Bit or DotProductInputAll capability). When Vector 1
///     and Vector 2 are vectors, the components of Vector 2 must have a
///     Signedness of 0.
/// 
///     When Vector 1 and Vector 2 are scalar integer types, Packed Vector
///     Format must be specified to select how the integers are to be
///     interpreted as vectors.
/// 
///     All components of Vector 1 are sign-extended to the bit width of the
///     result's type. All components of Vector 2 are zero-extended to the bit
///     width of the result's type. The sign- or zero-extended input vectors are
///     then multiplied component-wise and all components of the vector
///     resulting from the component-wise multiplication are added together. The
///     resulting value will equal the low-order N bits of the correct result R,
///     where N is the result width and R is computed with enough precision to
///     avoid overflow and underflow.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %r = spirv.SUDot %a, %b, <PackedVectorFormat4x8Bit> : i32 -> i32
///     %r = spirv.SUDot %a, %b, <PackedVectorFormat4x8Bit> : i32 -> i64
///     %r = spirv.SUDot %a, %b : vector<4xi8> -> i32
///     ```
class SUDotOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Select between two objects. Before version 1.4, results are only
///     computed per component.
/// Before version 1.4, Result Type must be a pointer, scalar, or vector.
/// 
///     The types of Object 1 and Object 2 must be the same as Result Type.
/// 
///     Condition must be a scalar or vector of Boolean type.
/// 
///     If Condition is a scalar and true, the result is Object 1. If Condition
///     is a scalar and false, the result is Object 2.
/// 
///     If Condition is a vector, Result Type must be a vector with the same
///     number of components as Condition and the result is a mix of Object 1
///     and Object 2: When a component of Condition is true, the corresponding
///     component in the result is taken from Object 1, otherwise it is taken
///     from Object 2.
/// 
///     #### Example:
/// 
///     ```mlir
///     %3 = spirv.Select %0, %1, %2 : i1, f32
///     %3 = spirv.Select %0, %1, %2 : i1, vector<3xi32>
///     %3 = spirv.Select %0, %1, %2 : vector<3xi1>, vector<3xf32>
///     ```
class SelectOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Define a structured selection.
/// SPIR-V can explicitly declare structured control-flow constructs using merge
///     instructions. These explicitly declare a header block before the control
///     flow diverges and a merge block where control flow subsequently converges.
///     These blocks delimit constructs that must nest, and can only be entered
///     and exited in structured ways. See "2.11. Structured Control Flow" of the
///     SPIR-V spec for more details.
/// 
///     Instead of having a `spirv.SelectionMerge` op to directly model selection
///     merge instruction for indicating the merge target, we use regions to delimit
///     the boundary of the selection: the merge target is the next op following the
///     `spirv.mlir.selection` op. This way it's easier to discover all blocks belonging to
///     the selection and it plays nicer with the MLIR system.
/// 
///     The `spirv.mlir.selection` region should contain at least two blocks: one selection
///     header block, and one selection merge. The selection header block should be
///     the first block. The selection merge block should be the last block.
///     The merge block should only contain a `spirv.mlir.merge` op.
/// 
///     Values defined inside the selection regions cannot be directly used
///     outside of them; however, the selection region can yield values. These values are
///     yielded using a `spirv.mlir.merge` op and returned as a result of the selection op.
class SelectionOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Shift the bits in Base left by the number of bits specified in Shift.
///     The least-significant bits are zero filled.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of each Base and Shift must be a scalar or vector of integer
///     type. Base and Shift must have the same number of components.  The
///     number of components and bit width of the type of Base must be the same
///     as in Result Type.
/// 
///     Shift is treated as unsigned. The result is undefined if Shift is
///     greater than or equal to the bit width of the components of Base.
/// 
///     The number of components and bit width of Result Type must match those
///     Base type. All types must be integer types.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.ShiftLeftLogical %0, %1 : i32, i16
///     %5 = spirv.ShiftLeftLogical %3, %4 : vector<3xi32>, vector<3xi16>
///     ```
class ShiftLeftLogicalOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Shift the bits in Base right by the number of bits specified in Shift.
///     The most-significant bits are filled with the sign bit from Base.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of each Base and Shift must be a scalar or vector of integer
///     type. Base and Shift must have the same number of components.  The
///     number of components and bit width of the type of Base must be the same
///     as in Result Type.
/// 
///     Shift is treated as unsigned. The result is undefined if Shift is
///     greater than or equal to the bit width of the components of Base.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.ShiftRightArithmetic %0, %1 : i32, i16
///     %5 = spirv.ShiftRightArithmetic %3, %4 : vector<3xi32>, vector<3xi16>
///     ```
class ShiftRightArithmeticOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Shift the bits in Base right by the number of bits specified in Shift.
///     The most-significant bits are zero filled.
/// Result Type must be a scalar or vector of integer type.
/// 
///     The type of each Base and Shift must be a scalar or vector of integer
///     type. Base and Shift must have the same number of components.  The
///     number of components and bit width of the type of Base must be the same
///     as in Result Type.
/// 
///     Shift is consumed as an unsigned integer. The result is undefined if
///     Shift is greater than or equal to the bit width of the components of
///     Base.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.ShiftRightLogical %0, %1 : i32, i16
///     %5 = spirv.ShiftRightLogical %3, %4 : vector<3xi32>, vector<3xi16>
///     ```
class ShiftRightLogicalOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare a new composite specialization constant.
/// This op declares a SPIR-V composite specialization constant. This covers
///     the `OpSpecConstantComposite` SPIR-V instruction. Scalar constants are
///     covered by `spirv.SpecConstant`.
/// 
///     A constituent of a spec constant composite can be:
///     - A symbol referring of another spec constant.
///     - The SSA ID of a non-specialization constant (i.e. defined through
///       `spirv.SpecConstant`).
///     - The SSA ID of a `spirv.Undef`.
/// 
///     ```
///     spv-spec-constant-composite-op ::= `spirv.SpecConstantComposite` symbol-ref-id ` (`
///                                        symbol-ref-id (`, ` symbol-ref-id)*
///                                        `) :` composite-type
///     ```
/// 
///      where `composite-type` is some non-scalar type that can be represented in the `spv`
///      dialect: `spirv.struct`, `spirv.array`, or `vector`.
/// 
///      #### Example:
/// 
///      ```mlir
///      spirv.SpecConstant @sc1 = 1   : i32
///      spirv.SpecConstant @sc2 = 2.5 : f32
///      spirv.SpecConstant @sc3 = 3.5 : f32
///      spirv.SpecConstantComposite @scc (@sc1, @sc2, @sc3) : !spirv.struct<i32, f32, f32>
///      ```
/// 
///     TODO Add support for constituents that are:
///     - regular constants.
///     - undef.
///     - spec constant composite.
class SpecConstantCompositeOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare a new integer-type or floating-point-type scalar specialization
///     constant.
/// This op declares a SPIR-V scalar specialization constant. SPIR-V has
///     multiple constant instructions covering different scalar types:
/// 
///     * `OpSpecConstantTrue` and `OpSpecConstantFalse` for boolean constants
///     * `OpSpecConstant` for scalar constants
/// 
///     Similar as `spirv.Constant`, this op represents all of the above cases.
///     `OpSpecConstantComposite` and `OpSpecConstantOp` are modelled with
///     separate ops.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     spv-spec-constant-op ::= `spirv.SpecConstant` symbol-ref-id
///                              `spec_id(` integer `)`
///                              `=` attribute-value (`:` spirv-type)?
///     ```
/// 
///     where `spec_id` specifies the SPIR-V SpecId decoration associated with
///     the op.
/// 
///     #### Example:
/// 
///     ```mlir
///     spirv.SpecConstant @spec_const1 = true
///     spirv.SpecConstant @spec_const2 spec_id(5) = 42 : i32
///     ```
class SpecConstantOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Declare a new specialization constant that results from doing an operation.
/// This op declares a SPIR-V specialization constant that results from
///     doing an operation on other constants (specialization or otherwise).
/// 
///     In the `spv` dialect, this op is modelled as follows:
/// 
///     ```
///     spv-spec-constant-operation-op ::= `spirv.SpecConstantOperation` `wraps`
///                                          generic-spirv-op `:` function-type
///     ```
/// 
///     In particular, an `spirv.SpecConstantOperation` contains exactly one
///     region. In turn, that region, contains exactly 2 instructions:
///     - One of SPIR-V's instructions that are allowed within an
///     OpSpecConstantOp.
///     - An `spirv.mlir.yield` instruction as the terminator.
/// 
///     The following SPIR-V instructions are valid:
///     - OpSConvert,
///     - OpUConvert,
///     - OpFConvert,
///     - OpSNegate,
///     - OpNot,
///     - OpIAdd,
///     - OpISub,
///     - OpIMul,
///     - OpUDiv,
///     - OpSDiv,
///     - OpUMod,
///     - OpSRem,
///     - OpSMod
///     - OpShiftRightLogical,
///     - OpShiftRightArithmetic,
///     - OpShiftLeftLogical
///     - OpBitwiseOr,
///     - OpBitwiseXor,
///     - OpBitwiseAnd
///     - OpVectorShuffle,
///     - OpCompositeExtract,
///     - OpCompositeInsert
///     - OpLogicalOr,
///     - OpLogicalAnd,
///     - OpLogicalNot,
///     - OpLogicalEqual,
///     - OpLogicalNotEqual
///     - OpSelect
///     - OpIEqual,
///     - OpINotEqual
///     - OpULessThan,
///     - OpSLessThan
///     - OpUGreaterThan,
///     - OpSGreaterThan
///     - OpULessThanEqual,
///     - OpSLessThanEqual
///     - OpUGreaterThanEqual,
///     - OpSGreaterThanEqual
/// 
///     TODO Add capability-specific ops when supported.
/// 
///     #### Example:
///     ```mlir
///     %0 = spirv.Constant 1: i32
///     %1 = spirv.Constant 1: i32
/// 
///     %2 = spirv.SpecConstantOperation wraps "spirv.IAdd"(%0, %1) : (i32, i32) -> i32
///     ```
class SpecConstantOperationOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Store through a pointer.
/// Pointer is the pointer to store through.  Its type must be an
///     OpTypePointer whose Type operand is the same as the type of Object.
/// 
///     Object is the object to store.
/// 
///     If present, any Memory Operands must begin with a memory operand
///     literal. If not present, it is the same as specifying the memory operand
///     None.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     store-op ::= `spirv.Store ` storage-class ssa-use `, ` ssa-use `, `
///                   (`[` memory-access `]`)? `:` spirv-element-type
///     ```
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Variable : !spirv.ptr<f32, Function>
///     %1 = spirv.FMul ... : f32
///     spirv.Store "Function" %0, %1 : f32
///     spirv.Store "Function" %0, %1 ["Volatile"] : f32
///     spirv.Store "Function" %0, %1 ["Aligned", 4] : f32
///     ```
class StoreOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Transpose a matrix.
/// Result Type must be an OpTypeMatrix.
/// 
///     Matrix must be an object of type OpTypeMatrix. The number of columns and
///     the column size of Matrix must be the reverse of those in Result Type.
///     The types of the scalar components in Matrix and Result Type must be the
///     same.
/// 
///     Matrix must have of type of OpTypeMatrix.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Transpose %matrix: !spirv.matrix<2 x vector<3xf32>> ->
///     !spirv.matrix<3 x vector<2xf32>>
///     ```
class TransposeOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Convert unsigned width. This is either a truncate or a zero extend.
/// Result Type must be a scalar or vector of integer type, whose Signedness
///     operand is 0.
/// 
///     Unsigned Value must be a scalar or vector of integer type.  It must have
///     the same number of components as Result Type.  The component width
///     cannot equal the component width in Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %1 = spirv.UConvertOp %0 : i32 to i64
///     %3 = spirv.UConvertOp %2 : vector<3xi32> to vector<3xi64>
///     ```
class UConvertOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned-integer division of Operand 1 divided by Operand 2.
/// Result Type must be a scalar or vector of integer type, whose Signedness
///     operand is 0.
/// 
///     The types of Operand 1 and Operand 2 both must be the same as Result
///     Type.
/// 
///     Results are computed per component.  The resulting value is undefined
///     if Operand 2 is 0.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.UDiv %0, %1 : i32
///     %5 = spirv.UDiv %2, %3 : vector<4xi32>
///     ```
class UDivOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned integer dot product of Vector 1 and Vector 2 and unsigned
///     saturating addition of the result with Accumulator.
/// Result Type must be an integer type with Signedness of 0 whose Width
///     must be greater than or equal to that of the components of Vector 1 and
///     Vector 2.
/// 
///     Vector 1 and Vector 2 must have the same type.
/// 
///     Vector 1 and Vector 2 must be either 32-bit integers (enabled by the
///     DotProductInput4x8BitPacked capability) or vectors of integer type with
///     Signedness of 0 (enabled by the DotProductInput4x8Bit or
///     DotProductInputAll capability).
/// 
///     The type of Accumulator must be the same as Result Type.
/// 
///     When Vector 1 and Vector 2 are scalar integer types, Packed Vector
///     Format must be specified to select how the integers are to be
///     interpreted as vectors.
/// 
///     All components of the input vectors are zero-extended to the bit width
///     of the result's type. The zero-extended input vectors are then
///     multiplied component-wise and all components of the vector resulting
///     from the component-wise multiplication are added together. Finally, the
///     resulting sum is added to the input accumulator. This final addition is
///     saturating.
/// 
///     If any of the multiplications or additions, with the exception of the
///     final accumulation, overflow or underflow, the result of the instruction
///     is undefined.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %r = spirv.UDotAccSat %a, %b, %acc, <PackedVectorFormat4x8Bit> : i32 -> i32
///     %r = spirv.UDotAccSat %a, %b, %acc, <PackedVectorFormat4x8Bit> : i32 -> i64
///     %r = spirv.UDotAccSat %a, %b, %acc : vector<4xi8> -> i32
///     ```
class UDotAccSatOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned integer dot product of Vector 1 and Vector 2.
/// Result Type must be an integer type with Signedness of 0 whose Width
///     must be greater than or equal to that of the components of Vector 1 and
///     Vector 2.
/// 
///     Vector 1 and Vector 2 must have the same type.
/// 
///     Vector 1 and Vector 2 must be either 32-bit integers (enabled by the
///     DotProductInput4x8BitPacked capability) or vectors of integer type with
///     Signedness of 0 (enabled by the DotProductInput4x8Bit or
///     DotProductInputAll capability).
/// 
///     When Vector 1 and Vector 2 are scalar integer types, Packed Vector
///     Format must be specified to select how the integers are to be
///     interpreted as vectors.
/// 
///     All components of the input vectors are zero-extended to the bit width
///     of the result's type. The zero-extended input vectors are then
///     multiplied component-wise and all components of the vector resulting
///     from the component-wise multiplication are added together. The resulting
///     value will equal the low-order N bits of the correct result R, where N
///     is the result width and R is computed with enough precision to avoid
///     overflow and underflow.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %r = spirv.UDot %a, %b, <PackedVectorFormat4x8Bit> : i32 -> i32
///     %r = spirv.UDot %a, %b, <PackedVectorFormat4x8Bit> : i32 -> i64
///     %r = spirv.UDot %a, %b : vector<4xi8> -> i32
///     ```
class UDotOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned-integer comparison if Operand 1 is greater than or equal to
///     Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.UGreaterThanEqual %0, %1 : i32
///     %5 = spirv.UGreaterThanEqual %2, %3 : vector<4xi32>
///     ```
class UGreaterThanEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned-integer comparison if Operand 1 is greater than  Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.UGreaterThan %0, %1 : i32
///     %5 = spirv.UGreaterThan %2, %3 : vector<4xi32>
///     ```
class UGreaterThanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned-integer comparison if Operand 1 is less than or equal to
///     Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.ULessThanEqual %0, %1 : i32
///     %5 = spirv.ULessThanEqual %2, %3 : vector<4xi32>
///     ```
class ULessThanEqualOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned-integer comparison if Operand 1 is less than Operand 2.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     The type of Operand 1 and Operand 2  must be a scalar or vector of
///     integer type.  They must have the same component width, and they must
///     have the same number of components as Result Type.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.ULessThan %0, %1 : i32
///     %5 = spirv.ULessThan %2, %3 : vector<4xi32>
///     ```
class ULessThanOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Unsigned modulo operation of Operand 1 modulo Operand 2.
/// Result Type must be a scalar or vector of integer type, whose Signedness
///     operand is 0.
/// 
///     The types of Operand 1 and Operand 2 both must be the same as Result
///     Type.
/// 
///     Results are computed per component.  The resulting value is undefined
///     if Operand 2 is 0.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.UMod %0, %1 : i32
///     %5 = spirv.UMod %2, %3 : vector<4xi32>
///     ```
class UModOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is the full value of the unsigned integer multiplication of
///     Operand 1 and Operand 2.
/// Result Type must be from OpTypeStruct.  The struct must have two
///     members, and the two members must be the same type.  The member type
///     must be a scalar or vector of integer type, whose Signedness operand is
///     0.
/// 
///     Operand 1 and Operand 2 must have the same type as the members of Result
///     Type. These are consumed as unsigned integers.
/// 
///     Results are computed per component.
/// 
///     Member 0 of the result gets the low-order bits of the multiplication.
/// 
///     Member 1 of the result gets the high-order bits of the multiplication.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %2 = spirv.UMulExtended %0, %1 : !spirv.struct<(i32, i32)>
///     %2 = spirv.UMulExtended %0, %1 : !spirv.struct<(vector<2xi32>, vector<2xi32>)>
///     ```
class UMulExtendedOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Make an intermediate object whose value is undefined.
/// Result Type is the type of object to make.
/// 
///     Each consumption of Result <id> yields an arbitrary, possibly different
///     bit pattern or abstract value resulting in possibly different concrete,
///     abstract, or opaque values.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Undef : f32
///     %1 = spirv.Undef : !spirv.struct<!spirv.array<4 x vector<4xi32>>>
///     ```
class UndefOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Result is true if either x or y is an IEEE NaN, otherwise result is
///     false.
/// Result Type must be a scalar or vector of Boolean type.
/// 
///     x must be a scalar or vector of floating-point type.  It must have the
///     same number of components as Result Type.
/// 
///     y must have the same type as x.
/// 
///     Results are computed per component.
/// 
///     #### Example:
/// 
///     ```mlir
///     %4 = spirv.Unordered %0, %1 : f32
///     %5 = spirv.Unordered %2, %3 : vector<4xf32>
///     ```
class UnorderedOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Behavior is undefined if this instruction is executed.
/// This instruction must be the last instruction in a block.
class UnreachableOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Allocate an object in memory, resulting in a pointer to it, which can be
///     used with OpLoad and OpStore.
/// Result Type must be an OpTypePointer. Its Type operand is the type of
///     object in memory.
/// 
///     Storage Class is the Storage Class of the memory holding the object.
///     Since the op is used to model function-level variables, the storage class
///     must be the `Function` Storage Class.
/// 
///     Initializer is optional. If Initializer is present, it will be the
///     initial value of the variable's memory content. Initializer must be an
///     <id> from a constant instruction or a global (module scope) OpVariable
///     instruction. Initializer must have the same type as the type pointed to
///     by Result Type.
/// 
///     From `SPV_KHR_physical_storage_buffer`:
///     If an OpVariable's pointee type is a pointer (or array of pointers) in
///     PhysicalStorageBuffer storage class, then the variable must be decorated
///     with exactly one of AliasedPointer or RestrictPointer.
/// 
///     <!-- End of AutoGen section -->
/// 
///     ```
///     variable-op ::= ssa-id `=` `spirv.Variable` (`init(` ssa-use `)`)?
///                     attribute-dict? `:` spirv-pointer-type
///     ```
/// 
///     where `init` specifies initializer.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.Constant ...
/// 
///     %1 = spirv.Variable : !spirv.ptr<f32, Function>
///     %2 = spirv.Variable init(%0): !spirv.ptr<f32, Function>
/// 
///     %3 = spirv.Variable {aliased_pointer} :
///       !spirv.ptr<!spirv.ptr<f32, PhysicalStorageBuffer>, Function>
///     ```
class VariableOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Extract a single, dynamically selected, component of a vector.
/// Result Type must be a scalar type.
/// 
///     Vector must have a type OpTypeVector whose Component Type is Result
///     Type.
/// 
///     Index must be a scalar integer. It is interpreted as a 0-based index of
///     which component of Vector to extract.
/// 
///     Behavior is undefined if Index's value is less than zero or greater than
///     or equal to the number of components in Vector.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```
///     %2 = spirv.VectorExtractDynamic %0[%1] : vector<8xf32>, i32
///     ```
class VectorExtractDynamicOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Make a copy of a vector, with a single, variably selected, component
///     modified.
/// Result Type must be an OpTypeVector.
/// 
///     Vector must have the same type as Result Type and is the vector that the
///     non-written components are copied from.
/// 
///     Component is the value supplied for the component selected by Index. It
///     must have the same type as the type of components in Result Type.
/// 
///     Index must be a scalar integer. It is interpreted as a 0-based index of
///     which component to modify.
/// 
///     Behavior is undefined if Index's value is less than zero or greater than
///     or equal to the number of components in Vector.
/// 
///     #### Example:
/// 
///     ```mlir
///     %scalar = ... : f32
///     %2 = spirv.VectorInsertDynamic %scalar %0[%1] : f32, vector<8xf32>, i32
///     ```
class VectorInsertDynamicOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Select arbitrary components from two vectors to make a new vector.
/// Result Type must be an OpTypeVector. The number of components in Result
///     Type must be the same as the number of Component operands.
/// 
///     Vector 1 and Vector 2 must both have vector types, with the same
///     Component Type as Result Type. They do not have to have the same number
///     of components as Result Type or with each other. They are logically
///     concatenated, forming a single vector with Vector 1's components
///     appearing before Vector 2's. The components of this logical vector are
///     logically numbered with a single consecutive set of numbers from 0 to N
///     - 1, where N is the total number of components.
/// 
///     Components are these logical numbers (see above), selecting which of the
///     logically numbered components form the result. Each component is an
///     unsigned 32-bit integer.  They can select the components in any order
///     and can repeat components. The first component of the result is selected
///     by the first Component operand,  the second component of the result is
///     selected by the second Component operand, etc. A Component literal may
///     also be FFFFFFFF, which means the corresponding result component has no
///     source and is undefined. All Component literals must either be FFFFFFFF
///     or in [0, N - 1] (inclusive).
/// 
///     Note: A vector “swizzle” can be done by using the vector for both Vector
///     operands, or using an OpUndef for one of the Vector operands.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.VectorShuffle [1: i32, 3: i32, 5: i32] %vector1, %vector2 :
///       vector<4xf32>, vector<2xf32> -> vector<3xf32>
///     ```
class VectorShuffleOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Linear-algebraic Vector X Matrix.
/// Result Type must be a vector of floating-point type.
/// 
///     Vector must be a vector with the same Component Type as the Component
///     Type in Result Type. Its number of components must equal the number of
///     components in each column in Matrix.
/// 
///     Matrix must be a matrix with the same Component Type as the Component
///     Type in Result Type. Its number of columns must equal the number of
///     components in Result Type.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %result = spirv.VectorTimesMatrix %vector, %matrix : vector<4xf32>, !spirv.matrix<4 x vector<4xf32>> -> vector<4xf32>
///     ```
class VectorTimesMatrixOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Scale a floating-point vector.
/// Result Type must be a vector of floating-point type.
/// 
///      The type of Vector must be the same as Result Type. Each component of
///     Vector is multiplied by Scalar.
/// 
///     Scalar must have the same type as the Component Type in Result Type.
/// 
///     <!-- End of AutoGen section -->
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = spirv.VectorTimesScalar %vector, %scalar : vector<4xf32>
///     ```
class VectorTimesScalarOp;
} // namespace spirv
} // namespace mlir
namespace mlir {
namespace spirv {
/// Yields the result computed in `spirv.SpecConstantOperation`'s
///     region back to the parent op.
/// This op is a special terminator whose only purpose is to terminate
///     an `spirv.SpecConstantOperation`'s enclosed region. It accepts a
///     single operand produced by the preceeding (and only other) instruction
///     in its parent block (see SPIRV_SpecConstantOperation for further
///     details). This op has no corresponding SPIR-V instruction.
/// 
///     #### Example:
/// 
///     ```mlir
///     %0 = ... (some op supported by SPIR-V OpSpecConstantOp)
///     spirv.mlir.yield %0
///     ```
class YieldOp;
} // namespace spirv
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AccessChainOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AccessChainOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AccessChainOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AccessChain", odsAttrs.getContext());
  }

  AccessChainOpGenericAdaptorBase(AccessChainOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AccessChainOpGenericAdaptor : public detail::AccessChainOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AccessChainOpGenericAdaptorBase;
  static constexpr int odsIndex_base_ptr = 0;
  static constexpr int odsIndex_indices = 1;
public:
  AccessChainOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AccessChainOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AccessChainOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AccessChainOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AccessChainOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AccessChainOpGenericAdaptor(RangeT values, const AccessChainOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AccessChainOp, typename = std::enable_if_t<std::is_same_v<LateInst, AccessChainOp>>>
  AccessChainOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBasePtr() {
    return (*getODSOperands(0).begin());
  }

  RangeT getIndices() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AccessChainOpAdaptor : public AccessChainOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AccessChainOpGenericAdaptor::AccessChainOpGenericAdaptor;
  AccessChainOpAdaptor(AccessChainOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AccessChainOp : public ::mlir::Op<AccessChainOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AccessChainOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AccessChainOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_base_ptr = 0;
  static constexpr int odsIndex_indices = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AccessChain");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBasePtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getBasePtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getComponentPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value basePtr, ValueRange indices);
  static AccessChainOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value basePtr, ValueRange indices);
  static AccessChainOp create(::mlir::ImplicitLocOpBuilder &builder, Value basePtr, ValueRange indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type component_ptr, ::mlir::Value base_ptr, ::mlir::ValueRange indices);
  static AccessChainOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type component_ptr, ::mlir::Value base_ptr, ::mlir::ValueRange indices);
  static AccessChainOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type component_ptr, ::mlir::Value base_ptr, ::mlir::ValueRange indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base_ptr, ::mlir::ValueRange indices);
  static AccessChainOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base_ptr, ::mlir::ValueRange indices);
  static AccessChainOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base_ptr, ::mlir::ValueRange indices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AccessChainOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AccessChainOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AccessChainOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AccessChainOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AccessChainOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AddressOfOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AddressOfOpGenericAdaptorBase {
public:
  struct Properties {
    using variableTy = ::mlir::FlatSymbolRefAttr;
    variableTy variable;

    auto getVariable() const {
      auto &propStorage = this->variable;
      return ::llvm::cast<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setVariable(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->variable = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.variable == this->variable &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddressOfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.mlir.addressof", odsAttrs.getContext());
  }

  AddressOfOpGenericAdaptorBase(AddressOfOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::FlatSymbolRefAttr getVariableAttr() {
    auto attr = ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().variable);
    return attr;
  }

  ::llvm::StringRef getVariable();
};
} // namespace detail
template <typename RangeT>
class AddressOfOpGenericAdaptor : public detail::AddressOfOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddressOfOpGenericAdaptorBase;
public:
  AddressOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddressOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddressOfOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddressOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddressOfOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddressOfOpGenericAdaptor(RangeT values, const AddressOfOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddressOfOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddressOfOp>>>
  AddressOfOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddressOfOpAdaptor : public AddressOfOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddressOfOpGenericAdaptor::AddressOfOpGenericAdaptor;
  AddressOfOpAdaptor(AddressOfOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddressOfOp : public ::mlir::Op<AddressOfOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddressOfOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddressOfOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("variable")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getVariableAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getVariableAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.mlir.addressof");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::FlatSymbolRefAttr getVariableAttr() {
    return ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().variable);
  }

  ::llvm::StringRef getVariable();
  void setVariableAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().variable = attr;
  }

  void setVariable(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, spirv::GlobalVariableOp var);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, spirv::GlobalVariableOp var);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, spirv::GlobalVariableOp var);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type pointer, ::mlir::FlatSymbolRefAttr variable);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type pointer, ::mlir::FlatSymbolRefAttr variable);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type pointer, ::mlir::FlatSymbolRefAttr variable);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr variable);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr variable);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr variable);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type pointer, ::llvm::StringRef variable);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type pointer, ::llvm::StringRef variable);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type pointer, ::llvm::StringRef variable);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef variable);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef variable);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef variable);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AddressOfOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicAndOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicAndOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicAndOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicAnd", odsAttrs.getContext());
  }

  AtomicAndOpGenericAdaptorBase(AtomicAndOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicAndOpGenericAdaptor : public detail::AtomicAndOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicAndOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicAndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicAndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicAndOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicAndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicAndOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicAndOpGenericAdaptor(RangeT values, const AtomicAndOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicAndOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicAndOp>>>
  AtomicAndOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicAndOpAdaptor : public AtomicAndOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicAndOpGenericAdaptor::AtomicAndOpGenericAdaptor;
  AtomicAndOpAdaptor(AtomicAndOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicAndOp : public ::mlir::Op<AtomicAndOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicAndOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicAndOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicAnd");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicAndOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicCompareExchangeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicCompareExchangeOpGenericAdaptorBase {
public:
  struct Properties {
    using equal_semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    equal_semanticsTy equal_semantics;

    auto getEqualSemantics() const {
      auto &propStorage = this->equal_semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setEqualSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->equal_semantics = propValue;
    }
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using unequal_semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    unequal_semanticsTy unequal_semantics;

    auto getUnequalSemantics() const {
      auto &propStorage = this->unequal_semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setUnequalSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->unequal_semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.equal_semantics == this->equal_semantics &&
        rhs.memory_scope == this->memory_scope &&
        rhs.unequal_semantics == this->unequal_semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicCompareExchangeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicCompareExchange", odsAttrs.getContext());
  }

  AtomicCompareExchangeOpGenericAdaptorBase(AtomicCompareExchangeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getEqualSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().equal_semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getEqualSemantics();
  ::mlir::spirv::MemorySemanticsAttr getUnequalSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().unequal_semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getUnequalSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicCompareExchangeOpGenericAdaptor : public detail::AtomicCompareExchangeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicCompareExchangeOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  static constexpr int odsIndex_comparator = 2;
public:
  AtomicCompareExchangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicCompareExchangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicCompareExchangeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicCompareExchangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicCompareExchangeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicCompareExchangeOpGenericAdaptor(RangeT values, const AtomicCompareExchangeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicCompareExchangeOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicCompareExchangeOp>>>
  AtomicCompareExchangeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  ValueT getComparator() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicCompareExchangeOpAdaptor : public AtomicCompareExchangeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicCompareExchangeOpGenericAdaptor::AtomicCompareExchangeOpGenericAdaptor;
  AtomicCompareExchangeOpAdaptor(AtomicCompareExchangeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicCompareExchangeOp : public ::mlir::Op<AtomicCompareExchangeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicCompareExchangeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicCompareExchangeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  static constexpr int odsIndex_comparator = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("equal_semantics"), ::llvm::StringRef("memory_scope"), ::llvm::StringRef("unequal_semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getEqualSemanticsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getEqualSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getUnequalSemanticsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getUnequalSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicCompareExchange");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getComparator() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getComparatorMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getEqualSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().equal_semantics);
  }

  ::mlir::spirv::MemorySemantics getEqualSemantics();
  ::mlir::spirv::MemorySemanticsAttr getUnequalSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().unequal_semantics);
  }

  ::mlir::spirv::MemorySemantics getUnequalSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setEqualSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().equal_semantics = attr;
  }

  void setEqualSemantics(::mlir::spirv::MemorySemantics attrValue);
  void setUnequalSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().unequal_semantics = attr;
  }

  void setUnequalSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCompareExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCompareExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicCompareExchangeOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicCompareExchangeWeakOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicCompareExchangeWeakOpGenericAdaptorBase {
public:
  struct Properties {
    using equal_semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    equal_semanticsTy equal_semantics;

    auto getEqualSemantics() const {
      auto &propStorage = this->equal_semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setEqualSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->equal_semantics = propValue;
    }
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using unequal_semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    unequal_semanticsTy unequal_semantics;

    auto getUnequalSemantics() const {
      auto &propStorage = this->unequal_semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setUnequalSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->unequal_semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.equal_semantics == this->equal_semantics &&
        rhs.memory_scope == this->memory_scope &&
        rhs.unequal_semantics == this->unequal_semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicCompareExchangeWeakOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicCompareExchangeWeak", odsAttrs.getContext());
  }

  AtomicCompareExchangeWeakOpGenericAdaptorBase(AtomicCompareExchangeWeakOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getEqualSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().equal_semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getEqualSemantics();
  ::mlir::spirv::MemorySemanticsAttr getUnequalSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().unequal_semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getUnequalSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicCompareExchangeWeakOpGenericAdaptor : public detail::AtomicCompareExchangeWeakOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicCompareExchangeWeakOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  static constexpr int odsIndex_comparator = 2;
public:
  AtomicCompareExchangeWeakOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicCompareExchangeWeakOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicCompareExchangeWeakOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicCompareExchangeWeakOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicCompareExchangeWeakOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicCompareExchangeWeakOpGenericAdaptor(RangeT values, const AtomicCompareExchangeWeakOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicCompareExchangeWeakOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicCompareExchangeWeakOp>>>
  AtomicCompareExchangeWeakOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  ValueT getComparator() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicCompareExchangeWeakOpAdaptor : public AtomicCompareExchangeWeakOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicCompareExchangeWeakOpGenericAdaptor::AtomicCompareExchangeWeakOpGenericAdaptor;
  AtomicCompareExchangeWeakOpAdaptor(AtomicCompareExchangeWeakOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicCompareExchangeWeakOp : public ::mlir::Op<AtomicCompareExchangeWeakOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicCompareExchangeWeakOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicCompareExchangeWeakOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  static constexpr int odsIndex_comparator = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("equal_semantics"), ::llvm::StringRef("memory_scope"), ::llvm::StringRef("unequal_semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getEqualSemanticsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getEqualSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getUnequalSemanticsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getUnequalSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicCompareExchangeWeak");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getComparator() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getComparatorMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getEqualSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().equal_semantics);
  }

  ::mlir::spirv::MemorySemantics getEqualSemantics();
  ::mlir::spirv::MemorySemanticsAttr getUnequalSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().unequal_semantics);
  }

  ::mlir::spirv::MemorySemantics getUnequalSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setEqualSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().equal_semantics = attr;
  }

  void setEqualSemantics(::mlir::spirv::MemorySemantics attrValue);
  void setUnequalSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().unequal_semantics = attr;
  }

  void setUnequalSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr equal_semantics, ::mlir::spirv::MemorySemanticsAttr unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, ::mlir::Value value, ::mlir::Value comparator);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCompareExchangeWeakOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCompareExchangeWeakOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicCompareExchangeWeakOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicExchangeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicExchangeOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicExchangeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicExchange", odsAttrs.getContext());
  }

  AtomicExchangeOpGenericAdaptorBase(AtomicExchangeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicExchangeOpGenericAdaptor : public detail::AtomicExchangeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicExchangeOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicExchangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicExchangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicExchangeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicExchangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicExchangeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicExchangeOpGenericAdaptor(RangeT values, const AtomicExchangeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicExchangeOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicExchangeOp>>>
  AtomicExchangeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicExchangeOpAdaptor : public AtomicExchangeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicExchangeOpGenericAdaptor::AtomicExchangeOpGenericAdaptor;
  AtomicExchangeOpAdaptor(AtomicExchangeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicExchangeOp : public ::mlir::Op<AtomicExchangeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicExchangeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicExchangeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicExchange");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicExchangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicExchangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicExchangeOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicIAddOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicIAddOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicIAddOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicIAdd", odsAttrs.getContext());
  }

  AtomicIAddOpGenericAdaptorBase(AtomicIAddOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicIAddOpGenericAdaptor : public detail::AtomicIAddOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicIAddOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicIAddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicIAddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicIAddOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicIAddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicIAddOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicIAddOpGenericAdaptor(RangeT values, const AtomicIAddOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicIAddOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicIAddOp>>>
  AtomicIAddOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicIAddOpAdaptor : public AtomicIAddOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicIAddOpGenericAdaptor::AtomicIAddOpGenericAdaptor;
  AtomicIAddOpAdaptor(AtomicIAddOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicIAddOp : public ::mlir::Op<AtomicIAddOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicIAddOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicIAddOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicIAdd");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicIAddOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicIDecrementOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicIDecrementOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicIDecrementOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicIDecrement", odsAttrs.getContext());
  }

  AtomicIDecrementOpGenericAdaptorBase(AtomicIDecrementOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicIDecrementOpGenericAdaptor : public detail::AtomicIDecrementOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicIDecrementOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
public:
  AtomicIDecrementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicIDecrementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicIDecrementOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicIDecrementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicIDecrementOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicIDecrementOpGenericAdaptor(RangeT values, const AtomicIDecrementOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicIDecrementOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicIDecrementOp>>>
  AtomicIDecrementOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicIDecrementOpAdaptor : public AtomicIDecrementOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicIDecrementOpGenericAdaptor::AtomicIDecrementOpGenericAdaptor;
  AtomicIDecrementOpAdaptor(AtomicIDecrementOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicIDecrementOp : public ::mlir::Op<AtomicIDecrementOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicIDecrementOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicIDecrementOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicIDecrement");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIDecrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIDecrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicIDecrementOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicIIncrementOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicIIncrementOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicIIncrementOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicIIncrement", odsAttrs.getContext());
  }

  AtomicIIncrementOpGenericAdaptorBase(AtomicIIncrementOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicIIncrementOpGenericAdaptor : public detail::AtomicIIncrementOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicIIncrementOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
public:
  AtomicIIncrementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicIIncrementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicIIncrementOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicIIncrementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicIIncrementOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicIIncrementOpGenericAdaptor(RangeT values, const AtomicIIncrementOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicIIncrementOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicIIncrementOp>>>
  AtomicIIncrementOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicIIncrementOpAdaptor : public AtomicIIncrementOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicIIncrementOpGenericAdaptor::AtomicIIncrementOpGenericAdaptor;
  AtomicIIncrementOpAdaptor(AtomicIIncrementOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicIIncrementOp : public ::mlir::Op<AtomicIIncrementOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicIIncrementOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicIIncrementOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicIIncrement");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIIncrementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicIIncrementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicIIncrementOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicISubOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicISubOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicISubOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicISub", odsAttrs.getContext());
  }

  AtomicISubOpGenericAdaptorBase(AtomicISubOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicISubOpGenericAdaptor : public detail::AtomicISubOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicISubOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicISubOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicISubOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicISubOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicISubOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicISubOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicISubOpGenericAdaptor(RangeT values, const AtomicISubOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicISubOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicISubOp>>>
  AtomicISubOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicISubOpAdaptor : public AtomicISubOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicISubOpGenericAdaptor::AtomicISubOpGenericAdaptor;
  AtomicISubOpAdaptor(AtomicISubOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicISubOp : public ::mlir::Op<AtomicISubOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicISubOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicISubOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicISub");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicISubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicISubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicISubOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicOrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicOrOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicOrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicOr", odsAttrs.getContext());
  }

  AtomicOrOpGenericAdaptorBase(AtomicOrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicOrOpGenericAdaptor : public detail::AtomicOrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicOrOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicOrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicOrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicOrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicOrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicOrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicOrOpGenericAdaptor(RangeT values, const AtomicOrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicOrOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicOrOp>>>
  AtomicOrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicOrOpAdaptor : public AtomicOrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicOrOpGenericAdaptor::AtomicOrOpGenericAdaptor;
  AtomicOrOpAdaptor(AtomicOrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicOrOp : public ::mlir::Op<AtomicOrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicOrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicOrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicOr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicOrOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicSMaxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicSMaxOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicSMaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicSMax", odsAttrs.getContext());
  }

  AtomicSMaxOpGenericAdaptorBase(AtomicSMaxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicSMaxOpGenericAdaptor : public detail::AtomicSMaxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicSMaxOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicSMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicSMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicSMaxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicSMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicSMaxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicSMaxOpGenericAdaptor(RangeT values, const AtomicSMaxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicSMaxOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicSMaxOp>>>
  AtomicSMaxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicSMaxOpAdaptor : public AtomicSMaxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicSMaxOpGenericAdaptor::AtomicSMaxOpGenericAdaptor;
  AtomicSMaxOpAdaptor(AtomicSMaxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicSMaxOp : public ::mlir::Op<AtomicSMaxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicSMaxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicSMaxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicSMax");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicSMaxOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicSMinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicSMinOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicSMinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicSMin", odsAttrs.getContext());
  }

  AtomicSMinOpGenericAdaptorBase(AtomicSMinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicSMinOpGenericAdaptor : public detail::AtomicSMinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicSMinOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicSMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicSMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicSMinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicSMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicSMinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicSMinOpGenericAdaptor(RangeT values, const AtomicSMinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicSMinOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicSMinOp>>>
  AtomicSMinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicSMinOpAdaptor : public AtomicSMinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicSMinOpGenericAdaptor::AtomicSMinOpGenericAdaptor;
  AtomicSMinOpAdaptor(AtomicSMinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicSMinOp : public ::mlir::Op<AtomicSMinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicSMinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicSMinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicSMin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicSMinOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicUMaxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicUMaxOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicUMaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicUMax", odsAttrs.getContext());
  }

  AtomicUMaxOpGenericAdaptorBase(AtomicUMaxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicUMaxOpGenericAdaptor : public detail::AtomicUMaxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicUMaxOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicUMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicUMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicUMaxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicUMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicUMaxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicUMaxOpGenericAdaptor(RangeT values, const AtomicUMaxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicUMaxOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicUMaxOp>>>
  AtomicUMaxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicUMaxOpAdaptor : public AtomicUMaxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicUMaxOpGenericAdaptor::AtomicUMaxOpGenericAdaptor;
  AtomicUMaxOpAdaptor(AtomicUMaxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicUMaxOp : public ::mlir::Op<AtomicUMaxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::spirv::UnsignedOp, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicUMaxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicUMaxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicUMax");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicUMaxOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicUMinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicUMinOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicUMinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicUMin", odsAttrs.getContext());
  }

  AtomicUMinOpGenericAdaptorBase(AtomicUMinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicUMinOpGenericAdaptor : public detail::AtomicUMinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicUMinOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicUMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicUMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicUMinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicUMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicUMinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicUMinOpGenericAdaptor(RangeT values, const AtomicUMinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicUMinOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicUMinOp>>>
  AtomicUMinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicUMinOpAdaptor : public AtomicUMinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicUMinOpGenericAdaptor::AtomicUMinOpGenericAdaptor;
  AtomicUMinOpAdaptor(AtomicUMinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicUMinOp : public ::mlir::Op<AtomicUMinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::spirv::UnsignedOp, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicUMinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicUMinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicUMin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicUMinOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::AtomicXorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicXorOpGenericAdaptorBase {
public:
  struct Properties {
    using memory_scopeTy = ::mlir::spirv::ScopeAttr;
    memory_scopeTy memory_scope;

    auto getMemoryScope() const {
      auto &propStorage = this->memory_scope;
      return ::llvm::cast<::mlir::spirv::ScopeAttr>(propStorage);
    }
    void setMemoryScope(const ::mlir::spirv::ScopeAttr &propValue) {
      this->memory_scope = propValue;
    }
    using semanticsTy = ::mlir::spirv::MemorySemanticsAttr;
    semanticsTy semantics;

    auto getSemantics() const {
      auto &propStorage = this->semantics;
      return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(propStorage);
    }
    void setSemantics(const ::mlir::spirv::MemorySemanticsAttr &propValue) {
      this->semantics = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memory_scope == this->memory_scope &&
        rhs.semantics == this->semantics &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicXorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.AtomicXor", odsAttrs.getContext());
  }

  AtomicXorOpGenericAdaptorBase(AtomicXorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
    return attr;
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    auto attr = ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
    return attr;
  }

  ::mlir::spirv::MemorySemantics getSemantics();
};
} // namespace detail
template <typename RangeT>
class AtomicXorOpGenericAdaptor : public detail::AtomicXorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicXorOpGenericAdaptorBase;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
public:
  AtomicXorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicXorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicXorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicXorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicXorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicXorOpGenericAdaptor(RangeT values, const AtomicXorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicXorOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicXorOp>>>
  AtomicXorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPointer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicXorOpAdaptor : public AtomicXorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicXorOpGenericAdaptor::AtomicXorOpGenericAdaptor;
  AtomicXorOpAdaptor(AtomicXorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicXorOp : public ::mlir::Op<AtomicXorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicXorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicXorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pointer = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memory_scope"), ::llvm::StringRef("semantics")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemoryScopeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemoryScopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSemanticsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSemanticsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.AtomicXor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getPointer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPointerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::spirv::ScopeAttr getMemoryScopeAttr() {
    return ::llvm::cast<::mlir::spirv::ScopeAttr>(getProperties().memory_scope);
  }

  ::mlir::spirv::Scope getMemoryScope();
  ::mlir::spirv::MemorySemanticsAttr getSemanticsAttr() {
    return ::llvm::cast<::mlir::spirv::MemorySemanticsAttr>(getProperties().semantics);
  }

  ::mlir::spirv::MemorySemantics getSemantics();
  void setMemoryScopeAttr(::mlir::spirv::ScopeAttr attr) {
    getProperties().memory_scope = attr;
  }

  void setMemoryScope(::mlir::spirv::Scope attrValue);
  void setSemanticsAttr(::mlir::spirv::MemorySemanticsAttr attr) {
    getProperties().semantics = attr;
  }

  void setSemantics(::mlir::spirv::MemorySemantics attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::ScopeAttr memory_scope, ::mlir::spirv::MemorySemanticsAttr semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::AtomicXorOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitCountOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitCountOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitCountOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BitCount", odsAttrs.getContext());
  }

  BitCountOpGenericAdaptorBase(BitCountOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitCountOpGenericAdaptor : public detail::BitCountOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitCountOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  BitCountOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitCountOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitCountOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitCountOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitCountOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitCountOpGenericAdaptor(RangeT values, const BitCountOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitCountOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitCountOp>>>
  BitCountOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitCountOpAdaptor : public BitCountOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitCountOpGenericAdaptor::BitCountOpGenericAdaptor;
  BitCountOpAdaptor(BitCountOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitCountOp : public ::mlir::Op<BitCountOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitCountOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitCountOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BitCount");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static BitCountOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static BitCountOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static BitCountOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static BitCountOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static BitCountOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static BitCountOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitCountOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitCountOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitCountOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitCountOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitCountOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitCountOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitCountOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitCountOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitCountOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitFieldInsertOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitFieldInsertOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitFieldInsertOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BitFieldInsert", odsAttrs.getContext());
  }

  BitFieldInsertOpGenericAdaptorBase(BitFieldInsertOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitFieldInsertOpGenericAdaptor : public detail::BitFieldInsertOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitFieldInsertOpGenericAdaptorBase;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_insert = 1;
  static constexpr int odsIndex_offset = 2;
  static constexpr int odsIndex_count = 3;
public:
  BitFieldInsertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitFieldInsertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitFieldInsertOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitFieldInsertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitFieldInsertOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitFieldInsertOpGenericAdaptor(RangeT values, const BitFieldInsertOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitFieldInsertOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitFieldInsertOp>>>
  BitFieldInsertOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBase() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInsert() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOffset() {
    return (*getODSOperands(2).begin());
  }

  ValueT getCount() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitFieldInsertOpAdaptor : public BitFieldInsertOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitFieldInsertOpGenericAdaptor::BitFieldInsertOpGenericAdaptor;
  BitFieldInsertOpAdaptor(BitFieldInsertOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitFieldInsertOp : public ::mlir::Op<BitFieldInsertOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitFieldInsertOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitFieldInsertOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_insert = 1;
  static constexpr int odsIndex_offset = 2;
  static constexpr int odsIndex_count = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BitFieldInsert");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getInsert() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOffset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getCount() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getBaseMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInsertMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOffsetMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCountMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldInsertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldInsertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldInsertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldInsertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldInsertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldInsertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value insert, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldInsertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldInsertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldInsertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldInsertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldInsertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldInsertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldInsertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldInsertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitFieldInsertOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitFieldSExtractOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitFieldSExtractOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitFieldSExtractOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BitFieldSExtract", odsAttrs.getContext());
  }

  BitFieldSExtractOpGenericAdaptorBase(BitFieldSExtractOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitFieldSExtractOpGenericAdaptor : public detail::BitFieldSExtractOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitFieldSExtractOpGenericAdaptorBase;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_offset = 1;
  static constexpr int odsIndex_count = 2;
public:
  BitFieldSExtractOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitFieldSExtractOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitFieldSExtractOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitFieldSExtractOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitFieldSExtractOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitFieldSExtractOpGenericAdaptor(RangeT values, const BitFieldSExtractOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitFieldSExtractOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitFieldSExtractOp>>>
  BitFieldSExtractOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBase() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOffset() {
    return (*getODSOperands(1).begin());
  }

  ValueT getCount() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitFieldSExtractOpAdaptor : public BitFieldSExtractOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitFieldSExtractOpGenericAdaptor::BitFieldSExtractOpGenericAdaptor;
  BitFieldSExtractOpAdaptor(BitFieldSExtractOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitFieldSExtractOp : public ::mlir::Op<BitFieldSExtractOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::spirv::SignedOp, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitFieldSExtractOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitFieldSExtractOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_offset = 1;
  static constexpr int odsIndex_count = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BitFieldSExtract");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOffset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getCount() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getBaseMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOffsetMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCountMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldSExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldSExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldSExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldSExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldSExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldSExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldSExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldSExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldSExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldSExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldSExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldSExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldSExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldSExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitFieldSExtractOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitFieldUExtractOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitFieldUExtractOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitFieldUExtractOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BitFieldUExtract", odsAttrs.getContext());
  }

  BitFieldUExtractOpGenericAdaptorBase(BitFieldUExtractOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitFieldUExtractOpGenericAdaptor : public detail::BitFieldUExtractOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitFieldUExtractOpGenericAdaptorBase;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_offset = 1;
  static constexpr int odsIndex_count = 2;
public:
  BitFieldUExtractOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitFieldUExtractOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitFieldUExtractOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitFieldUExtractOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitFieldUExtractOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitFieldUExtractOpGenericAdaptor(RangeT values, const BitFieldUExtractOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitFieldUExtractOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitFieldUExtractOp>>>
  BitFieldUExtractOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBase() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOffset() {
    return (*getODSOperands(1).begin());
  }

  ValueT getCount() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitFieldUExtractOpAdaptor : public BitFieldUExtractOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitFieldUExtractOpGenericAdaptor::BitFieldUExtractOpGenericAdaptor;
  BitFieldUExtractOpAdaptor(BitFieldUExtractOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitFieldUExtractOp : public ::mlir::Op<BitFieldUExtractOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::spirv::UnsignedOp, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitFieldUExtractOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitFieldUExtractOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_offset = 1;
  static constexpr int odsIndex_count = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BitFieldUExtract");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOffset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getCount() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getBaseMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOffsetMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCountMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldUExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldUExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldUExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldUExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldUExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static BitFieldUExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value offset, ::mlir::Value count);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldUExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldUExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldUExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitFieldUExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldUExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldUExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldUExtractOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitFieldUExtractOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitFieldUExtractOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitReverseOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitReverseOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitReverseOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BitReverse", odsAttrs.getContext());
  }

  BitReverseOpGenericAdaptorBase(BitReverseOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitReverseOpGenericAdaptor : public detail::BitReverseOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitReverseOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  BitReverseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitReverseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitReverseOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitReverseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitReverseOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitReverseOpGenericAdaptor(RangeT values, const BitReverseOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitReverseOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitReverseOp>>>
  BitReverseOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitReverseOpAdaptor : public BitReverseOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitReverseOpGenericAdaptor::BitReverseOpGenericAdaptor;
  BitReverseOpAdaptor(BitReverseOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitReverseOp : public ::mlir::Op<BitReverseOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitReverseOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitReverseOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BitReverse");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static BitReverseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static BitReverseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static BitReverseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static BitReverseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static BitReverseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static BitReverseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitReverseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitReverseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitReverseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitReverseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitReverseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitReverseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitReverseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitReverseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitReverseOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitcastOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitcastOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitcastOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.Bitcast", odsAttrs.getContext());
  }

  BitcastOpGenericAdaptorBase(BitcastOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitcastOpGenericAdaptor : public detail::BitcastOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitcastOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  BitcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitcastOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitcastOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitcastOpGenericAdaptor(RangeT values, const BitcastOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitcastOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitcastOp>>>
  BitcastOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitcastOpAdaptor : public BitcastOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitcastOpGenericAdaptor::BitcastOpGenericAdaptor;
  BitcastOpAdaptor(BitcastOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitcastOp : public ::mlir::Op<BitcastOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitcastOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitcastOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.Bitcast");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitcastOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitwiseAndOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitwiseAndOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitwiseAndOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BitwiseAnd", odsAttrs.getContext());
  }

  BitwiseAndOpGenericAdaptorBase(BitwiseAndOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitwiseAndOpGenericAdaptor : public detail::BitwiseAndOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitwiseAndOpGenericAdaptorBase;
  static constexpr int odsIndex_operand1 = 0;
  static constexpr int odsIndex_operand2 = 1;
public:
  BitwiseAndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitwiseAndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitwiseAndOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitwiseAndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitwiseAndOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitwiseAndOpGenericAdaptor(RangeT values, const BitwiseAndOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitwiseAndOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitwiseAndOp>>>
  BitwiseAndOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand1() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOperand2() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitwiseAndOpAdaptor : public BitwiseAndOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitwiseAndOpGenericAdaptor::BitwiseAndOpGenericAdaptor;
  BitwiseAndOpAdaptor(BitwiseAndOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitwiseAndOp : public ::mlir::Op<BitwiseAndOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::IsCommutative, ::mlir::OpTrait::spirv::UsableInSpecConstantOp, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitwiseAndOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitwiseAndOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand1 = 0;
  static constexpr int odsIndex_operand2 = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BitwiseAnd");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getOperand2() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOperand1Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOperand2Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseAndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseAndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitwiseAndOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitwiseOrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitwiseOrOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitwiseOrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BitwiseOr", odsAttrs.getContext());
  }

  BitwiseOrOpGenericAdaptorBase(BitwiseOrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitwiseOrOpGenericAdaptor : public detail::BitwiseOrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitwiseOrOpGenericAdaptorBase;
  static constexpr int odsIndex_operand1 = 0;
  static constexpr int odsIndex_operand2 = 1;
public:
  BitwiseOrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitwiseOrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitwiseOrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitwiseOrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitwiseOrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitwiseOrOpGenericAdaptor(RangeT values, const BitwiseOrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitwiseOrOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitwiseOrOp>>>
  BitwiseOrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand1() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOperand2() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitwiseOrOpAdaptor : public BitwiseOrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitwiseOrOpGenericAdaptor::BitwiseOrOpGenericAdaptor;
  BitwiseOrOpAdaptor(BitwiseOrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitwiseOrOp : public ::mlir::Op<BitwiseOrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::IsCommutative, ::mlir::OpTrait::spirv::UsableInSpecConstantOp, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitwiseOrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitwiseOrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand1 = 0;
  static constexpr int odsIndex_operand2 = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BitwiseOr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getOperand2() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOperand1Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOperand2Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseOrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseOrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitwiseOrOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BitwiseXorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitwiseXorOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitwiseXorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BitwiseXor", odsAttrs.getContext());
  }

  BitwiseXorOpGenericAdaptorBase(BitwiseXorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitwiseXorOpGenericAdaptor : public detail::BitwiseXorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitwiseXorOpGenericAdaptorBase;
  static constexpr int odsIndex_operand1 = 0;
  static constexpr int odsIndex_operand2 = 1;
public:
  BitwiseXorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitwiseXorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitwiseXorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitwiseXorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitwiseXorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitwiseXorOpGenericAdaptor(RangeT values, const BitwiseXorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitwiseXorOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitwiseXorOp>>>
  BitwiseXorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand1() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOperand2() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitwiseXorOpAdaptor : public BitwiseXorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitwiseXorOpGenericAdaptor::BitwiseXorOpGenericAdaptor;
  BitwiseXorOpAdaptor(BitwiseXorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitwiseXorOp : public ::mlir::Op<BitwiseXorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::IsCommutative, ::mlir::OpTrait::spirv::UsableInSpecConstantOp, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitwiseXorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitwiseXorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand1 = 0;
  static constexpr int odsIndex_operand2 = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BitwiseXor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getOperand2() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOperand1Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOperand2Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static BitwiseXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand1, ::mlir::Value operand2);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitwiseXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseXorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitwiseXorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BitwiseXorOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BranchConditionalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BranchConditionalOpGenericAdaptorBase {
public:
  struct Properties {
    using branch_weightsTy = ::mlir::ArrayAttr;
    branch_weightsTy branch_weights;

    auto getBranchWeights() const {
      auto &propStorage = this->branch_weights;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setBranchWeights(const ::mlir::ArrayAttr &propValue) {
      this->branch_weights = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.branch_weights == this->branch_weights &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BranchConditionalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.BranchConditional", odsAttrs.getContext());
  }

  BranchConditionalOpGenericAdaptorBase(BranchConditionalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getBranchWeightsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().branch_weights);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getBranchWeights();
};
} // namespace detail
template <typename RangeT>
class BranchConditionalOpGenericAdaptor : public detail::BranchConditionalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BranchConditionalOpGenericAdaptorBase;
  static constexpr int odsIndex_condition = 0;
  static constexpr int odsIndex_trueTargetOperands = 1;
  static constexpr int odsIndex_falseTargetOperands = 2;
public:
  BranchConditionalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BranchConditionalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BranchConditionalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BranchConditionalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : BranchConditionalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BranchConditionalOpGenericAdaptor(RangeT values, const BranchConditionalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BranchConditionalOp, typename = std::enable_if_t<std::is_same_v<LateInst, BranchConditionalOp>>>
  BranchConditionalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getCondition() {
    return (*getODSOperands(0).begin());
  }

  RangeT getTrueTargetOperands() {
    return getODSOperands(1);
  }

  RangeT getFalseTargetOperands() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BranchConditionalOpAdaptor : public BranchConditionalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BranchConditionalOpGenericAdaptor::BranchConditionalOpGenericAdaptor;
  BranchConditionalOpAdaptor(BranchConditionalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BranchConditionalOp : public ::mlir::Op<BranchConditionalOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::NSuccessors<2>::Impl, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::BranchOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::IsTerminator, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BranchConditionalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BranchConditionalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_condition = 0;
  static constexpr int odsIndex_trueTargetOperands = 1;
  static constexpr int odsIndex_falseTargetOperands = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("branch_weights"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBranchWeightsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBranchWeightsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.BranchConditional");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getCondition() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getTrueTargetOperands() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getFalseTargetOperands() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getConditionMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getTrueTargetOperandsMutable();
  ::mlir::MutableOperandRange getFalseTargetOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Block *getTrueTarget() {
    return (*this)->getSuccessor(0);
  }

  ::mlir::Block *getFalseTarget() {
    return (*this)->getSuccessor(1);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getBranchWeightsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().branch_weights);
  }

  ::std::optional< ::mlir::ArrayAttr > getBranchWeights();
  void setBranchWeightsAttr(::mlir::ArrayAttr attr) {
    getProperties().branch_weights = attr;
  }

  ::mlir::Attribute removeBranchWeightsAttr() {
      auto attr = getProperties().branch_weights;
      getProperties().branch_weights = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value condition, Block *trueBlock, ValueRange trueArguments, Block *falseBlock, ValueRange falseArguments, std::optional<std::pair<uint32_t, uint32_t>> weights = {});
  static BranchConditionalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value condition, Block *trueBlock, ValueRange trueArguments, Block *falseBlock, ValueRange falseArguments, std::optional<std::pair<uint32_t, uint32_t>> weights = {});
  static BranchConditionalOp create(::mlir::ImplicitLocOpBuilder &builder, Value condition, Block *trueBlock, ValueRange trueArguments, Block *falseBlock, ValueRange falseArguments, std::optional<std::pair<uint32_t, uint32_t>> weights = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value condition, ::mlir::ValueRange trueTargetOperands, ::mlir::ValueRange falseTargetOperands, /*optional*/::mlir::ArrayAttr branch_weights, ::mlir::Block *trueTarget, ::mlir::Block *falseTarget);
  static BranchConditionalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value condition, ::mlir::ValueRange trueTargetOperands, ::mlir::ValueRange falseTargetOperands, /*optional*/::mlir::ArrayAttr branch_weights, ::mlir::Block *trueTarget, ::mlir::Block *falseTarget);
  static BranchConditionalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value condition, ::mlir::ValueRange trueTargetOperands, ::mlir::ValueRange falseTargetOperands, /*optional*/::mlir::ArrayAttr branch_weights, ::mlir::Block *trueTarget, ::mlir::Block *falseTarget);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::ValueRange trueTargetOperands, ::mlir::ValueRange falseTargetOperands, /*optional*/::mlir::ArrayAttr branch_weights, ::mlir::Block *trueTarget, ::mlir::Block *falseTarget);
  static BranchConditionalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::ValueRange trueTargetOperands, ::mlir::ValueRange falseTargetOperands, /*optional*/::mlir::ArrayAttr branch_weights, ::mlir::Block *trueTarget, ::mlir::Block *falseTarget);
  static BranchConditionalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::ValueRange trueTargetOperands, ::mlir::ValueRange falseTargetOperands, /*optional*/::mlir::ArrayAttr branch_weights, ::mlir::Block *trueTarget, ::mlir::Block *falseTarget);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BranchConditionalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BranchConditionalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BranchConditionalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BranchConditionalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::SuccessorOperands getSuccessorOperands(unsigned index);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
    /// Branch indices into the successor list.
    enum { kTrueIndex = 0, kFalseIndex = 1 };

    /// Returns the target block for the true branch.
    Block *getTrueBlock() { return getOperation()->getSuccessor(kTrueIndex); }

    /// Returns the target block for the false branch.
    Block *getFalseBlock() { return getOperation()->getSuccessor(kFalseIndex); }

    /// Returns the number of arguments to the true target block.
    unsigned getNumTrueBlockArguments() {
      return getTrueTargetOperands().size();
    }

    /// Returns the number of arguments to the false target block.
    unsigned getNumFalseBlockArguments() {
      return getFalseTargetOperands().size();
    }

    // Iterator and range support for true target block arguments.
    operand_range getTrueBlockArguments() {
      return getTrueTargetOperands();
    }

    // Iterator and range support for false target block arguments.
    operand_range getFalseBlockArguments() {
      return getFalseTargetOperands();
    }

  private:
    /// Gets the index of the first true block argument in the operand list.
    unsigned getTrueBlockArgumentIndex() {
      return 1; // Omit the first argument, which is the condition.
    }

    /// Gets the index of the first false block argument in the operand list.
    unsigned getFalseBlockArgumentIndex() {
      return getTrueBlockArgumentIndex() + getNumTrueBlockArguments();
    }
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BranchConditionalOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::BranchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BranchOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BranchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.Branch", odsAttrs.getContext());
  }

  BranchOpGenericAdaptorBase(BranchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BranchOpGenericAdaptor : public detail::BranchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BranchOpGenericAdaptorBase;
  static constexpr int odsIndex_targetOperands = 0;
public:
  BranchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BranchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BranchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BranchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BranchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BranchOpGenericAdaptor(RangeT values, const BranchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BranchOp, typename = std::enable_if_t<std::is_same_v<LateInst, BranchOp>>>
  BranchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getTargetOperands() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BranchOpAdaptor : public BranchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BranchOpGenericAdaptor::BranchOpGenericAdaptor;
  BranchOpAdaptor(BranchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BranchOp : public ::mlir::Op<BranchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::OneSuccessor, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BranchOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::IsTerminator, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BranchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BranchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_targetOperands = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.Branch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getTargetOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getTargetOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Block *getTarget() {
    return (*this)->getSuccessor(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Block *successor, ValueRange arguments = {});
  static BranchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Block *successor, ValueRange arguments = {});
  static BranchOp create(::mlir::ImplicitLocOpBuilder &builder, Block *successor, ValueRange arguments = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::SuccessorOperands getSuccessorOperands(unsigned index);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  /// Returns the block arguments.
  operand_range getBlockArguments() { return getTargetOperands(); }
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::BranchOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLAcosOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLAcosOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLAcosOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.acos", odsAttrs.getContext());
  }

  CLAcosOpGenericAdaptorBase(CLAcosOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLAcosOpGenericAdaptor : public detail::CLAcosOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLAcosOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLAcosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLAcosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLAcosOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLAcosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLAcosOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLAcosOpGenericAdaptor(RangeT values, const CLAcosOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLAcosOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLAcosOp>>>
  CLAcosOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLAcosOpAdaptor : public CLAcosOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLAcosOpGenericAdaptor::CLAcosOpGenericAdaptor;
  CLAcosOpAdaptor(CLAcosOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLAcosOp : public ::mlir::Op<CLAcosOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLAcosOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLAcosOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.acos");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLAcosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLAcosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLAcosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLAcosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAcosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAcosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAcosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAcosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAcosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAcosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAcosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAcosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAcosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAcosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLAcosOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLAcoshOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLAcoshOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLAcoshOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.acosh", odsAttrs.getContext());
  }

  CLAcoshOpGenericAdaptorBase(CLAcoshOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLAcoshOpGenericAdaptor : public detail::CLAcoshOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLAcoshOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLAcoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLAcoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLAcoshOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLAcoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLAcoshOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLAcoshOpGenericAdaptor(RangeT values, const CLAcoshOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLAcoshOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLAcoshOp>>>
  CLAcoshOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLAcoshOpAdaptor : public CLAcoshOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLAcoshOpGenericAdaptor::CLAcoshOpGenericAdaptor;
  CLAcoshOpAdaptor(CLAcoshOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLAcoshOp : public ::mlir::Op<CLAcoshOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLAcoshOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLAcoshOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.acosh");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLAcoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLAcoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLAcoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLAcoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAcoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAcoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAcoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAcoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAcoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAcoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAcoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAcoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAcoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAcoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLAcoshOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLAsinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLAsinOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLAsinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.asin", odsAttrs.getContext());
  }

  CLAsinOpGenericAdaptorBase(CLAsinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLAsinOpGenericAdaptor : public detail::CLAsinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLAsinOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLAsinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLAsinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLAsinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLAsinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLAsinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLAsinOpGenericAdaptor(RangeT values, const CLAsinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLAsinOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLAsinOp>>>
  CLAsinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLAsinOpAdaptor : public CLAsinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLAsinOpGenericAdaptor::CLAsinOpGenericAdaptor;
  CLAsinOpAdaptor(CLAsinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLAsinOp : public ::mlir::Op<CLAsinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLAsinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLAsinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.asin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLAsinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLAsinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLAsinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLAsinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAsinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAsinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAsinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAsinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAsinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAsinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAsinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAsinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAsinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAsinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLAsinOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLAsinhOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLAsinhOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLAsinhOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.asinh", odsAttrs.getContext());
  }

  CLAsinhOpGenericAdaptorBase(CLAsinhOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLAsinhOpGenericAdaptor : public detail::CLAsinhOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLAsinhOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLAsinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLAsinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLAsinhOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLAsinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLAsinhOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLAsinhOpGenericAdaptor(RangeT values, const CLAsinhOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLAsinhOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLAsinhOp>>>
  CLAsinhOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLAsinhOpAdaptor : public CLAsinhOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLAsinhOpGenericAdaptor::CLAsinhOpGenericAdaptor;
  CLAsinhOpAdaptor(CLAsinhOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLAsinhOp : public ::mlir::Op<CLAsinhOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLAsinhOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLAsinhOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.asinh");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLAsinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLAsinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLAsinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLAsinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAsinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAsinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAsinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAsinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAsinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAsinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAsinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAsinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAsinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAsinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLAsinhOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLAtan2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLAtan2OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLAtan2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.atan2", odsAttrs.getContext());
  }

  CLAtan2OpGenericAdaptorBase(CLAtan2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLAtan2OpGenericAdaptor : public detail::CLAtan2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLAtan2OpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  CLAtan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLAtan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLAtan2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLAtan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLAtan2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLAtan2OpGenericAdaptor(RangeT values, const CLAtan2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLAtan2Op, typename = std::enable_if_t<std::is_same_v<LateInst, CLAtan2Op>>>
  CLAtan2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLAtan2OpAdaptor : public CLAtan2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLAtan2OpGenericAdaptor::CLAtan2OpGenericAdaptor;
  CLAtan2OpAdaptor(CLAtan2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLAtan2Op : public ::mlir::Op<CLAtan2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLAtan2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLAtan2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.atan2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLAtan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLAtan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLAtan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLAtan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLAtan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLAtan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLAtan2Op)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLAtanOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLAtanOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLAtanOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.atan", odsAttrs.getContext());
  }

  CLAtanOpGenericAdaptorBase(CLAtanOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLAtanOpGenericAdaptor : public detail::CLAtanOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLAtanOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLAtanOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLAtanOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLAtanOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLAtanOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLAtanOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLAtanOpGenericAdaptor(RangeT values, const CLAtanOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLAtanOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLAtanOp>>>
  CLAtanOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLAtanOpAdaptor : public CLAtanOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLAtanOpGenericAdaptor::CLAtanOpGenericAdaptor;
  CLAtanOpAdaptor(CLAtanOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLAtanOp : public ::mlir::Op<CLAtanOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLAtanOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLAtanOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.atan");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLAtanOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLAtanOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLAtanOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLAtanOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAtanOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAtanOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtanOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtanOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtanOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtanOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtanOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtanOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtanOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtanOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLAtanOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLAtanhOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLAtanhOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLAtanhOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.atanh", odsAttrs.getContext());
  }

  CLAtanhOpGenericAdaptorBase(CLAtanhOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLAtanhOpGenericAdaptor : public detail::CLAtanhOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLAtanhOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLAtanhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLAtanhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLAtanhOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLAtanhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLAtanhOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLAtanhOpGenericAdaptor(RangeT values, const CLAtanhOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLAtanhOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLAtanhOp>>>
  CLAtanhOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLAtanhOpAdaptor : public CLAtanhOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLAtanhOpGenericAdaptor::CLAtanhOpGenericAdaptor;
  CLAtanhOpAdaptor(CLAtanhOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLAtanhOp : public ::mlir::Op<CLAtanhOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLAtanhOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLAtanhOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.atanh");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLAtanhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLAtanhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLAtanhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLAtanhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAtanhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLAtanhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtanhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtanhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtanhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLAtanhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtanhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtanhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtanhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLAtanhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLAtanhOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLCeilOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLCeilOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLCeilOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.ceil", odsAttrs.getContext());
  }

  CLCeilOpGenericAdaptorBase(CLCeilOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLCeilOpGenericAdaptor : public detail::CLCeilOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLCeilOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLCeilOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLCeilOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLCeilOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLCeilOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLCeilOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLCeilOpGenericAdaptor(RangeT values, const CLCeilOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLCeilOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLCeilOp>>>
  CLCeilOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLCeilOpAdaptor : public CLCeilOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLCeilOpGenericAdaptor::CLCeilOpGenericAdaptor;
  CLCeilOpAdaptor(CLCeilOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLCeilOp : public ::mlir::Op<CLCeilOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLCeilOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLCeilOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.ceil");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLCeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLCeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLCeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLCeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLCeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLCeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLCeilOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLCosOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLCosOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLCosOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.cos", odsAttrs.getContext());
  }

  CLCosOpGenericAdaptorBase(CLCosOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLCosOpGenericAdaptor : public detail::CLCosOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLCosOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLCosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLCosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLCosOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLCosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLCosOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLCosOpGenericAdaptor(RangeT values, const CLCosOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLCosOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLCosOp>>>
  CLCosOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLCosOpAdaptor : public CLCosOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLCosOpGenericAdaptor::CLCosOpGenericAdaptor;
  CLCosOpAdaptor(CLCosOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLCosOp : public ::mlir::Op<CLCosOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLCosOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLCosOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.cos");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLCosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLCosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLCosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLCosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLCosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLCosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCosOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCosOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLCosOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLCoshOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLCoshOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLCoshOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.cosh", odsAttrs.getContext());
  }

  CLCoshOpGenericAdaptorBase(CLCoshOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLCoshOpGenericAdaptor : public detail::CLCoshOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLCoshOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLCoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLCoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLCoshOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLCoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLCoshOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLCoshOpGenericAdaptor(RangeT values, const CLCoshOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLCoshOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLCoshOp>>>
  CLCoshOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLCoshOpAdaptor : public CLCoshOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLCoshOpGenericAdaptor::CLCoshOpGenericAdaptor;
  CLCoshOpAdaptor(CLCoshOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLCoshOp : public ::mlir::Op<CLCoshOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLCoshOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLCoshOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.cosh");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLCoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLCoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLCoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLCoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLCoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLCoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLCoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCoshOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLCoshOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLCoshOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLErfOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLErfOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLErfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.erf", odsAttrs.getContext());
  }

  CLErfOpGenericAdaptorBase(CLErfOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLErfOpGenericAdaptor : public detail::CLErfOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLErfOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLErfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLErfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLErfOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLErfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLErfOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLErfOpGenericAdaptor(RangeT values, const CLErfOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLErfOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLErfOp>>>
  CLErfOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLErfOpAdaptor : public CLErfOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLErfOpGenericAdaptor::CLErfOpGenericAdaptor;
  CLErfOpAdaptor(CLErfOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLErfOp : public ::mlir::Op<CLErfOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLErfOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLErfOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.erf");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLErfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLErfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLErfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLErfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLErfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLErfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLErfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLErfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLErfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLErfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLErfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLErfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLErfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLErfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLErfOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLExpOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLExpOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLExpOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.exp", odsAttrs.getContext());
  }

  CLExpOpGenericAdaptorBase(CLExpOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLExpOpGenericAdaptor : public detail::CLExpOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLExpOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLExpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLExpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLExpOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLExpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLExpOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLExpOpGenericAdaptor(RangeT values, const CLExpOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLExpOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLExpOp>>>
  CLExpOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLExpOpAdaptor : public CLExpOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLExpOpGenericAdaptor::CLExpOpGenericAdaptor;
  CLExpOpAdaptor(CLExpOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLExpOp : public ::mlir::Op<CLExpOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLExpOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLExpOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.exp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLExpOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLFAbsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLFAbsOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLFAbsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.fabs", odsAttrs.getContext());
  }

  CLFAbsOpGenericAdaptorBase(CLFAbsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLFAbsOpGenericAdaptor : public detail::CLFAbsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLFAbsOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLFAbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLFAbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLFAbsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLFAbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLFAbsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLFAbsOpGenericAdaptor(RangeT values, const CLFAbsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLFAbsOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLFAbsOp>>>
  CLFAbsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLFAbsOpAdaptor : public CLFAbsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLFAbsOpGenericAdaptor::CLFAbsOpGenericAdaptor;
  CLFAbsOpAdaptor(CLFAbsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLFAbsOp : public ::mlir::Op<CLFAbsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLFAbsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLFAbsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.fabs");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLFAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLFAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLFAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLFAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLFAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLFAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLFAbsOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLFMaxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLFMaxOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLFMaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.fmax", odsAttrs.getContext());
  }

  CLFMaxOpGenericAdaptorBase(CLFMaxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLFMaxOpGenericAdaptor : public detail::CLFMaxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLFMaxOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  CLFMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLFMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLFMaxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLFMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLFMaxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLFMaxOpGenericAdaptor(RangeT values, const CLFMaxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLFMaxOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLFMaxOp>>>
  CLFMaxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLFMaxOpAdaptor : public CLFMaxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLFMaxOpGenericAdaptor::CLFMaxOpGenericAdaptor;
  CLFMaxOpAdaptor(CLFMaxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLFMaxOp : public ::mlir::Op<CLFMaxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLFMaxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLFMaxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.fmax");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLFMaxOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLFMinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLFMinOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLFMinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.fmin", odsAttrs.getContext());
  }

  CLFMinOpGenericAdaptorBase(CLFMinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLFMinOpGenericAdaptor : public detail::CLFMinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLFMinOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  CLFMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLFMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLFMinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLFMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLFMinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLFMinOpGenericAdaptor(RangeT values, const CLFMinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLFMinOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLFMinOp>>>
  CLFMinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLFMinOpAdaptor : public CLFMinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLFMinOpGenericAdaptor::CLFMinOpGenericAdaptor;
  CLFMinOpAdaptor(CLFMinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLFMinOp : public ::mlir::Op<CLFMinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLFMinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLFMinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.fmin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLFMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLFMinOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLFloorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLFloorOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLFloorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.floor", odsAttrs.getContext());
  }

  CLFloorOpGenericAdaptorBase(CLFloorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLFloorOpGenericAdaptor : public detail::CLFloorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLFloorOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLFloorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLFloorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLFloorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLFloorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLFloorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLFloorOpGenericAdaptor(RangeT values, const CLFloorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLFloorOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLFloorOp>>>
  CLFloorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLFloorOpAdaptor : public CLFloorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLFloorOpGenericAdaptor::CLFloorOpGenericAdaptor;
  CLFloorOpAdaptor(CLFloorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLFloorOp : public ::mlir::Op<CLFloorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLFloorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLFloorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.floor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLFloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLFloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLFloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLFloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLFloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLFloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLFloorOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLFmaOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLFmaOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLFmaOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.fma", odsAttrs.getContext());
  }

  CLFmaOpGenericAdaptorBase(CLFmaOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLFmaOpGenericAdaptor : public detail::CLFmaOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLFmaOpGenericAdaptorBase;
  static constexpr int odsIndex_x = 0;
  static constexpr int odsIndex_y = 1;
  static constexpr int odsIndex_z = 2;
public:
  CLFmaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLFmaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLFmaOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLFmaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLFmaOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLFmaOpGenericAdaptor(RangeT values, const CLFmaOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLFmaOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLFmaOp>>>
  CLFmaOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  ValueT getZ() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLFmaOpAdaptor : public CLFmaOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLFmaOpGenericAdaptor::CLFmaOpGenericAdaptor;
  CLFmaOpAdaptor(CLFmaOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLFmaOp : public ::mlir::Op<CLFmaOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLFmaOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLFmaOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_x = 0;
  static constexpr int odsIndex_y = 1;
  static constexpr int odsIndex_z = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.fma");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getZMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLFmaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLFmaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLFmaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLFmaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLFmaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLFmaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFmaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFmaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFmaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLFmaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFmaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFmaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFmaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLFmaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLFmaOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLLogOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLLogOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLLogOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.log", odsAttrs.getContext());
  }

  CLLogOpGenericAdaptorBase(CLLogOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLLogOpGenericAdaptor : public detail::CLLogOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLLogOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLLogOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLLogOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLLogOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLLogOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLLogOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLLogOpGenericAdaptor(RangeT values, const CLLogOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLLogOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLLogOp>>>
  CLLogOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLLogOpAdaptor : public CLLogOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLLogOpGenericAdaptor::CLLogOpGenericAdaptor;
  CLLogOpAdaptor(CLLogOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLLogOp : public ::mlir::Op<CLLogOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLLogOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLLogOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.log");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLLogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLLogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLLogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLLogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLLogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLLogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLLogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLLogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLLogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLLogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLLogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLLogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLLogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLLogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLLogOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLMixOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLMixOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLMixOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.mix", odsAttrs.getContext());
  }

  CLMixOpGenericAdaptorBase(CLMixOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLMixOpGenericAdaptor : public detail::CLMixOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLMixOpGenericAdaptorBase;
  static constexpr int odsIndex_x = 0;
  static constexpr int odsIndex_y = 1;
  static constexpr int odsIndex_z = 2;
public:
  CLMixOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLMixOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLMixOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLMixOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLMixOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLMixOpGenericAdaptor(RangeT values, const CLMixOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLMixOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLMixOp>>>
  CLMixOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  ValueT getZ() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLMixOpAdaptor : public CLMixOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLMixOpGenericAdaptor::CLMixOpGenericAdaptor;
  CLMixOpAdaptor(CLMixOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLMixOp : public ::mlir::Op<CLMixOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLMixOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLMixOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_x = 0;
  static constexpr int odsIndex_y = 1;
  static constexpr int odsIndex_z = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.mix");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getZMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLMixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLMixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLMixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLMixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLMixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static CLMixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, ::mlir::Value z);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLMixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLMixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLMixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLMixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLMixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLMixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLMixOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLMixOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLMixOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLPowOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLPowOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLPowOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.pow", odsAttrs.getContext());
  }

  CLPowOpGenericAdaptorBase(CLPowOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLPowOpGenericAdaptor : public detail::CLPowOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLPowOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  CLPowOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLPowOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLPowOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLPowOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLPowOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLPowOpGenericAdaptor(RangeT values, const CLPowOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLPowOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLPowOp>>>
  CLPowOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLPowOpAdaptor : public CLPowOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLPowOpGenericAdaptor::CLPowOpGenericAdaptor;
  CLPowOpAdaptor(CLPowOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLPowOp : public ::mlir::Op<CLPowOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLPowOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLPowOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.pow");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLPowOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLPowOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLPowOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLPowOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLPowOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLPowOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLPowOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLPowOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLPowOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLPowOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLPowOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLPowOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLPowOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLPowOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLPowOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLPrintfOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLPrintfOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLPrintfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.printf", odsAttrs.getContext());
  }

  CLPrintfOpGenericAdaptorBase(CLPrintfOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLPrintfOpGenericAdaptor : public detail::CLPrintfOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLPrintfOpGenericAdaptorBase;
  static constexpr int odsIndex_format = 0;
  static constexpr int odsIndex_arguments = 1;
public:
  CLPrintfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLPrintfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLPrintfOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLPrintfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLPrintfOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLPrintfOpGenericAdaptor(RangeT values, const CLPrintfOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLPrintfOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLPrintfOp>>>
  CLPrintfOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getFormat() {
    return (*getODSOperands(0).begin());
  }

  RangeT getArguments() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLPrintfOpAdaptor : public CLPrintfOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLPrintfOpGenericAdaptor::CLPrintfOpGenericAdaptor;
  CLPrintfOpAdaptor(CLPrintfOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLPrintfOp : public ::mlir::Op<CLPrintfOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLPrintfOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLPrintfOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_format = 0;
  static constexpr int odsIndex_arguments = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.printf");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getFormat() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getArguments() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getFormatMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getArgumentsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value format, ::mlir::ValueRange arguments);
  static CLPrintfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value format, ::mlir::ValueRange arguments);
  static CLPrintfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value format, ::mlir::ValueRange arguments);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value format, ::mlir::ValueRange arguments);
  static CLPrintfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value format, ::mlir::ValueRange arguments);
  static CLPrintfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value format, ::mlir::ValueRange arguments);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLPrintfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLPrintfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLPrintfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLPrintfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLPrintfOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLRintOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLRintOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLRintOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.rint", odsAttrs.getContext());
  }

  CLRintOpGenericAdaptorBase(CLRintOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLRintOpGenericAdaptor : public detail::CLRintOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLRintOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLRintOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLRintOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLRintOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLRintOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLRintOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLRintOpGenericAdaptor(RangeT values, const CLRintOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLRintOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLRintOp>>>
  CLRintOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLRintOpAdaptor : public CLRintOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLRintOpGenericAdaptor::CLRintOpGenericAdaptor;
  CLRintOpAdaptor(CLRintOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLRintOp : public ::mlir::Op<CLRintOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLRintOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLRintOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.rint");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLRintOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLRintOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLRintOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLRintOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLRintOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLRintOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRintOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRintOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRintOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRintOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRintOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRintOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRintOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRintOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLRintOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLRoundOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLRoundOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLRoundOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.round", odsAttrs.getContext());
  }

  CLRoundOpGenericAdaptorBase(CLRoundOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLRoundOpGenericAdaptor : public detail::CLRoundOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLRoundOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLRoundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLRoundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLRoundOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLRoundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLRoundOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLRoundOpGenericAdaptor(RangeT values, const CLRoundOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLRoundOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLRoundOp>>>
  CLRoundOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLRoundOpAdaptor : public CLRoundOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLRoundOpGenericAdaptor::CLRoundOpGenericAdaptor;
  CLRoundOpAdaptor(CLRoundOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLRoundOp : public ::mlir::Op<CLRoundOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLRoundOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLRoundOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.round");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLRoundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLRoundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLRoundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLRoundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLRoundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLRoundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRoundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRoundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRoundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRoundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRoundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRoundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRoundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRoundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLRoundOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLRsqrtOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLRsqrtOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLRsqrtOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.rsqrt", odsAttrs.getContext());
  }

  CLRsqrtOpGenericAdaptorBase(CLRsqrtOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLRsqrtOpGenericAdaptor : public detail::CLRsqrtOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLRsqrtOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLRsqrtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLRsqrtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLRsqrtOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLRsqrtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLRsqrtOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLRsqrtOpGenericAdaptor(RangeT values, const CLRsqrtOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLRsqrtOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLRsqrtOp>>>
  CLRsqrtOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLRsqrtOpAdaptor : public CLRsqrtOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLRsqrtOpGenericAdaptor::CLRsqrtOpGenericAdaptor;
  CLRsqrtOpAdaptor(CLRsqrtOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLRsqrtOp : public ::mlir::Op<CLRsqrtOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLRsqrtOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLRsqrtOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.rsqrt");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLRsqrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLRsqrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLRsqrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLRsqrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLRsqrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLRsqrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRsqrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRsqrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRsqrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLRsqrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRsqrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRsqrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRsqrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLRsqrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLRsqrtOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLSAbsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLSAbsOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLSAbsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.s_abs", odsAttrs.getContext());
  }

  CLSAbsOpGenericAdaptorBase(CLSAbsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLSAbsOpGenericAdaptor : public detail::CLSAbsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLSAbsOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLSAbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLSAbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLSAbsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLSAbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLSAbsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLSAbsOpGenericAdaptor(RangeT values, const CLSAbsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLSAbsOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLSAbsOp>>>
  CLSAbsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLSAbsOpAdaptor : public CLSAbsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLSAbsOpGenericAdaptor::CLSAbsOpGenericAdaptor;
  CLSAbsOpAdaptor(CLSAbsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLSAbsOp : public ::mlir::Op<CLSAbsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLSAbsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLSAbsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.s_abs");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLSAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLSAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLSAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLSAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLSAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLSAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSAbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSAbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLSAbsOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLSMaxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLSMaxOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLSMaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.s_max", odsAttrs.getContext());
  }

  CLSMaxOpGenericAdaptorBase(CLSMaxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLSMaxOpGenericAdaptor : public detail::CLSMaxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLSMaxOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  CLSMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLSMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLSMaxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLSMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLSMaxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLSMaxOpGenericAdaptor(RangeT values, const CLSMaxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLSMaxOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLSMaxOp>>>
  CLSMaxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLSMaxOpAdaptor : public CLSMaxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLSMaxOpGenericAdaptor::CLSMaxOpGenericAdaptor;
  CLSMaxOpAdaptor(CLSMaxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLSMaxOp : public ::mlir::Op<CLSMaxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLSMaxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLSMaxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.s_max");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSMaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSMaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLSMaxOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLSMinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLSMinOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLSMinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.s_min", odsAttrs.getContext());
  }

  CLSMinOpGenericAdaptorBase(CLSMinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLSMinOpGenericAdaptor : public detail::CLSMinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLSMinOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  CLSMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLSMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLSMinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLSMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLSMinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLSMinOpGenericAdaptor(RangeT values, const CLSMinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLSMinOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLSMinOp>>>
  CLSMinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLSMinOpAdaptor : public CLSMinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLSMinOpGenericAdaptor::CLSMinOpGenericAdaptor;
  CLSMinOpAdaptor(CLSMinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLSMinOp : public ::mlir::Op<CLSMinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLSMinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLSMinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.s_min");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static CLSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSMinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSMinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLSMinOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLSinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLSinOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLSinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.sin", odsAttrs.getContext());
  }

  CLSinOpGenericAdaptorBase(CLSinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLSinOpGenericAdaptor : public detail::CLSinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLSinOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLSinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLSinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLSinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLSinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLSinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLSinOpGenericAdaptor(RangeT values, const CLSinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLSinOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLSinOp>>>
  CLSinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLSinOpAdaptor : public CLSinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLSinOpGenericAdaptor::CLSinOpGenericAdaptor;
  CLSinOpAdaptor(CLSinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLSinOp : public ::mlir::Op<CLSinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLSinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLSinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.sin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLSinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLSinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLSinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLSinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLSinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLSinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLSinOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLSinhOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLSinhOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLSinhOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.sinh", odsAttrs.getContext());
  }

  CLSinhOpGenericAdaptorBase(CLSinhOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CLSinhOpGenericAdaptor : public detail::CLSinhOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CLSinhOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CLSinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CLSinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CLSinhOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CLSinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CLSinhOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CLSinhOpGenericAdaptor(RangeT values, const CLSinhOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CLSinhOp, typename = std::enable_if_t<std::is_same_v<LateInst, CLSinhOp>>>
  CLSinhOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CLSinhOpAdaptor : public CLSinhOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CLSinhOpGenericAdaptor::CLSinhOpGenericAdaptor;
  CLSinhOpAdaptor(CLSinhOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CLSinhOp : public ::mlir::Op<CLSinhOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::spirv::QueryMinVersionInterface::Trait, ::mlir::spirv::QueryMaxVersionInterface::Trait, ::mlir::spirv::QueryExtensionInterface::Trait, ::mlir::spirv::QueryCapabilityInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CLSinhOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CLSinhOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("spirv.CL.sinh");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CLSinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CLSinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CLSinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CLSinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLSinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CLSinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CLSinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSinhOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CLSinhOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::std::optional<::mlir::spirv::Version> getMinVersion();
  ::std::optional<::mlir::spirv::Version> getMaxVersion();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Extension>, 1> getExtensions();
  ::llvm::SmallVector<::llvm::ArrayRef<::mlir::spirv::Capability>, 1> getCapabilities();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace spirv
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::spirv::CLSinhOp)

namespace mlir {
namespace spirv {

//===----------------------------------------------------------------------===//
// ::mlir::spirv::CLSqrtOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CLSqrtOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CLSqrtOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("spirv.CL.sqrt", odsAttrs.getContext());
  }

  CLSqrtOpGenericAdaptorBase(CLSqrtOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAt