%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of Logtalk <https://logtalk.org/>
%  SPDX-FileCopyrightText: 2010 Victor Lagerkvist
%  SPDX-License-Identifier: BSD-3-Clause
%
%  Redistribution and use in source and binary forms, with or without
%  modification, are permitted provided that the following conditions are met:
%
%  * Redistributions of source code must retain the above copyright notice, this
%    list of conditions and the following disclaimer.
%
%  * Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
%  * Neither the name of the copyright holder nor the names of its
%    contributors may be used to endorse or promote products derived from
%    this software without specific prior written permission.
%
%  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
%  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
%  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
%  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
%  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
%  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
%  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
%  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
%  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


:- object(magic).

	:- info([
		version is 1:0:0,
		author is 'Ulf Nilsson. Ported to Logtalk and augmented with stratified negation by Victor Lagerkvist.',
		date is 2010-06-13,
		comment is 'Object encapsulating magic methods.'
	]).

	:- public(magicise/4).
	:- mode(magicise(+term, +list, -term, -list), zero_or_one).
	:- info(magicise/4, [
		comment is 'Transform (Head :- Body) into a magic clause (NewHead :- NewBody).',
		argnames is ['Head', 'Body', 'NewHead', 'NewBody']
	]).

	:- public(magic/2).
	:- mode(magic(+callable, -callable), zero_or_one).
	:- info(magic/2, [
		comment is 'Prefix the predicate symbol of Old with magic_.',
		argnames is ['Old', 'New']
	]).

	magicise(Head,Body,Head,[X|Body]) :-
		magic(Head,X).
	magicise(Head,Body,NewHead,[X|Left]) :-
		magic(Head,X),
		list::append(Left,[Y|_],Body),
		Y \= {_},
		magic_head(Y,NewHead).

	magic_head(not(X), Y) :-
		!,
		magic_head(X, Y).
	magic_head(X, Y) :-
		magic(X, Y).

	magic(X, Y) :-
		nonvar(X),
		X \= {_},
		X =.. [F | Args],
		atom_concat(magic_, F, G),
		Y =.. [G | Args].

:- end_object.
