
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was LibAlkimiaConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

list(APPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}")

include(CMakeFindDependencyMacro)

if("1" STREQUAL "ON" OR "1" STREQUAL "1")
    find_package(Qt4 COMPONENTS QtCore QtDBus)
else()
    find_dependency(Qt5Core)
    find_dependency(Qt5DBus)
endif()
find_dependency(MPIR)

include("${CMAKE_CURRENT_LIST_DIR}/LibAlkimiaTargets.cmake")

set_and_check(LIBALKIMIA_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include/alkimia/Qt4")
set_property(TARGET Alkimia::alkimia PROPERTY INTERFACE_INCLUDE_DIRECTORIES "${PACKAGE_PREFIX_DIR}/include/alkimia/Qt4" ${MPIR_INCLUDE_DIR})
message(STATUS "Found LibAlkimia: ${CMAKE_CURRENT_LIST_DIR}/LibAlkimiaConfig.cmake (found version \"8.0.3\")")
