/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.discourse;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.discourse.DiscourseException;
import org.jreleaser.sdk.discourse.api.Category;
import org.jreleaser.sdk.discourse.api.CategoryList;
import org.jreleaser.sdk.discourse.api.DiscourseAPI;
import org.jreleaser.util.StringUtils;

public class DiscourseSdk {
    private final JReleaserContext context;
    private final DiscourseAPI api;
    private final boolean dryrun;

    private DiscourseSdk(JReleaserContext context, String host, String userName, String apiKey, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank");
        StringUtils.requireNonBlank((String)userName, (String)"'userName' must not be blank");
        StringUtils.requireNonBlank((String)apiKey, (String)"'apiKey' must not be blank");
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.context = context;
        this.dryrun = dryrun;
        this.api = (DiscourseAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new JacksonEncoder(objectMapper)).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(template -> {
            template.header("User-Agent", new String[]{"JReleaser/" + JReleaserVersion.getPlainVersion()});
            template.header("Api-Key", new String[]{apiKey});
            template.header("Api-Username", new String[]{userName});
        }).target(DiscourseAPI.class, host);
        this.context.getLogger().debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void createPost(String title, String body, String categoryName) throws DiscourseException {
        this.wrap(() -> {
            Category category = this.findCategoryByName(categoryName);
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("title", title);
            params.put("raw", body);
            params.put("category", String.valueOf(category.getId()));
            this.api.createPost(params);
        });
    }

    public Category findCategoryByName(String categoryName) throws DiscourseException {
        CategoryList categoryList = this.api.getCategories().getCategoryList();
        return categoryList.getCategories().stream().filter(category -> category.getName().equals(categoryName)).findFirst().orElseThrow(() -> new DiscourseException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{categoryName})));
    }

    private void wrap(DiscourseOperation op) throws DiscourseException {
        try {
            if (!this.dryrun) {
                op.run();
            }
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new DiscourseException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"discourse"}), e);
        }
    }

    public static Builder builder(JReleaserContext context) {
        return new Builder(context);
    }

    @FunctionalInterface
    public static interface DiscourseOperation {
        public void run() throws DiscourseException;
    }

    public static class Builder {
        private final JReleaserContext context;
        private boolean dryrun;
        private String userName;
        private String apiKey;
        private String host;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = StringUtils.requireNonBlank((String)userName, (String)"'userName' must not be blank").trim();
            return this;
        }

        public Builder apiKey(String accessToken) {
            this.apiKey = StringUtils.requireNonBlank((String)accessToken, (String)"'apiKey' must not be blank").trim();
            return this;
        }

        public Builder host(String host) {
            this.host = StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.host, (String)"'host' must not be blank");
            StringUtils.requireNonBlank((String)this.userName, (String)"'userName' must not be blank");
            StringUtils.requireNonBlank((String)this.apiKey, (String)"'apiKey' must not be blank");
        }

        public DiscourseSdk build() {
            this.validate();
            return new DiscourseSdk(this.context, this.host, this.userName, this.apiKey, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

