/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openscience.jmol.app.janocchio.CoupleTable;
import org.openscience.jmol.app.janocchio.NMR_Viewer;
import org.openscience.jmol.app.janocchio.NoeTable;

public class LabelSetter
extends JPanel {
    NMR_Viewer viewer;
    NoeTable noeTable;
    CoupleTable coupleTable;
    String[] labelArray;
    int selectedAtomIndex;
    JLabel label;
    JTextField field;
    int minindex = 1;

    public LabelSetter(NMR_Viewer viewer, NoeTable noeTable, CoupleTable coupleTable) {
        this.viewer = viewer;
        this.noeTable = noeTable;
        this.coupleTable = coupleTable;
        this.setLayout(new BorderLayout());
        this.label = new JLabel();
        this.label.setText(this.getLabelText());
        this.field = new JTextField(5);
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelSetter.this.fieldActionPerformed(evt);
            }
        });
        this.add((Component)this.label, "West");
        this.add((Component)this.field, "Center");
    }

    void fieldActionPerformed(ActionEvent evt) {
        this.labelArray[this.selectedAtomIndex] = this.field.getText();
        String command = this.setLabelString(this.selectedAtomIndex, this.labelArray[this.selectedAtomIndex]);
        this.viewer.script(command);
        this.noeTable.setLabelArray(this.labelArray);
        this.noeTable.setmolCDKuptodate(false);
        this.coupleTable.setLabelArray(this.labelArray);
        this.noeTable.updateTables();
        this.coupleTable.updateTables();
    }

    public void setSelectedAtomIndex(int number) {
        this.selectedAtomIndex = number;
        this.label.setText(this.getLabelText());
        this.field.setText(this.labelArray[number]);
    }

    public void allocateLabelArray(int numAtoms) {
        this.labelArray = new String[numAtoms];
    }

    private String getLabelText() {
        String text = " Atom " + String.valueOf(this.selectedAtomIndex + this.minindex) + " Label ";
        return text;
    }

    public String[] getLabelArray() {
        return this.labelArray;
    }

    public int getMinindex() {
        return this.minindex;
    }

    public String setLabel(int i, String label) {
        this.labelArray[i] = label;
        return this.setLabelString(i, label);
    }

    public String setLabelString(int i, String label) {
        String command = "select (atomno=" + String.valueOf(i + this.minindex) + ");";
        command = label == null || label.trim().length() == 0 ? command + "label off" : command + "label " + label;
        command = command + ";set display NORMAL; select ALL;";
        return command;
    }
}

