/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.DividedWidgetPainter;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.combobox.ComboBoxConstants;
import com.github.weisj.darklaf.ui.combobox.DarkComboBoxUI;
import com.github.weisj.swingdsl.visualpadding.VisualPaddingProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarkComboBoxBorder
implements Border,
UIResource,
VisualPaddingProvider {
    protected final DarkComboBoxUI ui;
    protected final int borderSize;
    protected final int arcSize;
    protected final Color focusBorderColor;
    protected final Color borderColor;
    protected final Color inactiveBorderColor;

    public DarkComboBoxBorder(DarkComboBoxUI ui) {
        this.ui = ui;
        this.arcSize = UIManager.getInt("ComboBox.arc");
        this.borderSize = UIManager.getInt("ComboBox.borderThickness");
        this.focusBorderColor = UIManager.getColor("ComboBox.focusBorderColor");
        this.borderColor = UIManager.getColor("ComboBox.activeBorderColor");
        this.inactiveBorderColor = UIManager.getColor("ComboBox.inactiveBorderColor");
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        JComboBox<?> comboBox = this.ui.getComboBox();
        AbstractButton arrowButton = this.ui.getArrowButton();
        if (comboBox == null || arrowButton == null) {
            return;
        }
        boolean isTableCellEditor = ComboBoxConstants.isTableCellEditor(comboBox);
        boolean isTreeCellEditor = ComboBoxConstants.isTreeCellEditor(comboBox);
        this.ui.checkFocus();
        Graphics2D g = (Graphics2D)g2;
        g.translate(x, y);
        Color borderColor = this.getBorderColor(c);
        int dividerLocation = this.getDividerLocation(comboBox);
        DividedWidgetPainter.paintBorder(g, comboBox, width, height, this.arcSize, this.borderSize, dividerLocation, isTableCellEditor, isTreeCellEditor, this.ui.getHasFocus(), borderColor, this.focusBorderColor);
        g.translate(-x, -y);
    }

    private int getDividerLocation(JComboBox<?> comboBox) {
        if (comboBox.isEditable()) {
            AbstractButton arrowButton = this.ui.getArrowButton();
            Rectangle arrowBounds = arrowButton.getBounds();
            boolean leftToRight = comboBox.getComponentOrientation().isLeftToRight();
            return leftToRight ? arrowBounds.x : arrowBounds.x + arrowBounds.width - 1;
        }
        return -1;
    }

    protected void paintCellBorder(Component c, int width, int height, boolean isTableCellEditor, Graphics2D g, Color borderColor) {
        g.setColor(borderColor);
        Container parent = c.getParent();
        if (isTableCellEditor && parent instanceof JTable) {
            JTable table = (JTable)parent;
            CellUtil.paintTableEditorBorder(g, c, table, width, height);
        } else {
            PaintUtil.drawRect((Graphics)g, 0, 0, width, height, 1);
        }
    }

    protected Color getBorderColor(Component c) {
        return c.isEnabled() ? this.borderColor : this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (ComboBoxConstants.isTreeOrTableCellEditor(c)) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        return new InsetsUIResource(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
    }

    public Insets getVisualPaddings(Component component) {
        return this.getBorderInsets(component);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

