module Paths_cpphs (
	version,
	getBinDir, getLibDir, getDataDir, getLibexecDir,
	getDataFileName
	) where

import Data.Version

version = Version {versionBranch = [1,2], versionTags = []}

bindir     = "/opt/local/bin"
libdir     = "/opt/local/lib/hugs/packages/cpphs"
datadir    = "/opt/local/share/cpphs-1.2"
libexecdir = "/opt/local/libexec"

getBinDir, getLibDir, getDataDir, getLibexecDir :: IO FilePath
getBinDir = return bindir
getLibDir = return libdir
getDataDir = return datadir
getLibexecDir = return libexecdir

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = return (datadir ++ "/" ++ name)
